/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.DebugPanel;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;

public class FindDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private JComboBox toSearch;
    private JTextComponent toSearchEditor;
    private JCheckBox matchCase;
    private JCheckBox wholeWords;
    private JCheckBox backSearch;
    private JCheckBox wrapSearch;
    private JCheckBox searchFromTop;
    private JCheckBox matchMinusUnderscore;
    private JButton find;
    private JButton close;
    private FindParam param;
    private DebugPanel preview;

    public FindDialog(JFrame parent, String title, boolean modal, DebugPanel pv) {
        super(parent, title, modal);
        this.preview = pv;
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosed(WindowEvent evt) {
                FindDialog findDialog = FindDialog.this;
                synchronized (findDialog) {
                    FindDialog.this.notify();
                }
            }
        });
        LMResize layout = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(layout);
        this.matchCase = new JCheckBox("Match Case");
        this.wholeWords = new JCheckBox("Match Whole Words Only");
        this.backSearch = new JCheckBox("Backward Search");
        this.wrapSearch = new JCheckBox("Wrap Search");
        this.searchFromTop = new JCheckBox("From Top");
        this.matchMinusUnderscore = new JCheckBox("Match -/_");
        this.find = new JButton("Find");
        this.find.addActionListener(e -> this.responseOnAction());
        this.close = new JButton("Close");
        this.close.addActionListener(e -> this.closeDialog());
        this.find.setMnemonic('f');
        this.close.setMnemonic('c');
        JLabel findLbl = new JLabel("Find:");
        this.toSearch = new JComboBox();
        Component c = this.toSearch.getEditor().getEditorComponent();
        if (c instanceof JTextComponent) {
            this.toSearchEditor = (JTextComponent)c;
            c.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.toSearchEditor));
        }
        this.toSearch.setEditable(true);
        Dimension d = layout.getPreferredSize(findLbl);
        findLbl.setBounds(10, 10, d.width, d.height);
        this.getContentPane().add(findLbl);
        d = layout.getPreferredSize(this.matchCase);
        this.matchCase.setBounds(LMResize.getLeft(findLbl), LMResize.getBottom(findLbl) + 20, d.width, d.height);
        this.getContentPane().add(this.matchCase);
        d = layout.getPreferredSize(this.backSearch);
        this.backSearch.setBounds(LMResize.getLeft(findLbl), LMResize.getBottom(this.matchCase) + 10, d.width, d.height);
        this.getContentPane().add(this.backSearch);
        d = layout.getPreferredSize(this.searchFromTop);
        this.searchFromTop.setBounds(LMResize.getLeft(findLbl), LMResize.getBottom(this.backSearch) + 10, d.width, d.height);
        this.getContentPane().add(this.searchFromTop);
        d = layout.getPreferredSize(this.wholeWords);
        this.wholeWords.setBounds(LMResize.getRight(this.backSearch) + 20, LMResize.getTop(this.matchCase), d.width, d.height);
        this.getContentPane().add(this.wholeWords);
        int l = LMResize.getRight(findLbl) + 5;
        this.toSearch.setBounds(l, LMResize.getTop(findLbl), LMResize.getRight(this.wholeWords) - l, this.toSearch.getPreferredSize().height);
        this.getContentPane().add((Component)this.toSearch, new LMResizeData(1));
        d = layout.getPreferredSize(this.wrapSearch);
        this.wrapSearch.setBounds(LMResize.getRight(this.backSearch) + 20, LMResize.getTop(this.backSearch), d.width, d.height);
        this.getContentPane().add(this.wrapSearch);
        d = layout.getPreferredSize(this.matchMinusUnderscore);
        this.matchMinusUnderscore.setBounds(LMResize.getRight(this.backSearch) + 20, LMResize.getTop(this.searchFromTop), d.width, d.height);
        this.getContentPane().add(this.matchMinusUnderscore);
        d = layout.getPreferredSize(this.close);
        this.close.setBounds(LMResize.getRight(this.toSearch) - d.width + 5, LMResize.getBottom(this.searchFromTop) + 20, d.width, d.height);
        this.getContentPane().add((Component)this.close, new LMResizeData(10));
        this.find.setBounds(LMResize.getLeft(this.close) - 15 - d.width, LMResize.getTop(this.close), d.width, d.height);
        this.getContentPane().add((Component)this.find, new LMResizeData(10));
        this.pack();
        this.setDefaultButton(this.find);
    }

    public void setMatchCaseSelected(boolean b) {
        this.matchCase.setSelected(b);
    }

    public void setWholeWordsSelected(boolean b) {
        this.wholeWords.setSelected(b);
    }

    public void setBackwardSearchSelected(boolean b) {
        this.backSearch.setSelected(b);
    }

    public void setWrapSearchSelected(boolean b) {
        this.wrapSearch.setSelected(b);
    }

    public void setSearchFromTopSelected(boolean b) {
        this.searchFromTop.setSelected(b);
    }

    public void setMatchMinusUnderscoreSelected(boolean b) {
        this.matchMinusUnderscore.setSelected(b);
    }

    public boolean isMatchCaseSelected() {
        return this.matchCase.isSelected();
    }

    public boolean isWholeWordsSelected() {
        return this.wholeWords.isSelected();
    }

    public boolean isBackwardSearchSelected() {
        return this.backSearch.isSelected();
    }

    public boolean isWrapSearchSelected() {
        return this.wrapSearch.isSelected();
    }

    public boolean isSearchFromTopSelected() {
        return this.searchFromTop.isSelected();
    }

    public boolean isMatchMinusUnderscoreSelected() {
        return this.matchMinusUnderscore.isSelected();
    }

    public void setVisible(String def) {
        super.openDialog(this.getLastBounds());
        this.param = null;
        if (def != null && this.toSearchEditor != null) {
            this.toSearchEditor.setText(def);
        } else if (this.toSearch.getItemCount() > 0) {
            this.toSearch.setSelectedIndex(0);
        }
        if (this.toSearchEditor != null) {
            this.toSearchEditor.selectAll();
        }
    }

    public void addItemToSearchList(String item) {
        this.removeItem(item);
        this.toSearch.insertItemAt(item, 0);
        this.toSearch.setSelectedIndex(0);
    }

    private void responseOnAction() {
        String item;
        Object o = this.toSearch.getEditor().getItem();
        String string = item = o != null ? o.toString() : null;
        if (item != null && item.length() > 0) {
            this.param = new FindParam();
            this.param.toSearch = item.toString();
            this.param.matchCase = this.matchCase.isSelected();
            this.param.wholeWords = this.wholeWords.isSelected();
            this.param.backSearch = this.backSearch.isSelected();
            this.param.wrapSearch = this.wrapSearch.isSelected();
            this.param.searchFromTop = this.searchFromTop.isSelected();
            this.param.matchMinusUnderscore = this.matchMinusUnderscore.isSelected();
            this.searchFromTop.setSelected(false);
            this.preview.find(this.param);
        }
    }

    private void removeItem(String item) {
        int n = this.toSearch.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (!this.toSearch.getItemAt(i).toString().equals(item)) continue;
            this.toSearch.removeItemAt(i);
            return;
        }
    }

    public static class FindParam {
        public String toSearch;
        public boolean matchCase;
        public boolean wholeWords;
        public boolean backSearch;
        public boolean wrapSearch;
        public boolean searchFromTop;
        public boolean matchMinusUnderscore;

        public FindParam() {
        }

        public FindParam(String s, boolean mc, boolean ww, boolean bs, boolean ws, boolean top, boolean mMinusUnderscore) {
            this.toSearch = s;
            this.matchCase = mc;
            this.wholeWords = ww;
            this.backSearch = bs;
            this.wrapSearch = ws;
            this.searchFromTop = top;
            this.matchMinusUnderscore = mMinusUnderscore;
        }
    }
}

