/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.DebugPanel;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class JumpToDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private JRadioButton lineRb;
    private JRadioButton parRb;
    private JTextField lineTf;
    private JComboBox parCmb;
    private JComboBox fileCmb;
    private JButton jumpTo;
    private JButton close;
    private DebugPanel preview;
    private int selectedLine;
    private String selectedParagraph;
    private String selectedFileName;

    public JumpToDialog(JFrame parent, String title, DebugPanel p) {
        super(parent, title, true);
        this.preview = p;
        LMResize layout = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(layout);
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosed(WindowEvent evt) {
                JumpToDialog jumpToDialog = JumpToDialog.this;
                synchronized (jumpToDialog) {
                    JumpToDialog.this.notify();
                }
            }
        });
        this.lineRb = new JRadioButton("Jump to Line");
        this.lineRb.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.lineTf.setEnabled(true);
                this.parCmb.setEnabled(false);
                this.fileCmb.setEnabled(true);
                this.lineTf.requestFocus();
            }
        });
        Dimension d = layout.getPreferredSize(this.lineRb);
        this.lineRb.setBounds(10, 10, d.width, d.height);
        this.getContentPane().add(this.lineRb);
        this.lineTf = new JTextField();
        this.lineTf.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.lineTf));
        this.lineTf.setHorizontalAlignment(4);
        this.parRb = new JRadioButton("Jump to Paragraph");
        this.parRb.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.parCmb.setEnabled(true);
                this.lineTf.setEnabled(false);
                this.fileCmb.setEnabled(false);
                this.parCmb.requestFocus();
            }
        });
        d = layout.getPreferredSize(this.parRb);
        this.parRb.setBounds(LMResize.getLeft(this.lineRb), LMResize.getBottom(this.lineRb) + 20, d.width, d.height);
        this.getContentPane().add(this.parRb);
        this.lineTf.setBounds(LMResize.getRight(this.parRb) + 5, LMResize.getTop(this.lineRb) + 2, 70, this.lineTf.getPreferredSize().height);
        this.getContentPane().add((Component)this.lineTf, new LMResizeData(1));
        this.parCmb = new JComboBox();
        this.parCmb.setBounds(LMResize.getLeft(this.lineTf), LMResize.getTop(this.parRb) + 2, 200, this.parCmb.getPreferredSize().height);
        this.getContentPane().add((Component)this.parCmb, new LMResizeData(1));
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.lineRb);
        btnGroup.add(this.parRb);
        JLabel filenameLbl = new JLabel("Filename:");
        d = layout.getPreferredSize(filenameLbl);
        filenameLbl.setBounds(LMResize.getLeft(this.lineRb), LMResize.getBottom(this.parRb) + 20, d.width, d.height);
        this.getContentPane().add(filenameLbl);
        this.fileCmb = new JComboBox();
        this.fileCmb.setBounds(LMResize.getLeft(this.lineTf), LMResize.getTop(filenameLbl), 200, this.fileCmb.getPreferredSize().height);
        this.getContentPane().add((Component)this.fileCmb, new LMResizeData(1));
        this.jumpTo = new JButton("Jump To");
        this.jumpTo.setMnemonic('j');
        this.jumpTo.addActionListener(e -> {
            if (this.lineRb.isSelected()) {
                try {
                    this.selectedLine = Integer.parseInt(this.lineTf.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this.fileCmb.getSelectedIndex() >= 0) {
                    this.selectedFileName = this.fileCmb.getSelectedItem().toString();
                }
            } else if (this.parCmb.getSelectedIndex() >= 0) {
                this.selectedParagraph = this.parCmb.getSelectedItem().toString();
            }
            this.closeDialog();
        });
        this.close = new JButton("Close");
        this.close.addActionListener(e -> this.closeDialog());
        this.close.setMnemonic('c');
        this.lineRb.setSelected(true);
        d = layout.getPreferredSize(this.jumpTo);
        this.close.setBounds(LMResize.getRight(this.fileCmb) - d.width + 5, LMResize.getBottom(this.fileCmb) + 20, d.width, d.height);
        this.getContentPane().add((Component)this.close, new LMResizeData(10));
        this.jumpTo.setBounds(LMResize.getLeft(this.close) - 15 - d.width, LMResize.getTop(this.close), d.width, d.height);
        this.getContentPane().add((Component)this.jumpTo, new LMResizeData(10));
        JumpToDialog.setFirstFocusedComponent(this.lineTf);
        this.pack();
        this.setDefaultButton(this.jumpTo);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.fileCmb.removeAllItems();
            this.parCmb.removeAllItems();
            Filename[] filenames = this.preview.getFile().getFilenames();
            for (int i = 0; i < filenames.length; ++i) {
                this.fileCmb.addItem(filenames[i]);
            }
            this.parCmb.addItem("");
            Object[] pars = this.preview.getFile().getParagraphs();
            if (pars != null) {
                Arrays.sort(pars);
                for (int i = 0; i < pars.length; ++i) {
                    this.parCmb.addItem(pars[i]);
                }
            }
        }
        super.setVisible(b);
    }

    public int getSelectedLineNumber() {
        return this.selectedLine;
    }

    public String getSelectedFileName() {
        return this.selectedFileName;
    }

    public String getSelectedParagraphName() {
        return this.selectedParagraph;
    }
}

