/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.DebugPanel;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.AbstractSettingsDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class SettingsDialog
extends AbstractSettingsDialog {
    private static final long serialVersionUID = 1L;
    private DefaultListModel namesModel;
    private JList namesList;
    private JList stylesList;
    private JList sizesList;
    private JTextField nameField;
    private JTextField styleField;
    private JTextField sizeField;
    private JLabel previewLabel;
    private JCheckBox lafChk;
    private JLabel backLbl;
    private JLabel foreLbl;
    private JButton backBtn;
    private JButton foreBtn;
    private JTree settingsTree;
    private DebugPanel debugPanel;
    private Settings.FontAndColors copySource;
    private Settings.FontAndColors[] settings;
    private HashMap<Settings.FontAndColors, Settings.FontAndColors> cloneTable;

    public SettingsDialog(JFrame parent, String title, boolean modal, DebugPanel dbgpanel) {
        super(parent, title, modal);
        this.debugPanel = dbgpanel;
    }

    @Override
    protected void createContents(JPanel mainPanel) {
        this.cloneTable = new HashMap();
        Settings.FontAndColors[] s = Settings.getSettings();
        this.settings = new Settings.FontAndColors[s.length];
        for (int i = 0; i < s.length; ++i) {
            this.settings[i] = this.cloneFontAndColors(s[i]);
        }
        SpringLayout springLayout = new SpringLayout();
        mainPanel.setLayout(springLayout);
        JLabel nameLabel = new JLabel("Name");
        mainPanel.add(nameLabel);
        this.nameField = new JTextField(19);
        this.nameField.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.nameField));
        this.nameField.setEditable(false);
        this.nameField.setBackground(Color.white);
        mainPanel.add(this.nameField);
        this.namesModel = new DefaultListModel();
        for (int i = 0; i < Settings.getFonts().length; ++i) {
            this.namesModel.addElement(Settings.getFonts()[i]);
        }
        this.namesList = new JList(this.namesModel);
        this.namesList.addListSelectionListener(e -> {
            this.nameField.setText(this.namesList.getSelectedValue().toString());
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.settingsTree.getLastSelectedPathComponent();
            if (selNode != null) {
                Font selFont = this.getSelectedFont();
                Settings.FontAndColors fc = (Settings.FontAndColors)selNode.getUserObject();
                fc.setFont(selFont);
                fc.setModified(true);
                this.updatePreview(selFont);
                this.setDirty(true);
            }
        });
        this.namesList.setSelectionMode(0);
        JScrollPane namesSp = new JScrollPane(this.namesList);
        mainPanel.add(namesSp);
        JLabel styleLabel = new JLabel("Style");
        mainPanel.add(styleLabel);
        this.styleField = new JTextField(8);
        this.styleField.setEditable(false);
        this.styleField.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.styleField));
        this.styleField.setBackground(Color.white);
        mainPanel.add(this.styleField);
        this.stylesList = new JList<String>(Settings.getStylesNames());
        this.stylesList.addListSelectionListener(e -> {
            this.styleField.setText(this.stylesList.getSelectedValue().toString());
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.settingsTree.getLastSelectedPathComponent();
            if (selNode != null) {
                Font selFont = this.getSelectedFont();
                Settings.FontAndColors fc = (Settings.FontAndColors)selNode.getUserObject();
                fc.setFont(selFont);
                fc.setModified(true);
                this.updatePreview(selFont);
                this.setDirty(true);
            }
        });
        this.stylesList.setSelectionMode(0);
        JScrollPane stylesSp = new JScrollPane(this.stylesList);
        mainPanel.add(stylesSp);
        JLabel sizeLabel = new JLabel("Size");
        mainPanel.add(sizeLabel);
        this.sizeField = new JTextField(6);
        this.sizeField.setEditable(false);
        this.sizeField.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.sizeField));
        this.sizeField.setBackground(Color.white);
        mainPanel.add(this.sizeField);
        Integer[] sizesValues = new Integer[12];
        int i = 9;
        int j = 0;
        while (i <= 20) {
            sizesValues[j] = new Integer(i);
            ++i;
            ++j;
        }
        this.sizesList = new JList<Integer>(sizesValues);
        this.sizesList.addListSelectionListener(e -> {
            this.sizeField.setText(this.sizesList.getSelectedValue().toString());
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.settingsTree.getLastSelectedPathComponent();
            if (selNode != null) {
                Font selFont = this.getSelectedFont();
                Settings.FontAndColors fc = (Settings.FontAndColors)selNode.getUserObject();
                fc.setFont(selFont);
                fc.setModified(true);
                this.updatePreview(selFont);
                this.setDirty(true);
            }
        });
        this.sizesList.setSelectionMode(0);
        JScrollPane sizesSp = new JScrollPane(this.sizesList);
        mainPanel.add(sizesSp);
        this.lafChk = new JCheckBox("default LAF colors");
        mainPanel.add(this.lafChk);
        this.lafChk.addActionListener(e -> this.lafChkStateChanged());
        this.backLbl = new JLabel("Background");
        mainPanel.add(this.backLbl);
        this.backBtn = new JButton("...");
        this.backBtn.setPreferredSize(new Dimension(30, this.backBtn.getPreferredSize().height));
        mainPanel.add(this.backBtn);
        this.backBtn.addActionListener(e -> {
            DefaultMutableTreeNode selNode;
            Color c = JColorChooser.showDialog(this, "Choose background", this.backBtn.getBackground());
            if (c != null && (selNode = (DefaultMutableTreeNode)this.settingsTree.getLastSelectedPathComponent()) != null) {
                boolean ok = true;
                Settings.FontAndColors fc = (Settings.FontAndColors)selNode.getUserObject();
                if (fc.getName().startsWith("Level ")) {
                    int index = selNode.getParent().getIndex(selNode);
                    Settings.FontAndColors[] copySourceColors = this.copySource.getChildren();
                    for (int i = 0; i < copySourceColors.length && ok; ++i) {
                        ok = i == index || !c.equals(copySourceColors[i].getBackground());
                    }
                }
                if (ok) {
                    fc.setBackground(c);
                    fc.setModified(true);
                    this.updateBackground(c);
                    this.setDirty(true);
                } else {
                    JOptionPane.showMessageDialog(this, "Duplicate Color!", "ERROR", 0);
                }
            }
        });
        this.foreLbl = new JLabel("Foreground");
        mainPanel.add(this.foreLbl);
        this.foreBtn = new JButton("...");
        this.foreBtn.setPreferredSize(new Dimension(30, this.foreBtn.getPreferredSize().height));
        mainPanel.add(this.foreBtn);
        this.foreBtn.addActionListener(e -> {
            DefaultMutableTreeNode selNode;
            Color c = JColorChooser.showDialog(this, "Choose foreground", this.foreBtn.getBackground());
            if (c != null && (selNode = (DefaultMutableTreeNode)this.settingsTree.getLastSelectedPathComponent()) != null) {
                Settings.FontAndColors fc = (Settings.FontAndColors)selNode.getUserObject();
                fc.setForeground(c);
                fc.setModified(true);
                this.updateForeground(c);
                this.setDirty(true);
            }
        });
        JPanel previewPanel = new JPanel(new GridLayout(1, 0));
        this.previewLabel = new JLabel("isCOBOL Debugger");
        this.previewLabel.setOpaque(true);
        this.previewLabel.setHorizontalAlignment(0);
        previewPanel.add(this.previewLabel);
        previewPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.darkGray), "Preview", 0, 1, this.foreBtn.getFont()));
        mainPanel.add(previewPanel);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        DefaultTreeModel tModel = new DefaultTreeModel(root);
        this.settingsTree = new JTree(tModel);
        this.settingsTree.setRootVisible(false);
        this.settingsTree.setShowsRootHandles(true);
        this.settingsTree.addTreeSelectionListener(e -> {
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.settingsTree.getLastSelectedPathComponent();
            if (selNode != null) {
                Settings.FontAndColors fc = (Settings.FontAndColors)selNode.getUserObject();
                if (fc.getName().equals("Copy source")) {
                    fc = this.copySource.getChildren()[0];
                }
                boolean dirty = this.isDirty();
                this.lafChk.setSelected(fc.isInheritFromLaf());
                this.lafChkStateChanged();
                this.updateFont(fc.getFont(), !fc.isFontInherited());
                this.updateBackground(fc.getBackground(), !fc.isBackgroundInherited());
                this.updateForeground(fc.getForeground(), !fc.isForegroundInherited());
                this.setDirty(dirty);
            }
        });
        for (Settings.FontAndColors fc : this.settings) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(fc);
            root.add(node);
            if (!fc.getName().equals("Copy source")) continue;
            this.copySource = fc;
            Settings.FontAndColors[] copySourceColors = fc.getChildren();
            for (int j2 = 0; j2 < copySourceColors.length; ++j2) {
                node.add(new DefaultMutableTreeNode(copySourceColors[j2]));
            }
        }
        final JPopupMenu ppm1 = new JPopupMenu();
        JMenuItem addItem1 = new JMenuItem("Add");
        ActionListener addListener = e -> {
            Color c = JColorChooser.showDialog(this, "Choose background", this.backBtn.getBackground());
            if (c != null) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)this.settingsTree.getLastSelectedPathComponent();
                Settings.FontAndColors fc = (Settings.FontAndColors)n.getUserObject();
                if (!fc.getName().equals("Copy source")) {
                    n = (DefaultMutableTreeNode)n.getParent();
                }
                boolean ok = true;
                Settings.FontAndColors[] copySourceColors = this.copySource.getChildren();
                for (int i = 0; i < copySourceColors.length && ok; ++i) {
                    ok = !c.equals(copySourceColors[i].getBackground());
                }
                if (ok) {
                    Settings.FontAndColors[] newChildren = new Settings.FontAndColors[copySourceColors.length + 1];
                    System.arraycopy(copySourceColors, 0, newChildren, 0, copySourceColors.length);
                    newChildren[copySourceColors.length] = new Settings.FontAndColors(fc, "Level " + newChildren.length, null, c, null);
                    this.copySource.setChildren(newChildren);
                    this.copySource.setModified(true);
                    n.add(new DefaultMutableTreeNode(newChildren[newChildren.length - 1]));
                    tModel.reload();
                    this.settingsTree.expandPath(new TreePath(n.getPath()));
                    this.setDirty(true);
                } else {
                    JOptionPane.showMessageDialog(this, "Duplicate Color!", "ERROR", 0);
                }
            }
        };
        addItem1.addActionListener(addListener);
        ppm1.add(addItem1);
        final JPopupMenu ppm2 = new JPopupMenu();
        JMenuItem addItem2 = new JMenuItem("Add");
        addItem2.addActionListener(addListener);
        ppm2.add(addItem2);
        JMenuItem remItem = new JMenuItem("Remove");
        remItem.addActionListener(e -> {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)this.settingsTree.getLastSelectedPathComponent();
            DefaultMutableTreeNode par = (DefaultMutableTreeNode)n.getParent();
            if (par.getChildCount() > 1) {
                Settings.FontAndColors[] copySourceColors = this.copySource.getChildren();
                Settings.FontAndColors[] newChildren = new Settings.FontAndColors[copySourceColors.length - 1];
                int index = par.getIndex(n);
                int j = 0;
                for (int i = 0; i < copySourceColors.length; ++i) {
                    if (i == index) continue;
                    newChildren[j] = copySourceColors[i];
                    newChildren[j].setName("Level " + (j + 1));
                    ++j;
                }
                par.remove(index);
                this.copySource.setChildren(newChildren);
                this.copySource.setModified(true);
                tModel.reload();
                this.settingsTree.expandPath(new TreePath(par.getPath()));
                this.setDirty(true);
            } else {
                JOptionPane.showMessageDialog(this, "There must be at least one color pattern", "ERROR", 0);
            }
        });
        ppm2.add(remItem);
        this.settingsTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                DefaultMutableTreeNode n;
                if (e.isPopupTrigger() && (n = (DefaultMutableTreeNode)SettingsDialog.this.settingsTree.getLastSelectedPathComponent()) != null) {
                    Settings.FontAndColors fc = (Settings.FontAndColors)n.getUserObject();
                    if (fc.getName().equals("Copy source")) {
                        ppm1.show(e.getComponent(), e.getX(), e.getY());
                    } else if (fc.getName().startsWith("Level ")) {
                        ppm2.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        });
        JScrollPane settingsTreeSp = new JScrollPane(this.settingsTree);
        settingsTreeSp.setPreferredSize(new Dimension(270, 540));
        this.settingsTree.setRowHeight(this.settingsTree.getFontMetrics(this.settingsTree.getFont()).getHeight() + 2);
        mainPanel.add(settingsTreeSp);
        springLayout.putConstraint("North", (Component)settingsTreeSp, 10, "North", (Component)mainPanel);
        springLayout.putConstraint("West", (Component)settingsTreeSp, 10, "West", (Component)mainPanel);
        springLayout.putConstraint("South", (Component)mainPanel, 5, "South", (Component)settingsTreeSp);
        springLayout.putConstraint("West", (Component)nameLabel, 30, "East", (Component)settingsTreeSp);
        springLayout.putConstraint("North", (Component)nameLabel, 5, "North", (Component)mainPanel);
        springLayout.putConstraint("West", (Component)this.nameField, 0, "West", (Component)nameLabel);
        springLayout.putConstraint("North", (Component)this.nameField, 3, "South", (Component)nameLabel);
        springLayout.putConstraint("West", (Component)namesSp, 0, "West", (Component)this.nameField);
        springLayout.putConstraint("East", (Component)namesSp, 0, "East", (Component)this.nameField);
        springLayout.putConstraint("North", (Component)namesSp, 1, "South", (Component)this.nameField);
        springLayout.putConstraint("South", (Component)namesSp, 310, "North", (Component)namesSp);
        springLayout.putConstraint("West", (Component)styleLabel, 30, "East", (Component)this.nameField);
        springLayout.putConstraint("North", (Component)styleLabel, 0, "North", (Component)nameLabel);
        springLayout.putConstraint("West", (Component)this.styleField, 0, "West", (Component)styleLabel);
        springLayout.putConstraint("North", (Component)this.styleField, 3, "South", (Component)styleLabel);
        springLayout.putConstraint("West", (Component)stylesSp, 0, "West", (Component)this.styleField);
        springLayout.putConstraint("East", (Component)stylesSp, 0, "East", (Component)this.styleField);
        springLayout.putConstraint("North", (Component)stylesSp, 1, "South", (Component)this.styleField);
        springLayout.putConstraint("South", (Component)stylesSp, 0, "South", (Component)namesSp);
        springLayout.putConstraint("West", (Component)sizeLabel, 30, "East", (Component)this.styleField);
        springLayout.putConstraint("North", (Component)sizeLabel, 0, "North", (Component)styleLabel);
        springLayout.putConstraint("West", (Component)this.sizeField, 0, "West", (Component)sizeLabel);
        springLayout.putConstraint("North", (Component)this.sizeField, 3, "South", (Component)sizeLabel);
        springLayout.putConstraint("East", (Component)mainPanel, 10, "East", (Component)this.sizeField);
        springLayout.putConstraint("West", (Component)sizesSp, 0, "West", (Component)this.sizeField);
        springLayout.putConstraint("East", (Component)sizesSp, 0, "East", (Component)this.sizeField);
        springLayout.putConstraint("North", (Component)sizesSp, 1, "South", (Component)this.sizeField);
        springLayout.putConstraint("South", (Component)sizesSp, 0, "South", (Component)namesSp);
        springLayout.putConstraint("North", (Component)this.lafChk, 27, "South", (Component)namesSp);
        springLayout.putConstraint("West", (Component)this.lafChk, 0, "West", (Component)namesSp);
        springLayout.putConstraint("North", (Component)this.backLbl, 30, "South", (Component)namesSp);
        springLayout.putConstraint("West", (Component)this.backLbl, 20, "East", (Component)this.lafChk);
        springLayout.putConstraint("North", (Component)this.backBtn, -3, "North", (Component)this.backLbl);
        springLayout.putConstraint("West", (Component)this.backBtn, 10, "East", (Component)this.backLbl);
        springLayout.putConstraint("North", (Component)this.foreLbl, 0, "North", (Component)this.backLbl);
        springLayout.putConstraint("West", (Component)this.foreLbl, 10, "East", (Component)this.backBtn);
        springLayout.putConstraint("North", (Component)this.foreBtn, -3, "North", (Component)this.backLbl);
        springLayout.putConstraint("West", (Component)this.foreBtn, 10, "East", (Component)this.foreLbl);
        springLayout.putConstraint("North", (Component)previewPanel, 30, "South", (Component)this.backLbl);
        springLayout.putConstraint("West", (Component)previewPanel, 0, "West", (Component)namesSp);
        springLayout.putConstraint("South", (Component)previewPanel, 0, "South", (Component)settingsTreeSp);
        springLayout.putConstraint("East", (Component)previewPanel, 0, "East", (Component)this.sizeField);
        tModel.reload();
    }

    @Override
    public Rectangle openDialog(Rectangle bounds) {
        this.settingsTree.setSelectionRow(0);
        return super.openDialog(bounds);
    }

    private void selectFontName(String value) {
        int n = this.namesModel.size();
        for (int i = 0; i < n; ++i) {
            if (!value.equalsIgnoreCase(this.namesModel.elementAt(i).toString())) continue;
            this.namesList.setSelectedIndex(i);
            this.namesList.ensureIndexIsVisible(i);
            break;
        }
    }

    private Font getSelectedFont() {
        String fontName = this.nameField.getText();
        String fontStyle = this.styleField.getText();
        String fontSize = this.sizeField.getText();
        int style = 0;
        if (fontStyle.equalsIgnoreCase("Italic")) {
            style = 2;
        } else if (fontStyle.equalsIgnoreCase("Bold")) {
            style = 1;
        } else if (fontStyle.equalsIgnoreCase("Bold Italic")) {
            style = 3;
        }
        int size = 12;
        try {
            size = Integer.parseInt(fontSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Font(fontName, style, size);
    }

    private void updatePreview(Font selectedFont) {
        this.previewLabel.setFont(selectedFont);
    }

    private void updateBackground(Color c) {
        this.updateBackground(c, true);
    }

    private void updateBackground(Color c, boolean enabled) {
        this.backBtn.setBackground(c);
        this.previewLabel.setBackground(c);
        this.backLbl.setEnabled(enabled && !this.lafChk.isSelected());
        this.backBtn.setEnabled(enabled && !this.lafChk.isSelected());
    }

    private void updateForeground(Color c) {
        this.updateForeground(c, true);
    }

    private void updateForeground(Color c, boolean enabled) {
        this.foreBtn.setBackground(c);
        this.previewLabel.setForeground(c);
        this.foreLbl.setEnabled(enabled && !this.lafChk.isSelected());
        this.foreBtn.setEnabled(enabled && !this.lafChk.isSelected());
    }

    private void updateFont(Font f, boolean enabled) {
        this.selectFontName(f.getName());
        if (f.isPlain()) {
            this.stylesList.setSelectedIndex(0);
        } else if (f.isBold() && f.isItalic()) {
            this.stylesList.setSelectedIndex(3);
        } else if (f.isBold()) {
            this.stylesList.setSelectedIndex(2);
        } else {
            this.stylesList.setSelectedIndex(1);
        }
        int szIdx = f.getSize() - 9;
        this.sizesList.setSelectedIndex(szIdx);
        this.sizesList.ensureIndexIsVisible(szIdx);
        this.nameField.setEnabled(enabled);
        this.namesList.setEnabled(enabled);
        this.styleField.setEnabled(enabled);
        this.stylesList.setEnabled(enabled);
        this.sizeField.setEnabled(enabled);
        this.sizesList.setEnabled(enabled);
    }

    private Settings.FontAndColors cloneFontAndColors(Settings.FontAndColors src) {
        Settings.FontAndColors Return2 = this.cloneTable.get(src);
        if (Return2 == null) {
            Return2 = src.Clone();
            this.cloneTable.put(src, Return2);
        }
        if (src.getSuper() != null) {
            Settings.FontAndColors superClone = this.cloneTable.get(src.getSuper());
            if (superClone == null) {
                superClone = src.getSuper().Clone();
                this.cloneTable.put(src.getSuper(), superClone);
            }
            Return2.setSuper(superClone);
        }
        if (src.getChildren() != null) {
            Settings.FontAndColors[] children = new Settings.FontAndColors[src.getChildren().length];
            for (int i = 0; i < src.getChildren().length; ++i) {
                children[i] = this.cloneFontAndColors(src.getChildren()[i]);
            }
            Return2.setChildren(children);
        }
        return Return2;
    }

    private void lafChkStateChanged() {
        boolean sel = this.lafChk.isSelected();
        this.backLbl.setEnabled(!sel);
        this.backBtn.setEnabled(!sel);
        this.foreLbl.setEnabled(!sel);
        this.foreBtn.setEnabled(!sel);
        DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.settingsTree.getLastSelectedPathComponent();
        if (selNode != null) {
            Settings.FontAndColors fc = (Settings.FontAndColors)selNode.getUserObject();
            if (!sel) {
                fc.setBackground(fc.getBackground());
                fc.setForeground(fc.getForeground());
            }
            fc.setInheritFromLaf(sel);
            this.updateBackground(fc.getBackground());
            this.updateForeground(fc.getForeground());
            fc.setModified(true);
            this.setDirty(true);
        }
    }

    @Override
    protected void performApply() {
        Settings.setSettings(this.settings);
        for (int j = 0; j < this.settings.length; ++j) {
            Settings.FontAndColors fc = this.settings[j];
            String name = fc.getName();
            if (name.equals("Copy source")) {
                Settings.FontAndColors[] colorPattern = fc.getChildren();
                StringBuffer buf = new StringBuffer();
                boolean modified = fc.isModified();
                for (int i = 0; i < colorPattern.length; ++i) {
                    buf.append(colorPattern[i].getBackground().getRGB());
                    if (i < colorPattern.length - 1) {
                        buf.append(";");
                    }
                    modified |= colorPattern[i].isModified();
                    colorPattern[i].setModified(false);
                }
                Settings.setCopySourcePattern(buf.toString());
                if (modified && this.debugPanel != null) {
                    this.debugPanel.setCopySourcePattern(buf.toString());
                }
            } else if (fc.isModified() && this.debugPanel != null) {
                if (name.equals("Source code")) {
                    this.debugPanel.setSourceFont(fc.getFont());
                    this.debugPanel.setSourceBackground(fc.getBackground());
                    this.debugPanel.setSourceForeground(fc.getForeground());
                } else if (name.equals("Highlighted by search")) {
                    this.debugPanel.setHighBackground(fc.getBackground());
                    this.debugPanel.setHighForeground(fc.getForeground());
                } else if (name.equals("Source code (selected)")) {
                    this.debugPanel.setSelectedBackground(fc.getBackground());
                } else if (name.equals("Comments")) {
                    this.debugPanel.setCommentForeground(fc.getForeground());
                } else if (name.equals("Keywords")) {
                    this.debugPanel.setKeywordForeground(fc.getForeground());
                } else if (name.equals("String literals")) {
                    this.debugPanel.setStringForeground(fc.getForeground());
                } else if (name.equals("Numeric literals")) {
                    this.debugPanel.setNumberForeground(fc.getForeground());
                } else if (name.equals("Statements")) {
                    this.debugPanel.setStatementForeground(fc.getForeground());
                } else if (name.equals("Level numbers")) {
                    this.debugPanel.setLevelNumberForeground(fc.getForeground());
                } else if (name.equals("Figurative constants")) {
                    this.debugPanel.setFigurativeConstantForeground(fc.getForeground());
                } else if (name.equals("Line number column")) {
                    this.debugPanel.setLNBackground(fc.getBackground());
                    this.debugPanel.setLNForeground(fc.getForeground());
                } else if (name.equals("Current line")) {
                    this.debugPanel.setCurrLineBackground(fc.getBackground());
                } else if (name.equals("Breakpoint column")) {
                    this.debugPanel.setBPColBackground(fc.getBackground());
                } else if (name.equals("Variable hint")) {
                    this.debugPanel.setTipFont(fc.getFont());
                    this.debugPanel.setTipBackground(fc.getBackground());
                    this.debugPanel.setTipForeground(fc.getForeground());
                } else if (name.equals("Perform stack")) {
                    this.debugPanel.setPSFont(fc.getFont());
                    this.debugPanel.setPSBackground(fc.getBackground());
                    this.debugPanel.setPSForeground(fc.getForeground());
                } else if (name.equals("Perform stack (selected)")) {
                    this.debugPanel.setPSSelBackground(fc.getBackground());
                    this.debugPanel.setPSSelForeground(fc.getForeground());
                } else if (name.equals("Breakpoint list")) {
                    this.debugPanel.setBPLFont(fc.getFont());
                    this.debugPanel.setBPLBackground(fc.getBackground());
                    this.debugPanel.setBPLForeground(fc.getForeground());
                } else if (name.equals("Breakpoint list (selected)")) {
                    this.debugPanel.setBPLSelBackground(fc.getBackground());
                    this.debugPanel.setBPLSelForeground(fc.getForeground());
                } else if (name.equals("Monitor list")) {
                    this.debugPanel.setMLFont(fc.getFont());
                    this.debugPanel.setMLBackground(fc.getBackground());
                    this.debugPanel.setMLForeground(fc.getForeground());
                } else if (name.equals("Monitor list (selected)")) {
                    this.debugPanel.setMLSelBackground(fc.getBackground());
                    this.debugPanel.setMLSelForeground(fc.getForeground());
                } else if (name.equals("Command history")) {
                    this.debugPanel.setCHFont(fc.getFont());
                    this.debugPanel.setCHBackground(fc.getBackground());
                    this.debugPanel.setCHForeground(fc.getForeground());
                } else if (name.equals("Command history (selected)")) {
                    this.debugPanel.setCHSelBackground(fc.getBackground());
                    this.debugPanel.setCHSelForeground(fc.getForeground());
                } else if (name.equals("Thread list")) {
                    this.debugPanel.setTLFont(fc.getFont());
                    this.debugPanel.setTLBackground(fc.getBackground());
                    this.debugPanel.setTLForeground(fc.getForeground());
                } else if (name.equals("Display tree area")) {
                    this.debugPanel.setDTFont(fc.getFont());
                    this.debugPanel.setDTBackground(fc.getBackground());
                    this.debugPanel.setDTForeground(fc.getForeground());
                } else if (name.equals("Display tree area (selected)")) {
                    this.debugPanel.setDTSelBackground(fc.getBackground());
                    this.debugPanel.setDTSelForeground(fc.getForeground());
                } else if (name.equals("Output area")) {
                    this.debugPanel.setOutputFont(fc.getFont());
                    this.debugPanel.setOutputBackground(fc.getBackground());
                    this.debugPanel.setOutputForeground(fc.getForeground());
                } else if (name.equals("Console")) {
                    this.debugPanel.setConsoleFont(fc.getFont());
                    this.debugPanel.setConsoleBackground(fc.getBackground());
                    this.debugPanel.setConsoleForeground(fc.getForeground());
                } else if (name.equals("Output area (selected)")) {
                    this.debugPanel.setOutputSelBackground(fc.getBackground());
                    this.debugPanel.setOutputSelForeground(fc.getForeground());
                } else if (name.equals("Console (selected)")) {
                    this.debugPanel.setConsoleSelBackground(fc.getBackground());
                    this.debugPanel.setConsoleSelForeground(fc.getForeground());
                } else if (name.equals("Console StdErr")) {
                    this.debugPanel.setConsoleStdErrForeground(fc.getForeground());
                } else if (name.equals("Line command")) {
                    this.debugPanel.setInputFont(fc.getFont());
                    this.debugPanel.setInputBackground(fc.getBackground());
                    this.debugPanel.setInputForeground(fc.getForeground());
                } else if (name.equals("Line command (selected)")) {
                    this.debugPanel.setInputSelBackground(fc.getBackground());
                    this.debugPanel.setInputSelForeground(fc.getForeground());
                } else if (name.equals("Breakpoint line")) {
                    this.debugPanel.setBreakpointBackground(fc.getBackground());
                }
            }
            fc.setModified(false);
        }
        super.performApply();
    }
}

