/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.docking.eleritec;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.ImageIcon;

public class ResourceManager {
    public static URL getResource(String uri) {
        URL url = ResourceManager.class.getResource(uri);
        if (url == null) {
            url = ClassLoader.getSystemResource(uri);
        }
        if (url == null && !uri.startsWith("/")) {
            url = ResourceManager.getResource("/" + uri);
        }
        return url;
    }

    public static Image createImage(String url) {
        try {
            URL location = ResourceManager.getResource(url);
            return Toolkit.getDefaultToolkit().createImage(location);
        }
        catch (NullPointerException e) {
            throw new NullPointerException("Unable to locate image: " + url);
        }
    }

    public static ImageIcon createIcon(String url) {
        try {
            URL location = ResourceManager.getResource(url);
            return new ImageIcon(location);
        }
        catch (NullPointerException e) {
            throw new NullPointerException("Unable to locate image: " + url);
        }
    }

    public static Cursor createCursor(String url, Point hotPoint, String name) {
        Image image = ResourceManager.createImage(url);
        Cursor c = Toolkit.getDefaultToolkit().createCustomCursor(image, hotPoint, name);
        return c;
    }
}

