/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui;

import java.awt.font.TextAttribute;
import java.awt.font.TransformAttribute;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

public class FontAttribute
implements Serializable {
    public static final int FAMILY_N = 1;
    public static final int SIZE_N = 2;
    public static final int WEIGHT_N = 3;
    public static final int POSTURE_N = 4;
    public static final int UNDERLINE_N = 5;
    public static final int STRIKETHROUGH_N = 6;
    public static final int TRANSFORM_N = 7;
    public static final int PITCHFIXED_N = 8;
    public static final int ASCENT_N = 9;
    public static final int DESCENT_N = 10;
    public static final int LEADING_N = 11;
    public static final int AVEWIDTH_N = 12;
    public static final int MAXWIDTH_N = 13;
    public static final int FIRST_N = 1;
    public static final int LAST_N = 13;
    public static final Float WEIGHT_EXTRA_LIGHT = new Float(0.5);
    public static final Float WEIGHT_LIGHT = new Float(0.75);
    public static final Float WEIGHT_DEMILIGHT = new Float(0.875);
    public static final Float WEIGHT_REGULAR = new Float(1.0);
    public static final Float WEIGHT_SEMIBOLD = new Float(1.25);
    public static final Float WEIGHT_MEDIUM = new Float(1.5);
    public static final Float WEIGHT_DEMIBOLD = new Float(1.75);
    public static final Float WEIGHT_BOLD = new Float(2.0);
    public static final Float WEIGHT_HEAVY = new Float(2.25);
    public static final Float WEIGHT_EXTRABOLD = new Float(2.5);
    public static final Float WEIGHT_ULTRABOLD = new Float(2.75);
    public static final Float POSTURE_REGULAR = new Float(0.0f);
    public static final Float POSTURE_OBLIQUE = new Float(0.2f);
    public static final Integer UNDERLINE_ON = new Integer(0);
    public static final Boolean STRIKETHROUGH_ON = new Boolean(true);
    public static final Boolean PITCHFIXED_ON = new Boolean(true);
    private int type;
    public static final FontAttribute FAMILY = new FontAttribute(1);
    public static final FontAttribute SIZE = new FontAttribute(2);
    public static final FontAttribute WEIGHT = new FontAttribute(3);
    public static final FontAttribute POSTURE = new FontAttribute(4);
    public static final FontAttribute UNDERLINE = new FontAttribute(5);
    public static final FontAttribute STRIKETHROUGH = new FontAttribute(6);
    public static final FontAttribute TRANSFORM = new FontAttribute(7);
    public static final FontAttribute PITCHFIXED = new FontAttribute(8);
    public static final FontAttribute ASCENT = new FontAttribute(9);
    public static final FontAttribute DESCENT = new FontAttribute(10);
    public static final FontAttribute LEADING = new FontAttribute(11);
    public static final FontAttribute AVEWIDTH = new FontAttribute(12);
    public static final FontAttribute MAXWIDTH = new FontAttribute(13);

    private FontAttribute(int val) {
        this.type = val;
    }

    public int getId() {
        return this.type;
    }

    public boolean equals(Object obj) {
        return obj instanceof FontAttribute && ((FontAttribute)obj).type == this.type;
    }

    public int hashCode() {
        return this.type;
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return "FAMILY";
            }
            case 2: {
                return "SIZE";
            }
            case 3: {
                return "WEIGHT";
            }
            case 4: {
                return "POSTURE";
            }
            case 5: {
                return "UNDERLINE";
            }
            case 6: {
                return "STRIKETHROUGH";
            }
            case 7: {
                return "TRANSFORM";
            }
            case 8: {
                return "PITCHFIXED";
            }
            case 9: {
                return "ASCENT";
            }
            case 10: {
                return "DESCENT";
            }
            case 11: {
                return "LEADING";
            }
            case 12: {
                return "AVEWIDTH";
            }
            case 13: {
                return "MAXWIDTH";
            }
        }
        return "Unknown " + this.type;
    }

    public static Map convertToTextAttributes(Hashtable attrs) {
        Hashtable Return2 = new Hashtable(attrs.size());
        Enumeration en = attrs.keys();
        block9: while (en.hasMoreElements()) {
            FontAttribute fa = (FontAttribute)en.nextElement();
            switch (fa.getId()) {
                case 1: {
                    Return2.put(TextAttribute.FAMILY, attrs.get(fa));
                    continue block9;
                }
                case 2: {
                    Return2.put(TextAttribute.SIZE, attrs.get(fa));
                    continue block9;
                }
                case 3: {
                    Return2.put(TextAttribute.WEIGHT, attrs.get(fa));
                    continue block9;
                }
                case 4: {
                    Return2.put(TextAttribute.POSTURE, attrs.get(fa));
                    continue block9;
                }
                case 5: {
                    Return2.put(TextAttribute.UNDERLINE, attrs.get(fa));
                    continue block9;
                }
                case 6: {
                    Return2.put(TextAttribute.STRIKETHROUGH, attrs.get(fa));
                    continue block9;
                }
                case 7: {
                    Return2.put(TextAttribute.TRANSFORM, attrs.get(fa));
                    continue block9;
                }
            }
        }
        return Return2;
    }

    public static Hashtable convertFromTextAttributes(Map textAttrs) {
        Hashtable Return2 = new Hashtable();
        Object ta = textAttrs.get(TextAttribute.SIZE);
        if (ta != null) {
            Return2.put(SIZE, ta);
        }
        if ((ta = textAttrs.get(TextAttribute.WEIGHT)) != null) {
            Return2.put(WEIGHT, ta);
        }
        if ((ta = textAttrs.get(TextAttribute.POSTURE)) != null) {
            Return2.put(POSTURE, ta);
        }
        if ((ta = textAttrs.get(TextAttribute.UNDERLINE)) != null) {
            Return2.put(UNDERLINE, ta);
        }
        if ((ta = textAttrs.get(TextAttribute.STRIKETHROUGH)) != null) {
            Return2.put(STRIKETHROUGH, ta);
        }
        if ((ta = textAttrs.get(TextAttribute.TRANSFORM)) != null) {
            if (ta instanceof TransformAttribute) {
                Return2.put(TRANSFORM, ((TransformAttribute)ta).getTransform());
            } else {
                Return2.put(TRANSFORM, ta);
            }
        }
        return Return2;
    }
}

