/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.charva;

import charva.awt.event.KeyEvent;
import charvax.swing.JOptionPane;
import com.iscobol.gui.CobolFocusEvent;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.charva.GuiFactoryImpl;
import com.iscobol.gui.client.charva.MyKeyEvent;
import com.iscobol.gui.client.charva.PicobolTextEvent;
import com.iscobol.gui.client.charva.PicobolTextListener;
import com.iscobol.gui.client.charva.RemoteBaseGUIControl;
import com.iscobol.gui.client.charva.RemoteBaseGUIWindow;
import com.iscobol.gui.client.charva.RemoteDisplayWindow;
import com.iscobol.gui.client.charva.RemoteTerminalDisplay;
import com.iscobol.gui.client.charva.TerminalAccept;
import java.util.ArrayList;
import java.util.Vector;

public class RemoteTerminalAccept
extends RemoteTerminalDisplay {
    protected boolean autoTermination;
    protected boolean update;
    protected boolean prompt;
    protected char promptChar;
    protected boolean upper;
    protected boolean lower;
    protected boolean full;
    protected boolean required;
    protected boolean zeroFill;
    protected int cursor;
    private String editPict;
    private boolean noAutoClear;
    private boolean decPointComma;
    private boolean isOnScreenSection;

    public RemoteTerminalAccept(GuiFactoryImpl gf) {
        super(gf);
        this.noAutoClear = gf.getCsProperty().get("iscobol.terminal.no_autoclear", false);
    }

    @Override
    public String setValue(String v) {
        if (this.guiComponent == null) {
            super.setValue(v);
        } else {
            ((TerminalAccept)this.guiComponent).setValue(v);
        }
        return null;
    }

    @Override
    public String refreshValue(String v) {
        if (this.guiComponent == null) {
            super.setValue(v);
        } else {
            TerminalAccept ta = (TerminalAccept)this.guiComponent;
            ta.saveBGandAttr();
            if (!this.noAutoClear || this.update) {
                ta.setValue(v);
            }
            ta.restoreBGandAttr();
        }
        return null;
    }

    @Override
    public String getValue() {
        if (this.guiComponent == null) {
            return super.getValue();
        }
        super.setValue(((TerminalAccept)this.guiComponent).getValue());
        return super.getValue();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.destroyed) {
            return;
        }
        if (this.getLength() == 0) {
            ((RemoteDisplayWindow)this.parentWindow).keyPressed(e);
            return;
        }
        if (this.parentWindow != null) {
            ((RemoteDisplayWindow)this.parentWindow).stopTimer();
        }
        switch (e.getKeyCode()) {
            case 260: 
            case 261: {
                MyKeyEvent eawt0 = new MyKeyEvent();
                eawt0.setKeyChar(e.getKeyChar());
                eawt0.setKeyCode(e.getKeyCode());
                int cobFun0 = this.gf.getMyRemoteVirtualKeyboard().mapKey(eawt0);
                if (!(VirtualKeyboard.editing(cobFun0) == 589824 || VirtualKeyboard.editing(cobFun0) == 655360 || VirtualKeyboard.exception(cobFun0) < 0 && VirtualKeyboard.termination(cobFun0) < 0)) {
                    super.keyPressed(e);
                }
                return;
            }
            case 262: 
            case 263: 
            case 330: 
            case 360: {
                MyKeyEvent eawt = new MyKeyEvent();
                eawt.setKeyChar(e.getKeyChar());
                eawt.setKeyCode(e.getKeyCode());
                int cobFun = this.gf.getMyRemoteVirtualKeyboard().mapKey(eawt);
                if (VirtualKeyboard.exception(cobFun) >= 0 || VirtualKeyboard.termination(cobFun) >= 0) break;
                return;
            }
        }
        super.keyPressed(e);
    }

    @Override
    protected void setEditPict(String pic, boolean decPointComma) {
        this.editPict = pic;
        this.decPointComma = decPointComma;
        TerminalAccept ta = (TerminalAccept)this.guiComponent;
        if (ta != null) {
            ta.setPicture(this.editPict, decPointComma);
        }
    }

    @Override
    public void initialize() {
        TerminalAccept ta = new TerminalAccept(this.gf);
        this.setComponent(ta);
        this.intInitialize();
        RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.parentWindow;
        if (this.isNumeric) {
            ta.setNumeric(true);
        }
        ta.initialize(rdw.mainWindow.getCharTerminal(), this.getColumn(), this.getLine(), super.getValue(), this.getLength(), this.editPict, this.decPointComma);
        this.guiComponent.addKeyListener(this);
        if (this.getNoecho()) {
            ta.setNoEcho(true);
        }
        if (this.isUnderline) {
            ta.setUnderline(true);
        }
        if (this.isBold) {
            ta.setBold(true);
        }
        if (this.isBlink) {
            ta.setBlink(true);
        }
        if (this.isReverse) {
            ta.setReverse(true);
        }
        if (this.autoTermination) {
            ta.setAuto(true);
        }
        if (this.update) {
            ta.setUpdate(true);
        }
        if (this.promptChar != '\u0000') {
            ta.setPromptChar(this.promptChar);
        }
        if (this.prompt) {
            ta.setPrompt(true);
        }
        if (this.upper) {
            ta.setUpper(true);
        }
        if (this.lower) {
            ta.setLower(true);
        }
        if (this.full) {
            ta.setFull(true);
        }
        if (this.required) {
            ta.setRequired(true);
        }
        if (this.zeroFill) {
            ta.setZeroFill(true);
        }
        if (this.cursor > 0) {
            ta.setCursorPos(this.cursor);
        }
        ta.setJustification(this.just);
        ta.addTextListener(new PicobolTextListener(){

            @Override
            public void textChanged(PicobolTextEvent e) {
            }

            @Override
            public void valueIncrementing(PicobolTextEvent e) {
            }

            @Override
            public void valueDecrementing(PicobolTextEvent e) {
            }

            @Override
            public void inputTerminated(PicobolTextEvent e) {
                RemoteTerminalAccept.this.intKeyPressed(RemoteTerminalAccept.this.gf.getMyRemoteVirtualKeyboard().getAutoTerminated(), true, null);
            }

            @Override
            public void inputTerminated(KeyEvent e) {
                MyKeyEvent eawt = new MyKeyEvent();
                eawt.setKeyChar(e.getKeyChar());
                eawt.setKeyCode(e.getKeyCode());
                int cobFun = RemoteTerminalAccept.this.gf.getMyRemoteVirtualKeyboard().mapKey(eawt);
                if (VirtualKeyboard.editing(cobFun) == 589824 || VirtualKeyboard.editing(cobFun) == 655360) {
                    RemoteTerminalAccept.this.superkeyPressed(e);
                } else {
                    RemoteTerminalAccept.this.intKeyPressed(RemoteTerminalAccept.this.gf.getMyRemoteVirtualKeyboard().mapKey(eawt), false, null, false);
                }
            }

            @Override
            public boolean getFirstLast(KeyEvent e) {
                MyKeyEvent eawt = new MyKeyEvent();
                eawt.setKeyChar(e.getKeyChar());
                eawt.setKeyCode(e.getKeyCode());
                return RemoteTerminalAccept.this.intKeyPressed(e, RemoteTerminalAccept.this.gf.getMyRemoteVirtualKeyboard().mapKey(eawt), false, null, false);
            }
        });
        ((TerminalAccept)this.guiComponent).dorepaint = false;
        this.guiComponent.setVisible(true);
        ta.saveBGandAttr();
        ta.display();
        ta.restoreBGandAttr();
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    @Override
    public void focusGained(CobolFocusEvent cfe) {
        TerminalAccept ta = (TerminalAccept)this.guiComponent;
        if (ta != null) {
            ta.focusGained(cfe);
        }
        super.focusGained(cfe);
    }

    @Override
    public void focusLost(CobolFocusEvent cfe) {
        TerminalAccept ta = (TerminalAccept)this.guiComponent;
        if (ta != null) {
            ta.focusLost(cfe);
        }
        super.focusLost(cfe);
    }

    @Override
    protected boolean requestFocusLostComponent(RemoteBaseGUIControl opposite) {
        String errorMessage;
        this.saveCursorValue();
        TerminalAccept ta = (TerminalAccept)this.guiComponent;
        if (!(opposite != null && opposite.isSelfAct() || ta == null || (errorMessage = ta.check()) == null)) {
            JOptionPane.showMessageDialog(null, (Object)errorMessage, (String)"!!!", (int)100);
            return false;
        }
        return true;
    }

    @Override
    public void setIsNumeric(boolean b) {
        TerminalAccept ta = (TerminalAccept)this.guiComponent;
        super.setIsNumeric(b);
        if (ta != null) {
            ta.setNumeric(b);
        }
    }

    @Override
    public void setNoecho(boolean b) {
        TerminalAccept ta = (TerminalAccept)this.guiComponent;
        super.setNoecho(b);
        if (ta != null) {
            ta.setNoEcho(b);
        }
    }

    @Override
    public void setUnderline(boolean b) {
        TerminalAccept ta = (TerminalAccept)this.guiComponent;
        super.setUnderline(b);
        if (ta != null) {
            ta.setUnderline(b);
        }
    }

    @Override
    public void setBlink(boolean b) {
        TerminalAccept ta = (TerminalAccept)this.guiComponent;
        super.setBlink(b);
        if (ta != null) {
            ta.setBlink(b);
        }
    }

    @Override
    public void setReverse(boolean b) {
        TerminalAccept ta = (TerminalAccept)this.guiComponent;
        super.setReverse(b);
        if (ta != null) {
            ta.setReverse(b);
        }
    }

    @Override
    public void setVisible(boolean b) {
        this.guiComponent.setVisible(b);
        super.setVisible(b);
    }

    @Override
    public void setLocation(int xx, int yy) {
        super.setLocation(xx, yy);
    }

    public void setCursor(int crs) {
        this.setCursor(crs, false);
    }

    public void setCursor(int crs, boolean saveselectedall) {
        TerminalAccept ta = (TerminalAccept)this.guiComponent;
        this.cursor = crs;
        if (ta != null) {
            ta.setCursorPos(this.cursor, saveselectedall);
        }
    }

    @Override
    public void setPromptChar(char c) {
        TerminalAccept ta = (TerminalAccept)this.guiComponent;
        this.promptChar = c;
        if (ta != null) {
            ta.setPromptChar(this.promptChar);
        }
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize ps, int origWidth) {
        if (ps.sizes > 0.0f) {
            return ps.sizes;
        }
        if (ps.ccPIClen != -1) {
            return ps.ccPIClen;
        }
        if (ps.ccOlen != -1) {
            return ps.ccOlen;
        }
        if (ps.ccIlen != -1) {
            return ps.ccIlen;
        }
        return super.paramgetDefaultWidth(ps, origWidth);
    }

    @Override
    public void setStyle(int s, boolean set) {
        TerminalAccept ta;
        if ((s & 1) == 1) {
            ta = (TerminalAccept)this.guiComponent;
            this.autoTermination = true;
            if (ta != null) {
                ta.setAuto(this.autoTermination);
            }
        }
        if ((s & 0x2000) == 8192) {
            ta = (TerminalAccept)this.guiComponent;
            this.update = true;
            if (ta != null) {
                ta.setUpdate(this.update);
            }
        }
        if ((s & 0x200) == 512) {
            ta = (TerminalAccept)this.guiComponent;
            this.prompt = true;
            if (ta != null) {
                ta.setPrompt(this.prompt);
            }
        }
        if ((s & 0x4000) == 16384) {
            ta = (TerminalAccept)this.guiComponent;
            this.upper = true;
            if (ta != null) {
                ta.setUpper(this.upper);
            }
        }
        if ((s & 0x40) == 64) {
            ta = (TerminalAccept)this.guiComponent;
            this.lower = true;
            if (ta != null) {
                ta.setLower(this.lower);
            }
        }
        if ((s & 0x10000) == 65536) {
            ta = (TerminalAccept)this.guiComponent;
            this.full = true;
            if (ta != null) {
                ta.setFull(this.full);
            }
        }
        if ((s & 0x20000) == 131072 || (s & 0x100000) == 0x100000) {
            ta = (TerminalAccept)this.guiComponent;
            this.required = true;
            if (ta != null) {
                ta.setFull(this.required);
            }
        }
        if ((s & 0x40000) == 262144) {
            ta = (TerminalAccept)this.guiComponent;
            this.zeroFill = true;
            if (ta != null) {
                ta.setZeroFill(this.zeroFill);
            }
        }
        super.setStyle(s, set);
    }

    @Override
    public int getCursor() {
        TerminalAccept ta = (TerminalAccept)this.guiComponent;
        if (ta != null) {
            return ta.getCursorPos();
        }
        return -1;
    }

    @Override
    public void setCursorValue(RemoteDisplayWindow dw) {
        dw.setCursorValue(this.getCursor());
    }

    private void saveCursorValue() {
        RemoteBaseGUIControl fown;
        RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.parentWindow;
        if (rdw != null && (fown = (RemoteBaseGUIControl)rdw.getFocusOwner()) == this) {
            rdw.setCursorValue(this.getLine() + 1 << 16 | this.getColumn() + this.getLength() + 1);
        }
    }

    @Override
    protected boolean requestFocusLostComponent(RemoteBaseGUIWindow opposite) {
        this.saveCursorValue();
        return true;
    }

    @Override
    public void setActiveAccept(boolean al, ArrayList currChildsActiveAccept) {
        if (!al) {
            this.saveCursorValue();
        }
        super.setActiveAccept(al, currChildsActiveAccept);
    }

    @Override
    public void intFocusGained(boolean restore) {
        TerminalAccept ta = (TerminalAccept)this.guiComponent;
        if (ta != null) {
            ta.saveBGandAttr();
            ta.display(true);
        }
    }

    @Override
    public String getType() {
        return "terminalaccept";
    }

    @Override
    public void setJust(int j) {
        TerminalAccept ta = (TerminalAccept)this.guiComponent;
        super.setJust(j);
        if (ta != null) {
            ta.setJustification(this.just);
        }
    }

    @Override
    public void destroy() {
        TerminalAccept ta = (TerminalAccept)this.guiComponent;
        if (ta != null) {
            ta.removeTextListener();
        }
        super.destroy();
    }

    public boolean isOnScreenSection() {
        return this.isOnScreenSection;
    }

    @Override
    public void setControlInfo(int info) {
        super.setControlInfo(info);
        this.isOnScreenSection = (info & 0x400) == 1024;
        this.controlinfo &= 0xFFFFFBFF;
        this.controlinfo &= 0xFFFFF7FF;
    }

    @Override
    public void removeTerminalAcceptAndHeader(Vector destrctl) {
        if (!this.isOnScreenSection) {
            destrctl.add(new Integer(this.getServerId()));
        }
    }

    public void superkeyPressed(KeyEvent ke) {
        if (!this.isOnScreenSection && this.getParentBGW() != null && !this.getParentBGW().getIsonexceptionAccept()) {
            return;
        }
        super.keyPressed(ke);
    }

    @Override
    public void initializerowcol() {
        TerminalAccept ta;
        if (this.isOnScreenSection && (ta = (TerminalAccept)this.guiComponent) != null) {
            ta.initializerowcol(this.getColumn(), this.getLine());
        }
    }
}

