/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.FontAttribute;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.swing.FontLabel;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.InputList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class AdvancedFontChooser
extends JDialog {
    private final float screenResolution;
    private JFrame parent;
    private int closedOption = -1;
    private InputList fontNameInputList;
    private InputList fontSizeInputList;
    private MutableAttributeSet attributes;
    private JCheckBox boldCheckBox = new JCheckBox("Bold");
    private JCheckBox italicCheckBox = new JCheckBox("Italic");
    private JCheckBox underlineCheckBox = new JCheckBox("Underline");
    private JCheckBox strikethroughCheckBox = new JCheckBox("Strikethrough");
    private FontLabel previewLabel;
    private Font theFont;

    public AdvancedFontChooser(JFrame owner, int screenRes, String[] fontNames, Integer[] fontSizes) {
        super(owner, "Font Chooser", true);
        this.screenResolution = screenRes;
        this.fontNameInputList = new InputList(fontNames, "Name:");
        this.fontSizeInputList = new InputList(fontSizes, "Size:");
        this.parent = owner;
        Image icon = this.parent.getToolkit().getImage(this.getClass().getResource("iscobol.png"));
        this.parent.setIconImage(icon);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p = new JPanel(new GridLayout(1, 2, 10, 2));
        p.setBorder(new TitledBorder(new EtchedBorder(), "Font"));
        p.add(this.fontNameInputList);
        this.fontNameInputList.setDisplayedMnemonic('n');
        this.fontNameInputList.setToolTipText("Font name");
        p.add(this.fontSizeInputList);
        this.fontSizeInputList.setDisplayedMnemonic('s');
        this.fontSizeInputList.setToolTipText("Font size");
        JPanel tp = new JPanel(new BorderLayout());
        tp.add((Component)p, "Center");
        this.getContentPane().add(tp);
        p = new JPanel(new GridLayout(2, 2, 10, 5));
        p.setBorder(new TitledBorder(new EtchedBorder(), "Effects"));
        this.boldCheckBox.setMnemonic('b');
        this.boldCheckBox.setToolTipText("Bold font");
        p.add(this.boldCheckBox);
        this.italicCheckBox.setMnemonic('i');
        this.italicCheckBox.setToolTipText("Italic font");
        p.add(this.italicCheckBox);
        this.underlineCheckBox.setMnemonic('u');
        this.underlineCheckBox.setToolTipText("Underline font");
        p.add(this.underlineCheckBox);
        this.strikethroughCheckBox.setMnemonic('r');
        this.strikethroughCheckBox.setToolTipText("Strikethrough font");
        p.add(this.strikethroughCheckBox);
        this.getContentPane().add(p);
        this.getContentPane().add(Box.createVerticalStrut(5));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(Box.createHorizontalStrut(10));
        p.add(Box.createHorizontalStrut(20));
        p.add(Box.createHorizontalStrut(10));
        this.getContentPane().add(p);
        p = new JPanel(new GridLayout(1, 1));
        p.setBorder(new TitledBorder(new EtchedBorder(), "Preview"));
        this.previewLabel = new FontLabel("Preview Font");
        this.previewLabel.setPreferredSize(new Dimension(100, 75));
        p.add(this.previewLabel);
        this.getContentPane().add(p);
        p = new JPanel(new FlowLayout());
        JPanel p1 = new JPanel(new GridLayout(1, 2, 10, 2));
        JButton btOK = new JButton("OK");
        this.getRootPane().setDefaultButton(btOK);
        ActionListener actionListener = e -> {
            this.closedOption = 0;
            this.dispose();
            this.parent.dispose();
        };
        btOK.addActionListener(actionListener);
        p1.add(btOK);
        JButton btCancel = new JButton("Cancel");
        actionListener = e -> {
            this.closedOption = 2;
            this.dispose();
            this.parent.dispose();
        };
        btCancel.addActionListener(actionListener);
        p1.add(btCancel);
        p.add(p1);
        this.getContentPane().add(p);
        this.pack();
        ListSelectionListener listSelectListener = e -> this.updatePreview();
        this.fontNameInputList.addListSelectionListener(listSelectListener);
        this.fontSizeInputList.addListSelectionListener(listSelectListener);
        actionListener = e -> this.updatePreview();
        this.boldCheckBox.addActionListener(actionListener);
        this.italicCheckBox.addActionListener(actionListener);
        this.underlineCheckBox.addActionListener(actionListener);
        this.strikethroughCheckBox.addActionListener(actionListener);
    }

    @Override
    public void setVisible(boolean b) {
        if (b && !this.isVisible()) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new FocusEvent(this.fontNameInputList.list, 1004));
        }
        super.setVisible(b);
    }

    public void setAttributes(AttributeSet a) {
        this.attributes = new SimpleAttributeSet(a);
        String name = StyleConstants.getFontFamily(a);
        this.fontNameInputList.setSelected(name);
        int size = StyleConstants.getFontSize(a);
        this.fontSizeInputList.setSelectedInt(size);
        this.boldCheckBox.setSelected(StyleConstants.isBold(a));
        this.italicCheckBox.setSelected(StyleConstants.isItalic(a));
        this.underlineCheckBox.setSelected(StyleConstants.isUnderline(a));
        this.strikethroughCheckBox.setSelected(StyleConstants.isStrikeThrough(a));
        this.updatePreview();
    }

    public AttributeSet getAttributes() {
        if (this.attributes == null) {
            return null;
        }
        StyleConstants.setFontFamily(this.attributes, this.fontNameInputList.getSelected());
        StyleConstants.setFontSize(this.attributes, this.fontSizeInputList.getSelectedInt());
        StyleConstants.setBold(this.attributes, this.boldCheckBox.isSelected());
        StyleConstants.setItalic(this.attributes, this.italicCheckBox.isSelected());
        StyleConstants.setUnderline(this.attributes, this.underlineCheckBox.isSelected());
        StyleConstants.setStrikeThrough(this.attributes, this.strikethroughCheckBox.isSelected());
        return this.attributes;
    }

    public int getOption() {
        return this.closedOption;
    }

    @Override
    public Font getFont() {
        return this.theFont;
    }

    protected void updatePreview() {
        String name = this.fontNameInputList.getSelected();
        float size = this.fontSizeInputList.getSelectedInt();
        if (name == null || size <= 0.0f) {
            return;
        }
        Hashtable<TextAttribute, Object> attrs = new Hashtable<TextAttribute, Object>();
        attrs.put(TextAttribute.FAMILY, name);
        attrs.put(TextAttribute.SIZE, new Float((double)(size * this.screenResolution) / 72.0));
        if (this.boldCheckBox.isSelected()) {
            attrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (this.italicCheckBox.isSelected()) {
            attrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (this.underlineCheckBox.isSelected()) {
            attrs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (this.strikethroughCheckBox.isSelected()) {
            attrs.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        this.theFont = new Font(attrs);
        this.previewLabel.setFont(this.theFont);
        this.previewLabel.repaint();
    }

    public static Font choose(GuiFactoryImpl gf, int chooseFlags, int minSize, int maxSize, Hashtable font) {
        AdvancedFontChooser dlg = AdvancedFontChooser.create(gf, chooseFlags, minSize, maxSize, font);
        if (gf != null && gf.getIcon() != null) {
            dlg.setIconImage(gf.getIcon());
        }
        KeyboardBuffer.enable(null);
        dlg.setVisible(true);
        if (dlg.getOption() == 0) {
            return dlg.getFont();
        }
        return null;
    }

    private static AdvancedFontChooser create(GuiFactoryImpl gf, int chooseFlags, int minSize, int maxSize, Hashtable font) {
        Float size;
        String family;
        String defaultFamily;
        if (maxSize == 0) {
            maxSize = Integer.MAX_VALUE;
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        List<String> fontList = new ArrayList<String>();
        fontList.addAll(Arrays.asList(ge.getAvailableFontFamilyNames()));
        if ((chooseFlags & 1) == 1) {
            fontList = AdvancedFontChooser.filterFonts(fontList);
            defaultFamily = "Monospaced";
        } else {
            defaultFamily = "Dialog";
        }
        String[] fontNames = fontList.toArray(new String[fontList.size()]);
        ArrayList<Integer> fsz = new ArrayList<Integer>();
        for (int sz : new int[]{8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48, 72}) {
            if (sz < minSize || sz > maxSize) continue;
            fsz.add(sz);
        }
        Integer[] fontSizes = fsz.toArray(new Integer[fsz.size()]);
        int screenRes = gf != null ? gf.getScreenRes() : Toolkit.getDefaultToolkit().getScreenResolution();
        AdvancedFontChooser dlg = new AdvancedFontChooser(new JFrame(), screenRes, fontNames, fontSizes);
        SimpleAttributeSet a = new SimpleAttributeSet();
        if (font != null) {
            family = (String)font.get(FontAttribute.FAMILY);
            if (family == null || family.length() == 0) {
                family = defaultFamily;
            }
            if ((size = (Float)font.get(FontAttribute.SIZE)) == null) {
                size = new Float(12.0);
            }
        } else {
            family = defaultFamily;
            size = new Float(12.0);
        }
        if (size.floatValue() < (float)minSize) {
            size = new Float(minSize);
        }
        if (size.floatValue() > (float)maxSize) {
            size = new Float(maxSize);
        }
        StyleConstants.setFontFamily(a, family);
        StyleConstants.setFontSize(a, size.intValue());
        if (font != null) {
            Object val = font.get(FontAttribute.WEIGHT);
            if (val != null && FontAttribute.WEIGHT_BOLD.compareTo((Float)val) <= 0) {
                StyleConstants.setBold(a, true);
            }
            if ((val = font.get(FontAttribute.POSTURE)) != null && FontAttribute.POSTURE_OBLIQUE.compareTo((Float)val) == 0) {
                StyleConstants.setItalic(a, true);
            }
            if ((val = font.get(FontAttribute.UNDERLINE)) != null && FontAttribute.UNDERLINE_ON.compareTo((Integer)val) == 0) {
                StyleConstants.setUnderline(a, true);
            }
            if ((val = font.get(FontAttribute.STRIKETHROUGH)) != null && ((Boolean)val).booleanValue()) {
                StyleConstants.setStrikeThrough(a, true);
            }
        }
        dlg.setAttributes(a);
        return dlg;
    }

    private static List<String> filterFonts(List<String> fn) {
        JLabel target = new JLabel();
        ArrayList<String> al = new ArrayList<String>();
        for (String s : fn) {
            FontMetrics fm = target.getFontMetrics(new Font(s, 0, 20));
            if (fm.charWidth('i') != fm.charWidth('W')) continue;
            al.add(s);
        }
        return al;
    }
}

