/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;

public class CheckBox
extends JCheckBox {
    private static final long serialVersionUID = 1L;
    private static final int LEFT_TEXT_LEFT = 1;
    private static Dimension dimcb;
    private static Insets inscb;
    private static Insets inscbbrd;
    private boolean flat;
    private String title;
    private Image image;
    private Border defaultBorder;
    private int bitmapNumber;
    private int bitmapDisabled;
    private int bitmapDisabledSelected;
    private int bitmapPressed;
    private int bitmapRollover;
    private int bitmapSelected;
    private int bitmapRolloverSelected;
    private int bitmapWidth;
    private int imageHeight;
    private int imageWidth;
    private Dimension origSize;
    private boolean multiline;
    private int titlePosition;
    private boolean hasBitmap;
    private boolean vTop;
    private char mnemonic;
    private Integer defaultIconTextGap;
    private int leftTextAlignment;
    private boolean leftText;
    private Color background;
    private Color foreground;
    private Color disabledBackground;
    private Color disabledForeground;
    private Color rolloverBackground;
    private Color rolloverForeground;
    private boolean isMouseHovering;
    private boolean scaleDefaultIcon;
    private int bitmapScale;

    public CheckBox() {
        this.setOpaque(true);
        if (dimcb == null) {
            JCheckBox jcbstatic = new JCheckBox();
            dimcb = jcbstatic.getPreferredSize();
            inscb = jcbstatic.getMargin();
            if (jcbstatic.getBorder() != null) {
                inscbbrd = jcbstatic.getBorder().getBorderInsets(jcbstatic);
            }
            if (inscbbrd != null) {
                inscb = inscbbrd;
            }
        }
        this.addItemListener(e -> {
            this.drawBorder(this.isSelected());
            if (this.scaleDefaultIcon) {
                this.scaleDefaultIcon();
            }
        });
        this.addMouseListener(IsguiUtility.mouseAdapter(e -> {
            this.isMouseHovering = true;
            if (this.isEnabled()) {
                if (this.flat && this.hasBitmap && this.bitmapSelected == 0 && !this.isSelected()) {
                    this.setBorder(BorderFactory.createRaisedSoftBevelBorder());
                }
                if (this.rolloverBackground != null || this.rolloverForeground != null) {
                    this.updateColors();
                }
            }
        }, e -> {
            this.isMouseHovering = false;
            if (this.isEnabled()) {
                if (this.flat && this.hasBitmap && this.bitmapSelected == 0 && !this.isSelected()) {
                    this.setBorder(null);
                }
                if (this.rolloverBackground != null || this.rolloverForeground != null) {
                    this.updateColors();
                }
            }
        }, null, e -> {
            if (this.flat && this.hasBitmap && this.bitmapSelected == 0 && this.isEnabled() && !this.isSelected()) {
                this.setBorder(null);
            }
        }, null));
    }

    void setScaleDefaultIcon(boolean b) {
        if (b != this.scaleDefaultIcon) {
            this.scaleDefaultIcon = b;
            if (!this.hasBitmap) {
                if (this.scaleDefaultIcon) {
                    Image[] im = RemoteBaseGUIControl.getDefaultScalableCheckBoxImages(this.isSelected());
                    this.setIcon(new ImageIcon(im[0]));
                    this.setDisabledIcon(new ImageIcon(im[1]));
                } else {
                    this.setIcon(null);
                    this.setDisabledIcon(null);
                }
            }
        }
    }

    private void updateColors() {
        this.updateBackground();
        this.updateForeground();
    }

    private void updateBackground() {
        if (this.isEnabled()) {
            if (this.isMouseHovering && this.rolloverBackground != null) {
                super.setBackground(this.rolloverBackground);
            } else {
                super.setBackground(this.background);
            }
        } else if (this.disabledBackground != null) {
            super.setBackground(this.disabledBackground);
        } else {
            super.setBackground(this.background);
        }
    }

    private void updateForeground() {
        if (this.isEnabled()) {
            if (this.isMouseHovering && this.rolloverForeground != null) {
                super.setForeground(this.rolloverForeground);
            } else {
                super.setForeground(this.foreground);
            }
        } else if (this.disabledForeground != null) {
            super.setForeground(this.disabledForeground);
        } else {
            super.setForeground(this.foreground);
        }
    }

    @Override
    public void setEnabled(boolean en) {
        boolean old = this.isEnabled();
        super.setEnabled(en);
        if (old != en) {
            this.updateColors();
            if (this.scaleDefaultIcon) {
                this.scaleDefaultIcon();
            }
        }
    }

    @Override
    public void setBackground(Color bg) {
        this.background = bg;
        this.updateBackground();
    }

    @Override
    public void setForeground(Color fg) {
        if (fg != null && !(fg instanceof ColorUIResource)) {
            fg = new ColorUIResource(fg);
        }
        this.foreground = fg;
        this.updateForeground();
    }

    public void setHasBitmap(boolean b) {
        if (this.hasBitmap != b) {
            this.hasBitmap = b;
        }
        this.origSize = this.getSize();
    }

    public void setVTop(boolean vtop) {
        this.vTop = vtop;
        if (this.titlePosition != 3 && this.titlePosition != 4) {
            if (this.vTop) {
                this.setVerticalTextPosition(1);
                this.setVerticalAlignment(1);
            } else {
                this.setVerticalTextPosition(0);
                this.setVerticalAlignment(0);
            }
        }
    }

    public void setBoundsMinimized(int x, int y, int width, int height) {
        if (!(inscb == null || this.hasBitmap || this.title != null && this.title.length() != 0 || dimcb == null || CheckBox.dimcb.width <= 0 || width > CheckBox.dimcb.width - CheckBox.inscb.left - CheckBox.inscb.right + 1)) {
            this.setMargin(null);
            if (width <= CheckBox.dimcb.width - CheckBox.inscb.right - CheckBox.inscb.left + 1) {
                this.setBorder(BorderFactory.createEmptyBorder(CheckBox.inscb.top, 0, CheckBox.inscb.bottom, 0));
                width = CheckBox.dimcb.width - CheckBox.inscb.right - CheckBox.inscb.left;
            } else if (this.leftText) {
                this.setBorder(BorderFactory.createEmptyBorder(CheckBox.inscb.top, 0, CheckBox.inscb.bottom, CheckBox.inscb.right));
                width = this.getPreferredSize().width;
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(CheckBox.inscb.top, CheckBox.inscb.left, CheckBox.inscb.bottom, 0));
                width = this.getPreferredSize().width;
            }
            super.setBounds(x, y, width, height);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        Dimension oldSize = this.getSize();
        super.setBounds(x, y, width, height);
        if (this.hasBitmap && (oldSize.width != width || oldSize.height != height)) {
            if (this.bitmapScale > 0) {
                this.setIcons();
            } else if (this.titlePosition == 0 && (oldSize.height != height || this.bitmapWidth == 0)) {
                this.setIcons();
            }
        }
        if (oldSize.width != width) {
            this.updateIconTextGap();
        }
        if (oldSize.height != height) {
            this.scaleDefaultIcon();
        }
    }

    private void scaleDefaultIcon() {
        if (this.hasBitmap || !this.scaleDefaultIcon || this.origSize == null) {
            return;
        }
        float scaleY = (float)this.getSize().height / (float)this.origSize.height;
        Image[] im = RemoteBaseGUIControl.getDefaultScalableCheckBoxImages(this.isSelected());
        im[0] = RemoteBaseGUIControl.getScaledImage(im[0], scaleY);
        im[1] = RemoteBaseGUIControl.getScaledImage(im[1], scaleY);
        this.setIcon(new ImageIcon(im[0]));
        this.setDisabledIcon(new ImageIcon(im[1]));
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.updateIconTextGap();
    }

    public void setLeftText(boolean lt) {
        this.leftText = lt;
        if (this.leftText) {
            if (this.titlePosition != 3 && this.titlePosition != 4) {
                this.setTitlePosition(1);
            }
        } else if (this.titlePosition != 3 && this.titlePosition != 4) {
            this.setTitlePosition(2);
        }
    }

    public void setMultiline(boolean m) {
        this.multiline = m;
        this.setTitle(this.title);
    }

    public void setBitmapNumber(int n) {
        this.bitmapNumber = n;
        if (this.image != null) {
            this.setIcon(this.getIcon(this.bitmapNumber));
        }
    }

    public void setBitmapDisabled(int n) {
        this.bitmapDisabled = n;
        if (this.image != null) {
            this.setDisabledIcon(this.getIcon(this.bitmapDisabled));
        }
    }

    public void setBitmapDisabledSelected(int n) {
        this.bitmapDisabledSelected = n;
        if (this.image != null) {
            this.setDisabledSelectedIcon(this.getIcon(this.bitmapDisabledSelected));
        }
    }

    public void setBitmapRollover(int n) {
        this.bitmapRollover = n;
        if (this.image != null) {
            this.setRolloverIcon(this.getIcon(this.bitmapRollover));
        }
    }

    public void setBitmapSelected(int n) {
        this.bitmapSelected = n;
        if (this.image != null) {
            this.setSelectedIcon(this.getIcon(this.bitmapSelected));
        }
    }

    public void setBitmapRolloverSelected(int n) {
        this.bitmapRolloverSelected = n;
        if (this.image != null) {
            this.setRolloverSelectedIcon(this.getIcon(this.bitmapRolloverSelected));
        }
    }

    public void setBitmapPressed(int n) {
        this.bitmapPressed = n;
        if (this.image != null) {
            this.setPressedIcon(this.getIcon(this.bitmapPressed));
        }
    }

    public void setBitmapWidth(int w) {
        this.bitmapWidth = w;
    }

    private Icon getIcon(int strip) {
        Image imageStrip;
        if (strip <= 0) {
            return null;
        }
        Dimension sz = this.getSize();
        int imgWidth = this.bitmapWidth > 0 ? this.bitmapWidth : (this.titlePosition != 0 || this.bitmapScale > 0 ? this.imageWidth : this.imageWidth + sz.width - this.origSize.width);
        int imgHeight = this.titlePosition != 0 || this.bitmapScale > 0 ? this.imageHeight : this.imageHeight + sz.height - this.origSize.height;
        if (this.bitmapScale > 0 && (this.titlePosition == 0 || this.origSize != null)) {
            int scType;
            int align;
            if (this.bitmapScale == 1) {
                align = 5;
                scType = 0;
            } else {
                align = 7;
                scType = 1;
            }
            if (this.titlePosition != 0) {
                imageStrip = ScreenUtility.getImage(imgWidth, imgHeight, this.image, strip);
                float scaleX = (float)sz.width / (float)this.origSize.width;
                float scaleY = (float)sz.height / (float)this.origSize.height;
                if (imageStrip != null && (scaleX != 1.0f || scaleY != 1.0f)) {
                    imgWidth = Math.round(scaleX * (float)imageStrip.getWidth(null));
                    imgHeight = Math.round(scaleY * (float)imageStrip.getHeight(null));
                    imageStrip = IsguiUtility.scale(imageStrip, imgWidth, imgHeight, scType, align, false);
                }
            } else if (this.image != null) {
                imageStrip = ScreenUtility.getImage(this.bitmapWidth == 0 ? this.image.getWidth(null) : imgWidth, this.image.getHeight(null), this.image, strip);
                if (sz.width - 8 != imageStrip.getWidth(null) || sz.height - 7 != imageStrip.getHeight(null)) {
                    imageStrip = IsguiUtility.scale(imageStrip, sz.width - 8, sz.height - 7, scType, align, false);
                }
            } else {
                imageStrip = null;
            }
        } else {
            imageStrip = ScreenUtility.getImage(imgWidth, imgHeight, this.image, strip);
        }
        if (imageStrip != null) {
            return new ImageIcon(imageStrip);
        }
        return null;
    }

    public void setImage(Image image, int width, int height) {
        if (this.image != image || this.imageWidth != width || this.imageHeight != height) {
            this.setHasBitmap(image != null);
            this.image = image;
            this.imageHeight = height;
            this.imageWidth = width;
            if (this.bitmapNumber == 0) {
                this.bitmapNumber = 1;
            }
            this.setIcons();
            if (this.hasBitmap) {
                if (this.bitmapSelected > 0 && this.flat) {
                    this.setBorderPainted(false);
                } else {
                    this.setBorderPainted(true);
                }
            }
        }
    }

    private void setIcons() {
        this.setIcon(this.getIcon(this.bitmapNumber));
        this.setDisabledIcon(this.getIcon(this.bitmapDisabled));
        this.setDisabledSelectedIcon(this.getIcon(this.bitmapDisabledSelected));
        this.setRolloverIcon(this.getIcon(this.bitmapRollover));
        this.setPressedIcon(this.getIcon(this.bitmapPressed));
        this.setSelectedIcon(this.getIcon(this.bitmapSelected));
        this.setRolloverSelectedIcon(this.getIcon(this.bitmapRolloverSelected));
    }

    public void drawBorder(boolean selected) {
        if (this.hasBitmap && this.bitmapSelected == 0) {
            if (selected) {
                this.setBorder(BorderFactory.createLoweredSoftBevelBorder());
            } else if (this.flat) {
                this.setBorder(null);
            } else {
                this.setBorder(BorderFactory.createRaisedSoftBevelBorder());
            }
        }
    }

    @Override
    public void setVisible(boolean v) {
        super.setVisible(v);
        if (v) {
            this.drawBorder(this.isSelected());
        }
    }

    public void setFlat(boolean f) {
        this.flat = f;
        if (this.flat) {
            this.defaultBorder = this.getBorder();
            this.setBorder(null);
            this.setContentAreaFilled(false);
            if (this.hasBitmap && this.titlePosition == 0 && this.title == null) {
                this.setHorizontalAlignment(0);
            }
            if (this.bitmapSelected > 0) {
                this.setBorderPainted(false);
            }
        } else {
            if (this.defaultBorder != null) {
                this.setBorder(this.defaultBorder);
            }
            this.setContentAreaFilled(true);
        }
    }

    public void setTitle(String t) {
        this.title = t;
        t = ScreenUtility.rightTrim(this.title);
        if (t != null) {
            StringBuffer sb = new StringBuffer(t);
            int idx = ScreenUtility.getMnemonicIdx(sb);
            if (idx >= 0) {
                this.mnemonic = sb.charAt(idx);
            }
            if (this.hasBitmap && this.titlePosition <= 0) {
                this.setText(null);
                if (this.getToolTipText() == null || this.getToolTipText().length() == 0) {
                    super.setToolTipText(RemoteBaseGUIControl.buildTitle(sb.toString(), idx, false));
                }
            } else if (this.multiline) {
                this.setText(RemoteBaseGUIControl.buildTitle(sb.toString(), idx, false, false, true, false));
            } else {
                this.setText(sb.toString());
                if (idx >= 0 && idx < sb.length()) {
                    this.setDisplayedMnemonicIndex(idx);
                }
            }
        }
        this.updateIconTextGap();
    }

    @Override
    public void setToolTipText(String tt) {
        super.setToolTipText(tt);
        if ((tt == null || tt.length() == 0) && this.title != null && this.hasBitmap && this.titlePosition <= 0) {
            this.setTitle(this.title);
        }
    }

    public void setTitlePosition(int pos) {
        int oldPos = this.titlePosition;
        this.titlePosition = pos;
        switch (this.titlePosition) {
            case 2: {
                this.setHorizontalTextPosition(4);
                this.setVerticalTextPosition(0);
                this.setHorizontalAlignment(2);
                break;
            }
            case 1: {
                this.setHorizontalTextPosition(2);
                this.setVerticalTextPosition(0);
                if (this.leftText) {
                    this.setHorizontalAlignment(4);
                    break;
                }
                this.setHorizontalAlignment(2);
                break;
            }
            case 3: {
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(1);
                this.setHorizontalAlignment(0);
                break;
            }
            case 4: {
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(3);
                this.setHorizontalAlignment(0);
            }
        }
        if (oldPos == 0 ^ pos == 0) {
            this.setTitle(this.title);
        }
    }

    public int getLeftTextAlignment() {
        return this.leftTextAlignment;
    }

    public void setLeftTextAlignment(int leftTextAlignment) {
        this.leftTextAlignment = leftTextAlignment;
        if (this.titlePosition == 1 && this.leftText) {
            this.updateIconTextGap();
        }
    }

    private int getDefaultIconTextGap() {
        if (this.defaultIconTextGap == null) {
            this.defaultIconTextGap = new Integer(this.getIconTextGap());
        }
        return this.defaultIconTextGap;
    }

    private void updateIconTextGap() {
        int prefWidth;
        int realWidth;
        int ditg = this.getDefaultIconTextGap();
        this.setIconTextGap(ditg);
        if (this.leftText && this.leftTextAlignment == 1 && this.titlePosition != 3 && this.titlePosition != 4 && (realWidth = this.getSize().width) > (prefWidth = this.getPreferredSize().width)) {
            this.setIconTextGap(realWidth - prefWidth + ditg);
        }
    }

    public char getMnemonicChar() {
        return this.mnemonic;
    }

    public Color getDisabledBackground() {
        return this.disabledBackground;
    }

    public void setDisabledBackground(Color disabledBackground) {
        this.disabledBackground = disabledBackground;
        if (!this.isEnabled()) {
            this.updateBackground();
        }
    }

    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    public void setDisabledForeground(Color disabledForeground) {
        this.disabledForeground = disabledForeground;
        if (!this.isEnabled()) {
            this.updateForeground();
        }
    }

    public Color getRolloverBackground() {
        return this.rolloverBackground;
    }

    public void setRolloverBackground(Color rolloverBackground) {
        this.rolloverBackground = rolloverBackground;
        if (this.isEnabled()) {
            this.updateBackground();
        }
    }

    public Color getRolloverForeground() {
        return this.rolloverForeground;
    }

    public void setRolloverForeground(Color rolloverForeground) {
        this.rolloverForeground = rolloverForeground;
        if (this.isEnabled()) {
            this.updateForeground();
        }
    }

    public int getBitmapScale() {
        return this.bitmapScale;
    }

    public void setBitmapScale(int bitmapScale) {
        switch (bitmapScale) {
            case 1: 
            case 2: {
                this.bitmapScale = bitmapScale;
                break;
            }
            default: {
                this.bitmapScale = 0;
            }
        }
    }
}

