/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.ComboBox;
import com.iscobol.rts.Factory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class FindJPanel
extends JPanel
implements KeyListener {
    private static final long serialVersionUID = 1246L;
    private static final int SIZEIMG = 24;
    JPanel panelbutton = null;
    JPanel panelfind = null;
    JButton closebtn;
    JButton clearbtn;
    JToggleButton casesensitivebtn;
    JTextComponent findfield;
    ComboBox findcombo;
    Font font;
    Border syntaxborderok;
    ImageIcon closeIcon;
    ImageIcon findIcon;
    ImageIcon clearIcon;
    ImageIcon casesensitiveIcon;
    ImageIcon casenotsensitiveIcon;
    int propsearchpanel = 0;
    private FindListener listener;

    private Object makeObj(final String item) {
        return new Object(){

            public String toString() {
                return item;
            }
        };
    }

    public FindJPanel(Font font, ImageIcon closeIcon, ImageIcon findIcon, ImageIcon clearIcon, ImageIcon casesensitiveIcon, ImageIcon casenotsensitiveIcon, boolean casesensitiveState, int propsearchpanel, int findtimerdelay) {
        this.font = font;
        this.findIcon = findIcon;
        this.closeIcon = closeIcon;
        this.propsearchpanel = propsearchpanel;
        this.setLayout(new BorderLayout(2, 2));
        this.setFont(font);
        this.findcombo = new ComboBox(false, false);
        this.findcombo.setEditable(true);
        this.findcombo.setPlaceholder(Factory.getSysMsg("enter_text_to_search"));
        ((JLabel)((Object)this.findcombo.getRenderer())).setVerticalAlignment(0);
        this.findfield = (JTextComponent)this.findcombo.getEditor().getEditorComponent();
        this.syntaxborderok = this.findfield.getBorder();
        this.findfield.addKeyListener(this);
        if (findtimerdelay > 0) {
            this.findfield.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    FindJPanel.this.listenerfindText(FindJPanel.this.findfield.getText());
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    FindJPanel.this.listenerfindText(FindJPanel.this.findfield.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    FindJPanel.this.listenerfindText(FindJPanel.this.findfield.getText());
                }
            });
        }
        this.clearbtn = new JButton(clearIcon);
        this.clearbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindJPanel.this.clearperformed();
                FindJPanel.this.listenerfindText(FindJPanel.this.findfield.getText(), false);
                FindJPanel.this.listener.sendfinishfiltermsg();
            }
        });
        this.clearbtn.addKeyListener(this);
        this.clearbtn.setToolTipText(Factory.getSysMsg("Clear"));
        this.casesensitivebtn = new JToggleButton();
        this.casesensitivebtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindJPanel.this.listenerfindText(FindJPanel.this.findfield.getText());
            }
        });
        this.casesensitivebtn.addKeyListener(this);
        this.casesensitivebtn.setPreferredSize(new Dimension(24, 24));
        this.casesensitivebtn.setToolTipText(Factory.getSysMsg("match_case"));
        this.casesensitivebtn.setContentAreaFilled(true);
        this.casesensitivebtn.setIcon(casenotsensitiveIcon);
        this.casesensitivebtn.setSelectedIcon(casesensitiveIcon);
        this.casesensitivebtn.setSelected(casesensitiveState);
        this.clearbtn.setBorderPainted(true);
        this.casesensitivebtn.setBorderPainted(true);
        this.clearbtn.setContentAreaFilled(true);
        this.clearbtn.setPreferredSize(new Dimension(24, 24));
        if (propsearchpanel == 0) {
            this.closebtn = new JButton(closeIcon);
            this.closebtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindJPanel.this.closeperformed();
                    FindJPanel.this.listener.sendfinishfiltermsg();
                }
            });
            this.closebtn.addKeyListener(this);
            this.closebtn.setPreferredSize(new Dimension(24, 24));
            this.closebtn.setMinimumSize(new Dimension(0, 24));
            this.closebtn.setToolTipText(Factory.getSysMsg("close_find_bar"));
            this.closebtn.setContentAreaFilled(true);
            this.closebtn.setBorderPainted(true);
            this.closebtn.setFont(font);
            this.add((Component)this.closebtn, "West");
        } else if (this.closebtn != null) {
            this.remove(this.closebtn);
        }
        this.findcombo.setFont(font);
        this.clearbtn.setFont(font);
        this.casesensitivebtn.setFont(font);
        this.findcombo.setMinimumSize(new Dimension(0, 24));
        this.clearbtn.setMinimumSize(new Dimension(0, 24));
        this.casesensitivebtn.setMinimumSize(new Dimension(0, 24));
        this.add((Component)this.findcombo, "Center");
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add((Component)this.clearbtn, "West");
        jp.add((Component)this.casesensitivebtn, "East");
        this.add((Component)jp, "East");
        this.addKeyListener(this);
        this.setVisible(true);
        this.findfield.requestFocus();
    }

    private void findperformed() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.findcombo.getModel();
        String tmp = this.findfield.getText();
        int n = this.findcombo.getItemCount();
        boolean founded = false;
        for (int i = 0; !founded && i < n; ++i) {
            if (!this.findcombo.getItemAt(i).toString().equals(tmp)) continue;
            founded = true;
        }
        if (!founded) {
            this.findcombo.addItem(tmp);
            this.findfield.setText(tmp);
        }
    }

    public void clearperformed() {
        this.findfield.setText("");
        this.findfield.requestFocus();
    }

    public void closeperformed() {
        this.findperformed();
        this.setVisible(false);
        this.listener.refreshSelection();
        this.listener.requestFocus();
        this.findfield.setText("");
        this.listener.findTextClear(false);
    }

    public void setFindListener(FindListener fl) {
        this.listener = fl;
    }

    public FindListener getFindListener() {
        return this.listener;
    }

    public void findfieldsetBorder(Border b) {
        if (this.findfield != null) {
            this.findfield.setBorder(b);
        }
    }

    public void findfieldrequestFocus() {
        if (this.findfield != null) {
            this.findfield.requestFocus();
        }
    }

    public void findfieldfindText() {
        if (this.findfield != null && this.findfield.getText() != null && this.findfield.getText().length() > 0) {
            this.listenerfindText(this.findfield.getText());
        }
    }

    public void findfieldfindText(boolean starttimer) {
        if (this.findfield != null && this.findfield.getText() != null && this.findfield.getText().length() > 0) {
            this.listenerfindText(this.findfield.getText(), starttimer);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        Component src;
        if (!(e.getKeyCode() != 10 || (src = (Component)e.getSource()) != this.findfield && src instanceof JButton)) {
            this.listener.sendfinishfiltermsg();
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        Component src = (Component)evt.getSource();
        switch (evt.getKeyCode()) {
            case 9: {
                if (evt.isShiftDown()) {
                    if (src == this.closebtn) break;
                    src.transferFocusBackward();
                    break;
                }
                if (src == this.casesensitivebtn) break;
                src.transferFocus();
                break;
            }
            case 38: {
                if (src == this.closebtn) break;
                src.transferFocusBackward();
                break;
            }
            case 37: {
                if (src == this.closebtn || src == this.findfield) break;
                src.transferFocusBackward();
                break;
            }
            case 40: {
                if (src == this.clearbtn) break;
                src.transferFocus();
                break;
            }
            case 39: {
                if (src == this.closebtn || src == this.findfield) break;
                src.transferFocus();
                break;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Component src = (Component)e.getSource();
            if (src == this.findfield || !(src instanceof JButton)) {
                this.findperformed();
                this.listenerfindText(this.findfield.getText(), false);
            } else if (src == this.closebtn) {
                this.closebtn.doClick();
                this.listener.sendfinishfiltermsg();
            } else if (src == this.clearbtn) {
                this.clearbtn.doClick();
                this.listener.sendfinishfiltermsg();
            }
        } else if (e.getKeyCode() == 27) {
            if (this.propsearchpanel == 1) {
                this.clearperformed();
            } else {
                this.closeperformed();
                this.listener.sendfinishfiltermsg();
            }
        } else if (this.listener.isFindKeyPressed(e)) {
            this.findfield.selectAll();
            this.findfield.requestFocus();
        }
    }

    private void listenerfindText(String regexptxt) {
        this.listenerfindText(regexptxt, true);
    }

    private void listenerfindText(String regexptxt, boolean starttimer) {
        this.listener.findText(regexptxt, starttimer, this.casesensitivebtn.isSelected());
    }

    public void setFontFindComponents(Font f) {
        if (this.panelbutton != null) {
            this.panelbutton.setFont(f);
        }
        if (this.panelfind != null) {
            this.panelfind.setFont(f);
        }
        if (this.closebtn != null) {
            this.closebtn.setFont(f);
        }
        if (this.clearbtn != null) {
            this.clearbtn.setFont(f);
        }
        if (this.casesensitivebtn != null) {
            this.casesensitivebtn.setFont(f);
        }
        if (this.findfield != null) {
            this.findfield.setFont(f);
        }
        if (this.findcombo != null) {
            this.findcombo.setFont(f);
        }
    }

    public Font getFontFindComponents() {
        if (this.panelfind != null) {
            return this.panelfind.getFont();
        }
        return null;
    }

    public String getFindFieldText() {
        return this.findfield.getText();
    }

    public boolean isCasesensitive() {
        return this.casesensitivebtn.isSelected();
    }

    public static interface FindListener {
        public void findText(String var1, boolean var2, boolean var3);

        public void findTextClear(boolean var1);

        public boolean isFindKeyPressed(KeyEvent var1);

        public void refreshSelection();

        public void requestFocus();

        public void sendfinishfiltermsg();
    }
}

