/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlrenderer;

import com.iscobol.gui.Events;
import com.iscobol.gui.IsguiUtility;
import com.iscobol.htmlrenderer.CSSStyle;
import com.iscobol.htmlrenderer.CheckBoxImage;
import com.iscobol.htmlrenderer.RadioButtonImage;
import com.iscobol.htmlrenderer.UncheckBoxImage;
import com.iscobol.htmlrenderer.UnradioButtonImage;
import com.iscobol.rts.BitmapNotFoundException;
import com.iscobol.rts.Config;
import com.iscobol.rts.FileImage;
import com.iscobol.rts.UserHandles;
import com.iscobol.rts.print.LocalSpoolPrinter;
import com.iscobol.rts.print.SpoolPrinterList;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.print.attribute.Size2DSyntax;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import org.xml.sax.Attributes;

public class Drawer {
    public static final float PIX2PT = 0.75f;
    public static final int CUSTOM_PAPER = 9999;
    public static final String CUSTOM_PAPER_NAME = "custom";
    public static final int DEFAULT_PAPER = 9;
    public static final Map defaultFont = new Font("default", 0, 12).getAttributes();
    public static final Color defaultColor = Color.black;
    public static final Color defaultBrush = new Color(255, 255, 255, 0);
    public static FileImage checkBox;
    public static FileImage uncheckBox;
    public static FileImage radioButton;
    public static FileImage unradioButton;
    private static final Size2DSyntax customPaperSize;
    static final String[] media;
    final LocalSpoolPrinter thePrinter;
    private final HashMap<String, FileImage> images = new HashMap();
    private final Stack contexts = new Stack();
    private Map currFont;
    private Color currColor;
    private Color currBrush;
    private boolean inBody;
    private boolean landscape;
    private int currPaper;
    private int divDepth = -1;
    private ArrayList<int[]> divSizes = new ArrayList();
    private float _topMargin = 54.0f;
    private float _leftMargin = 54.0f;
    private float _bottomMargin = 54.0f;
    private float _rightMargin = 54.0f;
    private boolean lightGrayIsTransparent = Config.getProperty("iscobol.gui.light_gray_is_transparent", true);
    private HashSet<Integer> handlesToFree = new HashSet();

    public static boolean areEqual(Map font1, Map font2) {
        if (font1 != null) {
            if (font2 != null) {
                if (font1.size() == font2.size()) {
                    Set keys = font1.keySet();
                    for (Object key : keys) {
                        if (font1.get(key) != null) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return font2 == null;
    }

    public Drawer(Events events) throws IOException {
        this(events, false);
    }

    public Drawer(Events events, boolean pdfOnServer) throws IOException {
        if (pdfOnServer) {
            boolean serverSide = SpoolPrinterList.get().isServerSide();
            SpoolPrinterList.get().setServerSide(true);
            this.thePrinter = SpoolPrinterList.get().newSpoolPrinter(false, false, true, "-p preview", false, events);
            SpoolPrinterList.get().setServerSide(serverSide);
        } else {
            this.thePrinter = SpoolPrinterList.get().newSpoolPrinter(false, false, false, "-p preview", false, events);
        }
        this.currPaper = 9;
        this.thePrinter.setMediaSize(this.currPaper);
    }

    private FileImage getImage(String path) {
        FileImage Return2 = this.images.get(path);
        if (Return2 == null) {
            try {
                URL u = new URL(path);
                Return2 = new FileImage(u.openStream(), path);
            }
            catch (Exception u) {
                // empty catch block
            }
            if (Return2 == null) {
                try {
                    Return2 = new FileImage(path);
                }
                catch (BitmapNotFoundException _ex) {
                    Return2 = FileImage.getBroken();
                }
            }
            this.images.put(path, Return2);
        }
        return Return2;
    }

    public void setLandscape(boolean lndscp) {
        this.landscape = lndscp;
        try {
            if (this.landscape) {
                this.thePrinter.setOrientation(2);
            } else {
                this.thePrinter.setOrientation(1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isLandscape() {
        return this.landscape;
    }

    public String getPaperName() {
        if (this.currPaper == 9999) {
            return CUSTOM_PAPER_NAME;
        }
        if (this.currPaper > 0 && this.currPaper < media.length) {
            return media[this.currPaper];
        }
        return "unset";
    }

    public float[] getPaperSize(int unit) {
        try {
            Size2DSyntax s2d = this.thePrinter.getCurrMediaSize2D();
            if (s2d != null) {
                return s2d.getSize(25400);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new float[]{0.0f, 0.0f};
    }

    public int[] getMargins() {
        int[] Return2 = new int[4];
        try {
            double[] mrgns = this.thePrinter.getMargins(2);
            Return2[0] = (int)Math.round(mrgns[2] * 100.0);
            Return2[1] = (int)Math.round(mrgns[3] * 100.0);
            Return2[2] = (int)Math.round(mrgns[0] * 100.0);
            Return2[3] = (int)Math.round(mrgns[1] * 100.0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Return2;
    }

    public void setMargins(double left, double right, double top, double bottom) {
        this._topMargin = (float)top * 72.0f;
        this._leftMargin = (float)left * 72.0f;
        this._rightMargin = (float)right * 72.0f;
        this._bottomMargin = (float)bottom * 72.0f;
        try {
            this.thePrinter.setMargins(top, bottom, left, right, 2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean setCustomPaperSize(float width, float height) {
        boolean Return2;
        try {
            Return2 = this.thePrinter.setCustomMediaSize(width, height, 2);
            this.currPaper = 9999;
        }
        catch (IOException _ex) {
            Return2 = false;
        }
        return Return2;
    }

    public boolean setPaperSize(String psName) {
        if (CUSTOM_PAPER_NAME.equals(psName = psName.trim().toLowerCase())) {
            boolean Return2;
            try {
                Return2 = this.thePrinter.setCustomMediaSize(customPaperSize.getX(25400), customPaperSize.getY(25400), 2);
                this.currPaper = 9999;
            }
            catch (IOException _ex) {
                Return2 = false;
            }
            return Return2;
        }
        for (int i = 1; i < media.length; ++i) {
            if (!media[i].equalsIgnoreCase(psName)) continue;
            try {
                this.thePrinter.setMediaSize(i);
                this.currPaper = i;
            }
            catch (IOException _ex) {
                return false;
            }
            return true;
        }
        return false;
    }

    public void setup() {
        try {
            if (this.thePrinter.setup()) {
                this.currPaper = this.thePrinter.getCurrMediaSize();
                int or = this.thePrinter.getOrientation();
                this.landscape = or != 1 && or != 3;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public double[] setupPrint() {
        double[] Return2 = new double[]{};
        try {
            Return2 = this.thePrinter.setup(this._topMargin / 72.0f, this._bottomMargin / 72.0f, this._leftMargin / 72.0f, this._rightMargin / 72.0f);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Return2;
    }

    private Context startTag(String tagName) throws IOException {
        Context Return2;
        int size = this.contexts.size();
        Context ctx = null;
        for (int i = 0; i < size; ++i) {
            ctx = (Context)this.contexts.get(i);
            ctx.printText();
        }
        if (ctx == null) {
            Return2 = new Context(tagName);
            this.contexts.push(Return2);
        } else {
            Return2 = ctx.deepClone(tagName);
            this.contexts.push(Return2);
        }
        return Return2;
    }

    private void printPageHeader(int w) throws IOException {
    }

    private void printPageFooter(float w, float h) throws IOException {
    }

    public void startTag(String tagName, Attributes attrs, CSSStyle css) throws IOException {
        Context ctx = this.startTag(tagName);
        boolean newPage = false;
        if (this.inBody || (this.inBody = "body".equals(tagName))) {
            int width = 0;
            int height = 0;
            if ("div".equals(tagName)) {
                ++this.divDepth;
                if (this.divDepth == 1) {
                    this.thePrinter.newPage();
                    ctx.newPage();
                    newPage = true;
                    this.printPageHeader(width);
                } else if (this.divDepth == 0) {
                    this.divDepth = 1;
                    this.printPageHeader(width);
                }
                this.divSizes.add(new int[2]);
            }
            if (css != null) {
                int depth;
                CSSStyle.Border brd;
                int top;
                Object obj = css.get("top");
                if (obj != null) {
                    top = (Integer)obj;
                    if (newPage) {
                        top = 0;
                    }
                } else {
                    top = -1;
                }
                int left = (obj = css.get("left")) != null ? (Integer)obj : -1;
                obj = css.get("width");
                width = obj != null ? (Integer)obj : -1;
                obj = css.get("height");
                height = obj != null ? (Integer)obj : -1;
                if (this.divDepth > 0) {
                    int[] size = this.divSizes.get(this.divDepth - 1);
                    size[0] = width;
                    size[1] = height;
                }
                if ((obj = css.get("color")) != null) {
                    ctx.color = (Color)obj;
                }
                if ((obj = css.get("background-color")) != null) {
                    ctx.setBrush((Color)obj);
                }
                if (this.currBrush != null) {
                    if (ctx.brush == null) {
                        this.currBrush = defaultBrush;
                        this.thePrinter.setGraphBrush(0, this.currBrush.getRed(), this.currBrush.getGreen(), this.currBrush.getBlue(), this.currBrush.getAlpha());
                    } else if (!this.currBrush.equals(ctx.brush)) {
                        this.currBrush = ctx.brush;
                        this.thePrinter.setGraphBrush(0, this.currBrush.getRed(), this.currBrush.getGreen(), this.currBrush.getBlue(), this.currBrush.getAlpha());
                    }
                } else if (ctx.brush != null) {
                    this.currBrush = ctx.brush;
                    this.thePrinter.setGraphBrush(0, this.currBrush.getRed(), this.currBrush.getGreen(), this.currBrush.getBlue(), this.currBrush.getAlpha());
                }
                obj = css.get("text-align");
                if (obj != null) {
                    ctx.textAlign = obj.toString();
                }
                if ((obj = css.get("overflow")) != null) {
                    ctx.overflow = obj.toString();
                }
                if ((obj = css.get("border")) != null) {
                    brd = (CSSStyle.Border)obj;
                    depth = brd.getDepth();
                    Color col = brd.getColor();
                    if (col == null) {
                        col = ctx.color;
                    }
                    if (top >= 0 && left >= 0 && width > 0 && height > 0) {
                        this.drawBox(left, top, width, height, col, depth);
                    }
                } else {
                    obj = css.get("border-style");
                    if (obj != null) {
                        Integer depth2;
                        Color col = (Color)css.get("border-color");
                        if (col == null) {
                            col = ctx.color;
                        }
                        if ((depth2 = (Integer)css.get("border-width")) == null) {
                            depth2 = new Integer(3);
                        }
                        if (top >= 0 && left >= 0 && width > 0 && height > 0) {
                            this.drawBox(left, top, width, height, col, depth2.intValue());
                        }
                    } else {
                        obj = css.get("border-top");
                        if (obj != null) {
                            brd = (CSSStyle.Border)obj;
                            depth = brd.getDepth();
                            Color col = brd.getColor();
                            if (col == null) {
                                col = ctx.color;
                            }
                            if (top >= 0 && left >= 0 && width > 0 && height > 0) {
                                this.drawBox(left, top, width, height, col, depth);
                            }
                        } else {
                            obj = css.get("border-left");
                            if (obj != null) {
                                brd = (CSSStyle.Border)obj;
                                depth = brd.getDepth();
                                Color col = brd.getColor();
                                if (col == null) {
                                    col = ctx.color;
                                }
                                if (top >= 0 && left >= 0 && width > 0 && height > 0) {
                                    this.drawBox(left, top, width, height, col, depth);
                                }
                            } else if (ctx.brush != null) {
                                int w = width;
                                int h = height;
                                if (this.divDepth > 1) {
                                    int d;
                                    int[] parentSize = this.divSizes.get(this.divDepth - 2);
                                    if (w <= 0) {
                                        w = parentSize[0] - left;
                                    } else if (parentSize[0] > 0 && (d = w + left - parentSize[0]) > 0) {
                                        w -= d;
                                    }
                                    if (h <= 0) {
                                        h = parentSize[1] - top;
                                    } else if (parentSize[1] > 0 && (d = h + top - parentSize[1]) > 0) {
                                        h -= d;
                                    }
                                }
                                this.fillBox(left, top, w, h);
                            }
                        }
                    }
                }
                ctx.setPrintArea(left, top, width, height);
                obj = css.get("font-size");
                if (obj != null) {
                    ctx.font.put(TextAttribute.SIZE, ((CSSStyle.FontSizePt)obj).getValue());
                }
                if ((obj = css.get("font-family")) != null) {
                    ctx.font.put(TextAttribute.FAMILY, obj);
                }
                if ((obj = css.get("background")) != null && width > 0 && height > 0) {
                    String watermark = (String)obj;
                    int idx1 = watermark.indexOf(40);
                    int idx2 = watermark.indexOf(41);
                    if (idx1 >= 0 && idx2 > idx1) {
                        String url = watermark.substring(idx1 + 1, idx2);
                        boolean tile = watermark.indexOf("no-repeat", idx2 + 1) < 0;
                        InputStream is = null;
                        try {
                            is = new URL(url).openStream();
                        }
                        catch (Exception ex) {
                            try {
                                is = new FileInputStream(url);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (is != null) {
                            byte[] buff = new byte[4096];
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            int r = is.read(buff);
                            while (r >= 0) {
                                baos.write(buff, 0, r);
                                r = is.read(buff);
                            }
                            baos.close();
                            byte[] imgStream = baos.toByteArray();
                            is.close();
                            Image im = IsguiUtility.createImage(imgStream, new int[]{0}, true, this.lightGrayIsTransparent, Config.getProperty("iscobol.wbitmap.load_method", 1));
                            BufferedImage bkgImg = new BufferedImage(width, height, 2);
                            Graphics2D g = bkgImg.createGraphics();
                            if (tile) {
                                int imw = im.getWidth(null);
                                int imh = im.getHeight(null);
                                BufferedImage bim = new BufferedImage(imw, imh, 2);
                                Graphics2D bGr = bim.createGraphics();
                                bGr.drawImage(im, 0, 0, null);
                                bGr.dispose();
                                Rectangle bigr = new Rectangle(0, 0, imw, imh);
                                g.setPaint(new TexturePaint(bim, bigr));
                                g.fillRect(0, 0, width, height);
                            } else {
                                g.drawImage(im, (width - im.getWidth(null)) / 2, (height - im.getHeight(null)) / 2, null);
                            }
                            g.dispose();
                            baos = new ByteArrayOutputStream();
                            ImageIO.write((RenderedImage)bkgImg, "png", baos);
                            baos.close();
                            this.drawBitmap(new FileImage(baos.toByteArray()), width, height);
                        }
                    }
                }
            }
            if ("strong".equals(tagName)) {
                ctx.font.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            } else if ("em".equals(tagName)) {
                ctx.font.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            } else if ("u".equals(tagName)) {
                ctx.font.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            } else if (!"p".equals(tagName) && !"table".equals(tagName)) {
                if ("input".equals(tagName)) {
                    boolean checkbox = "checkbox".equalsIgnoreCase(attrs.getValue("type"));
                    if (checkbox || "radio".equalsIgnoreCase(attrs.getValue("type"))) {
                        FileImage img = attrs.getValue("checked") != null ? (checkbox ? (checkBox == null ? (checkBox = new CheckBoxImage()) : checkBox) : (radioButton == null ? (radioButton = new RadioButtonImage()) : radioButton)) : (checkbox ? (uncheckBox == null ? (uncheckBox = new UncheckBoxImage()) : uncheckBox) : (unradioButton == null ? (unradioButton = new UnradioButtonImage()) : unradioButton));
                        this.drawBitmap(img, img.getWidth(), img.getHeight());
                        ctx.moveRight(img.getWidth());
                        ctx.setBaselineDown(img.getHeight() - 5);
                    }
                } else if ("img".equals(tagName)) {
                    String fileName = attrs.getValue("src");
                    String s = attrs.getValue("width");
                    if (s != null) {
                        try {
                            width = Integer.parseInt(s);
                        }
                        catch (NumberFormatException _ex) {
                            width = 0;
                        }
                    }
                    if ((s = attrs.getValue("height")) != null) {
                        try {
                            height = Integer.parseInt(s);
                        }
                        catch (NumberFormatException _ex) {
                            height = 0;
                        }
                    }
                    if (fileName != null) {
                        this.drawBitmap(this.getImage(fileName), width, height);
                    }
                }
            }
        }
    }

    public void characters(char[] t, int offs, int len) {
        if (this.inBody && this.contexts.size() > 0) {
            ((Context)this.contexts.peek()).appendText(t, offs, len);
        }
    }

    public void characters(char[] t) {
        this.characters(t, 0, t.length);
    }

    public void characters(String s) {
        this.characters(s.toCharArray());
    }

    public void endTag() throws IOException {
        if (this.contexts.size() > 0) {
            Context ctx = (Context)this.contexts.pop();
            if (this.inBody) {
                ctx.printText();
                if ("div".equals(ctx.tagName)) {
                    this.divSizes.remove(this.divSizes.size() - 1);
                    --this.divDepth;
                    if (this.divDepth == 0) {
                        this.printPageFooter(ctx.getPageWidth(), ctx.getPageHeight());
                    }
                } else if ("body".equals(ctx.tagName)) {
                    this.inBody = false;
                }
            }
        }
    }

    public void drawBitmap(FileImage img, int w, int h) throws IOException {
        if (img.getImage() != null) {
            Context ctx = (Context)this.contexts.peek();
            double row = ctx.getPageTop();
            double col = ctx.getPageLeft();
            if (this.thePrinter.isServerSide()) {
                int bmapHndl = UserHandles.ssetId(img);
                this.thePrinter.printBitmap(bmapHndl, row, col, 4, (float)h * 0.75f, (float)w * 0.75f, 4);
                this.handlesToFree.add(bmapHndl);
            } else {
                int bmapHndl = img.getImage().getTheObjectId();
                this.thePrinter.printBitmap(bmapHndl, row, col, 4, (float)h * 0.75f, (float)w * 0.75f, 4);
            }
        }
    }

    public void drawBox(int x, int y, int w, int h, Color c, double penW) throws IOException {
        Context ctx = (Context)this.contexts.peek();
        if (c == null) {
            c = ctx.color;
        }
        penW = penW >= 1.0 ? penW : 0.0;
        this.thePrinter.setGraphPenPt(0, penW *= 0.75, c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
        double row = ctx.getPageTop();
        double col = ctx.getPageLeft();
        double erow = (row += (double)((float)y * 0.75f)) + (double)((float)(h - 1) * 0.75f);
        double ecol = (col += (double)((float)x * 0.75f)) + (double)((float)(w - 1) * 0.75f);
        this.thePrinter.drawGraph(1, col, row, ecol, erow, 4, null);
    }

    public void fillBox(int x, int y, int w, int h) throws IOException {
        if (x >= 0 && y >= 0 && w > 0 & h > 0) {
            Context ctx = (Context)this.contexts.peek();
            double row = ctx.getPageTop();
            double col = ctx.getPageLeft();
            double erow = (row += (double)((float)y * 0.75f)) + (double)((float)(h - 1) * 0.75f);
            double ecol = (col += (double)((float)x * 0.75f)) + (double)((float)(w - 1) * 0.75f);
            this.thePrinter.drawGraph(17, col, row, ecol, erow, 4, null);
        }
    }

    public void setFont(Map attrs) throws Exception {
        Context ctx = (Context)this.contexts.peek();
        ctx.setFont(attrs);
    }

    public void setColor(int red, int green, int blue) throws Exception {
        Context ctx = (Context)this.contexts.peek();
        ctx.setColor(new Color(red, green, blue));
    }

    public void setPosition(float x, float y) throws Exception {
        Context ctx = (Context)this.contexts.peek();
        ctx.setPrintArea(x, y, -1.0f, -1.0f);
    }

    public void setHeaderFooter(String head, String foot) throws IOException {
        this.thePrinter.setHeaderFooter(head, foot, 0);
    }

    public void setTitle(String w) {
    }

    public void setUrl(String u) throws IOException {
        this.thePrinter.setReportName(u);
    }

    public void write(char[] b, int off, int len) throws Exception {
        this.thePrinter.write(b, off, len);
    }

    public void close() throws IOException {
        this.thePrinter.close();
        if (checkBox != null) {
            checkBox.destroy();
            checkBox = null;
        }
        if (uncheckBox != null) {
            uncheckBox.destroy();
            uncheckBox = null;
        }
        for (FileImage img : this.images.values()) {
            img.destroy();
        }
        for (Integer h : this.handlesToFree) {
            UserHandles.free(h);
        }
    }

    public static List getPaperSizeNames() {
        return Arrays.asList(media);
    }

    static {
        media = new String[]{null, "letter", "letter small", "tabloid", "ledger", "legal", "statement", "executive", "a3", "a4", "a4 small", "a5", "b4", "b5", "folio", "quarto", "10x14", "11x17", "note", "envelope #9", "envelope #10", "envelope #11", "envelope #12", "envelope #14", "c", "d", "e", "envelope dl", "envelope c5", "envelope c3", "envelope c4", "envelope c6", "envelope c65", "envelope b4", "envelope b5", "envelope b6", "envelope italy", "envelope monarch", "envelope personal", "us std fanfold", "german std fanfold", "german legal fanfold", "b4", "japanese postcard", "9x11", "10x11", "15x11", "envelope invite"};
        String cusPaper = Config.getProperty(".printer.custompaper", null);
        if (cusPaper == null) {
            customPaperSize = MediaSize.getMediaSizeForName(MediaSizeName.ISO_A4);
        } else if ((cusPaper = cusPaper.trim().toLowerCase()).endsWith("mm")) {
            int width = -1;
            int height = -1;
            StringTokenizer st = new StringTokenizer(cusPaper = cusPaper.substring(0, cusPaper.length() - 2), "x ");
            if (st.hasMoreTokens()) {
                try {
                    width = Integer.parseInt(st.nextToken());
                    if (st.hasMoreTokens()) {
                        try {
                            height = Integer.parseInt(st.nextToken());
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            customPaperSize = width > 0 && height > 0 ? new MySize2DSyntax(width, height, 1000) : MediaSize.getMediaSizeForName(MediaSizeName.ISO_A4);
        } else {
            StringTokenizer st;
            float width = -1.0f;
            float height = -1.0f;
            if (cusPaper.endsWith("in")) {
                cusPaper = cusPaper.substring(0, cusPaper.length() - 2);
            }
            if ((st = new StringTokenizer(cusPaper, "x ")).hasMoreTokens()) {
                try {
                    width = Float.parseFloat(st.nextToken());
                    if (st.hasMoreTokens()) {
                        try {
                            height = Float.parseFloat(st.nextToken());
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            customPaperSize = width > 0.0f && height > 0.0f ? new MySize2DSyntax(width, height, 25400) : MediaSize.getMediaSizeForName(MediaSizeName.ISO_A4);
        }
    }

    private class Context
    implements Cloneable {
        private Map font = defaultFont;
        private Color color = defaultColor;
        private Color brush = defaultBrush;
        private float _pageTop;
        private float _pageLeft;
        private float _pageWidth;
        private float _pageHeight;
        private String textAlign;
        private String overflow;
        private StringBuffer text = new StringBuffer();
        private CSSStyle style;
        private final String tagName;

        public Context(String t) {
            this.tagName = t;
        }

        public final void setPageTop(float y) {
            this._pageTop = y;
        }

        public final float getPageTop() {
            return this._pageTop;
        }

        public final void addPageTop(float y) {
            this._pageTop += y;
        }

        public final void setPageLeft(float x) {
            this._pageLeft = x;
        }

        public final float getPageLeft() {
            return this._pageLeft;
        }

        public final void addPageLeft(float x) {
            this._pageLeft += x;
        }

        public final void setPageHeight(float y) {
            this._pageHeight = y;
        }

        public final void setPageWidth(float x) {
            this._pageWidth = x;
        }

        public final float getPageWidth() {
            return this._pageWidth;
        }

        public final float getPageHeight() {
            return Drawer.this._topMargin + this._pageHeight;
        }

        Context deepClone(String t) {
            Context Return2 = new Context(t);
            Return2.font = new HashMap(this.font);
            Return2.color = this.color;
            Return2.brush = this.brush;
            Return2._pageTop = this._pageTop;
            Return2._pageLeft = this._pageLeft;
            Return2._pageWidth = this._pageWidth;
            Return2._pageHeight = this._pageHeight;
            Return2.textAlign = this.textAlign;
            Return2.overflow = this.overflow;
            if (this.style != null) {
                Return2.style = new CSSStyle(this.style);
            }
            return Return2;
        }

        void setFont(Map attrs) {
            this.font = attrs;
        }

        void setColor(Color c) {
            this.color = c;
        }

        void setBrush(Color c) {
            this.brush = c;
        }

        void moveRight(float x) {
            this.addPageLeft(x * 0.75f);
        }

        void setBaselineDown(float y) {
            Object obj = this.font.get(TextAttribute.SIZE);
            float points = obj instanceof Float ? ((Float)obj).floatValue() : 12.0f;
            this.addPageTop(y * 0.75f - points);
        }

        void setPrintArea(float x, float y, float w, float h) {
            if (x >= 0.0f) {
                this.addPageLeft(x * 0.75f);
            }
            if (y >= 0.0f) {
                this.addPageTop(y * 0.75f);
            }
            if (w > 0.0f) {
                this.setPageWidth(w * 0.75f);
            }
            if (h > 0.0f) {
                this.setPageHeight(h * 0.75f);
            }
        }

        void newPage() {
            this.setPageTop(0.0f);
            this.setPageLeft(0.0f);
        }

        void appendText(char[] t, int offs, int len) {
            this.text.append(t, offs, len);
        }

        void printText() throws IOException {
            int len = this.text.length();
            if (len > 0) {
                if (this.font != null && !Drawer.areEqual(Drawer.this.currFont, this.font)) {
                    Drawer.this.thePrinter.setFont(this.font);
                    Drawer.this.currFont = this.font;
                }
                if (this.color != null && !this.color.equals(Drawer.this.currColor)) {
                    Drawer.this.thePrinter.setColor(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha());
                    Drawer.this.currColor = this.color;
                }
                char align = "right".equals(this.textAlign) ? (char)'R' : ("center".equals(this.textAlign) ? (char)'C' : 'L');
                Drawer.this.thePrinter.printAt(this.text.toString(), this.getPageLeft(), this.getPageTop(), this.getPageWidth(), false, align, (byte)2, false);
                this.text.delete(0, len);
            }
        }
    }

    private static class MySize2DSyntax
    extends Size2DSyntax {
        private static final long serialVersionUID = 1L;

        protected MySize2DSyntax(int x, int y, int units) {
            super(x, y, units);
        }

        protected MySize2DSyntax(float x, float y, int units) {
            super(x, y, units);
        }
    }
}

