/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.AtEndException;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.DataStream;
import com.iscobol.io.DynamicJavaSort;
import com.iscobol.io.ItemToSort;
import com.iscobol.io.SortFile;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicSort;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IPicAnyLength;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.SortKey;
import com.iscobol.rts.SortKeyItem;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import com.iscobol.types.PicX;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class CobolSort
implements DataStream,
RuntimeErrorsNumbers {
    public static final int BUFFERSIZE = Config.getProperty(".sort.memsize", 0x100000);
    public static final int NMERGE = Config.getProperty(".sort.maxfiles", 16);
    private String logicName;
    private ICobolVar path;
    private ICobolVar record;
    private int recSize;
    private ICobolVar fileStatus;
    private String intFileStatus = "";
    private Vector<SortKeyItem> keys = new Vector();
    private SortKey key = new SortKey();
    private final int maxElem;
    private Vector<ItemToSort> array = new Vector();
    private int readElem;
    private SortFile finalFile;
    private String extendedStatus = "00";
    private String statusMessage = "";
    private CobolIOException lastException;
    private Logger log;
    private int[] collatingSeq = new int[256];
    private boolean isInpEnd;
    private boolean isOutEnd;
    private Vector<SortFile> files = new Vector();
    private CobolFile[] using;
    private ICobolVar[] uNames;
    private CobolFile[] giving;
    private ICobolVar[] gNames;
    private DynamicSort sortClass;

    public CobolSort(String lname, ICobolVar sname, ICobolVar memBuf, int mlen, ICobolVar fs) {
        this(lname, sname, memBuf, mlen, fs, null);
    }

    public CobolSort(String lname, ICobolVar sname, ICobolVar memBuf, int mlen, ICobolVar fs, byte[] cs) {
        this.logicName = lname;
        this.path = sname;
        this.record = memBuf;
        this.fileStatus = fs;
        this.log = LoggerFactory.get(8);
        this.recSize = this.record.getMaxLength();
        this.maxElem = BUFFERSIZE / this.recSize;
        for (int i = 0; i < this.collatingSeq.length; ++i) {
            this.collatingSeq[i] = i;
        }
    }

    public CobolSort(ICobolVar memBuf) {
        this.logicName = "table$sort";
        this.record = memBuf;
        this.recSize = memBuf.getMaxLength();
        this.maxElem = memBuf.getLastDimension();
        for (int i = 0; i < this.collatingSeq.length; ++i) {
            this.collatingSeq[i] = i;
        }
    }

    public CobolSort collatingSequence(byte[] cs) {
        if (cs != null) {
            for (int i = 0; i < cs.length && i < this.collatingSeq.length; ++i) {
                this.collatingSeq[i] = cs[i] & 0xFF;
            }
        }
        return this;
    }

    @Override
    public void finalize() {
        Iterator<SortFile> it = this.files.iterator();
        while (it.hasNext()) {
            it.next().finalize();
        }
        this.array = new Vector();
        this.keys = new Vector();
        this.key.keyArray = null;
        this.readElem = 0;
        this.using = null;
        this.uNames = null;
        this.giving = null;
        this.gNames = null;
        this.sortClass = null;
    }

    public CobolSort keyAdd(CobolVar k, boolean descending) {
        return this.keyAdd((ICobolVar)k, descending);
    }

    public CobolSort keyAdd(ICobolVar k, boolean descending) {
        if (this.maxElem > 0) {
            SortKeyItem ski;
            if (k instanceof IPicAnyLength) {
                ski = new SortKeyItem(descending, k.getType(), (IPicAnyLength)k, this.key);
            } else {
                try {
                    k = k.intIAt(1);
                }
                catch (IscobolRuntimeException iscobolRuntimeException) {
                    // empty catch block
                }
                ski = new SortKeyItem(descending, k.getType(), k.getOffset(), k.length(), 0, this.key);
            }
            this.keys.addElement(ski);
        }
        return this;
    }

    public void keyTable(CobolVar k) {
        this.keyTable((ICobolVar)k);
    }

    public void keyTable(ICobolVar k) {
        int dim = k.length() / 7;
        if (dim > 0) {
            PicX KEY_TABLE = Factory.getVarAlphanum(k.getBytes(), 0, dim * 7, false, null, null, null, "KEY-TABLE", true, false);
            PicX SORT_KEY = Factory.getVarAlphanum(KEY_TABLE, 0, 7, false, null, new int[]{7}, new int[]{dim}, "SORT-KEY", true, false);
            NumericVar KEY_ASCENDING = Factory.getVarCompX(SORT_KEY, 0, 1, false, null, new int[]{7}, new int[]{dim}, "KEY-ASCENDING", true, 1, 0, false, false, false);
            NumericVar KEY_TYPE = Factory.getVarCompX(SORT_KEY, 1, 1, false, null, new int[]{7}, new int[]{dim}, "KEY-TYPE", true, 1, 0, false, false, false);
            NumericVar KEY_OFFSET = Factory.getVarCompX(SORT_KEY, 2, 2, false, null, new int[]{7}, new int[]{dim}, "KEY-OFFSET", true, 2, 0, false, false, false);
            NumericVar KEY_SIZE = Factory.getVarCompX(SORT_KEY, 4, 2, false, null, new int[]{7}, new int[]{dim}, "KEY-SIZE", true, 2, 0, false, false, false);
            NumericVar KEY_DIGITS = Factory.getVarCompX(SORT_KEY, 6, 1, false, null, new int[]{7}, new int[]{dim}, "KEY-DIGITS", true, 1, 0, false, false, false);
            int[] idx = new int[1];
            int type = 0;
            for (int i = 1; i <= dim; ++i) {
                idx[0] = i;
                type = KEY_TYPE.at(idx).integer();
                if (type == 8) {
                    type = 9;
                } else if (type == 9) {
                    type = 8;
                }
                this.keys.addElement(new SortKeyItem(KEY_ASCENDING.at(idx).integer() == 0, type, KEY_OFFSET.at(idx).integer(), KEY_SIZE.at(idx).integer(), KEY_DIGITS.at(idx).integer(), this.key));
            }
        }
    }

    public SortKey getKey() {
        this.getKeyArray();
        return this.key;
    }

    public SortKeyItem[] getKeyArray() {
        if (this.key.keyArray == null && this.keys.size() > 0) {
            this.key.keyArray = this.keys.toArray(new SortKeyItem[this.keys.size()]);
        }
        return this.key.keyArray;
    }

    public void releaseSort() {
        if (this.key.keyArray == null && this.keys.size() > 0) {
            this.key.keyArray = this.keys.toArray(new SortKeyItem[this.keys.size()]);
        }
        if (this.array.size() == this.maxElem) {
            Collections.sort(this.array);
            this.writeBuffer();
        }
        byte[] nrec = new byte[this.recSize];
        Factory.myArraycopy(this.record.getBytes(), 0, nrec, 0, this.recSize);
        this.array.addElement(new ItemToSort(this.key.keyArray, nrec));
    }

    public void returnSort(CobolVar into) {
        this.returnSort((ICobolVar)into);
    }

    public void returnSort(ICobolVar into) {
        byte[] mem = null;
        if (this.finalFile == null) {
            if (this.readElem == this.array.size()) {
                AtEndException.get(this, 6);
            } else {
                mem = this.array.elementAt((int)this.readElem++).memory;
            }
        } else {
            try {
                this.finalFile.read();
            }
            catch (IOException _ex) {
                CobolIOException.get(_ex, this, 6);
            }
            if (this.finalFile.isAtEnd()) {
                AtEndException.get(this, 6);
            } else {
                mem = this.finalFile.buffer.memory;
            }
        }
        this.record.set(mem, 0, this.recSize, true);
        if (into != null) {
            into.setUsingMaxLen(mem);
        }
    }

    public void sort(byte[] collSeq) {
        this.key.setCollatingSequence(collSeq);
        this.doSort();
    }

    public void sort() {
        this.key.setCollatingSequence(this.collatingSeq);
        this.doSort();
    }

    private void doSort() {
        if (this.array.size() > 1) {
            Collections.sort(this.array);
        }
        if (this.files.size() > 0) {
            this.merge();
            this.finalFile = this.files.elementAt(0);
            try {
                this.finalFile.openRead();
            }
            catch (IOException _ex) {
                CobolIOException.get(_ex, this, 6);
            }
        }
    }

    public void tableSort() {
        this.tableSort(null);
    }

    public void tableSort(SortHelper h) {
        ICobolVar cv;
        int i;
        if (this.maxElem <= 0) {
            return;
        }
        if (this.keys.size() == 0) {
            this.keyAdd(this.record, false);
        }
        this.getKeyArray();
        int offs = this.record.intIAt(1).getOffset();
        for (i = 0; i < this.key.keyArray.length; ++i) {
            this.key.keyArray[i].removeOffset(offs);
        }
        this.recSize = this.record.intIAt(1).length();
        for (i = 1; i <= this.maxElem; ++i) {
            cv = this.record.intIAt(i);
            byte[] nrec = new byte[this.recSize];
            System.arraycopy(cv.getBytes(), 0, nrec, 0, this.recSize);
            this.array.addElement(new ItemToSort(this.key.keyArray, nrec, i));
        }
        Collections.sort(this.array);
        if (this.record.isDynamicLength() && h != null) {
            ICobolVar tmp = h.getTmpVar();
            HashMap<Integer, Integer> pos1 = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> pos2 = new HashMap<Integer, Integer>();
            Iterator<ItemToSort> it = this.array.iterator();
            i = 1;
            while (it.hasNext()) {
                cv = this.record.intIAt(i);
                ItemToSort item = it.next();
                cv.set(item.memory, 0, this.recSize, true);
                Integer Idx = item.getIndex();
                Integer pos = (Integer)pos1.get(Idx);
                if (pos == null) {
                    pos = Idx;
                }
                if (pos != i) {
                    ICobolVar cv0 = this.record.intIAt(pos);
                    tmp.dynSet(cv);
                    cv.dynSet(cv0);
                    cv0.dynSet(tmp);
                    Integer I2 = i;
                    Idx = (Integer)pos2.get(I2);
                    if (Idx != null) {
                        pos2.remove(I2);
                        I2 = Idx;
                    }
                    pos1.put(I2, pos);
                    pos2.put(pos, I2);
                }
                ++i;
            }
        } else {
            Iterator<ItemToSort> it = this.array.iterator();
            i = 1;
            while (it.hasNext()) {
                cv = this.record.intIAt(i);
                ItemToSort item = it.next();
                cv.set(item.memory, 0, this.recSize, true);
                ++i;
            }
        }
        this.finalize();
    }

    private void writeBuffer() {
        if (this.files.size() == NMERGE) {
            this.merge();
        } else {
            SortFile sf = new SortFile(this.recSize, this.getKeyArray());
            try {
                sf.create();
            }
            catch (IOException _ex) {
                CobolIOException.get(_ex, this, 1);
            }
            this.files.addElement(sf);
            Iterator<ItemToSort> it = this.array.iterator();
            while (it.hasNext()) {
                try {
                    sf.write(it.next());
                }
                catch (IOException _ex) {
                    CobolIOException.get(_ex, this, 3);
                }
            }
            sf.close();
            this.array.removeAllElements();
        }
    }

    private void merge() {
        ItemToSort minLine;
        SortFile sf2;
        SortFile minSf = null;
        int nElem = 0;
        if (this.array.size() == 0 && this.files.size() < 2 || this.files.size() < 1) {
            return;
        }
        SortFile newFile = new SortFile(this.recSize, this.getKeyArray());
        try {
            newFile.create();
        }
        catch (IOException _ex) {
            CobolIOException.get(_ex, this, 1);
        }
        for (SortFile sf2 : this.files) {
            try {
                sf2.openRead();
                sf2.read();
            }
            catch (IOException _ex) {
                CobolIOException.get(_ex, this, 6);
            }
        }
        do {
            minLine = null;
            Iterator<SortFile> it = this.files.iterator();
            while (it.hasNext()) {
                sf2 = it.next();
                if (sf2.isAtEnd()) {
                    sf2.finalize();
                    it.remove();
                    continue;
                }
                if (minLine != null) {
                    if (minLine.compareTo(sf2.buffer) <= 0) continue;
                    minLine = sf2.buffer;
                    minSf = sf2;
                    continue;
                }
                minLine = sf2.buffer;
                minSf = sf2;
            }
            if (nElem < this.array.size()) {
                ItemToSort memLine = this.array.elementAt(nElem);
                if (minLine == null || minLine.compareTo(memLine) > 0) {
                    minLine = memLine;
                    minSf = null;
                }
            }
            if (minLine == null) continue;
            try {
                newFile.write(minLine);
            }
            catch (IOException _ex) {
                CobolIOException.get(_ex, this, 3);
            }
            if (minSf != null) {
                try {
                    minSf.read();
                }
                catch (IOException _ex) {
                    CobolIOException.get(_ex, this, 6);
                }
                continue;
            }
            ++nElem;
        } while (minLine != null);
        if (this.files.size() == 1) {
            sf2 = this.files.elementAt(0);
            sf2.finalize();
            this.files.remove(0);
        }
        this.files.addElement(newFile);
        newFile.close();
        this.array.removeAllElements();
    }

    @Override
    public void setFileStatus(String fs) {
        if (this.fileStatus != null) {
            this.fileStatus.set(fs);
        } else {
            this.intFileStatus = fs;
        }
    }

    @Override
    public String getFileStatus() {
        if (this.fileStatus != null) {
            return this.fileStatus.toString();
        }
        return this.intFileStatus;
    }

    @Override
    public void setExtendedStatus(String fs) {
        int len = fs == null ? 0 : fs.length();
        switch (len) {
            case 0: {
                this.extendedStatus = "00";
                break;
            }
            case 1: {
                this.extendedStatus = "0" + fs;
                break;
            }
            case 2: {
                this.extendedStatus = fs;
                break;
            }
            default: {
                this.extendedStatus = fs.substring(len - 2, len);
            }
        }
    }

    @Override
    public String getExtendedStatus() {
        return this.extendedStatus;
    }

    @Override
    public void setStatusMessage(String fs) {
        this.statusMessage = fs;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public void setLastException(CobolIOException ex) {
        this.lastException = ex;
    }

    @Override
    public CobolIOException getLastException() {
        return this.lastException;
    }

    @Override
    public String getLogicName() {
        return this.logicName;
    }

    @Override
    public String getOsPath() {
        if (this.path != null) {
            return this.path.toString();
        }
        return "";
    }

    @Override
    public Logger getLogger() {
        return this.log;
    }

    public void setUsing(CobolFile[] u, ICobolVar[] n) {
        this.using = u;
        this.uNames = n;
    }

    public void setGiving(CobolFile[] g, ICobolVar[] n) {
        this.giving = g;
        this.gNames = n;
    }

    public void initSort(byte[] collSeq) {
        if (this.log != null) {
            this.log.info("SORT: " + this.getOsPath());
        }
        if (collSeq != null) {
            this.key.setCollatingSequence(collSeq);
        } else {
            this.key.setCollatingSequence(this.collatingSeq);
        }
        String dsort = Config.getProperty(".sort", null);
        if (dsort == null) {
            this.sortClass = new DynamicJavaSort();
        } else {
            try {
                this.sortClass = (DynamicSort)Class.forName(dsort).newInstance();
            }
            catch (Exception _ex) {
                throw new IscobolRuntimeException(5, dsort + " (" + _ex + ")");
            }
        }
        int rc = this.sortClass.initSort(this.getOsPath(), this.record, this.getKey(), this.using, this.uNames, this.giving, this.gNames);
        if (rc != 1) {
            rc = this.sortClass.getCobErrno();
            this.finalize();
            CobolIOException.get(rc, null, this, 1);
        }
        if (this.using != null && this.using.length > 0 && this.giving != null && this.giving.length > 0) {
            this.finalize();
        }
        this.isOutEnd = false;
        this.isInpEnd = false;
    }

    public void endInput() {
        if (this.sortClass == null) {
            throw new IscobolRuntimeException(3, "endInput (" + this.logicName + ")");
        }
        this.isInpEnd = true;
        int rc = this.sortClass.endInput();
        if (rc != 1) {
            rc = this.sortClass.getCobErrno();
            this.finalize();
            CobolIOException.get(rc, null, this, 1);
        }
        if (this.giving != null && this.giving.length > 0) {
            this.finalize();
        }
    }

    public void endOutput() {
        if (this.sortClass == null) {
            throw new IscobolRuntimeException(3, "endOutput (" + this.logicName + ")");
        }
        this.isOutEnd = true;
        int rc = this.sortClass.endOutput();
        if (rc != 1) {
            rc = this.sortClass.getCobErrno();
            this.finalize();
            CobolIOException.get(rc, null, this, 1);
        }
        this.finalize();
    }

    public void releaseRecord() {
        this.releaseRecord(this.recSize);
    }

    public void releaseRecord(int rl) {
        if (this.isInpEnd || this.sortClass == null) {
            throw new IscobolRuntimeException(24, this.logicName);
        }
        int rc = this.sortClass.releaseRecord(rl);
        if (rc != 1) {
            rc = this.sortClass.getCobErrno();
            this.finalize();
            CobolIOException.get(rc, null, this, 1);
        }
    }

    public void returnRecord(CobolVar into) {
        this.returnRecord((ICobolVar)into);
    }

    public void returnRecord(ICobolVar into) {
        if (this.isOutEnd || this.sortClass == null) {
            throw new IscobolRuntimeException(25, this.logicName);
        }
        int rc = this.sortClass.returnRecord();
        if (rc < 0) {
            if (this.sortClass.getCobErrno() == 110) {
                AtEndException.get(this, 1);
            } else {
                rc = this.sortClass.getCobErrno();
                this.finalize();
                CobolIOException.get(rc, null, this, 1);
            }
        }
        if (into != null) {
            into.setUsingMaxLen(this.record.getBytes());
        }
    }

    public static interface SortHelper {
        public ICobolVar getTmpVar();
    }
}

