/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import IT.picosoft.isam.FLock;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.OSFile;
import com.iscobol.io.BaseFile;
import com.iscobol.io.FileLock;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.IOUtil;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;

public class DynamicRelative
implements DynamicFile,
RuntimeErrorsNumbers,
Cloneable {
    public static final int ERR_BOUNDARY_VIOLATION = -1;
    public static final int ERR_INVSEQDELREW = -2;
    public static final int ERR_NOTPERMITTED = -3;
    protected OSFile theFile;
    protected byte[] locBuffer;
    private byte[] delBuffer;
    private long currRecord;
    protected boolean positioned;
    protected boolean atBegin;
    protected boolean atEnd;
    private int accessMode;
    private FileLock lock;
    protected boolean exclusiveLock;
    protected boolean multipleLock;
    protected boolean readLock;
    private FLock lastLock;
    protected Hashtable allLocks;
    protected int realRecordSize;
    protected int maxRecordSize;
    protected int minRecordSize;
    private String path = "";
    protected int errno;
    protected Exception errio;
    protected int openMode = 0;
    private static boolean outLock = Config.getProperty(".file.output_lock", true);
    private static boolean extLock = Config.getProperty(".file.extend_lock", true);

    @Override
    public String getSysErrno() {
        if (this.errio != null) {
            return this.errio.getMessage();
        }
        return "";
    }

    @Override
    public String getErrMsg() {
        if (this.errio != null) {
            return this.errio.getMessage();
        }
        return "";
    }

    @Override
    public int getCobErrno() {
        switch (this.errno) {
            case 0: {
                return 0;
            }
            case 100: {
                return 100;
            }
            case 101: {
                return 101;
            }
            case 133: {
                return 133;
            }
            case 102: {
                return 102;
            }
            case 104: {
                return 104;
            }
            case 125: {
                return 125;
            }
            case 107: {
                return 107;
            }
            case 105: {
                return 105;
            }
            case 108: {
                return 108;
            }
            case 111: {
                return 111;
            }
            case 110: {
                return 110;
            }
            case 112: {
                return 112;
            }
            case 127: {
                return 127;
            }
            case 113: {
                return 113;
            }
            case 128: {
                return 128;
            }
            case 116: {
                return 116;
            }
            case 130: {
                return 130;
            }
            case 131: {
                return 131;
            }
            case 126: {
                return 126;
            }
            case 129: {
                return 129;
            }
            case 122: {
                return 122;
            }
            case -1: {
                return 145;
            }
            case -2: {
                return 143;
            }
            case -3: {
                return 126;
            }
        }
        return 134;
    }

    private void recordUnlock(FLock lck) throws IsamException {
        lck.l_type = (short)2;
        this.theFile.fcntl(6, this.lastLock);
        this.allLocks.remove(lck);
    }

    private synchronized void allRecordUnlock() throws IsamException {
        Enumeration en = this.allLocks.elements();
        while (en.hasMoreElements()) {
            FLock lck = (FLock)en.nextElement();
            lck.l_type = (short)2;
            this.theFile.fcntl(6, lck);
        }
        this.allLocks.clear();
    }

    protected synchronized void recordUnlockPos(long pos) throws IsamException {
        Long start = new Long(pos);
        FLock lck = (FLock)this.allLocks.get(start);
        if (lck != null) {
            lck.l_type = (short)2;
            this.theFile.fcntl(6, lck);
            this.allLocks.remove(start);
        }
    }

    private synchronized void recordLockNum(boolean lock, long recNum, int len) throws IsamException {
        if (lock && !this.exclusiveLock) {
            try {
                FLock lck = new FLock();
                lck.l_whence = 0;
                lck.l_start = (recNum - 1L) * (long)this.realRecordSize;
                lck.l_len = len;
                lck.l_type = this.readLock || this.openMode == 1 ? (short)0 : 1;
                Long start = new Long(lck.l_start);
                FLock oldlck = (FLock)this.allLocks.get(start);
                if (oldlck != null) {
                    if (oldlck.l_type == 0 && lck.l_type == 1 || oldlck.l_len < lck.l_len) {
                        this.allLocks.remove(oldlck);
                        this.theFile.fcntl(6, lck);
                        this.allLocks.put(start, lck);
                    }
                } else {
                    if (!this.multipleLock) {
                        this.allRecordUnlock();
                    }
                    this.theFile.fcntl(6, lck);
                    this.allLocks.put(start, lck);
                }
            }
            catch (IsamException ex) {
                if (ex.getIserrno() == 113) {
                    throw new IsamException(107);
                }
                throw ex;
            }
        }
    }

    private void setLockType(int lockType) {
        this.exclusiveLock = false;
        this.multipleLock = false;
        this.readLock = false;
        this.lastLock = null;
        this.allLocks = new Hashtable();
        switch (lockType & 0xF) {
            default: {
                break;
            }
            case 1: 
            case 6: {
                this.exclusiveLock = true;
                break;
            }
            case 4: {
                this.readLock = false;
                break;
            }
            case 3: 
            case 5: {
                this.readLock = true;
            }
        }
        if ((lockType & 0x100) != 0) {
            this.multipleLock = true;
        }
    }

    @Override
    public long getNumRecords() {
        long Return2 = 0L;
        if (this.theFile != null) {
            try {
                Return2 = this.theFile.length() / (long)this.realRecordSize;
            }
            catch (IsamException isamException) {
                // empty catch block
            }
        }
        return Return2;
    }

    @Override
    public int getNumKeys() {
        return 0;
    }

    @Override
    public int getMaxRecordSize() {
        return this.maxRecordSize;
    }

    @Override
    public int getMinRecordSize() {
        return this.minRecordSize;
    }

    @Override
    public KeyDescription getKey(int num) {
        KeyDescription Return2;
        if (num == 0) {
            Return2 = new KeyDescription(0, false);
        } else {
            this.mapError(new IsamException(102));
            Return2 = null;
        }
        return Return2;
    }

    @Override
    public byte[] getSequence() {
        return null;
    }

    protected int mapError(IsamException ex) {
        this.errno = ex.getIserrno();
        this.errio = ex.getIserrio();
        return 0;
    }

    protected boolean isDeleted(byte[] buffer) {
        return IOUtil.equals(buffer, 0, this.delBuffer, 0, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public int build(String path, String comment, int blockingFactor, int preAllocate, int extensionFactor, int compressionFactor, int ecryptionFlag, int maxRecordSize, int minRecordSize, KeyDescription[] keys, byte[] collating, boolean assignExt) {
        if (assignExt) {
            path = BaseFile.expandFileName(path);
        }
        f = new OSFile();
        this.lock = null;
        opened = false;
        try {
            f.open(path, 1);
            opened = true;
            this.lock = new FileLock(path, f, true, false);
        }
        catch (IsamException _ex) {
            switch (_ex.getIserrno()) {
                case 130: {
                    ** break;
lbl15:
                    // 1 sources

                    break;
                }
                default: {
                    var17_20 = this.mapError(_ex);
                    return var17_20;
                }
            }
        }
        finally {
            try {
                if (this.lock != null) {
                    this.lock.finalize();
                    this.lock = null;
                }
                if (opened) {
                    f.close();
                }
            }
            catch (IsamException _ex) {}
        }
        try {
            f.open(path, 577);
            f.close();
            Return = 1;
        }
        catch (IsamException _ex) {
            Return = this.mapError(_ex);
        }
        return Return;
    }

    protected OSFile getOSFile(boolean xLock) {
        return new OSFile();
    }

    @Override
    public int open(String path, int openType, int lockType, KeyDescription[] k, int maxRec, int minRec, int nKeys, int accessMode, boolean optional, boolean assignExt) {
        int Return2;
        if (assignExt) {
            path = BaseFile.expandFileName(path);
        }
        this.accessMode = accessMode;
        this.maxRecordSize = this.realRecordSize = maxRec;
        this.minRecordSize = minRec;
        this.locBuffer = new byte[this.maxRecordSize];
        this.delBuffer = new byte[this.maxRecordSize];
        this.setLockType(lockType);
        this.theFile = this.getOSFile(this.exclusiveLock);
        try {
            int mode = 0;
            if (openType == 2 && outLock) {
                mode = 128;
            } else if (openType == 6 && extLock) {
                mode = 128;
            } else if (this.exclusiveLock) {
                mode = 128;
            }
            switch (openType) {
                case 2: {
                    this.theFile.open(path, mode | 1);
                    if (this.readLock) break;
                    this.exclusiveLock = true;
                    break;
                }
                case 3: 
                case 6: {
                    this.theFile.open(path, mode | 2);
                    break;
                }
                case 1: {
                    this.theFile.open(path, mode | 0);
                    if (!this.exclusiveLock) break;
                    this.readLock = true;
                    break;
                }
                default: {
                    throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
                }
            }
            this.openMode = openType;
            try {
                this.lock = new FileLock(path, this.theFile, this.exclusiveLock, this.readLock);
            }
            catch (IsamException _ex) {
                this.theFile.close();
                throw _ex;
            }
            this.currRecord = 1L;
            this.positioned = true;
            this.atBegin = true;
            this.atEnd = false;
            Return2 = 1;
            this.path = path;
        }
        catch (IsamException _ex) {
            this.theFile = null;
            Return2 = this.mapError(_ex);
        }
        return Return2;
    }

    @Override
    public void setCurrentRecord(long nRec) {
        this.currRecord = nRec;
        this.positioned = true;
        this.atEnd = false;
        this.atBegin = false;
    }

    @Override
    public String getDescription() {
        return this.path;
    }

    @Override
    public int close() {
        int Return2;
        if (this.theFile != null) {
            try {
                this.lock.finalize();
                this.theFile.close();
                Return2 = 1;
                this.theFile = null;
                this.openMode = 0;
                this.path = "";
            }
            catch (IsamException _ex) {
                Return2 = this.mapError(_ex);
            }
        } else {
            Return2 = 1;
        }
        return Return2;
    }

    @Override
    public boolean isOpen() {
        return this.openMode != 0;
    }

    protected long nextRecNum() {
        if (this.atBegin) {
            return 1L;
        }
        if (this.currRecord <= 0L) {
            return 0L;
        }
        if (this.positioned) {
            return this.currRecord;
        }
        return this.currRecord + 1L;
    }

    private long prevRecNum() {
        if (this.atEnd) {
            return this.getNumRecords();
        }
        if (this.currRecord <= 0L) {
            return 0L;
        }
        if (this.positioned) {
            return this.currRecord;
        }
        return this.currRecord - 1L;
    }

    @Override
    public long getCurrentRecord() {
        if (this.atBegin || this.atEnd) {
            return 0L;
        }
        return this.currRecord;
    }

    @Override
    public long write(byte[] record, int offs, int len, boolean lock) {
        this.errno = 0;
        if (len > this.maxRecordSize) {
            len = this.maxRecordSize;
        }
        try {
            long recNum;
            if (this.openMode == 6) {
                this.theFile.seek(this.theFile.length());
                this.theFile.write(record, offs, len);
                recNum = this.theFile.length() / (long)this.realRecordSize + 1L;
            } else {
                recNum = this.nextRecNum();
                if (recNum < 1L) {
                    this.errno = -2;
                    return 0L;
                }
                long pos = (recNum - 1L) * (long)this.realRecordSize;
                this.theFile.seek(pos);
                int rc = this.theFile.read(this.locBuffer);
                if (rc < 0 || Arrays.equals(this.delBuffer, this.locBuffer)) {
                    this.theFile.seek(pos);
                    this.theFile.write(record, offs, len);
                    if (!this.exclusiveLock) {
                        this.recordUnlockPos(pos);
                    }
                } else {
                    return this.mapError(new IsamException(100));
                }
            }
            this.currRecord = recNum;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return 1L;
    }

    @Override
    public long rewrite(byte[] record, int offs, int len, boolean lock) {
        this.errno = 0;
        if (len > this.maxRecordSize) {
            len = this.maxRecordSize;
        }
        try {
            long recNum = this.getCurrentRecord();
            if (recNum < 1L) {
                this.errno = -2;
                return 0L;
            }
            long pos = (recNum - 1L) * (long)this.realRecordSize;
            this.theFile.seek(pos);
            int rc = this.theFile.read(this.locBuffer);
            if (rc >= 0 && !Arrays.equals(this.delBuffer, this.locBuffer)) {
                this.theFile.seek(pos);
                this.theFile.write(record, offs, len);
                if (!this.exclusiveLock) {
                    this.recordUnlockPos(pos);
                }
            } else {
                return this.mapError(new IsamException(111));
            }
            this.currRecord = recNum;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return 1L;
    }

    @Override
    public long delete(byte[] record, int offs) {
        try {
            long recNum = this.getCurrentRecord();
            if (recNum < 1L) {
                this.errno = -2;
                return 0L;
            }
            long pos = (recNum - 1L) * (long)this.realRecordSize;
            this.theFile.seek(pos);
            int rc = this.theFile.read(this.locBuffer);
            if (rc < 0 || Arrays.equals(this.delBuffer, this.locBuffer)) {
                return this.mapError(new IsamException(111));
            }
            this.theFile.seek(pos);
            this.theFile.write(this.delBuffer);
            this.currRecord = recNum;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return 1L;
    }

    private int myNext(byte[] buffer, int offs, int len, long nRec) throws IsamException {
        int rc;
        this.currRecord = nRec < 1L ? 1L : nRec;
        long pos = (this.currRecord - 1L) * (long)this.realRecordSize;
        this.theFile.seek(pos);
        do {
            if ((rc = this.theFile.read(this.locBuffer)) <= 0) continue;
            if (this.isDeleted(this.locBuffer)) {
                pos = this.currRecord * (long)this.realRecordSize;
                ++this.currRecord;
                continue;
            }
            System.arraycopy(this.locBuffer, 0, buffer, offs, len);
            break;
        } while (rc > 0);
        return rc;
    }

    private int myPrev(byte[] buffer, int offs, int len, long nRec) throws IsamException {
        int rc = 0;
        this.currRecord = nRec;
        while (this.currRecord > 0L) {
            long pos = (this.currRecord - 1L) * (long)this.realRecordSize;
            this.theFile.seek(pos);
            rc = this.theFile.read(this.locBuffer);
            if (this.isDeleted(this.locBuffer)) {
                --this.currRecord;
                continue;
            }
            System.arraycopy(this.locBuffer, 0, buffer, offs, len);
            break;
        }
        if (this.currRecord == 0L) {
            this.currRecord = 1L;
        }
        return rc;
    }

    @Override
    public long next(byte[] record, int offs, int lock) {
        int Return2;
        int len = record.length - offs;
        this.errno = 0;
        if (len > this.maxRecordSize) {
            len = this.maxRecordSize;
        }
        if (this.theFile == null) {
            return this.mapError(new IsamException(110));
        }
        if (this.currRecord <= 0L || this.atEnd) {
            return this.mapError(new IsamException(112));
        }
        try {
            Return2 = this.myNext(record, offs, len, this.nextRecNum());
            if (Return2 <= 0) {
                this.positioned = false;
                this.atBegin = false;
                this.atEnd = true;
                return this.mapError(new IsamException(110));
            }
            this.recordLockNum(lock > 0, this.currRecord, len);
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
        }
        catch (IsamException _ex) {
            this.currRecord = 0L;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
            return this.mapError(_ex);
        }
        return Return2;
    }

    @Override
    public long previous(byte[] record, int offs, int lock) {
        int Return2;
        int len = record.length - offs;
        this.errno = 0;
        if (len > this.maxRecordSize) {
            len = this.maxRecordSize;
        }
        if (this.theFile == null) {
            return this.mapError(new IsamException(110));
        }
        if (this.currRecord <= 0L || this.atBegin) {
            return this.mapError(new IsamException(112));
        }
        try {
            Return2 = this.myPrev(record, offs, len, this.prevRecNum());
            if (Return2 <= 0) {
                this.positioned = false;
                this.atEnd = false;
                this.atBegin = true;
                return this.mapError(new IsamException(110));
            }
            this.recordLockNum(lock > 0, this.currRecord, len);
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
        }
        catch (IsamException _ex) {
            this.currRecord = 0L;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
            return this.mapError(_ex);
        }
        return Return2;
    }

    private long read(byte[] record, int offs, int lock) {
        int Return2;
        int len = record.length - offs;
        this.errno = 0;
        if (len > this.maxRecordSize) {
            len = this.maxRecordSize;
        }
        if (this.theFile == null) {
            return this.mapError(new IsamException(111));
        }
        try {
            long recNum = this.nextRecNum();
            this.currRecord = 0L;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
            if (recNum < 1L) {
                return this.mapError(new IsamException(111));
            }
            long pos = (recNum - 1L) * (long)this.realRecordSize;
            this.theFile.seek(pos);
            Return2 = this.theFile.read(this.locBuffer);
            this.recordLockNum(lock > 0, recNum, len);
            if (Return2 < 0 || this.isDeleted(this.locBuffer)) {
                return this.mapError(new IsamException(111));
            }
            System.arraycopy(this.locBuffer, 0, record, 0, this.maxRecordSize);
            this.currRecord = recNum;
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return Return2;
    }

    @Override
    public long read(byte[] record, int offs, int keyNum, int lock) {
        return this.read(record, offs, lock);
    }

    @Override
    public long read(byte[] record, int offs, KeyDescription key, int lock) {
        return this.read(record, offs, lock);
    }

    private long start(byte[] record, int offs, int keyLen, int mode) {
        int len;
        int n = len = record != null ? record.length - offs : this.maxRecordSize;
        if (len > this.maxRecordSize) {
            len = this.maxRecordSize;
        }
        if (this.theFile == null) {
            return this.mapError(new IsamException(111));
        }
        try {
            long recNum = this.nextRecNum();
            this.currRecord = 0L;
            this.positioned = false;
            this.atEnd = false;
            this.atBegin = false;
            long lastRecord = this.theFile.length() / (long)len;
            if (mode == 0) {
                recNum = 1L;
            } else if (mode == 1) {
                recNum = lastRecord;
            }
            if (recNum < 1L) {
                if (mode == 6) {
                    recNum = 0L;
                } else if (mode == 7) {
                    recNum = 1L;
                } else {
                    return this.mapError(new IsamException(111));
                }
            }
            switch (mode) {
                case 5: {
                    if (recNum < 1L || recNum > lastRecord) {
                        return this.mapError(new IsamException(111));
                    }
                    long pos = (recNum - 1L) * (long)this.realRecordSize;
                    this.theFile.seek(pos);
                    int rc = this.theFile.read(this.locBuffer);
                    if (rc >= 0 && !this.isDeleted(this.locBuffer)) break;
                    return this.mapError(new IsamException(111));
                }
                case 6: {
                    ++recNum;
                }
                case 7: {
                    int rc;
                    if (recNum > lastRecord) {
                        return this.mapError(new IsamException(111));
                    }
                    if (recNum < 1L) {
                        recNum = 1L;
                    }
                    if ((rc = this.myNext(this.locBuffer, 0, len, recNum)) > 0) break;
                    return this.mapError(new IsamException(111));
                }
                case 8: {
                    --recNum;
                }
                case 9: {
                    int rc;
                    if (recNum < 1L) {
                        return this.mapError(new IsamException(111));
                    }
                    if (recNum > lastRecord) {
                        recNum = lastRecord;
                    }
                    if ((rc = this.myPrev(this.locBuffer, 0, len, recNum)) > 0) break;
                    return this.mapError(new IsamException(111));
                }
            }
            this.currRecord = recNum;
            if (this.currRecord < 1L) {
                return this.mapError(new IsamException(111));
            }
            this.positioned = true;
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return 1L;
    }

    @Override
    public long start(byte[] record, int offs, int kNum, int kSize, int mode) {
        return this.start(record, offs, kSize, mode);
    }

    @Override
    public long start(byte[] record, int offs, KeyDescription k, int kSize, int mode) {
        return this.start(record, offs, kSize, mode);
    }

    @Override
    public int unlock() {
        try {
            this.allRecordUnlock();
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return 1;
    }

    @Override
    public void sync(int allFiles) {
    }

    @Override
    public int remove(String name) {
        try {
            OSFile.unlink(name);
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return 1;
    }

    @Override
    public int rename(String src, String dst) {
        try {
            OSFile.rename(src, dst);
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return 1;
    }

    @Override
    public int begin() {
        return 1;
    }

    @Override
    public int commit(int ctx) {
        return 1;
    }

    @Override
    public int rollback() {
        return 1;
    }

    @Override
    public int recover() {
        return 1;
    }

    @Override
    public String getVersion() {
        return "$Id: DynamicRelative.java 38325 2024-07-02 10:12:20Z daniela_835 $";
    }

    @Override
    public boolean isKeySelectedByNum() {
        return false;
    }

    public void finalize() {
        this.close();
    }
}

