/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.DataStream;
import com.iscobol.io.FileStatusDefault;

public class FileStatusIBM
extends FileStatusDefault {
    @Override
    public int map(int type, String extFs, DataStream cf, int op) {
        if (extFs != null && extFs.length() > 0) {
            cf.setExtendedStatus(extFs);
        }
        switch (type) {
            case 200: {
                cf.setFileStatus("00");
                cf.setStatusMessage("duplicate key detected");
                type = 0;
                break;
            }
            case 203: {
                cf.setFileStatus("10");
                cf.setStatusMessage("optional file missing");
                type = 0;
                break;
            }
            case 202: {
                cf.setFileStatus("10");
                cf.setStatusMessage("optional file created");
                type = 0;
                break;
            }
            case 130: {
                cf.setFileStatus("91");
                cf.setStatusMessage("missing file");
                break;
            }
            case 131: {
                cf.setFileStatus("93");
                cf.setStatusMessage("invalid permission");
                break;
            }
            case 142: {
                cf.setFileStatus("93");
                cf.setStatusMessage("invalid open mode");
                break;
            }
            case 141: {
                cf.setFileStatus("93");
                cf.setStatusMessage("file closed with lock");
                break;
            }
            case 102: {
                cf.setFileStatus("95");
                cf.setStatusMessage("file mismatch");
                break;
            }
            case 135: {
                cf.setFileStatus("93");
                cf.setStatusMessage("already open");
                break;
            }
            case 101: {
                switch (op) {
                    default: {
                        cf.setFileStatus("92");
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 262: 
                    case 263: 
                    case 264: {
                        cf.setFileStatus("13");
                    }
                }
                cf.setStatusMessage("file not open");
                break;
            }
            case 143: {
                cf.setFileStatus("23");
                cf.setStatusMessage("Invalid delete/rewrite in sequential mode");
                break;
            }
            case 112: {
                cf.setFileStatus("21");
                cf.setStatusMessage("No current record defined");
                break;
            }
            case 136: 
            case 137: 
            case 138: {
                cf.setFileStatus("13");
                cf.setStatusMessage("file not open for I-O");
                cf.setExtendedStatus("01");
                break;
            }
            case 107: {
                cf.setFileStatus("23");
                cf.setStatusMessage("record locked");
                break;
            }
            case 129: {
                cf.setFileStatus("23");
                cf.setStatusMessage("no more locks available");
                break;
            }
            case 113: {
                cf.setFileStatus("93");
                cf.setStatusMessage("file locked");
                break;
            }
            case 104: {
                cf.setFileStatus("93");
                cf.setStatusMessage("too many files open");
                break;
            }
            default: {
                type = super.map(type, extFs, cf, op);
            }
        }
        return type;
    }
}

