/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.java.generator;

import com.iscobol.java.CobolVarHelper;
import com.iscobol.java.generator.AbstractCobolVarGenerator;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import com.iscobol.types.Pic1;
import com.iscobol.types.PicX;
import java.util.Enumeration;

public class CobolVarGenerator
extends AbstractCobolVarGenerator {
    public CobolVarGenerator(CobolVarHelper root) {
        super(root);
    }

    @Override
    public void generateVars() {
        this.root.getExternalHelper().get();
        if (this.root.isSection()) {
            CobolVarHelper child;
            boolean isLinkage = this.root.isLinkage();
            Enumeration<CobolVarHelper> e = this.root.childrenElements();
            while (e.hasMoreElements()) {
                CobolVarHelper red;
                child = e.nextElement();
                child.setOffset(0);
                if (child.getRedefines() != null && ((red = this.root.getHelper(child.getRedefines())) != null || (red = this.root.getExternalHelper().getHelper(child.getRedefines())) != null)) {
                    this.generateVars(red, child);
                    continue;
                }
                if (isLinkage) {
                    this.generateVars(null, child, false);
                    continue;
                }
                int size = child.getSizeInBytes();
                if (child.getOccurs() != null) {
                    size *= child.getOccurs().occurs;
                }
                byte[] mem = Factory.getMem(size);
                this.generateVars(mem, child, false);
            }
            e = this.root.childrenElements();
            while (e.hasMoreElements()) {
                child = e.nextElement();
                this.addAttributes(child);
            }
        } else {
            int size = this.root.getSizeInBytes();
            byte[] mem = Factory.getMem(size);
            this.root.setVariable(new PicX(mem, 0, size, this.root.getSizeDimension(), this.root.getNumDimension(), this.root.name, this.root.decimalPointIsComma, this.root.isJustified()));
            Enumeration<CobolVarHelper> e = this.root.childrenElements();
            while (e.hasMoreElements()) {
                CobolVarHelper red;
                CobolVarHelper par = this.root;
                CobolVarHelper child = e.nextElement();
                if (child.getRedefines() != null && ((red = this.root.getHelper(child.getRedefines())) != null || (red = this.root.getExternalHelper().getHelper(child.getRedefines())) != null)) {
                    par = red;
                }
                this.generateVars(par, child);
            }
            this.addAttributes(this.root);
        }
    }

    void generateVars(CobolVarHelper parent, CobolVarHelper var) {
        int offs = var.getOffset();
        int size = var.getSizeInBytes();
        int decs = var.getDecimals();
        CobolVar cv = null;
        block0 : switch (var.getType()) {
            default: {
                throw new RuntimeException("Internal error: generateVars(" + var.getType() + ")");
            }
            case 1: {
                cv = Factory.getVarAlphanum((CobolVar)parent.get(), offs, size, false, null, var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.isJustified());
                var.setVariable(cv);
                Enumeration<CobolVarHelper> e = var.childrenElements();
                while (e.hasMoreElements()) {
                    this.generateVars(var, e.nextElement());
                }
                break;
            }
            case 30: {
                cv = Factory.getVarBoolean((CobolVar)parent.get(), offs, size, false, (Pic1)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma);
                var.setVariable(cv);
                break;
            }
            case 31: {
                cv = Factory.getVarBooleanBit((CobolVar)parent.get(), offs, size, false, (Pic1)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getBitOffset(), var.getBitLength());
                var.setVariable(cv);
                break;
            }
            case 2: {
                cv = Factory.getVarAlphanum((CobolVar)parent.get(), offs, size, false, (CobolVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.isJustified());
                var.setVariable(cv);
                break;
            }
            case 3: {
                cv = Factory.getVarNational((CobolVar)parent.get(), offs, size, false, (CobolVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.isJustified());
                var.setVariable(cv);
                break;
            }
            case 26: {
                cv = Factory.getVarGAlphanum((CobolVar)parent.get(), offs, size, false, (CobolVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.isJustified());
                var.setVariable(cv);
                break;
            }
            case 4: {
                switch (var.opts & 0xF) {
                    default: {
                        cv = Factory.getVarDisplayAcu((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), var.isSignSeparate(), var.isSignLeading());
                        var.setVariable(cv);
                        break block0;
                    }
                    case 1: 
                    case 4: 
                    case 7: 
                    case 10: {
                        cv = Factory.getVarDisplay1((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), var.isSignSeparate(), var.isSignLeading());
                        var.setVariable(cv);
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        cv = Factory.getVarDisplayMF((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), var.isSignSeparate(), var.isSignLeading());
                        var.setVariable(cv);
                        break block0;
                    }
                    case 8: {
                        cv = Factory.getVarDisplayMBP((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), var.isSignSeparate(), var.isSignLeading());
                        var.setVariable(cv);
                        break block0;
                    }
                    case 9: 
                }
                cv = Factory.getVarDisplayRea((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), var.isSignSeparate(), var.isSignLeading());
                var.setVariable(cv);
                break;
            }
            case 5: {
                cv = Factory.getVarShortBinary((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), false, false);
                var.setVariable(cv);
                break;
            }
            case 6: {
                switch (var.opts & 0xF) {
                    default: {
                        cv = Factory.getVarDecimalStorageAcu((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), false, false);
                        var.setVariable(cv);
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                }
                cv = Factory.getVarDecimalStorageNoAcu((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), false, false);
                var.setVariable(cv);
                break;
            }
            case 7: {
                switch (var.opts & 0xF) {
                    default: {
                        cv = Factory.getVarPackedAcu((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), false, false);
                        var.setVariable(cv);
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 8: 
                    case 9: {
                        cv = Factory.getVarPackedNoAcu((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), 1);
                        var.setVariable(cv);
                        break block0;
                    }
                    case 7: {
                        cv = Factory.getVarPackedNoAcu((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), 3);
                        var.setVariable(cv);
                        break block0;
                    }
                    case 10: 
                }
                cv = Factory.getVarPackedNoAcu((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), 5);
                var.setVariable(cv);
                break;
            }
            case 8: {
                cv = Factory.getVarBinary((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), false, false, (var.opts & 0x40) != 0);
                var.setVariable(cv);
                break;
            }
            case 9: {
                cv = Factory.getVarNativeBinary((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), false, false, (var.opts & 0x40) != 0);
                var.setVariable(cv);
                break;
            }
            case 10: {
                cv = Factory.getVarPackedUnsignedAcu((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, false, false, false);
                var.setVariable(cv);
                break;
            }
            case 11: {
                cv = Factory.getVarOrderedPacked((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), false, false);
                var.setVariable(cv);
                break;
            }
            case 12: {
                cv = Factory.getVarCompN((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 0, 0, false, false, false);
                var.setVariable(cv);
                break;
            }
            case 13: {
                cv = Factory.getVarCompX((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 0, 0, false, false, false);
                var.setVariable(cv);
                break;
            }
            case 18: {
                cv = Factory.getVarFloat((CobolVar)parent.get(), offs, 4, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 0, 0, false, false, false);
                var.setVariable(cv);
                break;
            }
            case 19: {
                cv = Factory.getVarDouble((CobolVar)parent.get(), offs, 8, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 0, 0, false, false, false);
                var.setVariable(cv);
                break;
            }
            case 16: {
                cv = Factory.getVarXAnyLength((CobolVar)parent.get(), offs, 0, false, (CobolVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.isJustified());
                var.setVariable(cv);
                break;
            }
            case 17: {
                cv = Factory.getVarNAnyLength((CobolVar)parent.get(), offs, 0, false, (CobolVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.isJustified());
                var.setVariable(cv);
                break;
            }
            case 27: {
                cv = Factory.getVarGAnyLength((CobolVar)parent.get(), offs, 0, false, (CobolVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.isJustified());
                var.setVariable(cv);
                break;
            }
            case 14: {
                cv = Factory.getVarAlphaEdit((CobolVar)parent.get(), offs, size, false, (CobolVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getPicture());
                var.setVariable(cv);
                break;
            }
            case 15: {
                cv = Factory.getVarNumEdit((CobolVar)parent.get(), offs, size, false, (CobolVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getPicture());
                var.setVariable(cv);
                break;
            }
            case 20: {
                cv = Factory.getVarShort((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 5, 0, true, false, false);
                var.setVariable(cv);
                break;
            }
            case 21: {
                cv = Factory.getVarInt((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 10, 0, true, false, false);
                var.setVariable(cv);
                break;
            }
            case 22: {
                cv = Factory.getVarLong((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 18, 0, true, false, false);
                var.setVariable(cv);
                break;
            }
            case 23: {
                cv = Factory.getVarCompN((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 5, 0, var.isSigned(), false, false);
                var.setVariable(cv);
                break;
            }
            case 24: {
                cv = Factory.getVarCompN((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 10, 0, var.isSigned(), false, false);
                var.setVariable(cv);
                break;
            }
            case 25: {
                cv = Factory.getVarCompN((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 18, 0, var.isSigned(), false, false);
                var.setVariable(cv);
                break;
            }
            case 28: 
            case 29: {
                cv = Factory.getVarObject((CobolVar)parent.get(), offs, size, false, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 10, 0, false, false, false);
                var.setVariable(cv);
            }
        }
        if (cv != null) {
            cv.setInitialValue((CobolVar)var.getValue());
        }
    }

    void addAttributes(CobolVarHelper var) {
        CobolVarHelper.XmlAttrs xml;
        CobolVarHelper.Occurs occurs;
        CobolVarHelper.OccursDynamic dynamicData = var.getDynamicData();
        if (dynamicData != null) {
            if (dynamicData.capacity != null) {
                dynamicData.capacityName = dynamicData.capacity.getName();
            } else if (dynamicData.capacityName != null) {
                CobolVarHelper cvh = new CobolVarHelper("", var.opts);
                cvh.pic9Comp4(dynamicData.capacityName, 9, 0);
                dynamicData.capacity = cvh.get(dynamicData.capacityName);
            }
        }
        if ((occurs = var.getOccurs()) != null) {
            if (occurs.indexed == null && occurs.indexedName != null) {
                occurs.indexed = new ICobolVar[occurs.indexedName.length];
                for (int i = 0; i < occurs.indexed.length; ++i) {
                    CobolVarHelper cvh = new CobolVarHelper("", var.opts);
                    cvh.pic9Comp4(occurs.indexedName[i], 9, 0);
                    occurs.indexed[i] = cvh.get(occurs.indexedName[i]);
                }
            }
            if (occurs.depOnName != null && occurs.depOn == null) {
                occurs.depOn = this.root.get(occurs.depOnName);
            }
        }
        if ((xml = var.getXmlAttributes()) != null) {
            if (xml.identifierName != null && xml.identifier == null) {
                xml.identifier = this.root.get(xml.identifierName);
            }
            if (xml.namespaceName != null && xml.namespace == null) {
                xml.namespace = this.root.get(xml.namespaceName);
            }
            if (xml.countName != null && xml.count == null) {
                xml.count = this.root.get(xml.countName);
            }
        }
        CobolVar cv = (CobolVar)var.get();
        if (var.getRedefines() != null) {
            cv.setAsRedefines();
        }
        if (dynamicData != null) {
            cv.setDynamic((CobolVar)dynamicData.capacity, dynamicData.upperLimit, dynamicData.initialized);
        } else if (var.isInDynamic()) {
            cv.setInDynamic();
        }
        if (occurs != null && occurs.depOn != null) {
            if (cv instanceof NumericVar) {
                ((NumericVar)cv).setDepending((CobolVar)occurs.depOn);
            } else {
                ((PicX)cv).setDepending((CobolVar)occurs.depOn);
            }
        }
        if (xml != null && xml.identifier != null) {
            cv.setIdentifier((CobolVar)xml.identifier, false);
            cv.setCount((CobolVar)xml.count);
            cv.setNamespace((CobolVar)xml.namespace, false);
            cv.setAttribute(xml.attribute);
            cv.setProcessingInstruction(xml.processingInstr);
            cv.setRaw(xml.raw);
            cv.setBase64Binary(xml.b64Binary);
            cv.setNullable(xml.nullable);
            cv.setBoolean(xml.bool);
            cv.setHexBinary(xml.hexBinary);
            cv.setCDATA(xml.cdata);
        }
        if (var.childrenElements() != null) {
            Enumeration<CobolVarHelper> e = var.childrenElements();
            while (e.hasMoreElements()) {
                CobolVarHelper child = e.nextElement();
                this.addAttributes(child);
            }
        }
    }

    void generateVars(byte[] mem, CobolVarHelper var, boolean external) {
        int offs = var.getOffset();
        int size = var.getSizeInBytes();
        int decs = var.getDecimals();
        CobolVar cv = null;
        block0 : switch (var.getType()) {
            default: {
                throw new RuntimeException("Internal error: generateVars(" + var.getType() + ")");
            }
            case 1: {
                cv = Factory.getVarAlphanum(mem, offs, size, external, null, var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.isJustified());
                var.setVariable(cv);
                Enumeration<CobolVarHelper> e = var.childrenElements();
                while (e.hasMoreElements()) {
                    this.generateVars(var, e.nextElement());
                }
                break;
            }
            case 30: {
                cv = Factory.getVarBoolean(mem, offs, size, external, (Pic1)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma);
                var.setVariable(cv);
                break;
            }
            case 31: {
                cv = Factory.getVarBooleanBit(mem, offs, size, external, (Pic1)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getBitOffset(), var.getBitLength());
                var.setVariable(cv);
                break;
            }
            case 2: {
                cv = Factory.getVarAlphanum(mem, offs, size, external, (CobolVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.isJustified());
                var.setVariable(cv);
                break;
            }
            case 3: {
                cv = Factory.getVarNational(mem, offs, size, external, (CobolVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.isJustified());
                var.setVariable(cv);
                break;
            }
            case 26: {
                cv = Factory.getVarGAlphanum(mem, offs, size, external, (CobolVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.isJustified());
                var.setVariable(cv);
                break;
            }
            case 4: {
                switch (var.opts & 0xF) {
                    default: {
                        cv = Factory.getVarDisplayAcu(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), var.isSignSeparate(), var.isSignLeading());
                        var.setVariable(cv);
                        break block0;
                    }
                    case 1: 
                    case 4: 
                    case 7: 
                    case 10: {
                        cv = Factory.getVarDisplay1(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), var.isSignSeparate(), var.isSignLeading());
                        var.setVariable(cv);
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        cv = Factory.getVarDisplayMF(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), var.isSignSeparate(), var.isSignLeading());
                        var.setVariable(cv);
                        break block0;
                    }
                    case 8: {
                        cv = Factory.getVarDisplayMBP(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), var.isSignSeparate(), var.isSignLeading());
                        var.setVariable(cv);
                        break block0;
                    }
                    case 9: 
                }
                cv = Factory.getVarDisplayRea(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), var.isSignSeparate(), var.isSignLeading());
                var.setVariable(cv);
                break;
            }
            case 5: {
                cv = Factory.getVarShortBinary(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), false, false);
                var.setVariable(cv);
                break;
            }
            case 6: {
                switch (var.opts & 0xF) {
                    default: {
                        cv = Factory.getVarDecimalStorageAcu(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), false, false);
                        var.setVariable(cv);
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                }
                cv = Factory.getVarDecimalStorageNoAcu(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), false, false);
                var.setVariable(cv);
                break;
            }
            case 7: {
                switch (var.opts & 0xF) {
                    default: {
                        cv = Factory.getVarPackedAcu(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), false, false);
                        var.setVariable(cv);
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 8: 
                    case 9: {
                        cv = Factory.getVarPackedNoAcu(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), 1);
                        var.setVariable(cv);
                        break block0;
                    }
                    case 7: {
                        cv = Factory.getVarPackedNoAcu(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), 3);
                        var.setVariable(cv);
                        break block0;
                    }
                    case 10: 
                }
                cv = Factory.getVarPackedNoAcu(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), 5);
                var.setVariable(cv);
                break;
            }
            case 8: {
                cv = Factory.getVarBinary(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), false, false, (var.opts & 0x40) != 0);
                var.setVariable(cv);
                break;
            }
            case 9: {
                cv = Factory.getVarNativeBinary(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), false, false, (var.opts & 0x40) != 0);
                var.setVariable(cv);
                break;
            }
            case 10: {
                cv = Factory.getVarPackedUnsignedAcu(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, false, false, false);
                var.setVariable(cv);
                break;
            }
            case 11: {
                cv = Factory.getVarOrderedPacked(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getLength(), decs, var.isSigned(), false, false);
                var.setVariable(cv);
                break;
            }
            case 12: {
                cv = Factory.getVarCompN(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 0, 0, false, false, false);
                var.setVariable(cv);
                break;
            }
            case 13: {
                cv = Factory.getVarCompX(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 0, 0, false, false, false);
                var.setVariable(cv);
                break;
            }
            case 18: {
                cv = Factory.getVarFloat(mem, offs, 4, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 0, 0, false, false, false);
                var.setVariable(cv);
                break;
            }
            case 19: {
                cv = Factory.getVarDouble(mem, offs, 8, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 0, 0, false, false, false);
                var.setVariable(cv);
                break;
            }
            case 16: {
                cv = Factory.getVarXAnyLength(mem, offs, 0, external, (CobolVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.isJustified());
                var.setVariable(cv);
                break;
            }
            case 17: {
                cv = Factory.getVarNAnyLength(mem, offs, 0, external, (CobolVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.isJustified());
                var.setVariable(cv);
                break;
            }
            case 27: {
                cv = Factory.getVarGAnyLength(mem, offs, 0, external, (CobolVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.isJustified());
                var.setVariable(cv);
                break;
            }
            case 14: {
                cv = Factory.getVarAlphaEdit(mem, offs, size, external, (CobolVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getPicture());
                var.setVariable(cv);
                break;
            }
            case 15: {
                cv = Factory.getVarNumEdit(mem, offs, size, external, (CobolVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, var.getPicture());
                var.setVariable(cv);
                break;
            }
            case 20: {
                cv = Factory.getVarShort(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 5, 0, true, false, false);
                var.setVariable(cv);
                break;
            }
            case 21: {
                cv = Factory.getVarInt(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 10, 0, true, false, false);
                var.setVariable(cv);
                break;
            }
            case 22: {
                cv = Factory.getVarLong(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 18, 0, true, false, false);
                var.setVariable(cv);
                break;
            }
            case 23: {
                cv = Factory.getVarCompN(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 5, 0, var.isSigned(), false, false);
                var.setVariable(cv);
                break;
            }
            case 24: {
                cv = Factory.getVarCompN(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 10, 0, var.isSigned(), false, false);
                var.setVariable(cv);
                break;
            }
            case 25: {
                cv = Factory.getVarCompN(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 18, 0, var.isSigned(), false, false);
                var.setVariable(cv);
                break;
            }
            case 28: 
            case 29: {
                cv = Factory.getVarObject(mem, offs, size, external, (NumericVar)var.getValue(), var.getSizeDimension(), var.getNumDimension(), var.name, var.decimalPointIsComma, 10, 0, false, false, false);
                var.setVariable(cv);
            }
        }
        if (cv != null) {
            cv.setInitialValue((CobolVar)var.getValue());
        }
    }
}

