/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.export.xls;

import com.iscobol.misc.export.ss.SSExportHelper;
import com.iscobol.misc.export.ss.SSGridExporter;
import com.iscobol.misc.export.xls.XLSExportHelper;
import java.awt.Color;
import java.awt.Font;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class XLSGridExporter
extends SSGridExporter {
    @Override
    protected SSExportHelper createExportHelper() {
        return new XLSExportHelper();
    }

    @Override
    public void setCellStyleAttrs(CellStyle cellStyle, int rowIdx, int colIdx, String numericFormat) {
        VerticalAlignment verticalAlign = VerticalAlignment.CENTER;
        HorizontalAlignment horizontalAlign = HorizontalAlignment.LEFT;
        Font f = this.provider.getCellFont(rowIdx, colIdx);
        Color[] c = this.provider.getCellColor(rowIdx, colIdx);
        int halign = this.provider.getColumnAlignment(colIdx);
        org.apache.poi.ss.usermodel.Font font = this.getFont(f, c[1]);
        XLSExportHelper ee = (XLSExportHelper)this.helper;
        cellStyle.setFont(font);
        cellStyle.setFillForegroundColor(ee.getColor(c[0], HSSFColor.HSSFColorPredefined.WHITE.getIndex()));
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        switch (halign) {
            case 0: {
                horizontalAlign = HorizontalAlignment.CENTER;
                break;
            }
            case 4: {
                horizontalAlign = HorizontalAlignment.RIGHT;
            }
        }
        cellStyle.setAlignment(horizontalAlign);
        cellStyle.setVerticalAlignment(verticalAlign);
        Color dividerColor = this.provider.getDividerColor(rowIdx, colIdx);
        short colorIdx = ee.getColor(dividerColor, HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        int rowsDividers = this.provider.getRowsDivider();
        cellStyle.setBorderBottom(ee.getBorder(rowsDividers));
        cellStyle.setBottomBorderColor(colorIdx);
        cellStyle.setBorderLeft(ee.getBorder(this.provider.getColumnDivider(colIdx)));
        cellStyle.setLeftBorderColor(colorIdx);
        cellStyle.setWrapText(true);
        if (numericFormat != null) {
            cellStyle.setDataFormat(this.helper.getFormat(numericFormat));
        }
    }
}

