/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.javabeans;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.GuiWords;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.misc.javabeans.CobolSourceViewer;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;

public class StyledTextPane
extends JTextPane {
    private static final long serialVersionUID = 1L;
    private static final int[] ANSI_AREA_COLUMNS;
    private static final int[] TERMINAL_AREA_COLUMNS;
    private static final Set statements;
    private static final Set keywords;
    private static final String eol;
    private int lineCount;
    private CobolSourceViewer viewer;
    private Rectangle oldClip;

    public StyledTextPane(CobolSourceViewer viewer) {
        this.viewer = viewer;
        this.setContentType("text/plain");
        this.setEditable(false);
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        this.setBackground(new Color(this.viewer.getSourceBackground()));
        this.setForeground(new Color(this.viewer.getSourceForeground()));
        StyledDocument doc = this.getStyledDocument();
        doc.putProperty("__EndOfLine__", eol);
    }

    public void setContents(InputStream is) {
        this.setContents(new InputStreamReader(is));
    }

    public void setContents(final Reader reader) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setContentsImpl(reader);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        StyledTextPane.this.setContentsImpl(reader);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void setContentsImpl(Reader reader) {
        BufferedReader bufReader = new BufferedReader(reader);
        int i = 0;
        StringBuffer sb = new StringBuffer();
        try {
            String line = bufReader.readLine();
            while (line != null) {
                if (i > 0) {
                    sb.append(eol);
                }
                sb.append(line);
                line = bufReader.readLine();
                ++i;
            }
        }
        catch (IOException line) {
            // empty catch block
        }
        this.lineCount = i;
        StyledDocument doc = this.getStyledDocument();
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(0, sb.toString(), null);
            this.setCaretPosition(0);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    protected void setStyleAttributes(String text, int offset) throws IOException, BadLocationException {
        StyledDocument doc = this.getStyledDocument();
        BufferedReader reader = new BufferedReader(new StringReader(text));
        int i = 0;
        Hashtable nrw = this.viewer.getNotReservedWordsTable();
        int format = this.viewer.getSourceFormat();
        String line = reader.readLine();
        while (line != null) {
            int newFormat;
            if (i > 0) {
                offset += eol.length();
            }
            if ((newFormat = this.checkFormat(line)) != format) {
                reader.close();
                this.viewer.setSourceFormat(newFormat);
                return;
            }
            TokenList tl = PreProcessor.tokenizer(new StringBuffer(line), '.', true, true, nrw);
            boolean isComment = false;
            boolean firstToken = true;
            int end = 0;
            int beg = 0;
            Token tk = tl.getFirstWithSep();
            while (tk != null) {
                String word;
                String wordUp = tk.getWord();
                int offs = tk.getOffset();
                int diff = end - offs;
                end = Math.min(line.length(), offs + wordUp.length());
                if (diff >= 0) {
                    beg = Math.min(end, offs + diff);
                    word = line.substring(beg, end);
                } else {
                    beg = Math.min(offs, offs + diff);
                    word = line.substring(beg, offs);
                    doc.setCharacterAttributes(offset, word.length(), doc.getStyle("source"), true);
                    offset += word.length();
                    word = line.substring(offs, end);
                }
                if (word.length() != 0) {
                    Style attr;
                    if (isComment) {
                        attr = doc.getStyle("comment");
                    } else {
                        switch (tk.getToknum()) {
                            case 10016: {
                                if (word.startsWith("*>") || word.startsWith("|")) {
                                    attr = doc.getStyle("comment");
                                    firstToken = false;
                                    break;
                                }
                                if (word.trim().length() > 0) {
                                    firstToken = false;
                                }
                                attr = doc.getStyle("source");
                                break;
                            }
                            case 10002: {
                                attr = firstToken && StyledTextPane.isLevelNumber(word) ? doc.getStyle("levelNumber") : doc.getStyle("number");
                                firstToken = false;
                                break;
                            }
                            case 10017: {
                                attr = doc.getStyle("number");
                                firstToken = false;
                                break;
                            }
                            case 10001: 
                            case 10024: {
                                attr = doc.getStyle("string");
                                firstToken = false;
                                break;
                            }
                            case 576: 
                            case 577: 
                            case 601: 
                            case 660: 
                            case 661: 
                            case 736: 
                            case 737: 
                            case 822: 
                            case 824: 
                            case 825: {
                                attr = doc.getStyle("figurativeConstant");
                                firstToken = false;
                                break;
                            }
                            default: {
                                if (tk.getWord().startsWith("*")) {
                                    if (format == 1 && tk.getOffset() == 6 || format == 2 && tk.getOffset() == 0) {
                                        attr = doc.getStyle("comment");
                                        isComment = true;
                                    } else {
                                        attr = doc.getStyle("source");
                                    }
                                } else {
                                    attr = !nrw.contains(wordUp) ? (statements.contains(wordUp) ? doc.getStyle("statement") : (keywords.contains(wordUp) ? doc.getStyle("keyword") : doc.getStyle("source"))) : doc.getStyle("source");
                                }
                                firstToken = false;
                            }
                        }
                    }
                    doc.setCharacterAttributes(offset, word.length(), attr, true);
                    offset += word.length();
                }
                tk = tl.getNextWithSep();
            }
            if (end < line.length()) {
                String w = line.substring(end);
                doc.setCharacterAttributes(offset, w.length(), doc.getStyle("source"), true);
                offset += w.length();
            }
            line = reader.readLine();
            ++i;
        }
        reader.close();
    }

    protected void paintClientArea(Rectangle clip, Graphics g) {
        g.setColor(new Color(this.viewer.getSourceBackground()));
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        int format = this.viewer.getSourceFormat();
        if (this.viewer.isShowAreaBackground()) {
            int gap;
            int charWidth;
            FontMetrics fm;
            if (format == 1) {
                fm = this.getFontMetrics(this.getFont());
                charWidth = fm.charWidth('X');
                gap = this.getInsets().left;
                g.setColor(new Color(this.viewer.getAnsiSequenceNumberBackground()));
                g.fillRect(0, 0, gap + charWidth * ANSI_AREA_COLUMNS[0], this.getHeight());
                g.setColor(new Color(this.viewer.getAnsiIndicatorAreaBackground()));
                g.fillRect(gap + charWidth * ANSI_AREA_COLUMNS[0], 0, charWidth * (ANSI_AREA_COLUMNS[1] - ANSI_AREA_COLUMNS[0]), this.getHeight());
                g.setColor(new Color(this.viewer.getAnsiAreaABackground()));
                g.fillRect(gap + charWidth * ANSI_AREA_COLUMNS[1], 0, charWidth * (ANSI_AREA_COLUMNS[2] - ANSI_AREA_COLUMNS[1]), this.getHeight());
                g.setColor(new Color(this.viewer.getAnsiAreaBBackground()));
                g.fillRect(gap + charWidth * ANSI_AREA_COLUMNS[2], 0, charWidth * (ANSI_AREA_COLUMNS[3] - ANSI_AREA_COLUMNS[2]), this.getHeight());
                g.setColor(new Color(this.viewer.getAnsiIdentificationAreaBackground()));
                g.fillRect(gap + charWidth * ANSI_AREA_COLUMNS[3], 0, charWidth * (ANSI_AREA_COLUMNS[4] - ANSI_AREA_COLUMNS[3]), this.getHeight());
            } else if (format == 2) {
                fm = this.getFontMetrics(this.getFont());
                charWidth = fm.charWidth('X');
                gap = this.getInsets().left;
                g.setColor(new Color(this.viewer.getTerminalIndicatorAreaBackground()));
                g.fillRect(0, 0, gap + charWidth * TERMINAL_AREA_COLUMNS[0], this.getHeight());
                g.setColor(new Color(this.viewer.getTerminalAreaABackground()));
                g.fillRect(gap + charWidth * TERMINAL_AREA_COLUMNS[0], 0, charWidth * (TERMINAL_AREA_COLUMNS[1] - TERMINAL_AREA_COLUMNS[0]), this.getHeight());
                g.setColor(new Color(this.viewer.getTerminalAreaBBackground()));
                g.fillRect(gap + charWidth * TERMINAL_AREA_COLUMNS[1], 0, this.getWidth() - gap - charWidth * TERMINAL_AREA_COLUMNS[1], this.getHeight());
            }
        }
        if (this.viewer.isShowAreaDividers()) {
            int[] columns = null;
            if (format == 1) {
                columns = ANSI_AREA_COLUMNS;
            } else if (format == 2) {
                columns = TERMINAL_AREA_COLUMNS;
            }
            if (columns != null) {
                FontMetrics fm = this.getFontMetrics(this.getFont());
                Color dividerColor = new Color(this.viewer.getAreaDividerColor());
                g.setColor(dividerColor);
                int charWidth = fm.charWidth('X');
                int gap = this.getInsets().left;
                for (int i = 0; i < columns.length; ++i) {
                    int x = gap + charWidth * columns[i];
                    g.drawLine(x, 0, x, this.getHeight());
                }
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle clip = g.getClipBounds();
        this.paintClientArea(clip, g);
        if (this.oldClip == null || !this.oldClip.equals(clip)) {
            StyledDocument doc = this.getStyledDocument();
            int rowStartOffset = this.viewToModel(new Point(0, clip.y));
            int endOffset = this.viewToModel(new Point(0, clip.y + clip.height + g.getFontMetrics().getHeight()));
            endOffset = Math.min(doc.getLength(), endOffset);
            if (endOffset > rowStartOffset && doc.getLength() > 0) {
                try {
                    String text = doc.getText(rowStartOffset, endOffset - rowStartOffset);
                    this.setStyleAttributes(text, rowStartOffset);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.oldClip = clip;
        }
        super.paintComponent(g);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getUI().getPreferredSize((JComponent)this).width <= this.getParent().getSize().width;
    }

    private static boolean isLevelNumber(String str) {
        try {
            int num = Integer.parseInt(str);
            return num >= 1 && num <= 49 || num == 66 || num == 77 || num == 78 || num == 88;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private int checkFormat(String line) {
        int format = this.viewer.getSourceFormat();
        boolean mixedFormat = this.viewer.isSourceFormatMixed();
        if (format == 0 && line.length() > 0) {
            int i;
            if (line.charAt(0) == '*' && (mixedFormat || line.length() == 1 || line.charAt(1) != '>')) {
                return 2;
            }
            if (line.charAt(0) == '/' || line.charAt(0) == '$') {
                return 2;
            }
            for (i = 0; i < line.length() && (line.charAt(i) == ' ' || line.charAt(i) == '\t'); ++i) {
            }
            if (i < line.length()) {
                if (line.length() > 6 && (line.charAt(6) == '*' || line.charAt(6) == '$') || line.length() > 7 && line.charAt(6) == ' ' || line.charAt(6) == '/') {
                    for (i = 0; i < 6; ++i) {
                        if ((line.charAt(i) != '*' || line.charAt(i + 1) != '>') && (line.charAt(i) != '>' || line.charAt(i + 1) != '>')) continue;
                        if (mixedFormat) {
                            return 2;
                        }
                        return 3;
                    }
                    if (format == 0) {
                        return 1;
                    }
                } else {
                    if (mixedFormat) {
                        return 2;
                    }
                    return 3;
                }
            }
        }
        return format;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getLineNumber(int rowStartOffset) {
        int index;
        Element root = this.getDocument().getDefaultRootElement();
        Element line = root.getElement(index = root.getElementIndex(rowStartOffset));
        if (line.getStartOffset() == rowStartOffset) {
            return index + 1;
        }
        return 0;
    }

    static {
        int i;
        ANSI_AREA_COLUMNS = new int[]{6, 7, 11, 72, 80};
        TERMINAL_AREA_COLUMNS = new int[]{1, 5};
        statements = new HashSet();
        keywords = new HashSet();
        for (i = 0; i < CobolToken.tokDesc.length; ++i) {
            if (CobolToken.isStat[i]) {
                statements.add(CobolToken.tokDesc[i]);
                continue;
            }
            keywords.add(CobolToken.tokDesc[i]);
        }
        statements.add("::");
        statements.add(":>");
        for (i = 0; i < GuiWords.guiWords.length; ++i) {
            keywords.add(GuiWords.guiWords[i]);
        }
        eol = System.getProperty("line.separator", "\n");
    }
}

