/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.dualrpc.common;

import com.iscobol.rpc.dualrpc.common.AbstractRpcResultPayload;
import com.iscobol.rpc.dualrpc.common.IDualRpcMessageConstants;
import com.iscobol.rpc.dualrpc.common.IRpcHandler;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.dualrpc.common.RpcCallPayload;
import com.iscobol.rpc.dualrpc.common.RpcException;
import com.iscobol.rpc.dualrpc.common.RpcFaultPayload;
import com.iscobol.rpc.dualrpc.common.RpcResultPayload;
import com.iscobol.rpc.dualrpc.common.RpcResultPayloadContainer;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rpc.messageserver.common.SessionException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class RpcWorker
extends Thread
implements IDualRpcMessageConstants {
    private IRpcMessageDispatcher dispatcher = null;
    private Message message = null;

    public RpcWorker(IRpcMessageDispatcher dispatcher, Message message) {
        this.setDispatcher(dispatcher);
        this.setMessage(message);
    }

    protected void configureThread() {
        Thread.currentThread().setName(this.getClass().getName() + ":hashcode=" + this.hashCode() + ":sessionId=" + this.getDispatcher().getSession().getSessionId());
    }

    @Override
    public void run() {
        this.configureThread();
        int payloadType = -1;
        try {
            payloadType = this.getMessage().getPayloadType();
            switch (payloadType) {
                case 1: {
                    this.processRpcCallMessage(this.getMessage());
                    break;
                }
                case 2: {
                    this.processRpcResultMessage(this.getMessage(), 2);
                    break;
                }
                case 3: {
                    this.processRpcResultMessage(this.getMessage(), 3);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void processRpcCallMessage(Message message) throws SessionException {
        block8: {
            Session session = this.getDispatcher().getSession();
            long sessionId = session.getSessionId();
            RpcCallPayload payload = null;
            int messageId = message.getId();
            try {
                payload = (RpcCallPayload)message.getPayload();
                String handlerClassname = payload.getHandlerName();
                String handlerMethodName = payload.getMethodName();
                ArrayList methodParameterList = payload.getParameters();
                IRpcHandler handler = this.getDispatcher().getHandler(handlerClassname);
                if (handler == null) {
                    throw new RpcException("Unknown handler=" + handlerClassname);
                }
                ArrayList parameterClassList = new ArrayList();
                int elems = methodParameterList.size();
                StringBuffer bufParameterClassList = new StringBuffer();
                for (int i = 0; i < elems; ++i) {
                    Class<?> clazz = methodParameterList.get(i).getClass();
                    parameterClassList.add(clazz);
                    bufParameterClassList.append(clazz.getName() + ",");
                }
                Class[] parameterClassArray = new Class[parameterClassList.size()];
                parameterClassList.toArray(parameterClassArray);
                Method handlerMethod = this.findMethod(handler.getClass(), handlerMethodName, parameterClassArray);
                if (handlerMethod == null) {
                    throw new RpcException("Cannot locate method=" + handlerMethodName + "( " + bufParameterClassList.toString() + " )");
                }
                Object[] parameterObjectArray = new Object[methodParameterList.size()];
                methodParameterList.toArray(parameterObjectArray);
                Object returnObject = handlerMethod.invoke((Object)handler, parameterObjectArray);
                if (payload.isSendResults()) {
                    RpcResultPayload rpcresult = new RpcResultPayload(returnObject, messageId);
                    Message outboundMessage = new Message(-1, 2, rpcresult);
                    this.getDispatcher().getSession().sendMessage(outboundMessage);
                }
            }
            catch (InvocationTargetException itex) {
                if (payload != null && payload.isSendResults()) {
                    String errmsg = this.buildFaultErrorMessage(sessionId, itex.getTargetException());
                    this.sendFaultMessage(messageId, errmsg);
                }
            }
            catch (Exception ex) {
                if (payload == null || !payload.isSendResults()) break block8;
                String errmsg = this.buildFaultErrorMessage(sessionId, ex);
                this.sendFaultMessage(messageId, errmsg);
            }
        }
    }

    public String buildFaultErrorMessage(long sessionId, Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return t.getMessage() + "\n" + sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRpcResultMessage(Message message, int payloadType) throws RpcException {
        AbstractRpcResultPayload payload = null;
        switch (payloadType) {
            case 2: {
                payload = (RpcResultPayload)message.getPayload();
                break;
            }
            case 3: {
                payload = (RpcFaultPayload)message.getPayload();
                break;
            }
            default: {
                throw new RpcException("Unknown rpc message payloadType=" + payloadType);
            }
        }
        int originatingRpcCallMessageId = payload.getOriginatingRpcCallMessageId();
        RpcResultPayloadContainer container = (RpcResultPayloadContainer)this.getDispatcher().getCallWaitingRegistry().get(originatingRpcCallMessageId);
        if (container != null) {
            container.setRpcMessagePayload(payload);
            container.setRpcResultMessageType(payloadType);
            RpcResultPayloadContainer rpcResultPayloadContainer = container;
            synchronized (rpcResultPayloadContainer) {
                container.notifyAll();
            }
        } else {
            throw new RpcException("Orphaned rpc result message:originating rpc call message id=" + originatingRpcCallMessageId);
        }
    }

    public IRpcMessageDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(IRpcMessageDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public void sendFaultMessage(int originatingRpcCallMessageId, String errorMessage) throws SessionException {
        RpcFaultPayload rpcfault = new RpcFaultPayload("x", errorMessage, originatingRpcCallMessageId);
        Message outboundMessage = new Message(-1, 3, rpcfault);
        this.getDispatcher().getSession().sendMessage(outboundMessage);
    }

    public Method findMethod(Class klass, String methodName, Class[] parameterClasses) {
        Method method = null;
        try {
            method = klass.getMethod(methodName, parameterClasses);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            try {
                method = this.tryFindMethod(klass, methodName, parameterClasses);
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
        }
        return method;
    }

    private Method tryFindMethod(Class klass, String methodName, Class[] methodToFindParameterClasses) throws NoSuchMethodException {
        Method[] methods = klass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] foundMethodParameterClasses;
            if (!methods[i].getName().equals(methodName) || (foundMethodParameterClasses = methods[i].getParameterTypes()).length != methodToFindParameterClasses.length) continue;
            boolean found = true;
            for (int j = 0; j < foundMethodParameterClasses.length && found; found &= methodToFindParameterClasses[j] == null || RpcWorker.isAssignableFrom(foundMethodParameterClasses[j], methodToFindParameterClasses[j]), ++j) {
            }
            if (!found) continue;
            return methods[i];
        }
        throw new NoSuchMethodException();
    }

    private static boolean isAssignableFrom(Class to, Class from) {
        return to.isAssignableFrom(from) || to == Integer.TYPE && from == Integer.class || to == Long.TYPE && from == Long.class || to == Boolean.TYPE && from == Boolean.class || to == Float.TYPE && from == Float.class || to == Double.TYPE && from == Double.class || to == Character.TYPE && from == Character.class || to == Short.TYPE && from == Short.class || to == Byte.TYPE && from == Byte.class;
    }
}

