/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.as.ClientInfo;
import com.iscobol.gui.AppFactory;
import com.iscobol.rts.CallLoader;
import com.iscobol.rts.Config;
import com.iscobol.rts.CopyResources;
import com.iscobol.rts.ErrorBox;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.NoExit;
import com.iscobol.rts.RuntimeInfo;
import com.iscobol.rts.StopRunException;
import com.iscobol.rts.ThreadName;

public abstract class CallRun
implements Runnable {
    private Thread thread;
    private ClientInfo clientInfo;
    private CommandLineArgs commandLineArgs;

    public CallRun(String[] argv) {
        if (argv != null) {
            this.commandLineArgs = new CommandLineArgs(argv);
        }
        this.thread = new Thread(this);
        ThreadName.setName(this.thread, this);
        IscobolSystem.duplicateVar(AppFactory.class, this.thread);
        IscobolSystem.duplicateVar(RuntimeInfo.class, this.thread);
        IscobolSystem.duplicateVar(NoExit.class, this.thread);
        IscobolSystem.duplicateVar(CopyResources.class, this.thread);
        IscobolSystem.duplicateVar(CallLoader.SharedClassLoader.class, this.thread);
        this.clientInfo = (ClientInfo)IscobolSystem.get(ClientInfo.class);
    }

    public void start() {
        this.thread.start();
        if (Config.getProperty(".call_run.sync", false)) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public abstract void launch();

    @Override
    public void run() {
        RuntimeInfo ri = (RuntimeInfo)IscobolSystem.get(RuntimeInfo.class);
        if (ri != null) {
            ri.incrementCallRunCount();
        }
        try {
            IscobolSystem.set(CallRun.class, this);
            if (this.commandLineArgs != null) {
                IscobolSystem.set(CommandLineArgs.class, this.commandLineArgs);
            }
            if (this.clientInfo != null) {
                IscobolSystem.set(ClientInfo.class, this.clientInfo);
                String[] clData = this.clientInfo.getClData();
                if (clData != null && clData.length > 0 && clData[0] != null && clData[0].length() > 0) {
                    Config.loadProperties(clData[0]);
                }
            }
            this.launch();
        }
        catch (StopRunException clData) {
        }
        catch (Exception ex) {
            this.handleError(ex);
        }
        finally {
            if (ri != null) {
                ri.decrementCallRunCount();
            }
            try {
                IscobolSystem.destroyAndFinalizeEnv(this.thread);
            }
            catch (Exception exception) {}
        }
    }

    protected void handleError(Throwable t) {
        ErrorBox.show(t);
    }

    public Thread getThread() {
        return this.thread;
    }

    public static class CommandLineArgs {
        public String[] commandLineArgs;

        public CommandLineArgs(String[] commandLineArgs) {
            this.commandLineArgs = commandLineArgs;
        }
    }
}

