/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Config;
import com.iscobol.rts.CurrentDate;
import com.iscobol.rts.Factory;
import com.iscobol.rts.Handle;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.UserHandles;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import com.iscobol.types.Pic1;
import com.iscobol.types.Pic9Comp_5;
import com.iscobol.types.PicN;
import com.iscobol.types.PicX;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;

public class Functions
implements RuntimeErrorsNumbers {
    public static final Map<Integer, String> CCSIDs;
    private static final int[][] dayInMonth;
    private Random random;
    public static final CobolNum ZERO;
    public static final CobolNum ONE;
    public static final CobolNum TWO;
    public static final double LOG10;

    private static Functions get() {
        Functions Return2 = (Functions)IscobolSystem.get(Functions.class);
        if (Return2 == null) {
            Return2 = new Functions();
            IscobolSystem.set(Functions.class, Return2);
        }
        return Return2;
    }

    static int isLeapYear(int y) {
        return y % 4 == 0 && y % 100 != 0 || y % 400 == 0 ? 1 : 0;
    }

    static int toJulian(int year, int month, int day) {
        int i;
        int Return2 = 0;
        Return2 = day;
        if (month > 12) {
            year += month / 12;
            if ((month %= 12) == 0) {
                month = 12;
                --year;
            }
        }
        for (i = 1; i < month; ++i) {
            Return2 += dayInMonth[i][Functions.isLeapYear(year)];
        }
        for (i = 1601; i < year; ++i) {
            Return2 += 365 + Functions.isLeapYear(i);
        }
        return Return2;
    }

    static int fromJulian(int julian, boolean dayOfYear) {
        int day = 0;
        int month = 0;
        int year = 0;
        if (julian > 0) {
            int i = 1601;
            while (true) {
                if (Functions.isLeapYear(i) == 1) {
                    if ((julian -= 366) <= 0) {
                        year = i;
                        julian += 366;
                        break;
                    }
                } else if ((julian -= 365) <= 0) {
                    year = i;
                    julian += 365;
                    break;
                }
                ++i;
            }
            if (dayOfYear) {
                return year * 1000 + julian;
            }
            i = 1;
            while (true) {
                if ((julian -= dayInMonth[i][Functions.isLeapYear(year)]) <= 0) break;
                ++i;
            }
            month = i;
            day = julian + dayInMonth[i][Functions.isLeapYear(year)];
            return year * 10000 + month * 100 + day;
        }
        return 0;
    }

    public static Pic1 booleanOfInteger(CobolNum nv, CobolNum nBits) {
        return new Pic1(nv.longValue(), nBits.intValue());
    }

    public static NumericVar integerOfBoolean(Pic1 pic1, boolean dpc) {
        long l = pic1.tolong();
        return NumericVar.literal(l, CobolNum.getNumDigits(l), 0, dpc);
    }

    public static NumericVar integerOfBoolean(NumericVar nv, boolean dpc) {
        long l = nv.tolong();
        return NumericVar.literal(l, CobolNum.getNumDigits(l), 0, dpc);
    }

    public static NumericVar integerOfDate(CobolNum cv) {
        return Functions.integerOfDate(cv, false);
    }

    public static NumericVar integerOfDate(CobolNum cv, boolean dpic) {
        int date = cv.intValue();
        int Return2 = date > 16010100 ? Functions.toJulian(date / 10000, date % 10000 / 100, date % 100) : 0;
        return NumericVar.literal(Return2, 10, 0, false);
    }

    public static NumericVar integerOfDay(CobolNum cv, boolean dpic) {
        int date = cv.intValue();
        int Return2 = date > 1601000 ? Functions.toJulian(date / 1000, 0, date % 1000) : 0;
        return NumericVar.literal(Return2, 10, 0, false);
    }

    public static PicX currentDate() {
        long result = 0L;
        GregorianCalendar now = CurrentDate.get();
        result += (long)now.get(1) * 1000000000000L;
        result += (long)(now.get(2) + 1) * 10000000000L;
        result += (long)now.get(5) * 100000000L;
        result += (long)(now.get(11) * 1000000);
        result += (long)(now.get(12) * 10000);
        result += (long)(now.get(13) * 100);
        StringBuffer currDate = new StringBuffer();
        currDate.append(result += (long)(now.get(14) / 10));
        int offset = TimeZone.getDefault().getRawOffset();
        if (offset < 0) {
            currDate.append("-");
            offset *= -1;
        } else {
            currDate.append("+");
        }
        int hour = offset / 3600000;
        int min = offset % 3600000 / 60000;
        if (hour < 10) {
            currDate.append("0");
        }
        currDate.append(hour);
        if (min < 10) {
            currDate.append("0");
        }
        currDate.append(min);
        return Factory.getStrLiteral(currDate.toString());
    }

    public static NumericVar dateOfInteger(CobolNum cv) {
        return Functions.dateOfInteger(cv, false);
    }

    public static NumericVar dateOfInteger(CobolNum cv, boolean dpic) {
        return NumericVar.literal(Functions.fromJulian(cv.intValue(), false), 8, 0, dpic);
    }

    public static NumericVar dayOfInteger(CobolNum cv, boolean dpic) {
        return NumericVar.literal(Functions.fromJulian(cv.intValue(), true), 8, 0, dpic);
    }

    private static int yearToYyyy(int year, int threshold) {
        GregorianCalendar now = CurrentDate.get();
        int maxYear = now.get(1) + threshold;
        int Return2 = maxYear % 100 >= year ? year + 100 * (maxYear / 100) : year + 100 * (maxYear / 100 - 1);
        return Return2;
    }

    public static NumericVar yearToYyyy(CobolNum yr, boolean dpic) {
        return NumericVar.literal(Functions.yearToYyyy(yr.intValue(), 50), 8, 0, dpic);
    }

    public static NumericVar yearToYyyy(CobolNum yr, CobolNum ts, boolean dpic) {
        return NumericVar.literal(Functions.yearToYyyy(yr.intValue(), ts.intValue()), 8, 0, dpic);
    }

    private static int dateToYyyyMmDd(int date, int threshold) {
        return Functions.yearToYyyy(date / 10000, threshold) * 10000 + date % 10000;
    }

    public static NumericVar dateToYyyyMmDd(CobolNum dt, boolean dpic) {
        return NumericVar.literal(Functions.dateToYyyyMmDd(dt.intValue(), 50), 8, 0, dpic);
    }

    public static NumericVar dateToYyyyMmDd(CobolNum dt, CobolNum ts, boolean dpic) {
        return NumericVar.literal(Functions.dateToYyyyMmDd(dt.intValue(), ts.intValue()), 8, 0, dpic);
    }

    private static int dayToYyyyDdd(int day, int threshold) {
        return Functions.yearToYyyy(day / 1000, threshold) * 1000 + day % 1000;
    }

    public static NumericVar dayToYyyyDdd(CobolNum dy, boolean dpic) {
        return NumericVar.literal(Functions.dayToYyyyDdd(dy.intValue(), 50), 8, 0, dpic);
    }

    public static NumericVar dayToYyyyDdd(CobolNum dy, CobolNum ts, boolean dpic) {
        return NumericVar.literal(Functions.dayToYyyyDdd(dy.intValue(), ts.intValue()), 8, 0, dpic);
    }

    public static NumericVar length(CobolVar cv) {
        if (cv.getMemory() != null) {
            return NumericVar.literal(cv.getLength(), 10, 0, false);
        }
        if (cv instanceof PicN) {
            return NumericVar.literal(cv.length() / 2, 10, 0, false);
        }
        return NumericVar.literal(cv.length(), 10, 0, false);
    }

    public static NumericVar lengthComp_5(CobolVar cv) {
        if (cv.getMemory() != null) {
            return Pic9Comp_5.literal(cv.getLength());
        }
        if (cv instanceof PicN) {
            return Pic9Comp_5.literal(cv.length() / 2);
        }
        return Pic9Comp_5.literal(cv.length());
    }

    public static NumericVar byteLength(CobolVar cv) {
        if (cv.getMemory() != null) {
            return NumericVar.literal(cv.length(), 10, 0, false);
        }
        return NumericVar.literal(cv.getMaxLength(), 10, 0, false);
    }

    public static PicX upperCase(CobolVar cv) {
        return PicX.literal(Factory.toUpperCase(cv.toString()));
    }

    public static PicX lowerCase(CobolVar cv) {
        return PicX.literal(Factory.toLowerCase(cv.toString()));
    }

    public static PicX trim(CobolVar cv) {
        return PicX.literal(cv.toString().trim());
    }

    public static final String trimLeft(String arg) {
        int i;
        int len = arg.length();
        for (i = 0; i < len && arg.charAt(i) == ' '; ++i) {
        }
        if (i == 0) {
            return arg;
        }
        if (i == len) {
            return "";
        }
        return arg.substring(i);
    }

    public static final String trimRight(String arg) {
        int len_1;
        int i;
        for (i = len_1 = arg.length() - 1; i >= 0 && arg.charAt(i) == ' '; --i) {
        }
        if (i < 0) {
            return "";
        }
        if (i == len_1) {
            return arg;
        }
        return arg.substring(0, i + 1);
    }

    public static PicX triml(CobolVar cv) {
        return PicX.literal(Functions.trimLeft(cv.toString()));
    }

    public static PicX trimr(CobolVar cv) {
        return PicX.literal(Functions.trimRight(cv.toString()));
    }

    public static PicX reverse(CobolVar cv) {
        StringBuffer Return2 = new StringBuffer(cv.toString());
        if (Return2.length() > 1) {
            Return2.reverse();
        }
        return PicX.literal(Return2.toString());
    }

    public static PicX min(CobolVar[] args) {
        CobolVar min = args[0];
        for (int i = 1; i < args.length; ++i) {
            if (min.compareTo(args[i]) <= 0) continue;
            min = args[i];
        }
        return PicX.literal(min.toString());
    }

    public static NumericVar min(NumericVar[] args) {
        NumericVar min = args[0];
        for (int i = 1; i < args.length; ++i) {
            if (min.num().compareTo(args[i].num()) <= 0) continue;
            min = args[i];
        }
        return min.copy();
    }

    public static NumericVar min(CobolNum[] args, boolean dpic) {
        CobolNum min = args[0];
        for (int i = 1; i < args.length; ++i) {
            if (min.compareTo(args[i]) <= 0) continue;
            min = args[i];
        }
        return NumericVar.literal(min, dpic);
    }

    public static PicX max(CobolVar[] args) {
        CobolVar max = args[0];
        for (int i = 1; i < args.length; ++i) {
            if (max.compareTo(args[i]) >= 0) continue;
            max = args[i];
        }
        if (max instanceof PicN) {
            return PicN.literal(max.toString());
        }
        return PicX.literal(max.toString());
    }

    public static NumericVar max(NumericVar[] args) {
        NumericVar max = args[0];
        for (int i = 1; i < args.length; ++i) {
            if (max.num().compareTo(args[i].num()) >= 0) continue;
            max = args[i];
        }
        return max.copy();
    }

    public static NumericVar max(CobolNum[] args, boolean dpic) {
        CobolNum max = args[0];
        for (int i = 1; i < args.length; ++i) {
            if (max.compareTo(args[i]) >= 0) continue;
            max = args[i];
        }
        return NumericVar.literal(max, dpic);
    }

    public static NumericVar ordMax(CobolVar[] args) {
        CobolVar max = args[0];
        long Return2 = 0L;
        for (int i = 1; i < args.length; ++i) {
            if (max.compareTo(args[i]) >= 0) continue;
            max = args[i];
            Return2 = i;
        }
        return NumericVar.literal(Return2 + 1L, 18, 0, max.isDecimalPointComma());
    }

    public static NumericVar ordMax(CobolNum[] args, boolean dpic) {
        CobolNum max = args[0];
        long Return2 = 0L;
        for (int i = 1; i < args.length; ++i) {
            if (max.compareTo(args[i]) >= 0) continue;
            max = args[i];
            Return2 = i;
        }
        return NumericVar.literal(Return2 + 1L, 18, 0, dpic);
    }

    public static NumericVar ordMin(CobolVar[] args) {
        CobolVar min = args[0];
        long Return2 = 0L;
        for (int i = 1; i < args.length; ++i) {
            if (min.compareTo(args[i]) <= 0) continue;
            min = args[i];
            Return2 = i;
        }
        return NumericVar.literal(Return2 + 1L, 18, 0, min.isDecimalPointComma());
    }

    public static NumericVar ordMin(CobolNum[] args, boolean dpic) {
        CobolNum min = args[0];
        long Return2 = 0L;
        for (int i = 1; i < args.length; ++i) {
            if (min.compareTo(args[i]) <= 0) continue;
            min = args[i];
            Return2 = i;
        }
        return NumericVar.literal(Return2 + 1L, 18, 0, dpic);
    }

    public static NumericVar random() {
        return Functions.random(false);
    }

    public static NumericVar random(boolean dpic) {
        Functions self = Functions.get();
        if (self.random == null) {
            self.random = new Random();
        }
        return NumericVar.literal(self.random.nextDouble(), dpic);
    }

    public static NumericVar random(CobolNum seed) {
        return Functions.random(seed, false);
    }

    public static NumericVar random(CobolNum seed, boolean dpic) {
        Functions self = Functions.get();
        self.random = new Random(seed.longValue());
        return NumericVar.literal(self.random.nextDouble(), dpic);
    }

    public static NumericVar mod(CobolNum arg1, CobolNum arg2) {
        return Functions.mod(arg1, arg2, false);
    }

    public static NumericVar mod(CobolNum arg1, CobolNum arg2, boolean dpic) {
        return NumericVar.literal(arg1.subtract(arg2.multiply(arg1.divide(arg2).integerFunc())), dpic);
    }

    public static NumericVar testNumVal(CobolVar n) {
        int e = CobolNum.test(n.toString(), n.isDecimalPointComma(), 'N', '\u0000');
        return NumericVar.literal(Integer.toString(e), n.isDecimalPointComma());
    }

    public static NumericVar testNumValF(CobolVar n) {
        int e = CobolNum.test(n.toString(), n.isDecimalPointComma(), 'F', '\u0000');
        return NumericVar.literal(Integer.toString(e), n.isDecimalPointComma());
    }

    public static NumericVar testNumValC(CobolVar n) {
        int e = CobolNum.test(n.toString(), n.isDecimalPointComma(), 'C', '$');
        return NumericVar.literal(Integer.toString(e), n.isDecimalPointComma());
    }

    public static NumericVar testNumValC(CobolVar n, CobolVar cs) {
        char currChar = cs.toString().charAt(0);
        int e = CobolNum.test(n.toString(), n.isDecimalPointComma(), 'C', currChar);
        return NumericVar.literal(Integer.toString(e), n.isDecimalPointComma());
    }

    public static NumericVar numValF(CobolVar n) {
        return Functions.numVal(n);
    }

    public static NumericVar numVal(CobolVar n) {
        return Functions.numVal(n.toString(), n.isDecimalPointComma());
    }

    public static NumericVar numVal(String num, boolean decPointComma) {
        return NumericVar.literal(num, decPointComma);
    }

    public static NumericVar numValC(CobolVar n) {
        return Functions.numValC(n.toString(), n.isDecimalPointComma(), '\u0000');
    }

    public static NumericVar numValC(CobolVar n, CobolVar cs) {
        return Functions.numValC(n.toString(), n.isDecimalPointComma(), cs != null ? cs.toString().charAt(0) : (char)'\u0000');
    }

    public static NumericVar numValC(String num, boolean decPointComma, char currChar) {
        if (currChar > '\u0000') {
            num = num.replace(currChar, ' ');
        }
        return NumericVar.literal(num, decPointComma);
    }

    public static NumericVar handleType(CobolVar arg) {
        Object obj = UserHandles.getId(arg.toint());
        if (obj != null) {
            if (obj instanceof Handle) {
                return NumericVar.literal(((Handle)obj).type(), 9, 0, false);
            }
            return NumericVar.literal(9L, 9, 0, false);
        }
        return NumericVar.literal(0L, 9, 0, false);
    }

    public static PicX chr(CobolNum n) {
        return Functions.chr(n, false);
    }

    public static PicX chr(CobolNum n, boolean dpic) {
        return PicX.literal("" + (char)(n.intValue() - 1));
    }

    public static NumericVar ord(CobolVar cv) {
        String s = cv.toString();
        long n = -1L;
        if (s.length() > 0) {
            n = (long)s.charAt(0) + 1L;
        }
        return NumericVar.literal("" + n, false);
    }

    public static PicX dec2Hex(CobolNum n) {
        return Functions.dec2Hex(n, false);
    }

    public static PicX dec2Hex(CobolNum n, boolean dpic) {
        long l = n.longValue();
        if (l < 0L) {
            return PicX.literal("-" + Long.toHexString(-l));
        }
        return PicX.literal(Long.toHexString(l));
    }

    public static NumericVar hex2Dec(CobolVar n) {
        long Return2;
        try {
            Return2 = Long.parseLong(n.toString().trim(), 16);
        }
        catch (NumberFormatException _ex) {
            Return2 = 0L;
        }
        return NumericVar.literal(Return2, n.isDecimalPointComma());
    }

    public static PicX dec2Oct(CobolNum n) {
        return Functions.dec2Oct(n, false);
    }

    public static PicX dec2Oct(CobolNum n, boolean dpic) {
        long l = n.longValue();
        if (l < 0L) {
            return PicX.literal("-" + Long.toOctalString(-l));
        }
        return PicX.literal(Long.toOctalString(l));
    }

    public static NumericVar oct2Dec(CobolVar n) {
        long Return2;
        try {
            Return2 = Long.parseLong(n.toString().trim(), 8);
        }
        catch (NumberFormatException _ex) {
            Return2 = 0L;
        }
        return NumericVar.literal(Return2, n.isDecimalPointComma());
    }

    public static PicX dec2Bin(CobolNum n) {
        return Functions.dec2Bin(n, false);
    }

    public static PicX dec2Bin(CobolNum n, boolean dpic) {
        long l = n.longValue();
        if (l < 0L) {
            return PicX.literal("-" + Long.toBinaryString(-l));
        }
        return PicX.literal(Long.toBinaryString(l));
    }

    public static NumericVar bin2Dec(CobolVar n) {
        long Return2;
        try {
            Return2 = Long.parseLong(n.toString().trim(), 2);
        }
        catch (NumberFormatException _ex) {
            Return2 = 0L;
        }
        return NumericVar.literal(Return2, n.isDecimalPointComma());
    }

    public static NumericVar integer(CobolNum n) {
        return Functions.integer(n, false);
    }

    public static NumericVar integer(CobolNum n, boolean dpic) {
        return NumericVar.literal(n.integerFunc(), dpic);
    }

    public static NumericVar integerPart(CobolNum n) {
        return Functions.integerPart(n, false);
    }

    public static NumericVar integerPart(CobolNum n, boolean dpic) {
        return NumericVar.literal(n.integerPart(), dpic);
    }

    public static NumericVar rem(CobolNum n1, CobolNum n2) {
        return Functions.rem(n1, n2, false);
    }

    public static NumericVar rem(CobolNum n1, CobolNum n2, boolean dpic) {
        return NumericVar.literal(n1.remainder(n2, 0), dpic);
    }

    public static PicX vsCurrentDate() {
        int x2;
        int x1;
        GregorianCalendar now = CurrentDate.get();
        StringBuffer result = new StringBuffer(8);
        int yy = now.get(1) % 100;
        if (Config.getProperty(".current_date", false)) {
            x1 = now.get(5);
            x2 = now.get(2) + 1;
        } else {
            x1 = now.get(2) + 1;
            x2 = now.get(5);
        }
        if (x1 < 10) {
            result.append('0');
        }
        result.append(x1);
        result.append('/');
        if (x2 < 10) {
            result.append('0');
        }
        result.append(x2);
        result.append('/');
        if (yy < 10) {
            result.append('0');
        }
        result.append(yy);
        return PicX.literal(result.toString());
    }

    public static PicX vsTimeOfDay() {
        GregorianCalendar now = CurrentDate.get();
        StringBuffer result = new StringBuffer(6);
        int x = now.get(11);
        if (x < 10) {
            result.append('0');
        }
        result.append(x);
        x = now.get(12);
        if (x < 10) {
            result.append('0');
        }
        result.append(x);
        x = now.get(13);
        if (x < 10) {
            result.append('0');
        }
        result.append(x);
        return PicX.literal(result.toString());
    }

    public static PicX vsUseGiving(int code) {
        String rc;
        switch (code) {
            case 100: {
                rc = "00010000";
                break;
            }
            case 101: {
                rc = "10000000";
                break;
            }
            case 102: {
                rc = "01000000";
                break;
            }
            case 103: {
                rc = "10000000";
                break;
            }
            case 104: 
            case 105: {
                rc = "01000000";
                break;
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                rc = "10000000";
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                rc = "01000000";
                break;
            }
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: {
                rc = "10000000";
                break;
            }
            case 127: {
                rc = "00100000";
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: {
                rc = "10000000";
                break;
            }
            case 139: {
                rc = "00100000";
                break;
            }
            case 140: 
            case 141: 
            case 142: {
                rc = "10000000";
                break;
            }
            case 143: {
                rc = "01000000";
                break;
            }
            case 200: {
                rc = "00010000";
                break;
            }
            default: {
                rc = "10000000";
            }
        }
        return PicX.literal(rc);
    }

    public static NumericVar abs(CobolNum n, boolean dpic) {
        if (n.isNegative()) {
            return NumericVar.literal(n.negate(), dpic);
        }
        return NumericVar.literal(n, dpic);
    }

    public static NumericVar acos(CobolNum n, boolean dpic) {
        return NumericVar.literal(Math.acos(n.doubleValue()), dpic);
    }

    public static NumericVar asin(CobolNum n, boolean dpic) {
        return NumericVar.literal(Math.asin(n.doubleValue()), dpic);
    }

    public static NumericVar atan(CobolNum n, boolean dpic) {
        return NumericVar.literal(Math.atan(n.doubleValue()), dpic);
    }

    public static NumericVar cos(CobolNum n, boolean dpic) {
        return NumericVar.literal(Math.cos(n.doubleValue()), dpic);
    }

    public static NumericVar sin(CobolNum n, boolean dpic) {
        return NumericVar.literal(Math.sin(n.doubleValue()), dpic);
    }

    public static NumericVar tan(CobolNum n, boolean dpic) {
        return NumericVar.literal(Math.tan(n.doubleValue()), dpic);
    }

    public static NumericVar annuity(CobolNum n1, CobolNum n2, boolean dpic) {
        if (n1.compareTo(ZERO) == 0) {
            return NumericVar.literal(ONE.divide(n2), dpic);
        }
        return NumericVar.literal(n1.divide(ONE.subtract(ONE.add(n1).pow(n2.negate()))), dpic);
    }

    public static NumericVar factorial(CobolNum n, boolean dpic) {
        double fact = 1.0;
        for (long i = n.longValue(); i > 1L; --i) {
            fact *= (double)i;
        }
        return NumericVar.literal(fact, dpic);
    }

    public static NumericVar log(CobolNum n, boolean dpic) {
        return NumericVar.literal(Math.log(n.doubleValue()), dpic);
    }

    public static NumericVar log10(CobolNum n, boolean dpic) {
        return NumericVar.literal(Math.log(n.doubleValue()) / LOG10, dpic);
    }

    public static NumericVar sqrt(CobolNum n, boolean dpic) {
        return NumericVar.literal(Math.sqrt(n.doubleValue()), dpic);
    }

    public static NumericVar mean(CobolNum[] args, boolean dpic) {
        double sum = 0.0;
        for (int i = args.length - 1; i >= 0; --i) {
            sum += args[i].doubleValue();
        }
        return NumericVar.literal(sum / (double)args.length, dpic);
    }

    public static NumericVar median(CobolNum[] args, boolean dpic) {
        double[] vals = new double[args.length];
        for (int i = args.length - 1; i >= 0; --i) {
            vals[i] = args[i].doubleValue();
        }
        Arrays.sort(vals);
        int mid = vals.length / 2;
        if ((vals.length & 1) == 1) {
            return NumericVar.literal(vals[mid], dpic);
        }
        return NumericVar.literal((vals[mid] + vals[mid - 1]) / 2.0, dpic);
    }

    public static NumericVar midrange(CobolNum[] args, boolean dpic) {
        CobolNum max = args[0];
        CobolNum min = args[0];
        for (int i = 1; i < args.length; ++i) {
            if (max.compareTo(args[i]) < 0) {
                max = args[i];
                continue;
            }
            if (min.compareTo(args[i]) <= 0) continue;
            min = args[i];
        }
        return NumericVar.literal(max.add(min).divide(TWO), dpic);
    }

    public static NumericVar presentValue(CobolNum[] args, boolean dpic) {
        double Return2 = 0.0;
        double arg1 = args[0].doubleValue();
        for (int i = 1; i < args.length; ++i) {
            Return2 += args[i].doubleValue() / Math.pow(1.0 + arg1, i);
        }
        return NumericVar.literal(Return2, dpic);
    }

    public static NumericVar variance(CobolNum[] args, boolean dpic) {
        int i;
        double mean = 0.0;
        double Return2 = 0.0;
        double[] vals = new double[args.length];
        double n = args.length;
        for (i = args.length - 1; i >= 0; --i) {
            vals[i] = args[i].doubleValue();
            mean += vals[i];
        }
        mean /= n;
        for (i = args.length - 1; i >= 0; --i) {
            Return2 += Math.pow(vals[i] - mean, 2.0);
        }
        return NumericVar.literal(Return2 /= n, dpic);
    }

    public static NumericVar standardDeviation(CobolNum[] args, boolean dpic) {
        return NumericVar.literal(Math.sqrt(Functions.variance(args, dpic).num().doubleValue()), dpic);
    }

    public static NumericVar sum(CobolNum[] args, boolean dpic) {
        if (args.length > 0) {
            CobolNum sum = args[args.length - 1];
            for (int i = args.length - 2; i >= 0; --i) {
                sum = sum.add(args[i]);
            }
            return NumericVar.literal(sum, dpic);
        }
        return NumericVar.literal(0L, 1, 0, dpic);
    }

    public static NumericVar range(CobolNum[] args, boolean dpic) {
        CobolNum max = args[0];
        CobolNum min = args[0];
        for (int i = 1; i < args.length; ++i) {
            if (max.compareTo(args[i]) < 0) {
                max = args[i];
                continue;
            }
            if (min.compareTo(args[i]) <= 0) continue;
            min = args[i];
        }
        return NumericVar.literal(max.subtract(min), dpic);
    }

    public static NumericVar e(boolean dpic) {
        return NumericVar.literal(Math.E, dpic);
    }

    public static NumericVar exp(CobolNum n, boolean dpic) {
        return NumericVar.literal(Math.exp(n.doubleValue()), dpic);
    }

    public static NumericVar exp10(CobolNum n, boolean dpic) {
        return NumericVar.literal(Math.pow(10.0, n.doubleValue()), dpic);
    }

    public static NumericVar fractionPart(CobolNum n, boolean dpic) {
        return NumericVar.literal(n.subtract(n.integerPart()), dpic);
    }

    public static NumericVar pi(boolean dpic) {
        return NumericVar.literal(Math.PI, dpic);
    }

    public static NumericVar sign(CobolNum n, boolean dpic) {
        return NumericVar.literal(CobolNum.noo(n.signum(), 0), dpic);
    }

    public static PicX displayOf(PicN var) {
        return Functions.displayOf(var, (PicX)null);
    }

    public static PicX displayOf(PicN var, NumericVar codePage) {
        String csname;
        Charset cs = null;
        if (codePage != null && (csname = CCSIDs.get(codePage.toint())) != null) {
            try {
                cs = Charset.forName(csname);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cs != null) {
            try {
                CharsetEncoder enc = cs.newEncoder().onUnmappableCharacter(CodingErrorAction.REPLACE);
                enc.replaceWith("?".getBytes(cs));
                ByteBuffer bb = enc.encode(CharBuffer.wrap(var.toString()));
                byte[] bytes = new byte[bb.limit()];
                bb.get(bytes, bb.position(), bb.limit());
                return new PicX(bytes);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Functions.displayOf(var, (PicX)null);
    }

    public static PicX displayOf(PicN var, PicX replacement) {
        String str = var.toString();
        if (replacement != null) {
            try {
                CharsetEncoder enc = Charset.forName(CobolVar.encoding).newEncoder().onUnmappableCharacter(CodingErrorAction.REPLACE);
                enc.replaceWith(replacement.getBytes());
                ByteBuffer bb = enc.encode(CharBuffer.wrap(str));
                byte[] bytes = new byte[bb.limit()];
                bb.get(bytes, bb.position(), bb.limit());
                return new PicX(bytes);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new PicX(str);
    }

    public static PicN nationalOf(PicX var) {
        return Functions.nationalOf(var, (PicN)null);
    }

    public static PicN nationalOf(PicX var, NumericVar codePage) {
        String csname;
        Charset cs = null;
        if (codePage != null && (csname = CCSIDs.get(codePage.toint())) != null) {
            try {
                cs = Charset.forName(csname);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cs != null) {
            try {
                CharsetDecoder dec = cs.newDecoder().onUnmappableCharacter(CodingErrorAction.REPLACE);
                dec.replaceWith("?");
                CharBuffer cb = dec.decode(ByteBuffer.wrap(var.getBytes()));
                return new PicN(cb.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Functions.nationalOf(var, (PicN)null);
    }

    public static PicN nationalOf(PicX var, PicN replacement) {
        byte[] bytes = var.getBytes();
        if (replacement != null) {
            try {
                CharsetDecoder dec = Charset.forName(CobolVar.encoding).newDecoder().onUnmappableCharacter(CodingErrorAction.REPLACE);
                dec.replaceWith(replacement.toString());
                CharBuffer cb = dec.decode(ByteBuffer.wrap(bytes));
                return new PicN(cb.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new PicN(var.toString());
    }

    public static PicX compiledInfo(Class clazz) {
        String ret;
        try {
            ret = Factory.info(clazz);
        }
        catch (IllegalAccessException | InstantiationException e) {
            int idx = clazz.getName().lastIndexOf(46);
            String fileName = idx >= 0 ? clazz.getName().substring(idx + 1) + ".class" : clazz.getName() + ".class";
            ret = fileName + ": Unknown file type";
        }
        return PicX.literal(ret);
    }

    public static PicX compiledInfo(Object obj) {
        return PicX.literal(Factory.info(obj));
    }

    static {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        m.put(37, "IBM037");
        m.put(273, "IBM273");
        m.put(277, "IBM277");
        m.put(278, "IBM278");
        m.put(280, "IBM280");
        m.put(284, "IBM284");
        m.put(285, "IBM285");
        m.put(297, "IBM290");
        m.put(300, "x-IBM300");
        m.put(420, "IBM420");
        m.put(424, "IBM424");
        m.put(437, "IBM437");
        m.put(500, "IBM500");
        m.put(775, "IBM775");
        m.put(819, "ISO-8859-1");
        m.put(850, "IBM850");
        m.put(852, "IBM852");
        m.put(855, "IBM855");
        m.put(857, "IBM857");
        m.put(860, "IBM860");
        m.put(861, "IBM861");
        m.put(862, "IBM862");
        m.put(863, "IBM863");
        m.put(864, "IBM864");
        m.put(865, "IBM865");
        m.put(866, "IBM866");
        m.put(868, "IBM868");
        m.put(869, "IBM869");
        m.put(870, "IBM870");
        m.put(871, "IBM871");
        m.put(874, "x-IBM874");
        m.put(875, "x-IBM875");
        m.put(912, "ISO-8859-2");
        m.put(914, "ISO-8859-4");
        m.put(915, "ISO-8859-5");
        m.put(916, "ISO-8859-8");
        m.put(918, "IBM918");
        m.put(921, "x-IBM921");
        m.put(922, "x-IBM922");
        m.put(930, "x-IBM930");
        m.put(933, "x-IBM933");
        m.put(935, "x-IBM935");
        m.put(937, "x-IBM937");
        m.put(939, "x-IBM939");
        m.put(942, "x-IBM942");
        m.put(943, "x-IBM943");
        m.put(948, "x-IBM948");
        m.put(949, "x-IBM949");
        m.put(950, "x-IBM950");
        m.put(964, "x-IBM964");
        m.put(970, "x-IBM970");
        m.put(1025, "x-IBM1025");
        m.put(1046, "x-IBM1046");
        m.put(1097, "x-IBM1097");
        m.put(1098, "x-IBM1098");
        m.put(1112, "x-IBM1112");
        m.put(1122, "x-IBM1122");
        m.put(1123, "x-IBM1123");
        m.put(1124, "x-IBM1124");
        m.put(1166, "x-IBM1166");
        m.put(1364, "x-IBM1364");
        m.put(1381, "x-IBM1381");
        m.put(1383, "x-IBM1383");
        CCSIDs = Collections.unmodifiableMap(m);
        dayInMonth = new int[][]{{0, 0}, {31, 31}, {28, 29}, {31, 31}, {30, 30}, {31, 31}, {30, 30}, {31, 31}, {31, 31}, {30, 30}, {31, 31}, {30, 30}, {31, 31}};
        ZERO = CobolNum.noo(0L, 0);
        ONE = CobolNum.noo(1L, 0);
        TWO = CobolNum.noo(2L, 0);
        LOG10 = Math.log(10.0);
    }
}

