/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import java.util.ArrayList;

public class FuzzyRegexp {
    private static final char WC_INT_CHAR = '\u0000';
    private static final char WC_CHAR = '?';
    private static final char WC_STRING = '*';
    private static final char WC_ESC = '\\';
    private final String pattern;
    private final String shortestString;
    private final int shortestLen;
    private final boolean hasWCString;
    private final boolean caseInsensitive;
    private ArrayList expByLen = new ArrayList();

    public FuzzyRegexp(String pattern, boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        StringBuffer sb = new StringBuffer();
        boolean wcstr = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '*') {
                if (wcstr) continue;
                sb.append(c);
                wcstr = true;
                continue;
            }
            if (caseInsensitive) {
                sb.append(Character.toUpperCase(c));
            } else {
                sb.append(c);
            }
            wcstr = false;
        }
        this.pattern = sb.toString();
        this.shortestString = this.getShortestString();
        this.shortestLen = this.shortestString.length();
        this.hasWCString = this.shortestLen < pattern.length();
        ArrayList<WCString> shst = new ArrayList<WCString>();
        if (this.hasWCString) {
            shst.add(new WCString(this.shortestString));
            for (int i = 0; i <= this.shortestLen; ++i) {
                this.expByLen.add(shst);
            }
        } else {
            shst.add(new WCString(this.shortestString));
            this.expByLen.add(shst);
        }
    }

    private String getShortestString() {
        String Return2 = this.pattern;
        int len = Return2.length();
        block5: for (int i = 0; i < len; ++i) {
            char c = Return2.charAt(i);
            switch (c) {
                case '*': {
                    String prefix = Return2.substring(0, i);
                    String suffix = Return2.substring(i + 1);
                    Return2 = prefix + suffix;
                    --len;
                    --i;
                    continue block5;
                }
                case '?': {
                    Return2 = Return2.substring(0, i) + '\u0000' + Return2.substring(i + 1);
                    continue block5;
                }
                case '\\': {
                    Return2 = Return2.substring(0, i) + Return2.substring(i + 1);
                    ++i;
                    continue block5;
                }
            }
        }
        return Return2;
    }

    private void buildStrings(ArrayList result, String match, int offs, int len) {
        block5: for (int i = offs; i < match.length(); ++i) {
            char c = match.charAt(i);
            switch (c) {
                case '*': {
                    String prefix = match.substring(0, i);
                    String suffix = match.substring(i + 1);
                    for (int j = 0; j <= len - i; ++j) {
                        this.buildStrings(result, prefix + suffix, i, len);
                        prefix = prefix + '\u0000';
                    }
                    return;
                }
                case '?': {
                    match = match.substring(0, i) + '\u0000' + match.substring(i + 1);
                    continue block5;
                }
                case '\\': {
                    match = match.substring(0, i) + match.substring(i + 1);
                    ++i;
                    continue block5;
                }
            }
        }
        if (len == match.length()) {
            result.add(new WCString(match));
        }
    }

    public ArrayList getExpansion(int len) {
        ArrayList Return2;
        if (len <= this.shortestLen || !this.hasWCString) {
            Return2 = (ArrayList)this.expByLen.get(0);
        } else {
            for (int size = this.expByLen.size(); size <= len; ++size) {
                this.expByLen.add(null);
            }
            Return2 = (ArrayList)this.expByLen.get(len);
            if (Return2 == null) {
                Return2 = new ArrayList();
                this.expByLen.set(len, Return2);
                this.buildStrings(Return2, this.pattern, 0, len);
            }
        }
        return Return2;
    }

    private int distance(String p0, String s1, int s1Start, int s1Len, int maxDist) {
        int len0 = p0.length() + 1;
        int len1 = s1Len + 1;
        int[] cost = new int[len0];
        int[] newcost = new int[len0];
        for (int i = 0; i < len0; ++i) {
            cost[i] = i;
        }
        int end = s1Start + len1;
        for (int j = s1Start + 1; j < end; ++j) {
            newcost[0] = j;
            int minRowDist = maxDist;
            ++minRowDist;
            for (int i = 1; i < len0; ++i) {
                char c = p0.charAt(i - 1);
                int match = c == '\u0000' || c == s1.charAt(j - 1) ? 0 : 1;
                int cost_replace = cost[i - 1] + match;
                int cost_insert = cost[i] + 1;
                int cost_delete = newcost[i - 1] + 1;
                newcost[i] = Math.min(Math.min(cost_insert, cost_delete), cost_replace);
                if (newcost[i] >= minRowDist) continue;
                minRowDist = newcost[i];
            }
            if (minRowDist > maxDist) {
                return minRowDist;
            }
            int[] swap = cost;
            cost = newcost;
            newcost = swap;
        }
        return cost[len0 - 1];
    }

    public boolean isInDistance(int maxDist, String s) {
        if (this.caseInsensitive) {
            s = s.toUpperCase();
        }
        if (this.hasWCString) {
            ArrayList list = this.getExpansion(s.length());
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                WCString wcs = (WCString)list.get(i);
                int dist = wcs.subString != null ? this.distance(wcs.subString, s, wcs.subStart, wcs.subLen, maxDist) : this.distance(wcs.theString, s, 0, s.length(), maxDist);
                if (dist > maxDist) continue;
                return true;
            }
        } else {
            int dist = this.distance(this.shortestString, s, 0, s.length(), maxDist);
            if (dist <= maxDist) {
                return true;
            }
        }
        return false;
    }

    static class WCString {
        final String theString;
        final String subString;
        final int subStart;
        final int subLen;

        WCString(String s) {
            this.theString = s;
            if (this.theString.length() > 0) {
                int i;
                int len = this.theString.length();
                if (s.charAt(0) == '\u0000') {
                    for (i = 1; i < len && s.charAt(i) == '\u0000'; ++i) {
                    }
                    this.subStart = i;
                } else {
                    this.subStart = 0;
                }
                if (s.charAt(len - 1) == '\u0000') {
                    for (i = len - 2; i > this.subStart && s.charAt(i) == '\u0000'; --i) {
                    }
                    this.subLen = i - this.subStart + 1;
                } else {
                    this.subLen = len - this.subStart;
                }
                this.subString = this.subLen > 0 && this.subLen < len ? this.theString.substring(this.subStart, this.subStart + this.subLen) : null;
            } else {
                this.subString = null;
                this.subStart = 0;
                this.subLen = 0;
            }
        }
    }
}

