/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IPicNumEdit;
import com.iscobol.rts.IXMLAttributes;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.JSONException;
import com.iscobol.rts.SAJParser;
import com.iscobol.types.CobolNum;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JSONParseGenerate
extends DefaultHandler {
    private Stack<Node> varStack;
    private Node last;
    private IdentityHashMap<ICobolVar, String> names = new IdentityHashMap();
    private IdentityHashMap<ICobolVar, ICobolVar> suppressedVars = new IdentityHashMap();
    private int suppressed;
    private PrintWriter out;

    public JSONParseGenerate name(ICobolVar var, ICobolVar alias) {
        this.names.put(var, alias.toStringNoGui());
        return this;
    }

    public JSONParseGenerate suppress(ICobolVar var) {
        this.suppressedVars.put(var, var);
        return this;
    }

    public void generate(ICobolVar output, ICobolVar input) throws JSONException {
        this.generate(output, input, null);
    }

    public void generate(ICobolVar output, ICobolVar input, ICobolVar count) throws JSONException {
        try {
            this._generate(output, input, count);
        }
        catch (Exception ex) {
            throw new JSONException(ex);
        }
    }

    private void _generate(ICobolVar output, ICobolVar input, ICobolVar count) {
        StringWriter sw = new StringWriter();
        this.out = new PrintWriter(sw);
        this.out.print('{');
        this.writeObject(input, null);
        this.out.print('}');
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        String str = sw.toString();
        output.set(str);
        if (count != null) {
            count.set(str.length());
        }
    }

    private void writeObject(ICobolVar var, int[] dim) {
        if (this.suppressedVars.containsKey(var)) {
            return;
        }
        String id = this.getAlias(var);
        this.out.print('\"');
        this.out.print(id);
        this.out.print('\"');
        this.out.print(':');
        this.possibleArray(var, dim);
    }

    private void possibleArray(ICobolVar var, int[] dim) {
        int[] myDim = var.getDimensions();
        if (dim == null) {
            if (myDim == null) {
                if (JSONParseGenerate.hasChildren(var)) {
                    this.out.print('{');
                    this.writeChildren(var, dim);
                    this.out.print('}');
                } else {
                    this.writeValue(var);
                }
            } else {
                dim = new int[1];
                this.writeArray(var, 0, myDim[0], dim);
            }
        } else if (dim.length == myDim.length) {
            if (JSONParseGenerate.hasChildren(var)) {
                this.out.print('{');
                this.writeChildren(var, dim);
                this.out.print('}');
            } else {
                this.writeValue(this.getVar(var, dim));
            }
        } else {
            int[] newDim = new int[myDim.length];
            for (int i = 0; i < dim.length; ++i) {
                newDim[i] = dim[i];
            }
            dim = newDim;
            int n = myDim[myDim.length - 1];
            this.writeArray(var, myDim.length - 1, n, dim);
        }
    }

    private ICobolVar getNextElement(Enumeration e, int[] dim) {
        while (e.hasMoreElements()) {
            ICobolVar cv = (ICobolVar)e.nextElement();
            if (this.suppressedVars.containsKey(cv)) continue;
            return cv;
        }
        return null;
    }

    private void writeArray(ICobolVar var, int dimIdx, int n, int[] dim) {
        this.out.print('[');
        if (n > 0) {
            boolean hasChildren = JSONParseGenerate.hasChildren(var);
            boolean writeComma = false;
            int i = 1;
            while (true) {
                dim[dimIdx] = ++i;
                if (hasChildren) {
                    if (writeComma) {
                        this.out.print(',');
                    } else {
                        writeComma = true;
                    }
                    this.out.print('{');
                    this.writeChildren(var, dim);
                    this.out.print('}');
                } else {
                    if (writeComma) {
                        this.out.print(',');
                    } else {
                        writeComma = true;
                    }
                    this.writeValue(this.getVar(var, dim));
                }
                if (i == n) break;
            }
            dim[dimIdx] = i;
        }
        this.out.print(']');
    }

    private void writeChildren(ICobolVar var, int[] dim) {
        ICobolVar child;
        Enumeration chldrn = var.getChildren();
        if (chldrn != null && (child = this.getNextElement(chldrn, dim)) != null) {
            while (true) {
                this.writeIdentified(child, dim);
                child = this.getNextElement(chldrn, dim);
                if (child == null) break;
                this.out.print(',');
            }
        }
    }

    private void writeValue(ICobolVar var) {
        String s = var.toStringNoGui();
        if (var instanceof INumericVar) {
            this.out.print(s);
        } else {
            s = Factory.rightTrim(s);
            s = JSONParseGenerate.JSEscape(s);
            this.out.print("\"" + s + "\"");
        }
    }

    private static String JSEscape(String s) {
        StringBuffer Return2 = new StringBuffer();
        int len = s.length();
        block10: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\u0000': {
                    Return2.append("\\O");
                    continue block10;
                }
                case '\b': {
                    Return2.append("\\b");
                    continue block10;
                }
                case '\f': {
                    Return2.append("\\f");
                    continue block10;
                }
                case '\n': {
                    Return2.append("\\n");
                    continue block10;
                }
                case '\r': {
                    Return2.append("\\r");
                    continue block10;
                }
                case '\t': {
                    Return2.append("\\t");
                    continue block10;
                }
                case '\"': {
                    Return2.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    Return2.append("\\\\");
                    continue block10;
                }
                default: {
                    Return2.append(c);
                }
            }
        }
        return Return2.toString();
    }

    private void writeIdentified(ICobolVar var, int[] dim) {
        if (JSONParseGenerate.hasChildren(var)) {
            this.writeObject(var, dim);
        } else {
            if (this.suppressedVars.containsKey(var)) {
                return;
            }
            String id = this.getAlias(var);
            this.out.print('\"');
            this.out.print(id);
            this.out.print('\"');
            this.out.print(':');
            this.possibleArray(var, dim);
        }
    }

    private static boolean hasChildren(ICobolVar var) {
        Enumeration chldrn = var.getChildren();
        return chldrn.hasMoreElements();
    }

    public void parse(ICobolVar input, ICobolVar output) throws JSONException {
        try {
            this._parse(input, output);
        }
        catch (Exception ex) {
            throw new JSONException(ex);
        }
    }

    private void _parse(ICobolVar input, ICobolVar output) {
        this.varStack = new Stack();
        this.pushNode(output, null);
        try {
            SAJParser sajParser = new SAJParser(false);
            sajParser.parse(new StringReader(input.toStringNoGui()), this, null);
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
        catch (SAXException _ex) {
            if (_ex.getException() != null) {
                throw new IscobolRuntimeException(_ex.getException());
            }
            throw new IscobolRuntimeException(_ex);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        block7: {
            Node n;
            block6: {
                if (this.suppressed > 0) {
                    ++this.suppressed;
                    return;
                }
                if (this.varStack.isEmpty()) {
                    throw new SAXException("Empty stack on start element " + qName);
                }
                n = this.varStack.peek();
                if (this.suppressedVars.containsKey(n.var)) {
                    ++this.suppressed;
                    return;
                }
                if (this.last == null || !this.tagcmp(localName, this.last)) break block6;
                this.varStack.push(this.last);
                ICobolVar lvp = this.last.var.getIParent();
                if (lvp == null || this.last.var.getDimensions() == lvp.getDimensions()) break block7;
                this.last.clearData();
                int n2 = this.last.dim.length - 1;
                this.last.dim[n2] = this.last.dim[n2] + 1;
                this.last.sted = false;
                this.last = null;
                this.startElement(uri, localName, qName, attributes);
                break block7;
            }
            if (!n.sted && this.tagcmp(localName, n)) {
                n.sted = true;
            } else {
                for (int i = n.next.size() - 1; i >= 0; --i) {
                    ICobolVar child = n.next.elementAt(i);
                    if (!this.tagcmp(localName, child)) continue;
                    this.pushChildNode(localName, n, child);
                    break;
                }
            }
        }
        this.last = null;
    }

    protected void pushNode(ICobolVar var, int[] dim) {
        Enumeration chldrn = var.getChildren();
        int[] nDim = var.getDimensions();
        if (nDim != null) {
            if (dim == null) {
                dim = new int[]{1};
            } else if (dim.length != nDim.length) {
                for (int i = 0; i < dim.length; ++i) {
                    nDim[i] = dim[i];
                }
                nDim[dim.length] = 1;
                dim = nDim;
            }
        }
        Node n = new Node(var, dim);
        if (chldrn.hasMoreElements()) {
            chldrn = var.getChildren();
            while (chldrn.hasMoreElements()) {
                ICobolVar child = (ICobolVar)chldrn.nextElement();
                n.next.addElement(child);
            }
        } else if (n.data == null) {
            n.data = var;
        }
        this.varStack.push(n);
    }

    private void pushChildNode(String localName, Node n, ICobolVar child) throws SAXException {
        this.pushNode(child, n.dim);
        this.startElement(null, localName, localName, null);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.suppressed > 0) {
            return;
        }
        if (this.varStack.isEmpty()) {
            throw new SAXException("Empty stack on characters, last=" + this.last);
        }
        Node n = this.varStack.peek();
        n.cdata.append(ch, start, length);
    }

    private boolean isOccurs(ICobolVar var) {
        int[] dim = var.getDimensions();
        if (dim != null) {
            ICobolVar par = var.getIParent();
            int[] pdim = par != null ? par.getDimensions() : null;
            if (pdim != null) {
                return pdim.length < dim.length;
            }
            return true;
        }
        return false;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.suppressed > 0) {
            --this.suppressed;
            return;
        }
        if (this.varStack.isEmpty()) {
            throw new SAXException("Empty stack on end element " + qName);
        }
        Node n = this.varStack.pop();
        if (this.isOccurs(n.var)) {
            this.last = n;
        }
        if (n.data != null) {
            this.set(n.data, n.dim, n.cdata.toString());
        }
    }

    private boolean tagcmp(String localName, Node n) {
        return this.tagcmp(localName, n.var);
    }

    private boolean tagcmp(String localName, ICobolVar n) {
        return localName.equalsIgnoreCase(this.getAlias(n));
    }

    private String getAlias(ICobolVar n) {
        String n1 = this.names.get(n);
        if (n1 != null) {
            return n1;
        }
        IXMLAttributes attr = n.getIXMLAttributes();
        if (attr != null && attr.getIdentifier() != null) {
            return attr.getIdentifier();
        }
        return n.getName();
    }

    private void set(ICobolVar var, int[] dim, String val) {
        ICobolVar cv = this.getVar(var, dim);
        if (cv == null) {
            return;
        }
        if (cv instanceof IPicNumEdit) {
            boolean[] e = new boolean[1];
            cv.set(CobolNum.valueOf(val, cv.isDecimalPointComma(), e));
            if (e[0]) {
                cv.set(val);
            }
        } else {
            cv.set(val);
        }
    }

    private ICobolVar getVar(ICobolVar var, int[] dim) {
        ICobolVar cv;
        block4: {
            cv = null;
            if (dim == null) {
                cv = var;
            } else {
                try {
                    cv = var.intIAt(dim);
                }
                catch (IscobolRuntimeException _ex) {
                    if (_ex.getErrNum() == 1) break block4;
                    throw _ex;
                }
            }
        }
        return cv;
    }

    private static class Node {
        StringBuffer cdata = new StringBuffer();
        final ICobolVar var;
        final int[] dim;
        final Vector<ICobolVar> next = new Vector();
        ICobolVar data;
        boolean sted;

        Node(ICobolVar var, int[] dim) {
            this.var = var;
            this.dim = dim;
        }

        void clearData() {
            this.cdata = new StringBuffer();
        }
    }
}

