/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class RuntimeProperties {
    private static final ResourceBundle rb = ResourceBundle.getBundle("com.iscobol.rts.runtime");

    public static String getProductCopyright() {
        String ret = rb.getString("product.copyright");
        return ret;
    }

    public static String getProductDisplayName() {
        String ret = rb.getString("product.displayname");
        return ret;
    }

    public static String getProductFolderName() {
        String ret = rb.getString("product.foldername");
        return ret;
    }

    public static int getVersionNumber() {
        String s = rb.getString("runtime.version.number");
        int ret = Integer.parseInt(s);
        return ret;
    }

    public static int getReleaseNumber() {
        String s = rb.getString("runtime.release.number");
        int ret = Integer.parseInt(s);
        return ret;
    }

    public static int getMaintenanceNumber() {
        int ret;
        String s = rb.getString("runtime.maintenance.number");
        try {
            ret = Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            ret = 999999;
        }
        return ret;
    }

    public static String getBuildNumber() {
        String ret = rb.getString("runtime.build.number");
        return ret;
    }

    public static String getShortBuildNumber() {
        String ret = rb.getString("runtime.build.number");
        int idx = ret.indexOf(45);
        return idx >= 0 ? ret.substring(0, idx) : "0";
    }

    public static int getBuildMainNumber() {
        String s = rb.getString("runtime.build.number");
        if (s.equals("@BUILD_NUMBER")) {
            return 1000000297;
        }
        int i = 0;
        i = s.indexOf(46);
        if (i <= 0 && (i = s.indexOf(45)) <= 0 && (i = s.indexOf(43)) <= 0) {
            return 1000000297;
        }
        return Integer.parseInt(s.substring(0, i));
    }

    public static int getSpNumber() {
        String s = rb.getString("runtime.sp.number");
        int ret = Integer.parseInt(s);
        return ret;
    }

    public static String getFullVersionNumber() {
        if (RuntimeProperties.getBuildNumber().equals("@BUILD_NUMBER@")) {
            return " build#internal";
        }
        return RuntimeProperties.getProductDisplayName() + " release " + RuntimeProperties.getVersionNumber() + " R" + RuntimeProperties.getReleaseNumber() + (RuntimeProperties.getSpNumber() == 0 ? "" : " U" + RuntimeProperties.getSpNumber()) + " build#" + RuntimeProperties.getBuildNumber();
    }

    public static String getFullVersionNumberForFile() {
        return RuntimeProperties.getProductDisplayName().replace('-', '_').replace('.', '_') + "_" + RuntimeProperties.getVersionNumber() + "_R" + RuntimeProperties.getReleaseNumber() + (RuntimeProperties.getSpNumber() == 0 ? "" : "_U" + RuntimeProperties.getSpNumber()) + "_" + RuntimeProperties.getBuildNumber().replace('-', '_').replace('.', '_');
    }

    public static void main(String[] args) {
        String ret;
        if (args.length == 1) {
            ret = args[0].equals("-v") ? RuntimeProperties.getFullVersionNumber() : (args[0].equals("-n") ? RuntimeProperties.getProductDisplayName() : (args[0].equals("-f") ? RuntimeProperties.getProductFolderName() : (args[0].equals("-vf") ? RuntimeProperties.getFullVersionNumberForFile() : (args[0].equals("-c") ? RuntimeProperties.getProductCopyright() : (args[0].equals("-major-version") ? Integer.toString(RuntimeProperties.getVersionNumber()) : (args[0].equals("-minor-version") ? Integer.toString(RuntimeProperties.getReleaseNumber()) : RuntimeProperties.getFullVersionNumber()))))));
        } else {
            String[] version = new String[]{RuntimeProperties.getFullVersionNumber(), RuntimeProperties.getProductCopyright()};
            JOptionPane.showMessageDialog(null, version, "isCOBOL Version", 1);
            System.exit(0);
            ret = "";
        }
        System.out.println(ret);
    }
}

