/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.text.DateFormat;
import java.util.Date;

public class AutoHeaderFooter {
    private Font font = new Font("default", 0, 12);
    private Color color = Color.black;
    private final String[] header;
    private final String[] footer;
    private final int totPages;
    private final String reportName;
    Rectangle2D imgArea;
    private String timestamp;

    public AutoHeaderFooter(String[] head, String[] foot, int totPag, String u, Font f) {
        this.header = head;
        this.footer = foot;
        this.totPages = totPag;
        this.reportName = u;
        this.font = f != null ? f : new Font("default", 0, 12);
    }

    public void print(Graphics2D g2d, PageFormat pf, int pageNumber) {
        g2d.setFont(this.font);
        g2d.setColor(this.color);
        FontMetrics fm = g2d.getFontMetrics();
        if (this.imgArea == null) {
            this.imgArea = new Rectangle2D.Double(0.0, 0.0, pf.getImageableWidth(), pf.getImageableHeight());
        }
        double x = 1.0;
        double y = fm.getAscent();
        double h = this.imgArea.getHeight();
        if (this.header != null) {
            this.print(g2d, this.header, x, y, pageNumber);
        }
        y = h - (double)fm.getDescent();
        if (this.footer != null) {
            this.print(g2d, this.footer, x, y, pageNumber);
        }
    }

    private void print(Graphics2D g2d, String[] line, double x, double y, int pageNumber) {
        StringBuffer text = new StringBuffer();
        boolean alignRight = false;
        float imgX = (float)this.imgArea.getX();
        float imgY = (float)this.imgArea.getY();
        float w = (float)this.imgArea.getWidth();
        block11: for (int i = 0; i < line.length; ++i) {
            if (line[i].length() == 2) {
                if (line[i].charAt(0) == '&') {
                    switch (line[i].charAt(1)) {
                        case 'P': {
                            text.append(this.totPages);
                            break;
                        }
                        case 'p': {
                            text.append(pageNumber);
                            break;
                        }
                        case 'd': {
                            DateFormat df = DateFormat.getDateInstance(3);
                            text.append(df.format(new Date()));
                            break;
                        }
                        case 'D': {
                            DateFormat df = DateFormat.getDateInstance(1);
                            text.append(df.format(new Date()));
                            break;
                        }
                        case 'T': {
                            DateFormat df;
                            if (this.timestamp == null) {
                                df = DateFormat.getTimeInstance(2);
                                this.timestamp = df.format(new Date());
                            }
                            text.append(this.timestamp);
                            break;
                        }
                        case 'b': {
                            if (alignRight) continue block11;
                            if (text.length() > 0) {
                                g2d.drawString(text.toString(), (int)(x - (double)imgX), (int)(y - (double)imgY));
                            }
                            alignRight = true;
                            text.delete(0, text.length());
                            break;
                        }
                        case 'w': {
                            break;
                        }
                        case 'u': {
                            if (this.reportName == null) continue block11;
                            text.append(this.reportName);
                            break;
                        }
                        case '&': {
                            text.append('&');
                            break;
                        }
                        default: {
                            text.append('?');
                            break;
                        }
                    }
                    continue;
                }
                text.append(line[i]);
                continue;
            }
            text.append(line[i]);
        }
        if (text.length() > 0 && alignRight) {
            FontMetrics fm = g2d.getFontMetrics();
            x = w - (float)fm.stringWidth(text.toString()) - 1.0f;
        }
        g2d.drawString(text.toString(), (int)(x - (double)imgX), (int)(y - (double)imgY));
    }
}

