/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.rts.print.AutoHeaderFooter;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintCommandList;
import com.iscobol.rts.print.PrintContext;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.io.Serializable;

public class Page
implements Serializable {
    private PrintContext pc;
    private PrintCommandList cmdList;
    long firstElement = -1L;
    long lastElement = -1L;
    int numElem = 0;

    Page(PrintContext p, PrintCommandList l) {
        this.pc = new PrintContext(p);
        this.cmdList = l;
    }

    void addItem(long le) {
        this.lastElement = le;
        if (this.firstElement < 0L) {
            this.firstElement = le;
        }
        ++this.numElem;
    }

    int getItemNum() {
        return this.numElem;
    }

    PrintCommand getFirstItem() {
        if (this.cmdList != null) {
            return this.cmdList.getAt(this.firstElement);
        }
        return null;
    }

    void print(Graphics2D g2d, PageFormat pf, AutoHeaderFooter ahf, int page) {
        PrintContext ctx = new PrintContext(this.pc);
        g2d.setFont(ctx.font);
        g2d.setColor(ctx.color);
        ctx.frc = g2d.getFontRenderContext();
        if (this.firstElement < 0L) {
            return;
        }
        long cur = this.firstElement;
        PrintCommand cmd = this.cmdList.getAt(this.firstElement);
        while (cur <= this.lastElement && cmd != null) {
            cmd.print(ctx, g2d, pf);
            cur = this.cmdList.getNextIdx();
            cmd = this.cmdList.getNext();
        }
        if (ahf != null) {
            ahf.print(g2d, pf, page);
        }
    }

    public void finalize() {
    }
}

