/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.math.BigCobolDec;
import com.iscobol.math.BigCobolInt;
import com.iscobol.rts.Config;
import com.iscobol.rts.DivideByZeroException;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.Memory;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.types.CobolDouble;
import com.iscobol.types.CobolFloat;
import com.iscobol.types.CobolInt;
import com.iscobol.types.CobolVP18;
import com.iscobol.types.CobolVP31;
import com.iscobol.types.CobolVar;
import com.iscobol.types.EncBytes;
import com.iscobol.types.NumericVar;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class CobolNum
implements Cloneable,
Serializable,
EncBytes,
RuntimeErrorsNumbers {
    public static final byte UNDEFINED_TYPE = -1;
    public static final byte LONG_TYPE = 0;
    public static final byte BIGDECIMAL_TYPE = 1;
    public static final byte DOUBLE_TYPE = 2;
    public static final byte FLOAT_TYPE = 3;
    public static final int MAX_LN_DIGITS = 18;
    public static final int MAX_BD_DIGITS = 31;
    private static final long serialVersionUID = 123L;
    protected static final long OVERFLOW_LN = Long.MAX_VALUE;
    protected static final int CHECKDIV_PROPERTY = Config.getProperty("iscobol.checkdiv", 0);
    protected static final BigCobolDec OVERFLOW_BD = new BigCobolDec("10000000000000000000000000000000");
    public static final CobolNum INFINITY = new CobolDouble(Double.POSITIVE_INFINITY);
    static final boolean fpp36 = Config.getProperty(".math.fpp36", false);
    protected final byte type;
    public long lnUnscValue;
    public static final long[][] factBytes = new long[][]{{0L, 0L, -1L, 0L}, {255L, 127L, -128L, 128L}, {65535L, 32767L, -32768L, 32768L}, {0xFFFFFFL, 0x7FFFFFL, -8388608L, 0x800000L}, {0xFFFFFFFFL, Integer.MAX_VALUE, Integer.MIN_VALUE, 0x80000000L}, {0xFFFFFFFFFFL, 0x7FFFFFFFFFL, -549755813888L, 0x8000000000L}, {0xFFFFFFFFFFFFL, 0x7FFFFFFFFFFFL, -140737488355328L, 0x800000000000L}, {0xFFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, -36028797018963968L, 0x80000000000000L}, {-1L, Long.MAX_VALUE, Long.MIN_VALUE, Long.MIN_VALUE}};
    public static final BigCobolInt[][] factBytesBigInt = new BigCobolInt[][]{{new BigCobolInt("0"), new BigCobolInt("0")}, {new BigCobolInt("255"), new BigCobolInt("127")}, {new BigCobolInt("65535"), new BigCobolInt("32767")}, {new BigCobolInt("16777215"), new BigCobolInt("8388607")}, {new BigCobolInt("4294967295"), new BigCobolInt("2147483647")}, {new BigCobolInt("1099511627775"), new BigCobolInt("549755813887")}, {new BigCobolInt("281474976710655"), new BigCobolInt("140737488355327")}, {new BigCobolInt("4503599627370495"), new BigCobolInt("36028797018963967")}, {new BigCobolInt("18446744073709551615"), new BigCobolInt("9223372036854775807")}, {new BigCobolInt("4722366482869645213695"), new BigCobolInt("2361183241434822606847")}, {new BigCobolInt("1208925819614629174706175"), new BigCobolInt("604462909807314587353087")}, {new BigCobolInt("309485009821345068724781055"), new BigCobolInt("154742504910672534362390527")}, {new BigCobolInt("79228162514264337593543950335"), new BigCobolInt("39614081257132168796771975167")}, {new BigCobolInt("20282409603651670423947251286015"), new BigCobolInt("10141204801825835211973625643007")}, {new BigCobolInt("5192296858534827628530496329220095"), new BigCobolInt("2596148429267413814265248164610047")}, {new BigCobolInt("664613997892457936451903530140172287"), new BigCobolInt("664613997892457936451903530140172287")}, {new BigCobolInt("664613997892457936451903530140172287"), new BigCobolInt("664613997892457936451903530140172287")}};
    public static final long[] fact = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    public static final long[] factMax = new long[]{0L, 9L, 99L, 999L, 9999L, 99999L, 999999L, 9999999L, 99999999L, 999999999L, 9999999999L, 99999999999L, 999999999999L, 9999999999999L, 99999999999999L, 999999999999999L, 9999999999999999L, 99999999999999999L, 999999999999999999L};
    public static final long[] factMin = new long[]{0L, -9L, -99L, -999L, -9999L, -99999L, -999999L, -9999999L, -99999999L, -999999999L, -9999999999L, -99999999999L, -999999999999L, -9999999999999L, -99999999999999L, -999999999999999L, -9999999999999999L, -99999999999999999L, -999999999999999999L};
    public static final double[] factDouble = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22, 1.0E23, 1.0E24, 1.0E25, 1.0E26, 1.0E27, 1.0E28, 1.0E29, 1.0E30, 1.0E31, 1.0E32};
    public static final int[][] maxDigits = new int[][]{{0, 0}, {3, 3}, {5, 5}, {7, 8}, {10, 10}, {12, 13}, {15, 15}, {17, 17}, {18, 18}, {22, 22}, {24, 25}, {27, 27}, {29, 29}, {31, 31}};
    private static final long max = 0xCCCCCCCCCCCCCCCL;
    private static final long min = -922337203685477580L;
    private static final long max18 = factMax[18];
    private static final long min18 = factMin[18];
    private static boolean[] dummyErr = new boolean[]{false};

    public static CobolNum get(int precision, int scale) {
        if (precision < 0) {
            if (scale == -3) {
                return new CobolFloat(0.0f);
            }
            return new CobolDouble(0.0);
        }
        if (precision > 18) {
            return new CobolVP31(new BigCobolDec(0L, scale));
        }
        if (scale == 0) {
            return new CobolInt(0L);
        }
        if (fpp36) {
            return new CobolVP31(new BigCobolDec(0L, scale));
        }
        return new CobolVP18(0L, scale);
    }

    public static CobolNum noo(long val, int scale) {
        return new CobolVP18(val, scale);
    }

    public static CobolNum noo(BigCobolDec val) {
        return new CobolVP31(val);
    }

    public static CobolNum noo(BigDecimal val) {
        return new CobolVP31(val);
    }

    public static CobolNum noo(BigInteger val) {
        return new CobolVP31(val);
    }

    public static CobolNum noo(double val) {
        return new CobolDouble(val);
    }

    public static CobolNum noo(float val) {
        return new CobolFloat(val);
    }

    public static CobolNum noo(String intVal) {
        CobolNum Return2;
        int len = intVal.length();
        if (len > 18) {
            BigCobolDec num = new BigCobolDec();
            try {
                BigCobolDec.parseInt(num, intVal);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Return2 = CobolNum.noo(num);
        } else {
            long num = 0L;
            try {
                num = Long.parseLong(intVal.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Return2 = CobolNum.noo(num, 0);
        }
        return Return2;
    }

    public static CobolNum noo(CobolNum val) {
        switch (val.type) {
            case 0: {
                return CobolNum.noo(val.lnUnscValue, val.scale());
            }
            case 1: {
                return CobolNum.noo(val.bigCobDecValue());
            }
            case 2: {
                return CobolNum.noo(val.doubleValue());
            }
            case 3: {
                return CobolNum.noo(val.floatValue());
            }
        }
        throw new IscobolRuntimeException(3, "Unhandled type: " + val.type);
    }

    protected CobolNum(byte t) {
        this.type = t;
    }

    public static CobolNum get(String s, boolean decPointIsComma) {
        return CobolNum.get(s, decPointIsComma, dummyErr);
    }

    public static CobolNum valueOf(String s, boolean decPointIsComma, boolean[] error) {
        CobolNum Return2 = CobolNum.get(s, decPointIsComma, error);
        return Return2;
    }

    public static CobolNum get(String s, boolean decPointIsComma, boolean[] err) {
        CobolNum Return2;
        boolean minus = false;
        boolean foundDecPoint = false;
        boolean foundDigit = false;
        boolean foundSign = false;
        boolean end = false;
        long num = 0L;
        int nDec = 0;
        char[] src = s.trim().toCharArray();
        int nDigits = 0;
        char[] cNum = new char[src.length + 1];
        int cnIdx = 1;
        int tmpType = -1;
        double expDouble = 0.0;
        cNum[0] = 45;
        block14: for (int idx = 0; idx < src.length; ++idx) {
            switch (src[idx]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (end) {
                        err[0] = true;
                    }
                    num = num * 10L + (long)(src[idx] - 48);
                    cNum[cnIdx++] = src[idx];
                    ++nDigits;
                    foundDigit = true;
                    if (!foundDecPoint) continue block14;
                    ++nDec;
                    continue block14;
                }
                case '+': {
                    if (foundSign || end) {
                        err[0] = true;
                        continue block14;
                    }
                    foundSign = true;
                    if (!foundDigit) continue block14;
                    end = true;
                    continue block14;
                }
                case '-': {
                    if (foundSign || end) {
                        err[0] = true;
                        continue block14;
                    }
                    minus = true;
                    foundSign = true;
                    if (!foundDigit) continue block14;
                    end = true;
                    continue block14;
                }
                case '.': {
                    if (!decPointIsComma) {
                        if (foundDecPoint) {
                            err[0] = true;
                            continue block14;
                        }
                        foundDecPoint = true;
                        cNum[cnIdx++] = 46;
                        continue block14;
                    }
                    if (!end) continue block14;
                    err[0] = true;
                    continue block14;
                }
                case ',': {
                    if (decPointIsComma) {
                        if (foundDecPoint) {
                            err[0] = true;
                            continue block14;
                        }
                        foundDecPoint = true;
                        cNum[cnIdx++] = 46;
                        continue block14;
                    }
                    if (!end) continue block14;
                    err[0] = true;
                    continue block14;
                }
                case ' ': {
                    continue block14;
                }
                case '$': 
                case '*': 
                case '/': {
                    if (!end) continue block14;
                    err[0] = true;
                    continue block14;
                }
                case 'C': 
                case 'c': {
                    if (idx + 1 < src.length && (src[idx + 1] == 'R' || src[idx + 1] == 'r')) {
                        if (foundSign) {
                            err[0] = true;
                        } else {
                            minus = true;
                            foundSign = true;
                        }
                        ++idx;
                        end = true;
                        continue block14;
                    }
                    err[0] = true;
                    continue block14;
                }
                case 'D': 
                case 'd': {
                    if (idx + 1 < src.length && (src[idx + 1] == 'B' || src[idx + 1] == 'b')) {
                        if (foundSign) {
                            err[0] = true;
                        } else {
                            minus = true;
                            foundSign = true;
                        }
                        ++idx;
                        end = true;
                        continue block14;
                    }
                    err[0] = true;
                    continue block14;
                }
                case 'E': 
                case 'e': {
                    if (decPointIsComma) {
                        s = s.replace(',', '.');
                    }
                    try {
                        expDouble = Double.parseDouble(s);
                        tmpType = 2;
                        err[0] = false;
                        continue block14;
                    }
                    catch (NumberFormatException _ex) {
                        expDouble = 0.0;
                        err[0] = true;
                    }
                }
                default: {
                    err[0] = true;
                }
            }
        }
        if (tmpType == 2) {
            Return2 = new CobolDouble(expDouble);
        } else if (nDigits > 31) {
            Return2 = minus ? new CobolDouble(Double.parseDouble(new String(cNum, 0, cnIdx))) : new CobolDouble(Double.parseDouble(new String(cNum, 1, --cnIdx)));
        } else if (nDigits > 18) {
            Return2 = minus ? new CobolVP31(new BigCobolDec(new String(cNum, 0, cnIdx))) : new CobolVP31(new BigCobolDec(new String(cNum, 1, --cnIdx)));
        } else {
            if (minus) {
                num = -num;
            }
            Return2 = new CobolVP18(num, nDec);
        }
        return Return2;
    }

    public static int test(String s, boolean decPointIsComma, char type, char cc) {
        int startIdx;
        int Return2 = 0;
        boolean foundDecPoint = false;
        boolean foundDigit = false;
        boolean foundSign = false;
        boolean end = false;
        int expIdx = -1;
        int expDigits = 0;
        boolean foundExpSign = false;
        char[] src = s.toCharArray();
        int endIdx = src.length - 1;
        for (startIdx = 0; startIdx < src.length && src[startIdx] == ' '; ++startIdx) {
        }
        while (endIdx > startIdx && src[endIdx] == ' ') {
            --endIdx;
        }
        if (startIdx > endIdx) {
            return src.length;
        }
        block17: for (int idx = startIdx; idx <= endIdx; ++idx) {
            switch (src[idx]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (end || expDigits >= 4 || expIdx >= 0 && !foundExpSign) {
                        return idx + 1;
                    }
                    int spaces = 0;
                    block18: for (int idx0 = idx - 1; idx0 >= startIdx; --idx0) {
                        switch (src[idx0]) {
                            case ' ': {
                                ++spaces;
                                continue block18;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                if (spaces <= 0) continue block18;
                                return idx + 1;
                            }
                        }
                    }
                    foundDigit = true;
                    if (expIdx < 0) continue block17;
                    ++expDigits;
                    continue block17;
                }
                case '+': {
                    if (expIdx >= 0) {
                        if (foundExpSign || expDigits > 0) {
                            return idx + 1;
                        }
                        foundExpSign = true;
                        continue block17;
                    }
                    if (foundSign || end) {
                        return idx + 1;
                    }
                    foundSign = true;
                    if (!foundDigit) continue block17;
                    end = true;
                    if (type != 'F') continue block17;
                    return idx + 1;
                }
                case '-': {
                    if (expIdx >= 0) {
                        if (foundExpSign || expDigits > 0) {
                            return idx + 1;
                        }
                        foundExpSign = true;
                        continue block17;
                    }
                    if (foundSign || end) {
                        return idx + 1;
                    }
                    foundSign = true;
                    if (!foundDigit) continue block17;
                    end = true;
                    if (type != 'F') continue block17;
                    return idx + 1;
                }
                case '.': {
                    if (expIdx >= 0) {
                        return idx + 1;
                    }
                    if (!decPointIsComma) {
                        if (foundDecPoint) {
                            return idx + 1;
                        }
                        foundDecPoint = true;
                        continue block17;
                    }
                    if (!end && type == 'C') continue block17;
                    return idx + 1;
                }
                case ',': {
                    if (expIdx >= 0) {
                        return idx + 1;
                    }
                    if (decPointIsComma) {
                        if (foundDecPoint) {
                            return idx + 1;
                        }
                        foundDecPoint = true;
                        continue block17;
                    }
                    if (!end && type == 'C') continue block17;
                    return idx + 1;
                }
                case ' ': {
                    continue block17;
                }
                case 'C': 
                case 'c': {
                    if (type == 'C' && idx < endIdx && (src[idx + 1] == 'R' || src[idx + 1] == 'r')) {
                        if (foundSign) {
                            return idx + 1;
                        }
                        foundSign = true;
                        ++idx;
                        end = true;
                        continue block17;
                    }
                    return idx + 1;
                }
                case 'D': 
                case 'd': {
                    if (type == 'C' && idx < endIdx && (src[idx + 1] == 'B' || src[idx + 1] == 'b')) {
                        if (foundSign) {
                            return idx + 1;
                        }
                        foundSign = true;
                        ++idx;
                        end = true;
                        continue block17;
                    }
                    return idx + 1;
                }
                case 'E': 
                case 'e': {
                    if (type != 'F' || expIdx >= 0) {
                        return idx + 1;
                    }
                    expIdx = idx;
                    continue block17;
                }
                default: {
                    if (!end && type == 'C' && src[idx] == cc) continue block17;
                    return idx + 1;
                }
            }
        }
        if (expIdx >= 0 && expDigits == 0) {
            return expIdx + 1;
        }
        return Return2;
    }

    public static CobolNum get(String s, int scale) {
        CobolNum Return2;
        boolean minus = false;
        boolean foundDigit = false;
        boolean foundSign = false;
        boolean end = false;
        long num = 0L;
        char[] src = s.trim().toCharArray();
        int nDigits = 0;
        char[] cNum = new char[src.length + 1];
        int cnIdx = 1;
        cNum[0] = 45;
        block7: for (int idx = 0; idx < src.length; ++idx) {
            switch (src[idx]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    num = num * 10L + (long)(src[idx] - 48);
                    cNum[cnIdx++] = src[idx];
                    ++nDigits;
                    foundDigit = true;
                    continue block7;
                }
                case '+': {
                    if (foundSign || end) continue block7;
                    foundSign = true;
                    if (!foundDigit) continue block7;
                    end = true;
                    continue block7;
                }
                case '-': {
                    if (foundSign || end) continue block7;
                    minus = true;
                    foundSign = true;
                    if (!foundDigit) continue block7;
                    end = true;
                    continue block7;
                }
                case 'C': 
                case 'c': {
                    if (idx + 1 >= src.length || src[idx + 1] != 'R' && src[idx + 1] != 'r') continue block7;
                    if (!foundSign) {
                        minus = true;
                        foundSign = true;
                    }
                    ++idx;
                    end = true;
                    continue block7;
                }
                case 'D': 
                case 'd': {
                    if (idx + 1 >= src.length || src[idx + 1] != 'B' && src[idx + 1] != 'b') continue block7;
                    if (!foundSign) {
                        minus = true;
                        foundSign = true;
                    }
                    ++idx;
                    end = true;
                }
            }
        }
        if (nDigits > 18) {
            Return2 = minus ? new CobolVP31(new BigCobolDec(new BigCobolInt(new String(cNum, 0, cnIdx)), scale)) : new CobolVP31(new BigCobolDec(new BigCobolInt(new String(cNum, 1, --cnIdx)), scale));
        } else {
            if (minus) {
                num = -num;
            }
            Return2 = new CobolVP18(num, scale);
        }
        return Return2;
    }

    public static final float floatValue(long val, int scale) {
        if (scale > 0) {
            return (float)((double)val / factDouble[scale]);
        }
        return val;
    }

    public static final double doubleValue(long val, int scale) {
        if (scale > 0) {
            return (double)val / factDouble[scale];
        }
        return val;
    }

    public static final int evalCompare(float diff) {
        return diff > 0.0f ? 1 : (diff == 0.0f ? 0 : -1);
    }

    public static final int evalCompare(double diff) {
        return diff > 0.0 ? 1 : (diff == 0.0 ? 0 : -1);
    }

    public CobolNum set(long nLong, int nScale) {
        return this.set(nLong, nScale, false);
    }

    public abstract CobolNum set(long var1, int var3, boolean var4);

    public abstract CobolNum set(BigCobolDec var1);

    public abstract CobolNum set(float var1);

    public abstract CobolNum set(double var1);

    public abstract CobolNum set(CobolNum var1, boolean var2, boolean var3);

    public int getType() {
        return this.type;
    }

    public abstract CobolNum add(CobolNum var1);

    public abstract void addToMe(short var1);

    public abstract void subFromMe(short var1);

    public abstract void multiplyByMe(short var1);

    public abstract void divideIntoMe(boolean var1, short var2);

    public void divideIntoMe(short i) {
        this.divideIntoMe(false, i);
    }

    public abstract void addToMe(int var1);

    public abstract void subFromMe(int var1);

    public abstract void multiplyByMe(int var1);

    public abstract void divideIntoMe(boolean var1, int var2);

    public void divideIntoMe(int i) {
        this.divideIntoMe(false, i);
    }

    public abstract void addToMe(long var1);

    public abstract void subFromMe(long var1);

    public abstract void multiplyByMe(long var1);

    public abstract void divideIntoMe(boolean var1, long var2);

    public void divideIntoMe(long i) {
        this.divideIntoMe(false, i);
    }

    public abstract CobolNum add1();

    public abstract CobolNum subtract(CobolNum var1);

    public abstract CobolNum subtract1();

    public CobolNum pow(CobolNum val) {
        boolean inv = false;
        if (val.scale() != 0) {
            return new CobolDouble(Math.pow(this.doubleValue(), val.doubleValue()));
        }
        int exp = val.intValue();
        if (exp == 0) {
            return new CobolVP18(1L, 0);
        }
        if (exp < 0) {
            inv = true;
            exp = -exp;
        }
        CobolNum Return2 = this;
        for (int i = 1; i < exp; ++i) {
            Return2 = Return2.multiply(this);
        }
        if (inv) {
            Return2 = new CobolVP18(1L, 0).divide(Return2);
        }
        return Return2;
    }

    public abstract CobolNum multiply(CobolNum var1);

    public abstract CobolNum multiply36(CobolNum var1);

    public CobolNum divide(CobolNum val) {
        return this.divide(false, val, -1, false);
    }

    public CobolNum divide(CobolNum val, int scale) {
        return this.divide(false, val, scale, false);
    }

    public CobolNum divide(CobolNum val, int scale, boolean rounding) {
        return this.divide(false, val, scale, rounding);
    }

    public CobolNum divide(boolean checkdivbyzero, CobolNum val) {
        return this.divide(checkdivbyzero, val, -1, false);
    }

    public CobolNum divide(boolean checkdivbyzero, CobolNum val, int scale) {
        return this.divide(checkdivbyzero, val, scale, false);
    }

    public abstract CobolNum divide(boolean var1, CobolNum var2, int var3, boolean var4);

    public CobolNum divide36(boolean checkdivbyzero, CobolNum val) {
        return this.divide36(checkdivbyzero, val, -1, false);
    }

    public final CobolNum divide36(boolean checkdivbyzero, CobolNum val, int scale, boolean rounding) {
        if (this.type == 2 || val.type == 2 || this.type == 3 || val.type == 3) {
            return this.divide(checkdivbyzero, val, scale, rounding);
        }
        return CobolNum.divideBd(checkdivbyzero, this.bigCobDecValue(), val.bigCobDecValue(), scale, rounding);
    }

    public CobolNum divide36(boolean checkdivbyzero, CobolNum val, int scale) {
        return this.divide36(checkdivbyzero, val, scale, false);
    }

    protected static CobolNum divideLn(boolean checkdivbyzero, long n1, int s1, long n2, int s2, int scale, boolean rounding) {
        long tmpRes;
        int i;
        int diff = s1 - s2;
        if (n2 == 0L) {
            CobolNum cn = CobolNum.divideByZeroLn(checkdivbyzero);
            if (cn == null) {
                cn = new CobolVP18(n1, s1);
            }
            return cn;
        }
        long result = n1 / n2;
        if ((n1 %= n2) > 0xCCCCCCCCCCCCCCCL || n1 < -922337203685477580L) {
            n2 /= 10L;
        } else {
            n1 *= 10L;
        }
        if (scale == -1) {
            scale = Integer.MAX_VALUE;
            i = 0;
            if (result < max18 && result > min18) {
                while (n1 != 0L && (tmpRes = result * 10L + n1 / n2) < max18 && tmpRes > min18) {
                    result = tmpRes;
                    if ((n1 %= n2) > 0xCCCCCCCCCCCCCCCL || n1 < -922337203685477580L) {
                        n2 /= 10L;
                    } else {
                        n1 *= 10L;
                    }
                    ++i;
                }
            }
        } else {
            int sc = scale - diff;
            if (result < max18 && result > min18) {
                for (i = 0; i < sc && (tmpRes = result * 10L + n1 / n2) < max18 && tmpRes > min18; ++i) {
                    result = tmpRes;
                    if ((n1 %= n2) > 0xCCCCCCCCCCCCCCCL || n1 < -922337203685477580L) {
                        n2 /= 10L;
                        continue;
                    }
                    n1 *= 10L;
                }
            }
        }
        if (diff != 0) {
            if (diff < 0) {
                for (int j = -diff; j > 0; --j) {
                    if (i > scale || result > 0xCCCCCCCCCCCCCCCL || result < -922337203685477580L) {
                        --i;
                        continue;
                    }
                    result *= 10L;
                }
            } else {
                i += diff;
            }
        }
        if (rounding && n1 / n2 >= 5L) {
            ++result;
        }
        CobolVP18 Return2 = new CobolVP18(result, i);
        if (scale < i) {
            Return2.setScale(scale);
        }
        return Return2;
    }

    private static CobolNum divideByZeroBd(boolean checkdivbyzero) throws DivideByZeroException {
        int v = checkdivbyzero ? CHECKDIV_PROPERTY : 0;
        switch (v) {
            default: {
                return INFINITY;
            }
            case 1: {
                throw new DivideByZeroException();
            }
            case 2: {
                return new CobolVP31(new BigCobolDec());
            }
            case 3: {
                return null;
            }
            case -1: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumend undefined result");
                return INFINITY;
            }
            case -2: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed result is 0");
                return new CobolVP31(new BigCobolDec());
            }
            case -3: 
        }
        Factory.log("CHECK DIVIDE: detected divide by 0 assumed divide by 1");
        return null;
    }

    private static CobolNum divideByZeroLn(boolean checkdivbyzero) throws DivideByZeroException {
        int v = checkdivbyzero ? CHECKDIV_PROPERTY : 0;
        switch (v) {
            default: {
                return INFINITY;
            }
            case 1: {
                throw new DivideByZeroException();
            }
            case 2: {
                return new CobolVP18(0L, 0);
            }
            case 3: {
                return null;
            }
            case -1: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumend undefined result");
                return INFINITY;
            }
            case -2: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed result is 0");
                return new CobolVP18(0L, 0);
            }
            case -3: 
        }
        Factory.log("CHECK DIVIDE: detected divide by 0 assumed divide by 1");
        return null;
    }

    public abstract void divideIntoMeByZero(boolean var1) throws DivideByZeroException;

    protected static CobolNum divideBd(boolean checkdivbyzero, BigCobolDec n1, BigCobolDec n2, int scale, boolean rounding) {
        if (n2.isZero()) {
            CobolNum cn = CobolNum.divideByZeroBd(checkdivbyzero);
            if (cn == null) {
                cn = new CobolVP31(n1);
            }
            return cn;
        }
        if (scale == -1) {
            return new CobolVP31(n1.divide(n2, 31, rounding ? 1 : 0));
        }
        return new CobolVP31(n1.divide(n2, scale, rounding ? 1 : 0));
    }

    static CobolNum divideFloat(boolean checkdivbyzero, float n1, float n2, int scale, boolean rounding) {
        if (n2 == 0.0f) {
            int v = checkdivbyzero ? CHECKDIV_PROPERTY : 0;
            switch (v) {
                default: {
                    return INFINITY;
                }
                case 1: {
                    throw new DivideByZeroException();
                }
                case 2: {
                    return new CobolFloat(0.0f);
                }
                case 3: {
                    return new CobolFloat(n1);
                }
                case -1: {
                    Factory.log("CHECK DIVIDE: detected divide by 0 assumend undefined result");
                    return INFINITY;
                }
                case -2: {
                    Factory.log("CHECK DIVIDE: detected divide by 0 assumed result is 0");
                    return new CobolFloat(0.0f);
                }
                case -3: 
            }
            Factory.log("CHECK DIVIDE: detected divide by 0 assumed divide by 1");
            return new CobolFloat(n1);
        }
        return new CobolFloat(n1 / n2);
    }

    static CobolNum divideDouble(boolean checkdivbyzero, double n1, double n2, int scale, boolean rounding) {
        if (n2 == 0.0) {
            int v = checkdivbyzero ? CHECKDIV_PROPERTY : 0;
            switch (v) {
                default: {
                    return INFINITY;
                }
                case 1: {
                    throw new DivideByZeroException();
                }
                case 2: {
                    return new CobolDouble(0.0);
                }
                case 3: {
                    return new CobolDouble(n1);
                }
                case -1: {
                    Factory.log("CHECK DIVIDE: detected divide by 0 assumend undefined result");
                    return INFINITY;
                }
                case -2: {
                    Factory.log("CHECK DIVIDE: detected divide by 0 assumed result is 0");
                    return new CobolDouble(0.0);
                }
                case -3: 
            }
            Factory.log("CHECK DIVIDE: detected divide by 0 assumed divide by 1");
            return new CobolDouble(n1);
        }
        return new CobolDouble(n1 / n2);
    }

    public static int getNumIntDigits(double n1) {
        if (n1 < 0.0) {
            n1 = -n1;
        }
        if (n1 < factDouble[16]) {
            if (n1 < factDouble[8]) {
                if (n1 < factDouble[4]) {
                    if (n1 < factDouble[2]) {
                        if (n1 < factDouble[1]) {
                            return 1;
                        }
                        return 2;
                    }
                    if (n1 < factDouble[3]) {
                        return 3;
                    }
                    return 4;
                }
                if (n1 < factDouble[6]) {
                    if (n1 < factDouble[5]) {
                        return 5;
                    }
                    return 6;
                }
                if (n1 < factDouble[7]) {
                    return 7;
                }
                return 8;
            }
            if (n1 < factDouble[12]) {
                if (n1 < factDouble[10]) {
                    if (n1 < factDouble[9]) {
                        return 9;
                    }
                    return 10;
                }
                if (n1 < factDouble[11]) {
                    return 11;
                }
                return 12;
            }
            if (n1 < factDouble[14]) {
                if (n1 < factDouble[13]) {
                    return 13;
                }
                return 14;
            }
            if (n1 < factDouble[15]) {
                return 15;
            }
            return 16;
        }
        if (n1 < factDouble[24]) {
            if (n1 < factDouble[20]) {
                if (n1 < factDouble[18]) {
                    if (n1 < factDouble[17]) {
                        return 17;
                    }
                    return 18;
                }
                if (n1 < factDouble[19]) {
                    return 19;
                }
                return 20;
            }
            if (n1 < factDouble[22]) {
                if (n1 < factDouble[21]) {
                    return 21;
                }
                return 22;
            }
            if (n1 < factDouble[23]) {
                return 23;
            }
            return 24;
        }
        if (n1 < factDouble[28]) {
            if (n1 < factDouble[26]) {
                if (n1 < factDouble[25]) {
                    return 25;
                }
                return 26;
            }
            if (n1 < factDouble[27]) {
                return 27;
            }
            return 28;
        }
        if (n1 < factDouble[30]) {
            if (n1 < factDouble[29]) {
                return 29;
            }
            return 30;
        }
        if (n1 < factDouble[31]) {
            return 31;
        }
        return 32;
    }

    public static int getNumIntDigits(BigCobolDec n1) {
        return n1.precision();
    }

    public static int getNumDigits(long n1) {
        if (n1 < 0L) {
            n1 = -n1;
        }
        if (n1 < fact[16]) {
            if (n1 < fact[8]) {
                if (n1 < fact[4]) {
                    if (n1 < fact[2]) {
                        if (n1 < fact[1]) {
                            return 1;
                        }
                        return 2;
                    }
                    if (n1 < fact[3]) {
                        return 3;
                    }
                    return 4;
                }
                if (n1 < fact[6]) {
                    if (n1 < fact[5]) {
                        return 5;
                    }
                    return 6;
                }
                if (n1 < fact[7]) {
                    return 7;
                }
                return 8;
            }
            if (n1 < fact[12]) {
                if (n1 < fact[10]) {
                    if (n1 < fact[9]) {
                        return 9;
                    }
                    return 10;
                }
                if (n1 < fact[11]) {
                    return 11;
                }
                return 12;
            }
            if (n1 < fact[14]) {
                if (n1 < fact[13]) {
                    return 13;
                }
                return 14;
            }
            if (n1 < fact[15]) {
                return 15;
            }
            return 16;
        }
        if (n1 < fact[17]) {
            return 17;
        }
        if (n1 < fact[18]) {
            return 18;
        }
        return 19;
    }

    protected static CobolNum multiplyLn(long n1, int s1, long n2, int s2) {
        BigCobolInt r;
        int excDigits = CobolNum.getNumDigits(n2) + CobolNum.getNumDigits(n1) - 18;
        CobolNum Return2 = excDigits <= 0 ? new CobolVP18(n1 * n2, s1 + s2) : ((r = new BigCobolInt(n1).multiplyInt(new BigCobolInt(n2))).precision() > 18 ? new CobolVP31(new BigCobolDec(r, s1 + s2)) : new CobolVP18(r.longValue(), s1 + s2));
        return Return2;
    }

    protected CobolNum multiplyBd(BigCobolDec n1, BigCobolDec n2) {
        return new CobolVP31(n1.multiply(n2));
    }

    public CobolNum remainder(CobolNum val) {
        return this.remainder(false, val, -1);
    }

    public CobolNum remainder(boolean checkdivbyzero, CobolNum val) {
        return this.remainder(checkdivbyzero, val, -1);
    }

    public CobolNum remainder(CobolNum val, int scale) {
        return this.remainder(false, val, scale);
    }

    public CobolNum remainder(boolean checkdivbyzero, CobolNum val, int scale) {
        return this.subtract(this.divide(checkdivbyzero, val, scale, false).multiply(val));
    }

    public int compareTo(ICobolVar val) {
        return -val.compareTo(this);
    }

    public int compareTo(CobolVar val) {
        return -val.compareTo(this);
    }

    public int compareTo(NumericVar val) {
        return -val.compareTo(this);
    }

    public abstract int compareTo(CobolNum var1);

    public abstract int compareTo(long var1, int var3);

    public CobolNum max(CobolNum val) {
        return this.compareTo(val) < 0 ? val : this;
    }

    public CobolNum min(CobolNum val) {
        return this.compareTo(val) > 0 ? val : this;
    }

    public abstract long getUnscaledLong(boolean[] var1);

    public abstract void toBinaryByteArray(Memory var1, int var2, int var3);

    public abstract void toBinaryByteArray(byte[] var1, int var2, int var3);

    public abstract long getUnscaledLong();

    public abstract void setSizeDigit(int var1, int var2);

    public abstract void setSizeByteUnsigned(int var1);

    public abstract void setSizeByteSigned(int var1);

    public abstract void setScale(int var1, boolean var2, boolean var3);

    public void setScale(int scale) {
        this.setScale(scale, false, false);
    }

    public abstract void roundUpIfNeeded(int var1);

    public static final long roundUpIfNeeded(long unscaled, int scaleDiff) {
        if (unscaled < 0L) {
            long remainder = -unscaled % fact[scaleDiff];
            if (remainder >= fact[scaleDiff] >> 1) {
                unscaled += remainder;
                unscaled -= fact[scaleDiff];
            }
        } else {
            long remainder = unscaled % fact[scaleDiff];
            if (remainder >= fact[scaleDiff] >> 1) {
                unscaled -= remainder;
                unscaled += fact[scaleDiff];
            }
        }
        return unscaled;
    }

    static long computeUnscValue(long unscaled, int oldScale, int newScale, boolean rounding, boolean lenInBytes) {
        if (unscaled == 0L) {
            return 0L;
        }
        if (newScale != oldScale) {
            if (newScale > oldScale) {
                if (!lenInBytes) {
                    unscaled %= fact[18 - newScale + oldScale];
                }
                unscaled *= fact[newScale - oldScale];
            } else {
                int diff = oldScale - newScale;
                if (diff >= fact.length) {
                    unscaled = 0L;
                } else if (rounding) {
                    int inc = 0;
                    if (unscaled < 0L) {
                        if (-unscaled % fact[diff] >= fact[diff] >> 1) {
                            inc = -1;
                        }
                    } else if (unscaled % fact[diff] >= fact[diff] >> 1) {
                        inc = 1;
                    }
                    unscaled /= fact[diff];
                    unscaled += (long)inc;
                } else {
                    unscaled /= fact[oldScale - newScale];
                }
            }
        }
        return unscaled;
    }

    public abstract int scale();

    public abstract int precision();

    public CobolNum abs() {
        return this.signum() >= 0 ? this : this.negate();
    }

    public abstract int signum();

    public abstract void negateMe();

    public abstract CobolNum negate();

    protected static int compareLn(long n1, int s1, long n2, int s2) {
        long c = 0L;
        int diff = s1 - s2;
        if (diff == 0) {
            c = n1 - n2;
        } else if (diff > 0) {
            if (diff + CobolNum.getNumDigits(n2) - 18 > 0) {
                return BigCobolDec.valueOf(n1, s1).compareTo(BigCobolDec.valueOf(n2, s2));
            }
            c = n1 - fact[diff] * n2;
        } else {
            if ((diff = -diff) + CobolNum.getNumDigits(n1) - 18 > 0) {
                return BigCobolDec.valueOf(n1, s1).compareTo(BigCobolDec.valueOf(n2, s2));
            }
            c = n1 * fact[diff] - n2;
        }
        if (c > 0L) {
            return 1;
        }
        if (c < 0L) {
            return -1;
        }
        return 0;
    }

    protected int compareBd(BigCobolDec n1, BigCobolDec n2) {
        return n1.compareTo(n2);
    }

    protected static CobolNum addLn(long n1, int s1, long n2, int s2) {
        int nScale;
        int diff = s1 - s2;
        if (diff > 0) {
            int excDigits = diff + CobolNum.getNumDigits(n2) - 18;
            if (excDigits > 0) {
                if (diff < excDigits) {
                    n1 /= fact[diff];
                    nScale = s1 - diff;
                } else {
                    n1 /= fact[excDigits];
                    n2 *= fact[diff - excDigits];
                    nScale = s1 - excDigits;
                }
            } else {
                nScale = s1;
                n2 *= fact[diff];
            }
        } else if (diff < 0) {
            int excDigits = (diff = -diff) + CobolNum.getNumDigits(n1) - 18;
            if (excDigits > 0) {
                if (diff < excDigits) {
                    n2 /= fact[diff];
                    nScale = s2 - diff;
                } else {
                    n2 /= fact[excDigits];
                    n1 *= fact[diff - excDigits];
                    nScale = s2 - excDigits;
                }
            } else {
                nScale = s2;
                n1 *= fact[diff];
            }
        } else {
            nScale = s1;
        }
        return new CobolVP18(n1 + n2, nScale);
    }

    protected CobolNum addBd(BigCobolDec n1, BigCobolDec n2) {
        return new CobolVP31(n1.add(n2));
    }

    public abstract void shift(int var1);

    public abstract String toString();

    public abstract float floatValue();

    public abstract double doubleValue();

    public abstract int shortValue();

    public abstract int intValue();

    public abstract long longValue();

    public abstract int shortValue(boolean var1);

    public abstract int intValue(boolean var1);

    public abstract long longValue(boolean var1);

    public abstract CobolNum integerFunc();

    public abstract CobolNum integerPart();

    public abstract BigDecimal bigDecimalValue();

    public abstract BigCobolDec bigCobDecValue();

    public boolean isPositive() {
        return this.signum() == 1;
    }

    public boolean isNegative() {
        return this.signum() == -1;
    }

    public final void toCobolByteArray(byte[] Return2, int len) {
        this.toCobolByteArray(Return2, len, NumericVar.encoded_digits);
    }

    public abstract void toCobolByteArray(byte[] var1, int var2, byte[] var3);

    public abstract int toByteArray(byte[] var1);

    public static int toByteArray(long unscaled, int scale, byte[] Return2) {
        int i;
        int idx = 0;
        int len = 0;
        if (unscaled < 0L) {
            ++len;
            unscaled = -unscaled;
            Return2[idx++] = C_MINUS;
        }
        if (scale > 0) {
            ++len;
        }
        int digits = CobolNum.getNumDigits(unscaled);
        len += digits;
        int intLen = digits - scale;
        if (intLen <= 0) {
            len += -intLen;
        }
        if (intLen <= 0) {
            Return2[idx++] = C_POINT;
            for (i = -intLen - 1; i >= 0; --i) {
                Return2[idx++] = C_0;
            }
        }
        i = digits;
        int j = 1;
        while (i > 0) {
            Return2[idx++] = NumericVar.encoded_digits[(int)(unscaled / fact[i - 1])];
            unscaled %= fact[i - 1];
            if (j == intLen && scale > 0) {
                Return2[idx++] = C_POINT;
            }
            --i;
            ++j;
        }
        return len;
    }

    public static boolean isLongOverflowByte(long unscaled, int nBytes, boolean signed, int scaleDiff) {
        long myFact;
        if (nBytes == 8) {
            myFact = factBytes[nBytes][1];
        } else if (nBytes < factBytes.length) {
            myFact = factBytes[nBytes][signed ? 1 : 0];
        } else {
            return false;
        }
        if (unscaled < 0L) {
            ++myFact;
        }
        if (scaleDiff > 0) {
            unscaled /= fact[scaleDiff];
        } else if (scaleDiff < 0) {
            myFact /= fact[-scaleDiff];
        }
        if (unscaled < 0L) {
            return unscaled < -myFact;
        }
        return unscaled > myFact;
    }

    public static boolean isLongOverflow(long unscaled, int scale, int destIntPart) {
        int tot = destIntPart + scale;
        if (tot > 18) {
            return false;
        }
        if (unscaled < 0L) {
            return unscaled < factMin[tot];
        }
        return unscaled > factMax[tot];
    }

    public abstract boolean isOverflow(CobolNum var1, int var2);

    public abstract boolean isOverflowByte(CobolNum var1, int var2, boolean var3);

    public static void main(String[] args) {
        for (int i = 0; i < factBytesBigInt.length; ++i) {
            System.out.println(new BigInteger(factBytesBigInt[i][0].toString()).toString(16));
            System.out.println(new BigInteger(factBytesBigInt[i][1].toString()).toString(16));
        }
    }
}

