/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.rts.IPicAlphaEdit;
import com.iscobol.types.CobolVar;
import com.iscobol.types.EncBytes;
import com.iscobol.types.PicX;
import com.iscobol.types.PictureAnalyzer;

public final class PicAlphaEdit
extends PicX
implements EncBytes,
IPicAlphaEdit {
    private static final long serialVersionUID = 123L;
    private static final byte[] zeros = new byte[]{C_0};
    private char[] picture;
    protected int len;
    protected int end;
    private boolean editEnabled = true;

    public PicAlphaEdit(byte[] m, int offs, int phisicLen, int[] dimSize, int[] dim, String name, String pic, boolean pComma) {
        super(m, offs, phisicLen, dimSize, dim, name, pComma, false);
        this.picture = PictureAnalyzer.expandParenthesis(pic).toCharArray();
        this.len = this.getLen();
        this.end = this.getEnd();
    }

    public PicAlphaEdit(CobolVar parent, int offs, int phisicLen, int[] dimSize, int[] dim, String name, String pic, boolean pComma) {
        super(parent, offs, phisicLen, dimSize, dim, name, pComma, false);
        this.picture = PictureAnalyzer.expandParenthesis(pic).toCharArray();
        this.len = this.getLen();
        this.end = this.getEnd();
    }

    @Override
    public boolean set(String value) {
        return this.set(value.getBytes());
    }

    @Override
    public boolean set(byte[] src) {
        return this.set(src, 0, src.length, true);
    }

    @Override
    public void setAllZero() {
        this.setAll(C_0);
    }

    @Override
    public void setLowValues() {
        this.setAll((byte)0);
    }

    @Override
    public void setHighValues() {
        this.setAll((byte)-1);
    }

    private void setAll(byte b) {
        byte[] mem = this.getMemory();
        int j = this.curOffset;
        int pIdx = 0;
        while (j < this.end) {
            int c = this.editEnabled ? this.picture[pIdx] : 65;
            switch (c) {
                case 47: {
                    mem[j] = C_SLASH;
                    break;
                }
                case 48: {
                    mem[j] = C_0;
                    break;
                }
                case 66: {
                    mem[j] = C_SPACE;
                    break;
                }
                default: {
                    mem[j] = b;
                }
            }
            ++j;
            ++pIdx;
        }
    }

    @Override
    public void setZero() {
        this.set(zeros, 0, 1, true);
    }

    @Override
    public void setSpace() {
        this.setAll(C_SPACE);
    }

    @Override
    void internalSet(CobolVar cv) {
        if (PictureAnalyzer.storeValueWithoutEdit) {
            this.editEnabled = false;
            cv.moveTo(this);
            this.editEnabled = true;
        } else {
            cv.moveTo(this);
        }
    }

    @Override
    public boolean set(byte[] src, int offs, int len, boolean filling) {
        byte[] mem = this.getMemory();
        boolean error = false;
        for (int k = this.curOffset; k < this.end; ++k) {
            mem[k] = C_SPACE;
        }
        int vIdx = 0;
        int j = this.curOffset;
        int pIdx = 0;
        while (j < this.end) {
            int c = this.editEnabled ? this.picture[pIdx] : 65;
            switch (c) {
                case 57: {
                    if (vIdx < len) {
                        mem[j] = src[offs + vIdx++];
                        break;
                    }
                    mem[j] = C_0;
                    break;
                }
                case 65: 
                case 88: {
                    if (vIdx >= len) break;
                    mem[j] = src[offs + vIdx++];
                    break;
                }
                case 47: {
                    mem[j] = C_SLASH;
                    break;
                }
                case 48: {
                    mem[j] = C_0;
                    break;
                }
                case 66: {
                    mem[j] = C_SPACE;
                }
            }
            ++j;
            ++pIdx;
        }
        return error && vIdx < len;
    }

    @Override
    public void defaultInitialize() {
        this.setSpace();
    }

    @Override
    protected int getCategory() {
        return 3;
    }

    @Override
    protected void updateEnd() {
        this.end = this.getEnd();
    }

    @Override
    public String getPicture() {
        return new String(this.picture);
    }

    @Override
    public void enableEdit() {
        this.editEnabled = true;
    }

    @Override
    public void disableEdit() {
        this.editEnabled = false;
    }
}

