/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.Memory;
import com.iscobol.types.CobolNum;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.NumericVar;

public final class Pic9Comp_6
extends NumericVar {
    private static final long serialVersionUID = 123L;

    public Pic9Comp_6(Memory m, int i, int il, int dl, int[] dimSize, int[] dim, String name, boolean pComma) {
        super(m, i, il, dl, false, (il + dl + 1) / 2, dimSize, dim, name, pComma);
        if (m != null) {
            this.updateCache(m, this.theValue);
        }
    }

    public Pic9Comp_6(CobolVar par, int i, int il, int dl, int[] dimSize, int[] dim, String name, boolean pComma) {
        super(par, i, il, dl, false, (il + dl + 1) / 2, dimSize, dim, name, pComma);
    }

    @Override
    int getAlphaBuffSize() {
        return super.getAlphaBuffSize() + 1;
    }

    private void putBDToMem(Memory mem, BigCobolDec _bcd) {
        int i = this.end - 1;
        BigCobolDec val = new BigCobolDec(_bcd);
        while (i >= this.curOffset) {
            byte nibble = val.getDecDigit(0);
            val.shift(-1);
            byte b = nibble;
            nibble = val.getDecDigit(0);
            val.shift(-1);
            b = (byte)(b | (byte)(nibble << 4));
            mem.put(i--, b);
        }
    }

    private void putLongToMem(Memory mem, long val) {
        int i = this.end - 1;
        if (val < 0L) {
            val = -val;
        }
        while (i >= this.curOffset) {
            byte nibble = (byte)(val % 10L);
            byte b = nibble;
            nibble = (byte)((val /= 10L) % 10L);
            val /= 10L;
            b = (byte)(b | (byte)(nibble << 4));
            mem.put(i--, b);
        }
    }

    @Override
    void updateMemory(Memory mem, CobolNum cn) {
        if (this.intLen + this.decLen <= 18) {
            this.putLongToMem(mem, cn.getUnscaledLong());
        } else {
            this.putBDToMem(mem, cn.bigCobDecValue());
        }
    }

    @Override
    void updateMemory(Memory mem) {
        if (this.intLen + this.decLen <= 18) {
            this.putLongToMem(mem, this.num().getUnscaledLong());
        } else {
            this.putBDToMem(mem, this.num().bigCobDecValue());
        }
    }

    @Override
    public void defaultInitialize() {
        this.theValue.lnUnscValue = 0L;
        Memory mem = this.getMemory();
        mem.fill(this.curOffset, this.end, (byte)0);
    }

    @Override
    void updateCache(Memory mem, CobolNum cn) {
        if (this.intLen + this.decLen <= 18) {
            cn.set(this.getLongFromMem(mem), this.decLen);
        } else {
            cn.set(this.getBDFromMem(mem));
        }
    }

    long getLongFromMem(Memory mem) {
        int i = this.end;
        long Return2 = 0L;
        long decFact = 1L;
        --i;
        while (i > this.curOffset) {
            Return2 += (long)(mem.get(i) & 0xF) * decFact;
            Return2 += (long)(mem.get(i) >> 4 & 0xF) * (decFact *= 10L);
            decFact *= 10L;
            --i;
        }
        Return2 += (long)(mem.get(i) & 0xF) * decFact;
        decFact *= 10L;
        if ((this.intLen + this.decLen & 1) == 0) {
            Return2 += (long)(mem.get(i) >> 4 & 0xF) * decFact;
            decFact *= 10L;
        }
        return Return2;
    }

    private BigCobolDec getBDFromMem(Memory mem) {
        int i = this.end;
        char[] cNum = new char[this.intLen + this.decLen + 2];
        int cnIdx = cNum.length;
        --i;
        while (i > this.curOffset) {
            cNum[--cnIdx] = (char)(mem.get(i) & 0xF);
            cNum[--cnIdx] = (char)(mem.get(i) >> 4 & 0xF);
            --i;
        }
        cNum[--cnIdx] = (char)(mem.get(i) & 0xF);
        if ((this.intLen + this.decLen & 1) == 0) {
            cNum[--cnIdx] = (char)(mem.get(i) >> 4 & 0xF);
        }
        return Pic9Comp_6.getBD(cNum, cnIdx, false, this.decLen);
    }

    @Override
    public boolean isNumeric() {
        Memory mem = this.getMemory();
        for (int k = this.curOffset; k < this.end; ++k) {
            if ((mem.get(k) & 0xF) <= 9 && (mem.get(k) >> 4 & 0xF) <= 9) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNegative() {
        return false;
    }
}

