/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.exceptions.InvalidDirectiveException;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class OOCTRL
extends BaseDirective {
    private static final Pattern optionPattern = Pattern.compile("^(?<onoff>[+-])(?<option>[AFGLPQW]) *");
    public static final String NAME = "OOCTRL";
    private EnumSet<Options> onOptions;
    private EnumSet<Options> offOptions;

    @Override
    protected void initialize() {
        this.onOptions = EnumSet.noneOf(Options.class);
        this.offOptions = EnumSet.noneOf(Options.class);
    }

    @Override
    public void setValues() throws InvalidDirectiveException {
        this.checkParameterCount(1);
        this.onOptions.clear();
        this.offOptions.clear();
        String string = this.getTokenValue(0).toUpperCase();
        while (string.length() > 0) {
            Matcher matcher = optionPattern.matcher(string);
            if (matcher.find()) {
                Options options = null;
                switch (matcher.group("option")) {
                    case "A": {
                        options = Options.AllowActiveX;
                        break;
                    }
                    case "F": {
                        options = Options.FoldMethodNames;
                        break;
                    }
                    case "G": {
                        options = Options.MakeDataGlobal;
                        break;
                    }
                    case "L": {
                        options = Options.IncludeLocationInComments;
                        break;
                    }
                    case "P": {
                        options = Options.ExposeParameterTypeInformation;
                        break;
                    }
                    case "Q": {
                        options = Options.DisableQualification;
                        break;
                    }
                    case "W": {
                        options = Options.WorkingIsObject;
                    }
                }
                String string2 = matcher.group("onoff");
                if (string2.equals("+")) {
                    this.onOptions.add(options);
                } else {
                    this.offOptions.add(options);
                }
                string = string.substring(matcher.end());
                continue;
            }
            this.onOptions.clear();
            this.offOptions.clear();
            throw Directives.invalidDirectiveException("Directive %s: Invalid value %s.", NAME, this.getTokenValue(0));
        }
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return false;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.Any;
    }

    public static void setDefault(Directives directives) throws InvalidDirectiveException {
        directives.setDefault("OOCTRL(+A+F-G+L-P+Q+W)");
    }

    public EnumSet<Options> getOnOptions() {
        return this.onOptions;
    }

    public EnumSet<Options> getOffOptions() {
        return this.offOptions;
    }

    public OOCTRL(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 222;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static enum Options {
        AllowActiveX,
        FoldMethodNames,
        MakeDataGlobal,
        IncludeLocationInComments,
        ExposeParameterTypeInformation,
        DisableQualification,
        WorkingIsObject;

    }
}

