/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.compiler.directives.INDD;
import com.veryant.cobol.exceptions.InvalidDirectiveException;

public final class OUTDD
extends BaseDirective {
    public static final String NAME = "OUTDD";
    private String fileName;
    private Integer recordSize;
    private INDD.RecordType recordType;

    @Override
    public void setValues() throws InvalidDirectiveException {
        if (this.isNo()) {
            this.fileName = null;
            this.recordSize = null;
            this.recordType = null;
            return;
        }
        this.checkMaxParams(1);
        this.fileName = "SYSOUT";
        this.recordSize = 132;
        this.recordType = INDD.RecordType.LineSequential;
        if (this.getTokenCount() == 0) {
            return;
        }
        String[] stringArray = this.getTokenValue(0).split(" +");
        if (stringArray.length == 0) {
            return;
        }
        if (stringArray.length > 0) {
            this.fileName = stringArray[0];
        }
        if (stringArray.length > 1) {
            this.recordSize = this.getTokenIntegerValue(stringArray[1], 0, 255);
        }
        if (stringArray.length > 2) {
            this.checkTokenValues(stringArray[2], true, "L", "R");
            switch (stringArray[2].toUpperCase()) {
                case "L": {
                    this.recordType = INDD.RecordType.LineSequential;
                    break;
                }
                case "R": {
                    this.recordType = INDD.RecordType.RecordSequential;
                }
            }
        }
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return true;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.Init;
    }

    public static void setDefault(Directives directives) throws InvalidDirectiveException {
        directives.setDefault("NOOUTDD");
    }

    public String getFileName() {
        return this.fileName;
    }

    public Integer getRecordSize() {
        return this.recordSize;
    }

    public INDD.RecordType getRecordType() {
        return this.recordType;
    }

    public OUTDD(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 228;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

