/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.builtin;

import com.veryant.cobol.compiler.BuiltIn;
import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.compiler.emitters.jvm.BuiltInEmitter;
import com.veryant.cobol.compiler.emitters.jvm.JvmCodeSnippet;
import com.veryant.cobol.compiler.emitters.jvm.VMType;
import com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes;
import com.veryant.cobol.compiler.emitters.jvm.core.Errors;

public abstract class NumericDisplay {
    static final BuiltInEmitter LOAD = (jvmCode, abstractOperand) -> {
        Magnitude magnitude = abstractOperand.getMagnitude();
        VMType vMType = VMType.from(magnitude);
        Opcodes.LOAD_ADDR(jvmCode, abstractOperand);
        BuiltIn builtIn = abstractOperand.getBuiltIn();
        if (vMType == VMType.INT128) {
            jvmCode.push(abstractOperand, vMType, builtIn.getLoadConvention().getSimpleName() + ".load" + vMType.getName() + "(" + jvmCode.pop() + "," + magnitude.getScale() + ")", magnitude);
        } else {
            jvmCode.push(abstractOperand, vMType, builtIn.getLoadConvention().getSimpleName() + ".load" + vMType.getName() + "(" + jvmCode.pop() + ")", magnitude);
        }
    };
    static final BuiltInEmitter STORE = (jvmCode, abstractOperand) -> {
        Magnitude magnitude = abstractOperand.getMagnitude();
        VMType vMType = (VMType)((JvmCodeSnippet)jvmCode.peek()).getVmType();
        BuiltIn builtIn = abstractOperand.getBuiltIn();
        if (vMType == VMType.INT128) {
            JvmCodeSnippet jvmCodeSnippet = (JvmCodeSnippet)jvmCode.pop();
            Opcodes.LOAD_ADDR(jvmCode, abstractOperand);
            jvmCode.push(abstractOperand, VMType.VOID, builtIn.getStoreConvention().getSimpleName() + ".store(" + jvmCodeSnippet + "," + jvmCode.pop() + "," + magnitude.getScale() + ");");
            return;
        }
        if (vMType == VMType.INT32 || vMType == VMType.INT64) {
            com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.SCALE(jvmCode, magnitude.getScale());
            JvmCodeSnippet jvmCodeSnippet = (JvmCodeSnippet)jvmCode.pop();
            Opcodes.LOAD_ADDR(jvmCode, abstractOperand);
            jvmCode.push(abstractOperand, VMType.VOID, builtIn.getStoreConvention().getSimpleName() + ".store(" + jvmCodeSnippet + "," + jvmCode.pop() + ");");
            return;
        }
        throw Errors.e_should_be_numeric(jvmCode.pop());
    };
}

