/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.stmts;

import com.veryant.cobol.compiler.IOperand;
import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.Statements;
import com.veryant.cobol.compiler.emitters.jvm.MathPrecision;
import com.veryant.cobol.compiler.stmts.AbstractArithmeticStatement;
import com.veryant.cobol.compiler.types.AbstractOperand;

public class Subtract
extends AbstractArithmeticStatement {
    private final AbstractOperand[] operands;
    private final AbstractOperand[] fromOperands;
    private final AbstractOperand[] givingOperands;

    @Override
    public Statements getStatement() {
        return Statements.SUBTRACT;
    }

    @Override
    public MathPrecision getPrecision() {
        for (AbstractOperand abstractOperand : this.operands) {
            if (!IOperand.isFloatingPoint(abstractOperand)) continue;
            return MathPrecision.FLOATING_POINT_PRECISION;
        }
        for (AbstractOperand abstractOperand : this.fromOperands) {
            if (!IOperand.isFloatingPoint(abstractOperand)) continue;
            return MathPrecision.FLOATING_POINT_PRECISION;
        }
        return MathPrecision.FIXED_POINT_PRECISION;
    }

    public Subtract(ISourceReference iSourceReference, AbstractOperand[] abstractOperandArray, AbstractOperand[] abstractOperandArray2, AbstractOperand[] abstractOperandArray3) {
        super(iSourceReference);
        this.operands = abstractOperandArray;
        this.fromOperands = abstractOperandArray2;
        this.givingOperands = abstractOperandArray3;
    }

    public Subtract(ISourceReference iSourceReference, AbstractOperand[] abstractOperandArray, AbstractOperand[] abstractOperandArray2) {
        this(iSourceReference, abstractOperandArray, abstractOperandArray2, null);
    }

    public AbstractOperand[] getOperands() {
        return this.operands;
    }

    public AbstractOperand[] getFromOperands() {
        return this.fromOperands;
    }

    public AbstractOperand[] getGivingOperands() {
        return this.givingOperands;
    }
}

