/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.converters;

import com.veryant.cobol.converters.Endianness;
import com.veryant.cobol.data.IMemory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Bytes {
    public static final ByteOrder byteOrder = Endianness.getByteOrder();

    private static ByteBuffer newBuffer(int n) {
        return ByteBuffer.wrap(new byte[n]).order(byteOrder);
    }

    private static ByteBuffer newBuffer(IMemory iMemory, int n, int n2) {
        byte[] byArray = new byte[n2];
        iMemory.copy(byArray, n, 0, n2);
        return ByteBuffer.wrap(byArray).order(byteOrder);
    }

    public static byte[] get(float f) {
        return Bytes.newBuffer(4).putFloat(0, f).array();
    }

    public static byte[] get(double d) {
        return Bytes.newBuffer(8).putDouble(0, d).array();
    }

    public static byte[] get(byte by) {
        return new byte[]{by};
    }

    public static byte[] get(char c) {
        return Bytes.newBuffer(2).putChar(0, c).array();
    }

    public static byte[] get(short s) {
        return Bytes.newBuffer(2).putShort(0, s).array();
    }

    public static byte[] get(int n) {
        return Bytes.newBuffer(4).putInt(0, n).array();
    }

    public static byte[] get(long l) {
        return Bytes.newBuffer(8).putLong(0, l).array();
    }

    public static float toFloat(IMemory iMemory, int n) {
        return Bytes.newBuffer(iMemory, n, 4).getFloat(0);
    }

    public static double toDouble(IMemory iMemory, int n) {
        return Bytes.newBuffer(iMemory, n, 8).getDouble(0);
    }

    public static byte toByte(IMemory iMemory, int n) {
        return iMemory.get(n);
    }

    public static char toChar(IMemory iMemory, int n) {
        return Bytes.newBuffer(iMemory, n, 2).getChar(0);
    }

    public static short toShort(IMemory iMemory, int n) {
        return Bytes.newBuffer(iMemory, n, 2).getShort(0);
    }

    public static int toInt(IMemory iMemory, int n) {
        return Bytes.newBuffer(iMemory, n, 4).getInt(0);
    }

    public static long toLong(IMemory iMemory, int n) {
        return Bytes.newBuffer(iMemory, n, 8).getLong(0);
    }
}

