/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file;

import com.veryant.vision4j.file.internals.IConfigValidator;

public class ConfigEntry {
    private static final String BASE_PACKAGE = "com.veryant.vision4j";
    private final String name;
    private int integerValue;
    private int defaultIntegerValue;
    private IConfigValidator configValidator;
    private boolean on;
    private boolean defaultBooleanValue;

    public boolean isOff() {
        return !this.on;
    }

    public boolean is(int value) {
        return this.integerValue == value;
    }

    private int stringToInteger(String string) {
        if (string == null) {
            return this.defaultIntegerValue;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException ignored) {
            return this.defaultIntegerValue;
        }
    }

    private boolean stringToBoolean(String string) {
        if (string == null) {
            return this.defaultBooleanValue;
        }
        if (string.length() == 1) {
            char c = string.charAt(0);
            switch (c) {
                case '1': 
                case 'T': 
                case 'Y': 
                case 't': 
                case 'y': {
                    return true;
                }
                case '0': 
                case 'F': 
                case 'N': 
                case 'f': 
                case 'n': {
                    return false;
                }
            }
            return this.defaultBooleanValue;
        }
        if ("on".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string)) {
            return true;
        }
        if ("off".equalsIgnoreCase(string) || "no".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
            return false;
        }
        return this.defaultBooleanValue;
    }

    public void parse(String val) {
        if (val != null) {
            int tmp = this.stringToInteger(val);
            this.integerValue = this.configValidator != null ? this.configValidator.validate(tmp) : tmp;
            this.on = this.stringToBoolean(val);
        }
    }

    public void set(int val) {
        this.integerValue = this.configValidator != null ? this.configValidator.validate(val) : val;
        this.on = this.integerValue != 0;
    }

    public void set(boolean val) {
        this.on = val;
        int tmp = val ? 1 : 0;
        this.integerValue = this.configValidator != null ? this.configValidator.validate(tmp) : tmp;
    }

    public ConfigEntry(String name, int defaultValue, IConfigValidator configValidator) {
        this.name = name;
        this.defaultIntegerValue = defaultValue;
        this.configValidator = configValidator;
        String envVal = System.getProperty("com.veryant.vision4j." + name);
        if (envVal == null) {
            this.set(defaultValue);
        } else {
            this.set(this.stringToInteger(envVal));
        }
    }

    public ConfigEntry(String name, boolean defaultValue) {
        this.name = name;
        this.defaultBooleanValue = defaultValue;
        String envVal = System.getProperty("com.veryant.vision4j." + name);
        this.set(envVal == null ? defaultValue : this.stringToBoolean(envVal));
    }

    public String getName() {
        return this.name;
    }

    public int getIntegerValue() {
        return this.integerValue;
    }

    public boolean isOn() {
        return this.on;
    }
}

