/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class SegmentInfoHelper {
    private static final ByteOrder byteOrder = ByteOrder.nativeOrder();
    private final byte[] bytes;

    private int getNativeUnsignedShort(int offset) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return (this.bytes[offset + 1] & 0xFF) << 8 | this.bytes[offset] & 0xFF;
        }
        return (this.bytes[offset] & 0xFF) << 8 | this.bytes[offset + 1] & 0xFF;
    }

    private void setCString(String value, int offset, int size) {
        Arrays.fill(this.bytes, offset, size, (byte)0);
        byte[] stringBytes = value.getBytes(StandardCharsets.US_ASCII);
        System.arraycopy(stringBytes, 0, this.bytes, offset, Math.min(size - 1, stringBytes.length));
    }

    public SegmentInfoHelper(byte[] bytes) {
        this.bytes = bytes;
    }

    public boolean isDataSegment() {
        return this.getNativeUnsignedShort(272) == 255;
    }

    public boolean isIndexSegment() {
        return this.getNativeUnsignedShort(272) == 254;
    }

    public int getSegmentNumber() {
        return this.getNativeUnsignedShort(274);
    }

    public void setSegmentName(String name) {
        this.setCString(name, 0, 256);
    }

    public void setSegmentSize(long size) {
        this.setCString(String.format("%015d", size), 256, 16);
    }
}

