/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file;

import com.veryant.vision4j.file.TransactionLogEntry;
import java.util.ArrayList;
import java.util.Arrays;

public class TransactionLog {
    public static final int WRITE = 0;
    public static final int REWRITE = 1;
    public static final int DELETE = 2;
    public int nestedIndex;
    private TransactionLogEntry last;
    private ArrayList<Integer> postponedCloseList = new ArrayList();

    public boolean inTransaction() {
        return this.nestedIndex > 0;
    }

    public TransactionLogEntry getLast() {
        return this.last;
    }

    public int[] getPostponedCloseList() {
        return this.postponedCloseList.stream().mapToInt(Integer::intValue).toArray();
    }

    public void init() {
    }

    public void clear() {
        this.last = null;
        this.postponedCloseList.clear();
    }

    private void add(TransactionLogEntry entry) {
        if (this.last != null) {
            entry.setPrev(this.last);
        }
        this.last = entry;
    }

    public void rewrite(int fileId, byte[] record, int size) {
        this.add(new TransactionLogEntry(1, fileId, Arrays.copyOf(record, size), size));
    }

    public void write(int fileId, byte[] record, int size) {
        this.add(new TransactionLogEntry(0, fileId, Arrays.copyOf(record, size), size));
    }

    public void delete(int fileId, byte[] record, int size) {
        this.add(new TransactionLogEntry(2, fileId, Arrays.copyOf(record, size), size));
    }

    public void postponedClose(int fileId) {
        this.postponedCloseList.add(fileId);
    }
}

