/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file;

import com.veryant.vision4j.file.Config;
import com.veryant.vision4j.file.Constants;
import com.veryant.vision4j.file.File;
import com.veryant.vision4j.file.FileSystemCache;
import com.veryant.vision4j.file.FileTable;
import com.veryant.vision4j.file.IndexFile;
import com.veryant.vision4j.file.Offset;
import com.veryant.vision4j.file.SegmentedFile;
import com.veryant.vision4j.file.Status;
import com.veryant.vision4j.file.TransactionLog;
import com.veryant.vision4j.file.internals.Block;
import com.veryant.vision4j.file.internals.BlockType;
import com.veryant.vision4j.file.internals.CacheDataType;
import com.veryant.vision4j.file.internals.CombineMode;
import com.veryant.vision4j.file.internals.FileAddress;
import com.veryant.vision4j.file.internals.FileDescriptor;
import com.veryant.vision4j.file.internals.FindKeyResult;
import com.veryant.vision4j.file.internals.KeyEntry;
import com.veryant.vision4j.file.internals.KeyInfo;
import com.veryant.vision4j.file.internals.Lock;
import com.veryant.vision4j.file.internals.LockType;
import com.veryant.vision4j.file.internals.LogicalAttributes;
import com.veryant.vision4j.file.internals.PointerState;
import com.veryant.vision4j.file.internals.RecordHeader;
import com.veryant.vision4j.file.internals.RecordStatus;
import java.nio.channels.FileLock;

public abstract class VisionBase
implements Constants {
    private static final Block FULL_STOPPER_KEY = new Block(new byte[]{1, 127});
    private static final byte[] COMPRESSED_VALUES = new byte[]{0, 32, 48, 0};
    protected final Config config;
    protected final Status status = new Status();
    protected final FileTable fileTable;

    public VisionBase(Config config, FileTable fileTable) {
        this.config = config;
        this.fileTable = fileTable;
    }

    private String stripFileExtension(String filePath) {
        int startingOffset;
        int lastDot = filePath.lastIndexOf(46);
        if (lastDot > (startingOffset = Math.max(filePath.lastIndexOf(92), filePath.lastIndexOf(47)) + 1)) {
            return filePath.substring(0, lastDot);
        }
        return filePath;
    }

    protected int standardizeOpenMode(int openMode) {
        int open = openMode & 3;
        int lock = openMode & 0x300;
        int multiLock = openMode & 0x4010;
        return (open == 1 || openMode == 3 ? 2 : open) | lock | multiLock;
    }

    protected boolean isInputOnly(int openMode) {
        return (openMode & 3) == 0;
    }

    protected boolean isOutputOnly(int openMode) {
        return (openMode & 3) == 1;
    }

    protected boolean isExtendOnly(int openMode) {
        return (openMode & 3) == 3;
    }

    protected boolean isMultiLockOnly(int openMode) {
        return (openMode & 0x10) != 0;
    }

    protected boolean isMultiLock(int openMode) {
        return (openMode & 0x10) != 0 || (openMode & 0x4000) != 0;
    }

    protected boolean canRollback(int openMode) {
        return (openMode & 0x4000) != 0;
    }

    protected boolean useTransactionLog(File visionFile, TransactionLog transactionLog) {
        return transactionLog != null && transactionLog.inTransaction() && visionFile.isRollbackable() && !this.isInputOnly(visionFile.getOpenMode());
    }

    protected String getDataSegmentName(String fileName, int segment) {
        if (segment == 0) {
            return fileName;
        }
        if (this.config.V_STRIP_DOT_EXTENSION.isOn()) {
            fileName = this.stripFileExtension(fileName);
        }
        fileName = fileName + (segment < 256 ? String.format(".d%02x", segment) : String.format(".d%04x", segment));
        return fileName;
    }

    protected String getIndexSegmentName(String fileName, int segment) {
        if (this.config.V_STRIP_DOT_EXTENSION.isOn()) {
            fileName = this.stripFileExtension(fileName);
        }
        fileName = segment == 0 ? fileName + ".vix" : fileName + (segment < 256 ? String.format(".v%02x", segment) : String.format(".v%04x", segment));
        return fileName;
    }

    protected String getSegmentName(String fileName, BlockType type, int segment) {
        return type == BlockType.NODE ? this.getIndexSegmentName(fileName, segment) : this.getDataSegmentName(fileName, segment);
    }

    private boolean hold(File file) {
        FileDescriptor fileDescriptor = file.getSegment(0);
        Lock exclusiveLock = fileDescriptor.getExclusiveLock();
        if (exclusiveLock == null) {
            int openMode = file.getOpenMode();
            if ((openMode & 0x200) != 0 || (openMode & 0x100) != 0) {
                return true;
            }
            FileLock nioLock = file.getFileSystemCache().lock(fileDescriptor);
            if (nioLock == null) {
                return false;
            }
            fileDescriptor.setExclusiveLock(new Lock(0, nioLock));
        }
        return true;
    }

    private void release(File file) {
        FileDescriptor fileDescriptor = file.getSegment(0);
        Lock exclusiveLock = fileDescriptor.getExclusiveLock();
        if (exclusiveLock != null) {
            exclusiveLock.release();
            fileDescriptor.setExclusiveLock(null);
        }
    }

    protected boolean lockHeader(File visionFile, boolean refresh, boolean updateAllowed, boolean readOrReadNext) {
        long keyRootVersion;
        boolean retry;
        if (visionFile.isHeaderLocked() && !visionFile.isUnlockedHeaderRead()) {
            return true;
        }
        if (readOrReadNext && this.config.V_LOCK_METHOD.is(1) && !visionFile.isUnlockedHeaderRead()) {
            visionFile.setUnlockedHeaderRead(true);
        } else {
            if (visionFile.isUnlockedHeaderRead()) {
                visionFile.getCurrentNode().invalidate();
            }
            visionFile.setUnlockedHeaderRead(false);
            if (!this.hold(visionFile)) {
                return false;
            }
        }
        FileDescriptor segment0 = visionFile.getSegment(0);
        int version = visionFile.getVersion();
        int headerSize = Offset.PHDR_SIZE.get(version) - 4;
        Block headerCache = visionFile.getHeaderCache();
        FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
        do {
            retry = false;
            fileSystemCache.seek(segment0, 4L);
            if (fileSystemCache.read(segment0, headerCache, 4, headerSize, CacheDataType.HEADER) != headerSize) {
                this.release(visionFile);
                return false;
            }
            headerCache.put32(0, version == 3 ? 269620246 : 269620249);
            if (!visionFile.isUnlockedHeaderRead() || headerCache.get16(Offset.UPDATING.get(version)) == 0) continue;
            visionFile.setUnlockedHeaderRead(false);
            if (!this.hold(visionFile)) {
                return false;
            }
            retry = true;
        } while (retry);
        visionFile.setTreeVersion((long)headerCache.get32(Offset.IVERSION.get(version)) & 0xFFFFFFFFL);
        fileSystemCache.checkCacheVersion(visionFile.getTreeVersion());
        if (version > 3) {
            Block size;
            int segmentIndex = visionFile.getSegmentCount() - 1;
            if (segmentIndex == 0) {
                if (version < 6) {
                    visionFile.setSegmentSize(0, (long)headerCache.get32(Offset.FILESIZE.get(version)) & 0xFFFFFFFFL);
                } else {
                    visionFile.setSegmentSize(0, headerCache.get48(Offset.FILESIZE.get(version)));
                }
            } else {
                Block size2 = new Block(4);
                FileDescriptor lastSegment = visionFile.getSegment(segmentIndex);
                fileSystemCache.seek(lastSegment, Offset.D_FILESIZE.get(version));
                fileSystemCache.read(lastSegment, size2, CacheDataType.HEADER);
                visionFile.setSegmentSize(segmentIndex, (long)size2.get32(0) & 0xFFFFFFFFL);
            }
            int wholeSegs = 0;
            int segs = 0;
            if (version < 6) {
                wholeSegs = headerCache.get16(Offset.WHOLE_DATA_SEG.get(version)) & 0xFFFF;
                segs = headerCache.get16(Offset.DATA_SEGS.get(version)) & 0xFFFF;
            }
            while (visionFile.getSegmentCount() <= segs) {
                if (this.loadAdditionalSegment(visionFile, false, visionFile.getSegmentCount())) continue;
                return false;
            }
            visionFile.getFileSize().setSegment(wholeSegs);
            if (version < 6) {
                visionFile.getFileSize().setOffset((long)headerCache.get32(Offset.WHOLE_DATA_OFF.get(version)) & 0xFFFFFFFFL);
            } else {
                visionFile.getFileSize().setOffset(headerCache.get48(Offset.WHOLE_DATA_OFF.get(version)));
            }
            IndexFile indexFile = visionFile.getIndexFile();
            int isegmentIndex = indexFile.getSegmentCount() - 1;
            FileDescriptor lastSegment = indexFile.getSegment(isegmentIndex);
            fileSystemCache.seek(lastSegment, Offset.I_FILESIZE.get(version));
            if (version < 6) {
                size = new Block(4);
                fileSystemCache.read(lastSegment, size, CacheDataType.HEADER);
                indexFile.setSegmentSize(isegmentIndex, (long)size.get32(0) & 0xFFFFFFFFL);
            } else {
                size = new Block(6);
                fileSystemCache.read(lastSegment, size, CacheDataType.HEADER);
                indexFile.setSegmentSize(isegmentIndex, size.get48(0));
            }
            wholeSegs = 0;
            segs = 0;
            if (version < 6) {
                wholeSegs = headerCache.get16(Offset.WHOLE_INDEX_SEG.get(version)) & 0xFFFF;
                segs = headerCache.get16(Offset.INDEX_SEGS.get(version)) & 0xFFFF;
            }
            while (indexFile.getSegmentCount() <= segs) {
                if (this.loadAdditionalSegment(visionFile, true, indexFile.getSegmentCount())) continue;
                return false;
            }
            indexFile.getFileSize().setSegment(wholeSegs);
            if (version < 6) {
                indexFile.getFileSize().setOffset((long)headerCache.get32(Offset.WHOLE_INDEX_OFF.get(version)) & 0xFFFFFFFFL);
            } else {
                indexFile.getFileSize().setOffset(headerCache.get48(Offset.WHOLE_INDEX_OFF.get(version)));
            }
        }
        if (refresh) {
            if (version == 3) {
                visionFile.getFileSize().setOffset((long)headerCache.get32(Offset.FILESIZE.get(version)) & 0xFFFFFFFFL);
                visionFile.getFileSize().setSegment(0);
                visionFile.getNextBlock().setSegment(0);
                visionFile.getNextRec().setSegment(0);
                visionFile.getFreeRec().setSegment(0);
                visionFile.getAbandonedRec().setSegment(0);
                visionFile.getFreeNode().setSegment(0);
            } else if (version < 6) {
                visionFile.getNextBlock().setSegment(headerCache.get16(Offset.NXTBLK_SEG.get(version)) & 0xFFFF);
                visionFile.getNextRec().setSegment(headerCache.get16(Offset.NXTREC_SEG.get(version)) & 0xFFFF);
                visionFile.getFreeRec().setSegment(headerCache.get16(Offset.FREEREC_SEG.get(version)) & 0xFFFF);
                visionFile.getFreeNode().setSegment(headerCache.get16(Offset.FREENODE_SEG.get(version)) & 0xFFFF);
                IndexFile indexFile = visionFile.getIndexFile();
                indexFile.getNextBlock().setOffset((long)headerCache.get32(Offset.I_NXTBLK_OFF.get(version)) & 0xFFFFFFFFL);
                indexFile.getNextBlock().setSegment(headerCache.get16(Offset.I_NXTBLK_SEG.get(version)) & 0xFFFF);
            } else {
                visionFile.getNextBlock().setSegment(0);
                visionFile.getNextRec().setSegment(0);
                visionFile.getFreeRec().setSegment(0);
                visionFile.getFreeNode().setSegment(0);
                IndexFile indexFile = visionFile.getIndexFile();
                indexFile.getNextBlock().setOffset(headerCache.get48(Offset.I_NXTBLK_OFF.get(version)));
                indexFile.getNextBlock().setSegment(0);
            }
            if (version < 6) {
                visionFile.getNextBlock().setOffset((long)headerCache.get32(Offset.NXTBLK_OFF.get(version)) & 0xFFFFFFFFL);
                visionFile.getNextRec().setOffset((long)headerCache.get32(Offset.NXTREC_OFF.get(version)) & 0xFFFFFFFFL);
                visionFile.getFreeRec().setOffset((long)headerCache.get32(Offset.FREEREC_OFF.get(version)) & 0xFFFFFFFFL);
                visionFile.getFreeNode().setOffset((long)headerCache.get32(Offset.FREENODE_OFF.get(version)) & 0xFFFFFFFFL);
            } else {
                visionFile.getNextBlock().setOffset(headerCache.get48(Offset.NXTBLK_OFF.get(version)));
                visionFile.getNextRec().setOffset(headerCache.get48(Offset.NXTREC_OFF.get(version)));
                visionFile.getFreeRec().setOffset(headerCache.get48(Offset.FREEREC_OFF.get(version)));
                visionFile.getFreeNode().setOffset(headerCache.get48(Offset.FREENODE_OFF.get(version)));
            }
            visionFile.setTotalRecords((long)headerCache.get32(Offset.RECCOUNT.get(version)) & 0xFFFFFFFFL);
            visionFile.setDeletedRecords((long)headerCache.get32(Offset.DELCOUNT.get(version)) & 0xFFFFFFFFL);
            visionFile.setNextUniqueId((long)headerCache.get32(Offset.NEXTUNIQ.get(version)) & 0xFFFFFFFFL);
            visionFile.setFreeFailures(headerCache.get16(Offset.FREEFAILS.get(version)) & 0xFFFF);
            visionFile.setOpenCounter(headerCache.get16(Offset.OPEN_CNT.get(version)) & 0xFFFF);
            if (version < 5) {
                visionFile.setUsedNodes(headerCache.get16(Offset.NODES_USED.get(version)) & 0xFFFF);
                visionFile.setFreeNodes(headerCache.get16(Offset.NODES_FREE.get(version)) & 0xFFFF);
                visionFile.setNodeUsage((long)headerCache.get32(Offset.NODE_USAGE.get(version)) & 0xFFFFFFFFL);
            } else {
                visionFile.setNodeUsage(headerCache.get48(Offset.NODE_USAGE.get(version)));
                if (version < 6) {
                    visionFile.setUsedNodes((long)headerCache.get32(Offset.NODES_USED.get(version)) & 0xFFFFFFFFL);
                    visionFile.setFreeNodes((long)headerCache.get32(Offset.NODES_FREE.get(version)) & 0xFFFFFFFFL);
                    visionFile.getAbandonedRec().setOffset((long)headerCache.get32(Offset.ABREC_OFF.get(version)) & 0xFFFFFFFFL);
                    visionFile.getAbandonedRec().setSegment(headerCache.get16(Offset.ABREC_SEG.get(version)) & 0xFFFF);
                } else {
                    visionFile.setUsedNodes(headerCache.get48(Offset.NODES_USED.get(version)));
                    visionFile.setFreeNodes(headerCache.get48(Offset.NODES_FREE.get(version)));
                    visionFile.getAbandonedRec().setOffset(headerCache.get48(Offset.ABREC_OFF.get(version)));
                    visionFile.getAbandonedRec().setSegment(0);
                }
                visionFile.setAbandonedRecords((long)headerCache.get32(Offset.ABCOUNT.get(version)) & 0xFFFFFFFFL);
            }
            short broken = headerCache.get16(Offset.BROKEN.get(version));
            if (broken != 0) {
                if (this.config.V_FORCE_OPEN.isOff()) {
                    this.release(visionFile);
                    this.status.setErrno(6);
                    this.status.setIntErrno(broken);
                    return false;
                }
            } else if (visionFile.getNextUniqueId() == 0xFFFFFFFFL) {
                if (updateAllowed) {
                    Block tmp = new Block(2);
                    tmp.put16(0, (short)42);
                    fileSystemCache.seek(segment0, Offset.BROKEN.get(version));
                    fileSystemCache.write(segment0, tmp, CacheDataType.HEADER);
                }
                this.release(visionFile);
                this.status.setErrno(6);
                this.status.setIntErrno(42);
                return false;
            }
            if (updateAllowed && this.config.V_LOCK_METHOD.is(1)) {
                headerCache.put16(Offset.UPDATING.get(version), (short)1);
                fileSystemCache.seek(segment0, 0L);
                fileSystemCache.write(segment0, headerCache, 0, Offset.PHDR_SIZE.get(version), CacheDataType.HEADER);
            }
        }
        if ((keyRootVersion = (long)headerCache.get32(Offset.ROOT_VERS.get(version)) & 0xFFFFFFFFL) != visionFile.getKeyRootVersion()) {
            visionFile.setKeyRootVersion(keyRootVersion);
            int offset = Offset.KEYINFO.get(version);
            int keyMult = Offset.KEY_MULT.get(version);
            Block tmp = new Block(keyMult);
            LogicalAttributes logicalAttributes = visionFile.getLogicalAttributes();
            for (int i = 0; i < logicalAttributes.getNumKeys(); ++i) {
                int spaceLeft = 512 - offset % 512;
                if (spaceLeft < keyMult) {
                    offset += spaceLeft;
                }
                fileSystemCache.seek(segment0, offset);
                fileSystemCache.read(segment0, tmp, CacheDataType.HEADER);
                offset += keyMult;
                KeyInfo keyInfo = logicalAttributes.getKey(i);
                if (version < 6) {
                    keyInfo.getKeyRoot().setOffset((long)tmp.get32(Offset.KEYROOT_OFF.get(version)) & 0xFFFFFFFFL);
                } else {
                    keyInfo.getKeyRoot().setOffset(tmp.get48(Offset.KEYROOT_OFF.get(version)));
                }
                if (version == 4 || version == 5) {
                    keyInfo.getKeyRoot().setSegment(tmp.get16(Offset.KEYROOT_SEG.get(version)) & 0xFFFF);
                } else {
                    keyInfo.getKeyRoot().setSegment(0);
                }
                keyInfo.setHeight((short)(tmp.get8(Offset.KEYHEIGHT.get(version)) & 0xFF));
            }
        }
        visionFile.setHeaderLocked(true);
        return true;
    }

    public boolean locklessReadCheck(File visionFile) {
        if (visionFile.isUnlockedHeaderRead()) {
            int version = visionFile.getVersion();
            FileDescriptor segment = this.retrieveSegment(visionFile, BlockType.DATA, 0);
            Block header = visionFile.getHeaderCache();
            FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
            fileSystemCache.seek(segment, 4L);
            fileSystemCache.read(segment, header, 4, Offset.PHDR_SIZE.get(version) - 4, CacheDataType.HEADER);
            long treeVersion = (long)header.get32(Offset.IVERSION.get(version)) & 0xFFFFFFFFL;
            if (header.get16(Offset.UPDATING.get(version)) > 0 || treeVersion != visionFile.getTreeVersion()) {
                return false;
            }
        }
        return true;
    }

    private boolean loadAdditionalSegment(File visionFile, boolean asIndexSegment, int segment) {
        boolean checkTreeVersion;
        FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
        FileDescriptor newSegment = fileSystemCache.open(asIndexSegment ? this.getIndexSegmentName(visionFile.getName(), segment) : this.getDataSegmentName(visionFile.getName(), segment), this.standardizeOpenMode(visionFile.getOpenMode()));
        if (newSegment == null) {
            if (this.status.getErrno() == 15) {
                this.status.setErrno(6);
                this.status.setIntErrno(asIndexSegment ? 69 : 68);
            }
            return false;
        }
        FileLock newSegmentLock = fileSystemCache.lock(newSegment);
        if (newSegmentLock == null) {
            fileSystemCache.close(newSegment);
            return false;
        }
        Block segmentHeader = new Block(512);
        if (fileSystemCache.read(newSegment, segmentHeader, CacheDataType.HEADER) != 512) {
            fileSystemCache.unlock(newSegmentLock);
            fileSystemCache.close(newSegment);
            return false;
        }
        int version = visionFile.getVersion();
        int openCounter = visionFile.getHeaderCache().get16(Offset.OPEN_CNT.get(version)) & 0xFFFF;
        boolean bl = checkTreeVersion = openCounter == 0 && (this.config.V_OPEN_STRICT.isOn() || this.config.V_FORCE_OPEN.isOff());
        if (asIndexSegment) {
            int imagic = segmentHeader.get32(Offset.I_MAGIC.get(version));
            short iversion = segmentHeader.get16(Offset.I_VERSION.get(version));
            short iseg = segmentHeader.get16(Offset.I_SEGNUM.get(version));
            if (imagic != 269620248 || iversion != version || iseg != segment) {
                fileSystemCache.unlock(newSegmentLock);
                fileSystemCache.close(newSegment);
                this.status.setErrno(13);
                return false;
            }
            if (checkTreeVersion && visionFile.getTreeVersion() != ((long)segmentHeader.get32(Offset.I_IVERSION.get(version)) & 0xFFFFFFFFL)) {
                fileSystemCache.unlock(newSegmentLock);
                fileSystemCache.close(newSegment);
                this.status.setErrno(6);
                this.status.setIntErrno(90);
                return false;
            }
            IndexFile indexFile = visionFile.getIndexFile();
            indexFile.addSegment(newSegment);
            indexFile.setSegmentSize(segment, (long)segmentHeader.get32(Offset.I_FILESIZE.get(version)) & 0xFFFFFFFFL);
        } else {
            int dmagic = segmentHeader.get32(Offset.D_MAGIC.get(version));
            short dversion = segmentHeader.get16(Offset.D_VERSION.get(version));
            short dseg = segmentHeader.get16(Offset.D_SEGNUM.get(version));
            if (dmagic != 269620247 || dversion != version || dseg != segment) {
                fileSystemCache.unlock(newSegmentLock);
                fileSystemCache.close(newSegment);
                this.status.setErrno(13);
                return false;
            }
            if (checkTreeVersion && visionFile.getTreeVersion() != ((long)segmentHeader.get32(Offset.D_IVERSION.get(version)) & 0xFFFFFFFFL)) {
                fileSystemCache.unlock(newSegmentLock);
                fileSystemCache.close(newSegment);
                this.status.setErrno(6);
                this.status.setIntErrno(89);
                return false;
            }
            visionFile.addSegment(newSegment);
            visionFile.setSegmentSize(segment, (long)segmentHeader.get32(Offset.D_FILESIZE.get(version)) & 0xFFFFFFFFL);
        }
        fileSystemCache.unlock(newSegmentLock);
        return true;
    }

    protected boolean unlockHeader(File visionFile, boolean readOrStart) {
        FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
        visionFile.getCurrentNode().invalidate();
        if (visionFile.isHeaderLocked()) {
            FileDescriptor segment0 = visionFile.getSegment(0);
            if (this.status.getErrno() == 6 && this.isInputOnly(visionFile.getOpenMode()) && (this.config.V_MARK_READ_CORRUPT.isOn() || !readOrStart)) {
                Block tmp = new Block(2);
                tmp.put16(0, (short)this.status.getIntErrno());
                fileSystemCache.seek(segment0, Offset.BROKEN.get(visionFile.getVersion()));
                fileSystemCache.write(segment0, tmp, CacheDataType.HEADER);
            }
            this.release(visionFile);
            visionFile.setHeaderLocked(false);
            visionFile.setUnlockedHeaderRead(false);
        }
        return true;
    }

    protected void saveHeader(File visionFile, boolean bumpVersion) {
        int version = visionFile.getVersion();
        if (bumpVersion) {
            visionFile.incTreeVersion();
        }
        FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
        fileSystemCache.setCacheVersion(visionFile.getTreeVersion());
        Block header = visionFile.getHeaderCache();
        if (version < 6) {
            header.put32(Offset.NXTREC_OFF.get(version), (int)visionFile.getNextRec().getOffset());
        } else {
            header.put48(Offset.NXTREC_OFF.get(version), visionFile.getNextRec().getOffset());
        }
        if (version == 3) {
            header.put32(Offset.FILESIZE.get(version), (int)visionFile.getFileSize().getOffset());
        } else if (version < 6) {
            header.put16(Offset.NXTREC_SEG.get(version), (short)visionFile.getNextRec().getSegment());
            header.put32(Offset.WHOLE_DATA_OFF.get(version), (int)visionFile.getFileSize().getOffset());
            header.put16(Offset.WHOLE_DATA_SEG.get(version), (short)visionFile.getFileSize().getSegment());
            header.put32(Offset.WHOLE_INDEX_OFF.get(version), (int)visionFile.getIndexFile().getFileSize().getOffset());
            header.put16(Offset.WHOLE_INDEX_SEG.get(version), (short)visionFile.getIndexFile().getFileSize().getSegment());
            header.put16(Offset.DATA_SEGS.get(version), (short)(visionFile.getSegmentCount() - 1));
            header.put16(Offset.INDEX_SEGS.get(version), (short)(visionFile.getIndexFile().getSegmentCount() - 1));
        } else {
            header.put48(Offset.WHOLE_DATA_OFF.get(version), visionFile.getFileSize().getOffset());
            header.put48(Offset.WHOLE_INDEX_OFF.get(version), visionFile.getIndexFile().getFileSize().getOffset());
        }
        header.put32(Offset.RECCOUNT.get(version), (int)visionFile.getTotalRecords());
        header.put32(Offset.DELCOUNT.get(version), (int)visionFile.getDeletedRecords());
        header.put32(Offset.NEXTUNIQ.get(version), (int)visionFile.getNextUniqueId());
        header.put32(Offset.IVERSION.get(version), (int)visionFile.getTreeVersion());
        if (version < 5) {
            header.put32(Offset.NODE_USAGE.get(version), (int)visionFile.getNodeUsage());
        } else {
            header.put48(Offset.NODE_USAGE.get(version), visionFile.getNodeUsage());
            header.put32(Offset.ABCOUNT.get(version), (int)visionFile.getAbandonedRecords());
        }
        header.put16(Offset.FREEFAILS.get(version), (short)visionFile.getFreeFailures());
        header.put16(Offset.UPDATING.get(version), (short)0);
        FileDescriptor segment = this.retrieveSegment(visionFile, BlockType.DATA, 0);
        fileSystemCache.seek(segment, 0L);
        fileSystemCache.write(segment, header, 0, Offset.PHDR_SIZE.get(version), CacheDataType.HEADER);
    }

    protected FileDescriptor retrieveSegment(File visionFile, BlockType type, int segment) {
        if (visionFile.getVersion() > 3) {
            if (type == BlockType.NODE) {
                return visionFile.getIndexFile().getSegment(segment);
            }
            return visionFile.getSegment(segment);
        }
        return visionFile.getSegment(0);
    }

    private boolean updateSegmentSize(File visionFile, BlockType type, FileAddress endAddress) {
        int offset;
        Block buffer;
        int version = visionFile.getVersion();
        if (version < 6) {
            buffer = new Block(4);
            buffer.put32(0, (int)endAddress.getOffset());
        } else {
            buffer = new Block(6);
            buffer.put48(0, endAddress.getOffset());
        }
        if (type == BlockType.NODE) {
            visionFile.getIndexFile().setSegmentSize(endAddress.getSegment(), endAddress.getOffset());
            offset = Offset.I_FILESIZE.get(version);
        } else {
            visionFile.setSegmentSize(endAddress.getSegment(), endAddress.getOffset());
            if (endAddress.getSegment() > 0) {
                offset = Offset.D_FILESIZE.get(version);
            } else {
                offset = Offset.FILESIZE.get(version);
                visionFile.getHeaderCache().copy(offset, buffer, 0, buffer.size());
            }
        }
        FileDescriptor lastSegment = this.retrieveSegment(visionFile, type, endAddress.getSegment());
        FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
        fileSystemCache.seek(lastSegment, offset);
        return fileSystemCache.write(lastSegment, buffer, CacheDataType.HEADER) == buffer.size();
    }

    private boolean createAdditionalSegment(File visionFile, BlockType type) {
        FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
        SegmentedFile segmentedFile = visionFile;
        if (type == BlockType.NODE) {
            segmentedFile = visionFile.getIndexFile();
        }
        if (segmentedFile.getSegmentCount() >= 65535) {
            this.status.setErrno(6);
            this.status.setIntErrno(99);
            return false;
        }
        int index = segmentedFile.getSegmentCount();
        String newSegmentName = this.getSegmentName(visionFile.getName(), type, index);
        FileDescriptor newSegment = fileSystemCache.open(newSegmentName, 1);
        if (newSegment == null) {
            this.status.setErrno(1);
            return false;
        }
        fileSystemCache.close(newSegment);
        newSegment = fileSystemCache.open(newSegmentName, this.standardizeOpenMode(visionFile.getOpenMode()));
        if (newSegment == null) {
            this.status.setErrno(1);
            return false;
        }
        int version = visionFile.getVersion();
        Block header = new Block(512);
        if (type == BlockType.NODE) {
            header.put32(Offset.I_MAGIC.get(version), 269620248);
            header.put16(Offset.I_VERSION.get(version), (short)version);
            header.put16(Offset.I_SEGNUM.get(version), (short)index);
            header.put32(Offset.I_FILESIZE.get(version), 512);
        } else {
            header.put32(Offset.D_MAGIC.get(version), 269620247);
            header.put16(Offset.D_VERSION.get(version), (short)version);
            header.put16(Offset.D_SEGNUM.get(version), (short)index);
            header.put32(Offset.D_FILESIZE.get(version), 512);
        }
        if (fileSystemCache.write(newSegment, header, CacheDataType.HEADER) != 512) {
            return false;
        }
        segmentedFile.addSegment(newSegment);
        segmentedFile.setSegmentSize(index, 512L);
        return true;
    }

    private boolean newBlock(File visionFile, BlockType type) {
        FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
        int version = visionFile.getVersion();
        SegmentedFile segmentedFile = visionFile;
        if (version > 3 && type == BlockType.NODE) {
            segmentedFile = visionFile.getIndexFile();
        }
        int extensionFactor = visionFile.getPhysicalAttributes().getExtensionFactor();
        if (type == BlockType.NODE && (extensionFactor = (int)((double)extensionFactor * ((double)this.config.V_INDEX_BLOCK_PERCENT.getIntegerValue() / 100.0) + 0.5)) < 1) {
            extensionFactor = 1;
        }
        FileAddress nextBlock = segmentedFile.getNextBlock();
        FileAddress endingBlock = nextBlock.copy();
        FileDescriptor lastSegment = this.retrieveSegment(visionFile, type, nextBlock.getSegment());
        fileSystemCache.seek(lastSegment, nextBlock.getOffset());
        CacheDataType cacheType = type == BlockType.NODE ? CacheDataType.INDEX : CacheDataType.RECORD;
        int blockingFactor = visionFile.getPhysicalAttributes().getBlockingFactor();
        FileAddress fileSize = segmentedFile.getFileSize();
        Block block = new Block(512);
        if (nextBlock.ge(fileSize)) {
            for (int i = 0; i < extensionFactor; ++i) {
                if (version == 3) {
                    block.put8(0, i == 0 ? type.getVal() : BlockType.EMPTY.getVal());
                }
                int sectorCounter = 0;
                boolean changedSegment = false;
                for (int y = 0; y < blockingFactor; ++y) {
                    if ((version == 4 || version == 5) && endingBlock.getOffset() > visionFile.getMaxSegmentSize() - 512L) {
                        if (!this.updateSegmentSize(visionFile, type, endingBlock)) {
                            this.status.setErrno(1);
                            return false;
                        }
                        if (!this.createAdditionalSegment(visionFile, type)) {
                            return false;
                        }
                        endingBlock.incSegment();
                        endingBlock.setOffset(512L);
                        lastSegment = this.retrieveSegment(visionFile, type, endingBlock.getSegment());
                        fileSystemCache.seek(lastSegment, endingBlock.getOffset());
                        y -= sectorCounter;
                        changedSegment = true;
                    }
                    if (!changedSegment) {
                        ++sectorCounter;
                    }
                    if (fileSystemCache.write(lastSegment, block, cacheType) != 512) {
                        return false;
                    }
                    endingBlock.incOffset(512L);
                    block.put8(0, (byte)0);
                }
            }
            fileSize.copyFrom(endingBlock);
            if (version > 3 && !this.updateSegmentSize(visionFile, type, fileSize)) {
                this.status.setErrno(1);
                return false;
            }
        } else if (version == 3 && type != BlockType.NODE) {
            block.put8(0, type.getVal());
            fileSystemCache.write(lastSegment, block, 0, 1, cacheType);
        }
        Block header = visionFile.getHeaderCache();
        int totalBLockSize = blockingFactor * 512;
        if (version == 3) {
            nextBlock.incOffset(totalBLockSize);
            header.put32(Offset.NXTBLK_OFF.get(version), (int)nextBlock.getOffset());
        } else {
            if (version < 6 && nextBlock.getOffset() > visionFile.getMaxSegmentSize() - (long)totalBLockSize) {
                nextBlock.incSegment();
                nextBlock.setOffset(512 + totalBLockSize);
            } else {
                nextBlock.incOffset(totalBLockSize);
            }
            if (type == BlockType.NODE) {
                if (version < 6) {
                    header.put32(Offset.I_NXTBLK_OFF.get(version), (int)nextBlock.getOffset());
                    header.put16(Offset.I_NXTBLK_SEG.get(version), (short)nextBlock.getSegment());
                } else {
                    header.put48(Offset.I_NXTBLK_OFF.get(version), nextBlock.getOffset());
                }
            } else if (version < 6) {
                header.put32(Offset.NXTBLK_OFF.get(version), (int)nextBlock.getOffset());
                header.put16(Offset.NXTBLK_SEG.get(version), (short)nextBlock.getSegment());
            } else {
                header.put48(Offset.NXTBLK_OFF.get(version), nextBlock.getOffset());
            }
        }
        return true;
    }

    protected FileAddress getRecord(File visionFile, Block buffer, int size, FileAddress source, boolean skipFirstByte) {
        FileAddress address;
        block9: {
            FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
            address = source.copy();
            int bufferOffset = 0;
            if (skipFirstByte) {
                address.incOffset(1L);
                --size;
                bufferOffset = 1;
            }
            if (address.getOffset() < 0L) {
                this.status.setErrno(6);
                this.status.setIntErrno(83);
                address.initialize();
                return address;
            }
            if (address.getSegment() >= visionFile.getSegmentCount()) {
                this.status.setErrno(6);
                this.status.setIntErrno(83);
                address.initialize();
                return address;
            }
            FileDescriptor segment = this.retrieveSegment(visionFile, BlockType.DATA, address.getSegment());
            if (visionFile.getVersion() == 3) {
                Block nextBlock = new Block(4);
                int blockSize = visionFile.getBlockSize();
                do {
                    int readAmount = Math.min(size, blockSize - (int)(address.getOffset() % (long)blockSize) - 4);
                    fileSystemCache.seek(segment, address.getOffset());
                    if (readAmount > 0 && fileSystemCache.read(segment, buffer, bufferOffset, readAmount, CacheDataType.RECORD) != readAmount) {
                        this.status.setErrno(6);
                        this.status.setIntErrno(83);
                        address.initialize();
                        return address;
                    }
                    bufferOffset += readAmount;
                    if ((size -= readAmount) == 0) {
                        address.incOffset(readAmount);
                        break block9;
                    }
                    if (fileSystemCache.read(segment, nextBlock, CacheDataType.RECORD) != 4) {
                        this.status.setErrno(6);
                        this.status.setIntErrno(83);
                        address.initialize();
                        return address;
                    }
                    address.setOffset(nextBlock.get32(0) + 1);
                } while (address.getOffset() > 1L);
                this.status.setErrno(6);
                this.status.setIntErrno(83);
                address.initialize();
                return address;
            }
            fileSystemCache.seek(segment, address.getOffset());
            if (fileSystemCache.read(segment, buffer, bufferOffset, size, CacheDataType.RECORD) != size) {
                this.status.setErrno(6);
                this.status.setIntErrno(83);
                address.initialize();
                return address;
            }
            address.incOffset(size);
        }
        return address;
    }

    protected int getRecordWithLock(File visionFile, byte[] record, FileAddress recordAddress, RecordHeader recordHeader, LockType lockType) {
        FileAddress nextAddress;
        int i;
        int mod;
        this.unlockRecord(visionFile);
        int size = visionFile.getBlockSize();
        if (visionFile.getVersion() == 3 && (mod = size - (int)(recordAddress.getOffset() % (long)size)) == 4) {
            this.status.setErrno(6);
            this.status.setIntErrno(31);
            return 0;
        }
        boolean exclusive = (visionFile.getOpenMode() & 0x300) != 0;
        boolean noLock = this.isInputOnly(visionFile.getOpenMode()) || exclusive || this.config.F_NO_LOCK == 1;
        boolean keepLock = !noLock && this.config.F_NO_LOCK == 0;
        boolean alreadyLockedByUs = false;
        Lock[] locks = visionFile.getLocks();
        int maxLocks = locks.length;
        if (!noLock && maxLocks > 1) {
            for (i = 0; i < maxLocks && locks[i] != null; ++i) {
                if (!locks[i].getAddress().eq(recordAddress)) continue;
                keepLock = false;
                locks[i].updateType(lockType);
                alreadyLockedByUs = true;
                break;
            }
            if (!alreadyLockedByUs && i >= maxLocks) {
                this.status.setErrno(18);
                this.status.setIntErrno(3);
                return 0;
            }
        }
        if (!noLock && !alreadyLockedByUs) {
            Lock lock = this.createLock(visionFile, recordAddress, lockType);
            if (lock == null) {
                return 0;
            }
            if (keepLock) {
                locks[i] = lock;
            } else {
                lock.release();
            }
        }
        if (record == null) {
            return size;
        }
        boolean avoidEnforcedLock = this.isInputOnly(visionFile.getOpenMode()) || this.config.F_NO_LOCK > 0;
        Block recordBuffer = visionFile.getRecord();
        LogicalAttributes logicalAttributes = visionFile.getLogicalAttributes();
        if (logicalAttributes.getMinRecordSize() < logicalAttributes.getMaxRecordSize() || logicalAttributes.isCompressed()) {
            nextAddress = this.getRecord(visionFile, recordBuffer, visionFile.getRecordOverhead(), recordAddress, avoidEnforcedLock);
            if (nextAddress.isZero()) {
                if (keepLock) {
                    locks[i].release();
                    locks[i] = null;
                }
                return 0;
            }
            this.unpackRecordHeader(visionFile, recordBuffer, recordHeader);
            if (recordHeader.getStatus() != RecordStatus.NO_STATUS || recordHeader.getUsed() > logicalAttributes.getMaxRecordSize() || recordHeader.getUsed() <= 0) {
                this.status.setErrno(6);
                this.status.setIntErrno(81);
                if (keepLock) {
                    locks[i].release();
                    locks[i] = null;
                }
                return 0;
            }
            boolean compressed = logicalAttributes.isCompressed() && !recordHeader.isUncompressed();
            nextAddress = this.getRecord(visionFile, compressed ? visionFile.getCompressedRecord() : recordBuffer, visionFile.getRecordOverhead() + recordHeader.getUsed(), recordAddress, avoidEnforcedLock);
            if (nextAddress.isZero()) {
                if (keepLock) {
                    locks[i].release();
                    locks[i] = null;
                }
                return 0;
            }
            if (compressed) {
                size = this.inflate(visionFile, recordBuffer, visionFile.getRecordOverhead(), recordHeader.getUsed());
                if (size == 0) {
                    this.status.setErrno(6);
                    this.status.setIntErrno(85);
                    if (keepLock) {
                        locks[i].release();
                        locks[i] = null;
                    }
                    return 0;
                }
            } else {
                size = recordHeader.getUsed();
            }
        } else {
            nextAddress = this.getRecord(visionFile, recordBuffer, recordBuffer.size(), recordAddress, avoidEnforcedLock);
            if (nextAddress.isZero()) {
                if (keepLock) {
                    locks[i].release();
                    locks[i] = null;
                }
                return 0;
            }
            this.unpackRecordHeader(visionFile, recordBuffer, recordHeader);
            if (recordHeader.getStatus() != RecordStatus.NO_STATUS || recordHeader.getUsed() > logicalAttributes.getMaxRecordSize()) {
                this.status.setErrno(6);
                this.status.setIntErrno(82);
                if (keepLock) {
                    locks[i].release();
                    locks[i] = null;
                }
                return 0;
            }
            size = recordHeader.getUsed();
        }
        System.arraycopy(recordBuffer.getBytes(), visionFile.getRecordOverhead(), record, 0, Math.min(record.length, size));
        if (keepLock || exclusive) {
            visionFile.getCurrentRecord().copyFrom(recordAddress);
            KeyInfo pk = logicalAttributes.getKey(0);
            int storeOffset = 0;
            for (int n = 0; n < pk.getSegments(); ++n) {
                int segmentSize = pk.getSize(n);
                visionFile.getCurrentPrimaryKey().copy(storeOffset, record, pk.getOffset(n), segmentSize);
                storeOffset += segmentSize;
            }
            if (keepLock && this.config.V_INTERNAL_LOCKS.isOff()) {
                this.extendLock(visionFile, locks[i], nextAddress);
            }
        }
        return size;
    }

    protected FileAddress setRecord(File visionFile, Block buffer, int size, FileAddress destination, boolean appendMode) {
        FileAddress address;
        block16: {
            FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
            address = destination.copy();
            FileDescriptor segment = this.retrieveSegment(visionFile, BlockType.DATA, address.getSegment());
            int version = visionFile.getVersion();
            if (version == 3) {
                int bufferOffset = 0;
                Block nextBlock = new Block(4);
                int blockSize = visionFile.getBlockSize();
                while (true) {
                    fileSystemCache.seek(segment, address.getOffset());
                    int writeAmount = Math.min(size, blockSize - (int)(address.getOffset() % (long)blockSize) - 4);
                    if (writeAmount > 0 && fileSystemCache.write(segment, buffer, bufferOffset, writeAmount, CacheDataType.RECORD) != writeAmount) {
                        address.initialize();
                        return address;
                    }
                    if ((size -= writeAmount) == 0) {
                        address.incOffset(writeAmount);
                        break block16;
                    }
                    bufferOffset += writeAmount;
                    if (appendMode) {
                        address = visionFile.getNextBlock().copy();
                        nextBlock.put32(0, (int)address.getOffset());
                        address.incOffset(1L);
                        fileSystemCache.write(segment, nextBlock, CacheDataType.RECORD);
                        if (!this.newBlock(visionFile, BlockType.DATA)) {
                            address.initialize();
                            return address;
                        }
                    } else {
                        if (fileSystemCache.read(segment, nextBlock, CacheDataType.RECORD) != 4) {
                            this.status.setErrno(6);
                            this.status.setIntErrno(86);
                            address.initialize();
                            return address;
                        }
                        address.setOffset(nextBlock.get32(0) + 1);
                    }
                    if (writeAmount != 0) continue;
                    destination.copyFrom(address);
                }
            }
            if (appendMode) {
                int spaceLeft;
                int appendAmount = 0;
                long offset = address.getOffset();
                int blockSize = visionFile.getBlockSize();
                if (version < 6) {
                    long segmentSize = visionFile.getMaxSegmentSize();
                    if (offset > segmentSize - (long)size) {
                        appendAmount = (int)((long)appendAmount + ((segmentSize - offset) / (long)blockSize + 1L));
                        address.incSegment();
                        address.setOffset(512L);
                        destination.copyFrom(address);
                    }
                    if (address.getSegment() > 0) {
                        offset = address.getOffset() - 512L;
                    }
                }
                if (size >= (spaceLeft = blockSize - (int)(offset % (long)blockSize))) {
                    appendAmount += (size - spaceLeft) / blockSize + 1;
                }
                while (appendAmount-- > 0) {
                    if (this.newBlock(visionFile, BlockType.DATA)) continue;
                    address.initialize();
                    return address;
                }
                if (version < 6) {
                    segment = this.retrieveSegment(visionFile, BlockType.DATA, address.getSegment());
                }
            }
            fileSystemCache.seek(segment, address.getOffset());
            if (fileSystemCache.write(segment, buffer, 0, size, CacheDataType.RECORD) != size) {
                address.initialize();
                return address;
            }
            address.incOffset(size);
        }
        return address;
    }

    private void unpackRecordHeader(File visionFile, Block buffer, RecordHeader recordHeader) {
        int version = visionFile.getVersion();
        if (version < 5) {
            recordHeader.setSize(buffer.get16(0) & 0xFFFF);
            short used = buffer.get16(2);
            if ((used & 0x8000) != 0) {
                recordHeader.setUncompressed(true);
                used = (short)(used & Short.MAX_VALUE);
            }
            recordHeader.setUsed(used);
            recordHeader.setUniqueId(visionFile.getLogicalAttributes().getDuplicates() > 0 ? (long)buffer.get32(4) & 0xFFFFFFFFL : 0L);
            recordHeader.setStatus(recordHeader.getUsed() == 0 ? RecordStatus.DELETED : RecordStatus.NO_STATUS);
            recordHeader.getNextDeleted().initialize();
        } else {
            recordHeader.setSize(buffer.get32(0));
            recordHeader.setUsed(buffer.get32(4));
            byte status = buffer.get8(8);
            if ((status & 4) != 0) {
                recordHeader.setUncompressed(true);
            }
            recordHeader.setStatus(RecordStatus.from(status));
            if (recordHeader.getStatus() == RecordStatus.NO_STATUS) {
                recordHeader.setUniqueId(visionFile.getLogicalAttributes().getDuplicates() > 0 ? (long)buffer.get32(9) & 0xFFFFFFFFL : 0L);
                recordHeader.getNextDeleted().initialize();
            } else {
                FileAddress nextRec = new FileAddress();
                if (version < 6) {
                    nextRec.setOffset((long)buffer.get32(9) & 0xFFFFFFFFL);
                    nextRec.setSegment(buffer.get16(13) & 0xFFFF);
                } else {
                    nextRec.setOffset(buffer.get48(9));
                }
                recordHeader.getNextDeleted().copyFrom(nextRec);
                recordHeader.setUniqueId(0L);
            }
        }
    }

    private void packRecordHeader(File visionFile, Block buffer, RecordHeader recordHeader) {
        int version = visionFile.getVersion();
        if (version < 5) {
            buffer.put16(0, (short)recordHeader.getSize());
            if (recordHeader.getStatus() == RecordStatus.NO_STATUS) {
                short used = (short)recordHeader.getUsed();
                if (recordHeader.isUncompressed()) {
                    used = (short)(used | 0x8000);
                }
                buffer.put16(2, used);
                if (visionFile.getLogicalAttributes().getDuplicates() > 0) {
                    buffer.put32(4, (int)recordHeader.getUniqueId());
                }
            } else {
                buffer.put16(2, (short)0);
                if (visionFile.getLogicalAttributes().getDuplicates() > 0) {
                    buffer.put32(4, 0);
                }
            }
        } else {
            buffer.put32(0, recordHeader.getSize());
            buffer.put32(4, recordHeader.getUsed());
            byte status = recordHeader.getStatus().getVal();
            if (recordHeader.isUncompressed()) {
                status = (byte)(status | 4);
            }
            buffer.put8(8, status);
            if (recordHeader.getStatus() == RecordStatus.NO_STATUS) {
                if (visionFile.getLogicalAttributes().getDuplicates() > 0) {
                    buffer.put32(9, (int)recordHeader.getUniqueId());
                }
            } else if (version < 6) {
                buffer.put32(9, (int)recordHeader.getNextDeleted().getOffset());
                buffer.put16(13, (short)recordHeader.getNextDeleted().getSegment());
            } else {
                buffer.put48(9, recordHeader.getNextDeleted().getOffset());
            }
        }
    }

    private int fileAddressSize(int version) {
        switch (version) {
            case 3: {
                return 4;
            }
            case 4: 
            case 5: {
                return 6;
            }
        }
        return 6;
    }

    private int checkMinRecordSize(int version, int sizeToEvaluate) {
        switch (version) {
            case 3: {
                return Math.max(sizeToEvaluate, 4);
            }
            case 4: {
                return Math.max(sizeToEvaluate, 6);
            }
            case 5: 
            case 6: {
                return Math.max(sizeToEvaluate, 1);
            }
        }
        return sizeToEvaluate;
    }

    protected boolean loadNode(File visionFile, FileAddress address) {
        FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
        FileAddress currentBlock = visionFile.getCurrentNode();
        if (!address.eq(currentBlock)) {
            FileDescriptor segment = this.retrieveSegment(visionFile, BlockType.NODE, address.getSegment());
            fileSystemCache.seek(segment, address.getOffset());
            if (fileSystemCache.read(segment, visionFile.getLoadedNode(), CacheDataType.INDEX) != visionFile.getBlockSize()) {
                currentBlock.invalidate();
                return false;
            }
            currentBlock.copyFrom(address);
        }
        return true;
    }

    protected void buildKey(File visionFile, int keyNum, byte[] record, Block keyBuffer) {
        KeyInfo keyInfo = visionFile.getLogicalAttributes().getKey(keyNum);
        keyBuffer.put8(0, (byte)(keyInfo.getTotalSize() + 1));
        keyBuffer.put8(1, (byte)keyNum);
        int offset = 2;
        for (int i = 0; i < keyInfo.getSegments(); ++i) {
            int segmentSize;
            int segmentOffset = keyInfo.getOffset(i);
            if (visionFile.hasCollate()) {
                for (segmentSize = keyInfo.getSize(i); segmentSize > 0; --segmentSize) {
                    keyBuffer.put8(offset++, visionFile.collate(record[segmentOffset++] & 0xFF));
                }
                continue;
            }
            keyBuffer.copy(offset, record, segmentOffset, segmentSize);
            offset += segmentSize;
        }
    }

    private long getKeyInfoOffset(File visionFile, int keyNumber) {
        int version = visionFile.getVersion();
        int keyInfoSize = Offset.KEY_MULT.get(version);
        int keysInTheFirstSector = Offset.BLK_1_KEYS.get(version);
        int keysInSector = Offset.BLK_N_KEYS.get(version);
        if (version == 3 || keyNumber < keysInTheFirstSector) {
            return (long)Offset.KEYINFO.get(version) + (long)keyNumber * (long)keyInfoSize;
        }
        long offset = 512L;
        return (offset += (long)((keyNumber -= keysInTheFirstSector) / keysInSector) * 512L) + (long)(keyNumber %= keysInSector) * (long)keyInfoSize;
    }

    private boolean saveNode(File visionFile, Block nodeBuffer, FileAddress address) {
        nodeBuffer.put8(0, BlockType.NODE.getVal());
        FileDescriptor segment = this.retrieveSegment(visionFile, BlockType.NODE, address.getSegment());
        FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
        fileSystemCache.seek(segment, address.getOffset());
        return fileSystemCache.write(segment, nodeBuffer, CacheDataType.INDEX) == visionFile.getBlockSize();
    }

    protected boolean addKey(File visionFile, Block keyBuffer, FileAddress recordAddress, long uniqueId, boolean duplicates) {
        FindKeyResult result;
        KeyEntry output = new KeyEntry();
        do {
            if ((result = this.findKey(visionFile, keyBuffer, uniqueId, output)) != FindKeyResult.EMPTY) continue;
            FileAddress zeroAddress = new FileAddress();
            FileAddress rootAddress = new FileAddress();
            Block nodeBuffer = new Block(visionFile.getBlockSize());
            this.makeRoot(visionFile, nodeBuffer, zeroAddress, rootAddress);
            if (!rootAddress.isZero() && this.saveNode(visionFile, nodeBuffer, rootAddress)) continue;
            return false;
        } while (result == FindKeyResult.EMPTY);
        if (result == FindKeyResult.ERROR) {
            return false;
        }
        if (!duplicates && result.fastCompare(FindKeyResult.KEY_MATCH) >= 0) {
            this.status.setErrno(7);
            return false;
        }
        if (result == FindKeyResult.FULL_MATCH) {
            this.status.setErrno(6);
            this.status.setIntErrno(3);
            return false;
        }
        return this.insertKey(visionFile, keyBuffer, uniqueId, recordAddress, output);
    }

    protected boolean deleteKey(File visionFile, Block fullKey, long uniqueId) {
        KeyEntry keyEntry = new KeyEntry();
        FindKeyResult result = this.findKey(visionFile, fullKey, uniqueId, keyEntry);
        if (result == FindKeyResult.ERROR) {
            return false;
        }
        if (result != FindKeyResult.FULL_MATCH) {
            this.status.setErrno(6);
            this.status.setIntErrno(6);
            return false;
        }
        return this.deleteKeyEntry(visionFile, keyEntry);
    }

    private boolean deleteKeyEntry(File visionFile, KeyEntry keyEntry) {
        CombineMode combineResult = CombineMode.NONE;
        boolean wasLastInNode = this.deleteKeyEntryFromLoadedNode(visionFile, keyEntry.getPhysicalKeyOffset());
        int used = visionFile.getLoadedNode().get16(1) & 0xFFFF;
        if (used < (visionFile.getBlockSize() - 3) / 3) {
            combineResult = this.combineNodes(visionFile, keyEntry);
            if (combineResult == CombineMode.ERROR) {
                return false;
            }
            used = visionFile.getLoadedNode().get16(1) & 0xFFFF;
        }
        if (used == 0) {
            return true;
        }
        if (visionFile.getCurrentNode().gtZero()) {
            this.saveNode(visionFile, visionFile.getLoadedNode(), visionFile.getCurrentNode());
        }
        if (wasLastInNode && combineResult != CombineMode.RIGHT && keyEntry.getKeyDepth() > 0) {
            int parentIndex = keyEntry.getKeyDepth() - 1;
            FileAddress parentAddress = visionFile.getNodeAddresses()[parentIndex];
            if (parentAddress.isValid()) {
                return this.refreshLastKey(visionFile, parentAddress, keyEntry.getNodeAddress(), parentIndex);
            }
        }
        return true;
    }

    private boolean refreshLastKey(File visionFile, FileAddress parentAddress, FileAddress childAddress, int keyDepth) {
        if (!this.loadNode(visionFile, childAddress)) {
            return false;
        }
        Block fullKey = new Block(252);
        Block loadedNode = visionFile.getLoadedNode();
        int used = loadedNode.get16(1) & 0xFFFF;
        long uniqueId = this.getFullKey(visionFile, used - 1, loadedNode, fullKey);
        KeyEntry keyEntry = new KeyEntry();
        if (!this.findMe(visionFile, parentAddress, childAddress, keyEntry)) {
            return false;
        }
        boolean wasLastKey = this.deleteKeyEntryFromLoadedNode(visionFile, keyEntry.getPhysicalKeyOffset());
        KeyEntry newEntry = new KeyEntry();
        newEntry.setKeyOffset(keyEntry.getKeyOffset());
        newEntry.getNodeAddress().copyFrom(parentAddress);
        newEntry.setKeyDepth(keyDepth);
        if (!this.insertKey(visionFile, fullKey, uniqueId, childAddress, newEntry)) {
            return false;
        }
        if (wasLastKey && keyDepth > 0) {
            return this.refreshLastKey(visionFile, visionFile.getNodeAddresses()[keyDepth - 1], newEntry.getNodeAddress(), keyDepth - 1);
        }
        return true;
    }

    private CombineMode combineNodes(File visionFile, KeyEntry keyEntry) {
        int limit;
        CombineMode result = CombineMode.LEFT;
        Block loadedNode = visionFile.getLoadedNode();
        if (keyEntry.getKeyDepth() <= 0) {
            if ((loadedNode.get8(3 + visionFile.getKeyEntryOffset() + 2) & 0xFF) == 127) {
                FileAddress leftAddress = new FileAddress();
                this.getLeftAddress(visionFile, loadedNode, 3, leftAddress);
                int version = visionFile.getVersion();
                Block newKeyRoot = new Block(this.fileAddressSize(version) + 1);
                visionFile.getHeaderCache().put32(Offset.ROOT_VERS.get(version), (int)visionFile.incKeyRootVersion());
                int keyNum = visionFile.getFindKeyNum();
                KeyInfo keyInfo = visionFile.getLogicalAttributes().getKey(keyNum);
                keyInfo.getKeyRoot().copyFrom(leftAddress);
                if (version < 6) {
                    newKeyRoot.put32(0, (int)leftAddress.getOffset());
                    if (version == 4 || version == 5) {
                        newKeyRoot.put16(4, (short)leftAddress.getSegment());
                    }
                } else {
                    newKeyRoot.put48(0, leftAddress.getOffset());
                }
                newKeyRoot.put8(Offset.KEYHEIGHT.get(version), (byte)keyInfo.decHeight());
                FileDescriptor segment = this.retrieveSegment(visionFile, BlockType.DATA, 0);
                FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
                fileSystemCache.seek(segment, this.getKeyInfoOffset(visionFile, keyNum));
                fileSystemCache.write(segment, newKeyRoot, CacheDataType.HEADER);
                int used = loadedNode.get16(1) & 0xFFFF;
                visionFile.decNodeUsage(used);
                this.freeCurrentNode(visionFile);
                visionFile.getNodeAddresses()[0].invalidate();
            }
            return CombineMode.NONE;
        }
        Block oldNode = new Block(loadedNode.size());
        oldNode.copy(0, loadedNode, 0, loadedNode.size());
        KeyEntry me = new KeyEntry();
        FileAddress parentNodeAddress = visionFile.getNodeAddresses()[keyEntry.getKeyDepth() - 1];
        if (!this.findMe(visionFile, parentNodeAddress, keyEntry.getNodeAddress(), me)) {
            return CombineMode.ERROR;
        }
        loadedNode = visionFile.getLoadedNode();
        int physicalRightSiblingOffset = me.getPhysicalKeyOffset() + visionFile.getKeyEntryOverhead() + (loadedNode.get8(me.getPhysicalKeyOffset() + visionFile.getKeyEntryOffset()) & 0xFF);
        if (physicalRightSiblingOffset >= (limit = (loadedNode.get16(1) & 0xFFFF) + 3)) {
            physicalRightSiblingOffset = -1;
        }
        boolean onlyRemoveFromParent = false;
        if (oldNode.get16(1) == 0) {
            result = CombineMode.RIGHT;
            onlyRemoveFromParent = true;
        }
        FileAddress rightNodeAddress = new FileAddress();
        FileAddress leftNodeAddress = new FileAddress();
        FileAddress newNodeAddress = new FileAddress();
        Block newNode = new Block(visionFile.getBlockSize());
        if (!onlyRemoveFromParent) {
            boolean directionFound = false;
            if (me.getPreviousKeyOffset() >= 0) {
                this.getLeftAddress(visionFile, loadedNode, me.getPreviousPhysicalKeyOffset(), leftNodeAddress);
            }
            if (physicalRightSiblingOffset >= 0) {
                this.getLeftAddress(visionFile, loadedNode, physicalRightSiblingOffset, rightNodeAddress);
            }
            int oldNodeUsed = oldNode.get16(1) & 0xFFFF;
            int siblingNodeUsed = 0;
            if (physicalRightSiblingOffset >= 0) {
                if (!this.loadNode(visionFile, rightNodeAddress)) {
                    return CombineMode.ERROR;
                }
                loadedNode = visionFile.getLoadedNode();
                siblingNodeUsed = loadedNode.get16(1) & 0xFFFF;
                if (siblingNodeUsed + oldNodeUsed <= visionFile.getBlockSize() - 3) {
                    result = CombineMode.RIGHT;
                    directionFound = true;
                }
            }
            if (!directionFound && me.getPreviousKeyOffset() >= 0) {
                if (!this.loadNode(visionFile, leftNodeAddress)) {
                    return CombineMode.ERROR;
                }
                loadedNode = visionFile.getLoadedNode();
                siblingNodeUsed = loadedNode.get16(1) & 0xFFFF;
                if (siblingNodeUsed + oldNodeUsed <= visionFile.getBlockSize() - 3) {
                    directionFound = true;
                }
            }
            if (!directionFound) {
                visionFile.getLoadedNode().copy(0, oldNode, 0, oldNode.size());
                visionFile.getCurrentNode().copyFrom(keyEntry.getNodeAddress());
                return CombineMode.NONE;
            }
            this.makeNewNode(visionFile, newNodeAddress);
            if (newNodeAddress.isZero()) {
                return CombineMode.ERROR;
            }
            if (result == CombineMode.RIGHT) {
                newNode.copy(3, oldNode, 3, oldNodeUsed);
                newNode.copy(3 + oldNodeUsed, loadedNode, 3, siblingNodeUsed);
            } else {
                newNode.copy(3, loadedNode, 3, siblingNodeUsed);
                newNode.copy(3 + siblingNodeUsed, oldNode, 3, oldNodeUsed);
            }
            newNode.put16(1, (short)(oldNodeUsed + siblingNodeUsed));
            this.saveNode(visionFile, newNode, newNodeAddress);
            this.loadNode(visionFile, parentNodeAddress);
            loadedNode = visionFile.getLoadedNode();
            this.setLeftBranch(visionFile, loadedNode, result == CombineMode.RIGHT ? physicalRightSiblingOffset : me.getPhysicalKeyOffset(), newNodeAddress);
            this.saveNode(visionFile, loadedNode, parentNodeAddress);
        }
        KeyEntry toBeDeleted = new KeyEntry();
        toBeDeleted.getNodeAddress().copyFrom(parentNodeAddress);
        toBeDeleted.setPhysicalKeyOffset(result == CombineMode.RIGHT ? me.getPhysicalKeyOffset() : me.getPreviousPhysicalKeyOffset());
        toBeDeleted.setKeyDepth(keyEntry.getKeyDepth() - 1);
        this.loadNode(visionFile, parentNodeAddress);
        if (!this.deleteKeyEntry(visionFile, toBeDeleted)) {
            return CombineMode.ERROR;
        }
        visionFile.getCurrentNode().copyFrom(keyEntry.getNodeAddress());
        this.freeCurrentNode(visionFile);
        if (!onlyRemoveFromParent) {
            visionFile.getCurrentNode().copyFrom(result == CombineMode.RIGHT ? rightNodeAddress : leftNodeAddress);
            this.freeCurrentNode(visionFile);
            visionFile.getLoadedNode().copy(0, newNode, 0, newNode.size());
            visionFile.getCurrentNode().copyFrom(newNodeAddress);
        }
        keyEntry.getNodeAddress().copyFrom(visionFile.getCurrentNode());
        visionFile.getNodeAddresses()[keyEntry.getKeyDepth()].copyFrom(visionFile.getCurrentNode());
        return result;
    }

    private boolean deleteKeyEntryFromLoadedNode(File visionFile, int physicalOffset) {
        int deltaPrefix;
        boolean lastKeyEntry;
        Block keyBufferToKeep = new Block(253);
        Block nodeBlock = visionFile.getLoadedNode();
        int currentUsage = nodeBlock.get16(1) & 0xFFFF;
        int limit = currentUsage + 3;
        int entryOffset = physicalOffset + visionFile.getKeyEntryOffset();
        int nextPhysicalOffset = physicalOffset + visionFile.getKeyEntryOverhead() + (nodeBlock.get8(entryOffset) & 0xFF);
        if (nextPhysicalOffset >= limit) {
            lastKeyEntry = true;
            deltaPrefix = 0;
        } else {
            int prefix2;
            lastKeyEntry = false;
            int nextEntryOffset = nextPhysicalOffset + visionFile.getKeyEntryOffset();
            int prefix1 = nodeBlock.get8(entryOffset + 1) & 0xFF;
            if (prefix1 >= (prefix2 = nodeBlock.get8(nextEntryOffset + 1) & 0xFF)) {
                deltaPrefix = 0;
            } else {
                deltaPrefix = prefix2 - prefix1;
                keyBufferToKeep.copy(0, nodeBlock, entryOffset + 2, deltaPrefix);
            }
        }
        nodeBlock.shift(nextPhysicalOffset, physicalOffset + deltaPrefix - nextPhysicalOffset, limit - nextPhysicalOffset);
        if (deltaPrefix > 0) {
            nodeBlock.shift(physicalOffset + deltaPrefix, -deltaPrefix, visionFile.getKeyEntryOverhead() + 1);
            nodeBlock.copy(entryOffset + 2, keyBufferToKeep, 0, deltaPrefix);
            nodeBlock.put8(entryOffset, (byte)(nodeBlock.get8(entryOffset) + deltaPrefix));
            nodeBlock.put8(entryOffset + 1, (byte)(nodeBlock.get8(entryOffset + 1) - deltaPrefix));
        }
        int sizeToZeroFill = nextPhysicalOffset - physicalOffset - deltaPrefix;
        nodeBlock.fill(limit - sizeToZeroFill, sizeToZeroFill, (byte)0);
        nodeBlock.put16(1, (short)(currentUsage - sizeToZeroFill));
        visionFile.decNodeUsage(sizeToZeroFill);
        return lastKeyEntry;
    }

    private void makeRoot(File visionFile, Block output, FileAddress rightAddress, FileAddress address) {
        this.makeNewNode(visionFile, address);
        if (address.isZero()) {
            return;
        }
        int version = visionFile.getVersion();
        visionFile.getHeaderCache().put32(Offset.ROOT_VERS.get(version), (int)visionFile.incKeyRootVersion());
        KeyInfo selectedKey = visionFile.getLogicalAttributes().getKey(visionFile.getFindKeyNum());
        selectedKey.getKeyRoot().copyFrom(address);
        Block buffer = new Block(this.fileAddressSize(version) + 1);
        if (version < 6) {
            buffer.put32(Offset.KEYROOT_OFF.get(version), (int)address.getOffset());
            if (version == 4 || version == 5) {
                buffer.put16(Offset.KEYROOT_SEG.get(version), (short)address.getSegment());
            }
        } else {
            buffer.put48(Offset.KEYROOT_OFF.get(version), address.getOffset());
        }
        buffer.put8(Offset.KEYHEIGHT.get(version), (byte)selectedKey.incHeight());
        FileDescriptor segment = this.retrieveSegment(visionFile, BlockType.DATA, 0);
        FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
        fileSystemCache.seek(segment, this.getKeyInfoOffset(visionFile, visionFile.getFindKeyNum()));
        fileSystemCache.write(segment, buffer, CacheDataType.HEADER);
        int nodeUsage = visionFile.getKeyEntryOverhead() + 2;
        output.fill(0, visionFile.getBlockSize(), (byte)0);
        output.put8(0, BlockType.NODE.getVal());
        output.put16(1, (short)nodeUsage);
        int firstKeyEntryOffset = 3;
        if (version < 6) {
            output.put32(firstKeyEntryOffset + Offset.LEFT_OFF.get(version), (int)rightAddress.getOffset());
            if (version == 4 || version == 5) {
                output.put16(firstKeyEntryOffset + Offset.LEFT_SEG.get(version), (short)rightAddress.getSegment());
            }
        } else {
            output.put48(firstKeyEntryOffset + Offset.LEFT_OFF.get(version), rightAddress.getOffset());
        }
        if (this.selectedKeyHasDuplicates(visionFile)) {
            output.put32(firstKeyEntryOffset + Offset.UNIQ.get(version), 0);
        }
        output.put8(firstKeyEntryOffset += visionFile.getKeyEntryOffset(), (byte)2);
        output.put8(firstKeyEntryOffset + 1, (byte)0);
        output.put8(firstKeyEntryOffset + 2, (byte)127);
        visionFile.incNodeUsage(nodeUsage);
    }

    private void makeNewNode(File visionFile, FileAddress address) {
        int version = visionFile.getVersion();
        FileAddress freeNode = visionFile.getFreeNode();
        if (!freeNode.isZero()) {
            int addressSize = this.fileAddressSize(version);
            Block buffer = new Block(1 + addressSize);
            FileDescriptor segment = this.retrieveSegment(visionFile, BlockType.NODE, freeNode.getSegment());
            FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
            fileSystemCache.seek(segment, freeNode.getOffset());
            if (fileSystemCache.read(segment, buffer, CacheDataType.INDEX) != 1 + addressSize) {
                return;
            }
            FileAddress nextFreeNode = new FileAddress();
            byte blockType = buffer.get8(0);
            if (version < 6) {
                nextFreeNode.setOffset((long)buffer.get32(1) & 0xFFFFFFFFL);
            } else {
                nextFreeNode.setOffset(buffer.get48(1));
            }
            if (version == 4 || version == 5) {
                nextFreeNode.setSegment(buffer.get16(5) & 0xFFFF);
            } else {
                nextFreeNode.setSegment(0);
            }
            if (blockType != BlockType.FREENODE.getVal()) {
                this.status.setErrno(6);
                this.status.setIntErrno(12);
                return;
            }
            address.copyFrom(freeNode);
            freeNode.copyFrom(nextFreeNode);
            visionFile.decFreeNodes();
            Block header = visionFile.getHeaderCache();
            if (version < 6) {
                header.put32(Offset.FREENODE_OFF.get(version), (int)freeNode.getOffset());
            } else {
                header.put48(Offset.FREENODE_OFF.get(version), freeNode.getOffset());
            }
            if (version == 4 || version == 5) {
                header.put16(Offset.FREENODE_SEG.get(version), (short)freeNode.getSegment());
            }
            if (version < 5) {
                header.put16(Offset.NODES_FREE.get(version), (short)visionFile.getFreeNodes());
            } else if (version == 5) {
                header.put32(Offset.NODES_FREE.get(version), (int)visionFile.getFreeNodes());
            } else {
                header.put48(Offset.NODES_FREE.get(version), visionFile.getFreeNodes());
            }
        } else {
            if (version == 3) {
                address.copyFrom(visionFile.getNextBlock());
            } else {
                address.copyFrom(visionFile.getIndexFile().getNextBlock());
                if (version < 6 && address.getOffset() > visionFile.getMaxSegmentSize() - (long)visionFile.getBlockSize()) {
                    address.setOffset(512L);
                    address.incSegment();
                }
            }
            if (!this.newBlock(visionFile, BlockType.NODE)) {
                address.initialize();
                return;
            }
        }
        visionFile.incUsedNodes();
        Block header = visionFile.getHeaderCache();
        if (version < 5) {
            header.put16(Offset.NODES_USED.get(version), (short)visionFile.getUsedNodes());
        } else if (version == 5) {
            header.put32(Offset.NODES_USED.get(version), (int)visionFile.getUsedNodes());
        } else {
            header.put48(Offset.NODES_USED.get(version), visionFile.getUsedNodes());
        }
    }

    private boolean insertKey(File visionFile, Block keyBuffer, long uniqueId, FileAddress leftAddress, KeyEntry keyEntry) {
        int entrySize;
        int prefix;
        int physicalOffset;
        boolean notFits;
        Block nodeBlock = visionFile.getLoadedNode();
        Block prevKeyBuffer = new Block(252);
        int limit = (nodeBlock.get16(1) & 0xFFFF) + 3;
        do {
            physicalOffset = keyEntry.getPhysicalKeyOffset();
            this.getFullKey(visionFile, physicalOffset - 1, nodeBlock, prevKeyBuffer);
            prefix = this.getPrefix(prevKeyBuffer, keyBuffer);
            entrySize = visionFile.getKeyEntryOverhead() + (keyBuffer.get8(0) & 0xFF) - prefix + 1;
            if (entrySize > visionFile.getBlockSize() - limit) {
                if (!this.splitNode(visionFile, keyEntry, keyBuffer, uniqueId)) {
                    return false;
                }
                nodeBlock = visionFile.getLoadedNode();
                limit = (nodeBlock.get16(1) & 0xFFFF) + 3;
                notFits = true;
                continue;
            }
            notFits = false;
        } while (notFits);
        int delta = 0;
        int newPrefix = 0;
        if (physicalOffset < limit) {
            int nextPrefix = this.getPartialKey(visionFile, physicalOffset, nodeBlock, prevKeyBuffer);
            newPrefix = this.getPrefix(keyBuffer, prevKeyBuffer);
            delta = newPrefix - nextPrefix;
        }
        int keyEntryOffset = physicalOffset + visionFile.getKeyEntryOffset();
        if (delta > 0) {
            nodeBlock.put8(keyEntryOffset, (byte)((nodeBlock.get8(keyEntryOffset) & 0xFF) - delta));
            nodeBlock.put8(keyEntryOffset + 1, (byte)newPrefix);
            nodeBlock.shift(physicalOffset, delta, visionFile.getKeyEntryOverhead() + 1);
        }
        nodeBlock.shift(physicalOffset + delta, entrySize - delta, limit - physicalOffset - delta);
        nodeBlock.put8(keyEntryOffset, (byte)(entrySize - visionFile.getKeyEntryOverhead()));
        nodeBlock.put8(keyEntryOffset + 1, (byte)prefix);
        nodeBlock.copy(keyEntryOffset + 2, keyBuffer, 1 + prefix, (keyBuffer.get8(0) & 0xFF) - prefix);
        int version = visionFile.getVersion();
        if (version < 6) {
            nodeBlock.put32(physicalOffset + Offset.LEFT_OFF.get(version), (int)leftAddress.getOffset());
            if (version == 4 || version == 5) {
                nodeBlock.put16(physicalOffset + Offset.LEFT_SEG.get(version), (short)leftAddress.getSegment());
            }
        } else {
            nodeBlock.put48(physicalOffset + Offset.LEFT_OFF.get(version), leftAddress.getOffset());
        }
        if (this.selectedKeyHasDuplicates(visionFile)) {
            nodeBlock.put32(physicalOffset + Offset.UNIQ.get(version), (int)uniqueId);
        }
        int usageIncrement = entrySize - delta;
        nodeBlock.put16(1, (short)(limit - 3 + usageIncrement));
        if (!this.saveNode(visionFile, nodeBlock, visionFile.getCurrentNode())) {
            return false;
        }
        visionFile.incNodeUsage(usageIncrement);
        return true;
    }

    private boolean splitNode(File visionFile, KeyEntry keyEntry, Block keyBuffer, long uniqueId) {
        KeyEntry insertPosition;
        int entrySize;
        FileAddress rightNodeAddress = new FileAddress();
        FileAddress leftNodeAddress = new FileAddress();
        this.makeNewNode(visionFile, leftNodeAddress);
        this.makeNewNode(visionFile, rightNodeAddress);
        if (leftNodeAddress.isZero() || rightNodeAddress.isZero()) {
            return false;
        }
        this.saveNode(visionFile, visionFile.getLoadedNode(), rightNodeAddress);
        this.loadNode(visionFile, rightNodeAddress);
        Block nodeBlock = visionFile.getLoadedNode();
        int used = nodeBlock.get16(1) & 0xFFFF;
        int offset = keyEntry.getKeyOffset();
        int nextOffset = 0;
        int prevOffset = 0;
        int entryOffset = 3 + offset + visionFile.getKeyEntryOffset();
        if (nodeBlock.get8(entryOffset + 1) == 0 && nodeBlock.get8(entryOffset + 2) != keyBuffer.get8(1)) {
            if (offset < used / 2) {
                offset += visionFile.getKeyEntryOverhead() + (nodeBlock.get8(entryOffset) & 0xFF);
            }
            if (offset >= used) {
                offset = 0;
            }
            nextOffset = offset;
        } else {
            offset = 0;
        }
        if (offset == 0) {
            while (offset < used / 2) {
                entryOffset = 3 + offset + visionFile.getKeyEntryOffset();
                prevOffset = offset;
                offset += visionFile.getKeyEntryOverhead() + (nodeBlock.get8(entryOffset) & 0xFF);
            }
            nextOffset = offset;
            if (keyEntry.getKeyOffset() < offset) {
                offset = prevOffset;
            }
        }
        int blockSize = visionFile.getBlockSize();
        Block leftBlock = new Block(blockSize);
        leftBlock.put8(0, BlockType.NODE.getVal());
        leftBlock.put16(1, (short)offset);
        leftBlock.copy(3, nodeBlock, 3, offset);
        Block newFirstKey = new Block(253);
        this.getFullKey(visionFile, 3 + offset, nodeBlock, newFirstKey);
        int prefix = nodeBlock.get8(3 + offset + visionFile.getKeyEntryOffset() + 1) & 0xFF;
        nodeBlock.put16(1, (short)(used - (offset - prefix)));
        nodeBlock.shift(3 + offset, prefix - offset, used - offset);
        nodeBlock.fill(3 + used - offset + prefix, offset - prefix, (byte)0);
        if (prefix > 0) {
            nodeBlock.shift(3 + prefix, -prefix, visionFile.getKeyEntryOverhead());
            int firstEntryOffset = 3 + visionFile.getKeyEntryOffset();
            int keyBufferSize = newFirstKey.get8(0) & 0xFF;
            nodeBlock.put8(firstEntryOffset, (byte)(keyBufferSize + 1));
            nodeBlock.put8(firstEntryOffset + 1, (byte)0);
            nodeBlock.copy(firstEntryOffset + 2, newFirstKey, 1, keyBufferSize);
            visionFile.incNodeUsage(prefix);
        }
        Block rightBlock = new Block(blockSize);
        rightBlock.copy(0, nodeBlock, 0, blockSize);
        int lastOffset = 0;
        long lastUid = 0L;
        for (int i = 0; i < offset; i += entrySize) {
            entrySize = visionFile.getKeyEntryOverhead() + (leftBlock.get8(3 + i + visionFile.getKeyEntryOffset()) & 0xFF);
            lastOffset = i;
        }
        if (keyEntry.getKeyOffset() < nextOffset && keyEntry.getKeyOffset() > lastOffset) {
            newFirstKey.copy(0, keyBuffer, 0, (keyBuffer.get8(0) & 0xFF) + 1);
            lastUid = uniqueId;
        } else {
            lastUid = this.getFullKey(visionFile, 3 + lastOffset, leftBlock, newFirstKey);
        }
        boolean newRootCreated = false;
        FileAddress parentAddress = new FileAddress();
        if (keyEntry.getKeyDepth() == 0 || !visionFile.getNodeAddresses()[keyEntry.getKeyDepth() - 1].isValid()) {
            this.makeRoot(visionFile, visionFile.getLoadedNode(), rightNodeAddress, parentAddress);
            if (parentAddress.isZero()) {
                return false;
            }
            visionFile.getCurrentNode().copyFrom(parentAddress);
            newRootCreated = true;
        } else {
            parentAddress.copyFrom(visionFile.getNodeAddresses()[keyEntry.getKeyDepth() - 1]);
        }
        this.saveNode(visionFile, rightBlock, rightNodeAddress);
        this.saveNode(visionFile, leftBlock, leftNodeAddress);
        if (!newRootCreated) {
            KeyEntry tmp = new KeyEntry();
            if (!this.findMe(visionFile, parentAddress, keyEntry.getNodeAddress(), tmp)) {
                return false;
            }
            this.setLeftBranch(visionFile, visionFile.getLoadedNode(), tmp.getPhysicalKeyOffset(), rightNodeAddress);
            this.saveNode(visionFile, visionFile.getLoadedNode(), parentAddress);
        }
        if (this.searchInNode(visionFile, newFirstKey, lastUid, parentAddress, insertPosition = new KeyEntry()) == FindKeyResult.ERROR) {
            return false;
        }
        insertPosition.setKeyDepth(keyEntry.getKeyDepth() - 1);
        if (!this.insertKey(visionFile, newFirstKey, lastUid, leftNodeAddress, insertPosition)) {
            return false;
        }
        visionFile.getCurrentNode().copyFrom(keyEntry.getNodeAddress());
        this.freeCurrentNode(visionFile);
        if (keyEntry.getKeyOffset() < nextOffset) {
            keyEntry.getNodeAddress().copyFrom(leftNodeAddress);
        } else {
            keyEntry.getNodeAddress().copyFrom(rightNodeAddress);
            if (keyEntry.getKeyOffset() == offset) {
                keyEntry.setKeyOffset(0);
            } else {
                keyEntry.setKeyOffset(keyEntry.getKeyOffset() - (offset - prefix));
            }
        }
        this.loadNode(visionFile, keyEntry.getNodeAddress());
        visionFile.getNodeAddresses()[keyEntry.getKeyDepth()].copyFrom(keyEntry.getNodeAddress());
        return true;
    }

    private void freeCurrentNode(File visionFile) {
        FileAddress nodeAddress = visionFile.getCurrentNode();
        int version = visionFile.getVersion();
        Block freeBlockHeader = new Block(1 + this.fileAddressSize(version));
        freeBlockHeader.put8(0, BlockType.FREENODE.getVal());
        FileAddress firstFreeAddress = visionFile.getFreeNode();
        if (version < 6) {
            freeBlockHeader.put32(1, (int)firstFreeAddress.getOffset());
            if (version == 4 || version == 5) {
                freeBlockHeader.put16(5, (short)firstFreeAddress.getSegment());
            }
        } else {
            freeBlockHeader.put48(1, firstFreeAddress.getOffset());
        }
        FileDescriptor segment = this.retrieveSegment(visionFile, BlockType.NODE, nodeAddress.getSegment());
        FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
        fileSystemCache.seek(segment, nodeAddress.getOffset());
        fileSystemCache.write(segment, freeBlockHeader, CacheDataType.INDEX);
        firstFreeAddress.copyFrom(nodeAddress);
        visionFile.decUsedNodes();
        visionFile.incFreeNodes();
        Block cachedHeader = visionFile.getHeaderCache();
        if (version < 6) {
            cachedHeader.put32(Offset.FREENODE_OFF.get(version), (int)nodeAddress.getOffset());
            if (version == 4 || version == 5) {
                cachedHeader.put16(Offset.FREENODE_SEG.get(version), (short)nodeAddress.getSegment());
            }
        } else {
            cachedHeader.put48(Offset.FREENODE_OFF.get(version), nodeAddress.getOffset());
        }
        if (version < 5) {
            cachedHeader.put16(Offset.NODES_USED.get(version), (short)visionFile.getUsedNodes());
            cachedHeader.put16(Offset.NODES_FREE.get(version), (short)visionFile.getFreeNodes());
        } else if (version == 5) {
            cachedHeader.put32(Offset.NODES_USED.get(version), (int)visionFile.getUsedNodes());
            cachedHeader.put32(Offset.NODES_FREE.get(version), (int)visionFile.getFreeNodes());
        } else {
            cachedHeader.put48(Offset.NODES_USED.get(version), visionFile.getUsedNodes());
            cachedHeader.put48(Offset.NODES_FREE.get(version), visionFile.getFreeNodes());
        }
        nodeAddress.invalidate();
    }

    private boolean findMe(File visionFile, FileAddress parent, FileAddress child, KeyEntry output) {
        int offset;
        int entrySize;
        if (!this.loadNode(visionFile, parent)) {
            return false;
        }
        Block nodeBlock = visionFile.getLoadedNode();
        FileAddress leftAddress = new FileAddress();
        int limit = (nodeBlock.get16(1) & 0xFFFF) + 3;
        output.setPreviousPhysicalKeyOffset(-1);
        for (offset = 3; offset < limit; offset += visionFile.getKeyEntryOverhead() + entrySize) {
            entrySize = nodeBlock.get8(offset + visionFile.getKeyEntryOffset()) & 0xFF;
            this.getLeftAddress(visionFile, nodeBlock, offset, leftAddress);
            if (leftAddress.eq(child)) break;
            output.setPreviousPhysicalKeyOffset(offset);
        }
        if (offset >= limit) {
            this.status.setErrno(6);
            this.status.setIntErrno(7);
            return false;
        }
        output.setPhysicalKeyOffset(offset);
        return true;
    }

    private int getPrefix(Block first, Block second) {
        int minSize = Math.min(first.get8(0) & 0xFF, second.get8(0) & 0xFF);
        int prefix = 0;
        int i = 1;
        while (prefix < minSize && first.get8(i) == second.get8(i)) {
            ++prefix;
            ++i;
        }
        return prefix;
    }

    private long getFullKey(File visionFile, int physicalKeyOffset, Block nodeBlock, Block output) {
        int limit = (nodeBlock.get16(1) & 0xFFFF) + 3;
        if (physicalKeyOffset >= limit || physicalKeyOffset < 0) {
            output.put8(0, (byte)0);
            return 0L;
        }
        int entrySize = 0;
        int prefix = 1;
        int entryOffset = 0;
        int lastOffset = 0;
        for (int offset = 3; offset <= physicalKeyOffset; offset += visionFile.getKeyEntryOverhead() + entrySize) {
            entryOffset = offset + visionFile.getKeyEntryOffset();
            entrySize = nodeBlock.get8(entryOffset) & 0xFF;
            prefix = nodeBlock.get8(entryOffset + 1) & 0xFF;
            output.copy(prefix + 1, nodeBlock, entryOffset + 2, entrySize - 1);
            lastOffset = offset;
        }
        output.put8(0, (byte)(entrySize + prefix - 1));
        return this.getUniqueId(visionFile, nodeBlock, lastOffset);
    }

    private int getPartialKey(File visionFile, int physicalKeyOffset, Block nodeBlock, Block output) {
        int offset = physicalKeyOffset + visionFile.getKeyEntryOffset();
        int size = (nodeBlock.get8(offset) & 0xFF) - 1;
        int prefix = nodeBlock.get8(offset + 1) & 0xFF;
        output.copy(prefix + 1, nodeBlock, offset + 2, size);
        output.put8(0, (byte)(size + prefix));
        return prefix;
    }

    protected FindKeyResult findKey(File visionFile, Block keyBuffer, long uniqueId, KeyEntry output) {
        FindKeyResult result = FindKeyResult.ERROR;
        this.setKey(visionFile, keyBuffer.get8(1) & 0xFF);
        KeyInfo selectedKey = visionFile.getLogicalAttributes().getKey(visionFile.getFindKeyNum());
        FileAddress address = selectedKey.getKeyRoot().copy();
        if (address.isZero()) {
            return FindKeyResult.EMPTY;
        }
        int level = 0;
        FileAddress[] nodeAddresses = visionFile.getNodeAddresses();
        while (address.gtZero()) {
            nodeAddresses[level] = address.copy();
            result = this.searchInNode(visionFile, keyBuffer, uniqueId, address, output);
            if (result == FindKeyResult.ERROR) {
                return result;
            }
            if (result == FindKeyResult.NO_MATCH) {
                this.status.setErrno(6);
                this.status.setIntErrno(4);
                return FindKeyResult.ERROR;
            }
            ++level;
            this.getLeftAddress(visionFile, visionFile.getLoadedNode(), output.getPhysicalKeyOffset(), address);
        }
        output.setKeyDepth(level - 1);
        return result;
    }

    protected boolean findPrevious(File visionFile, KeyEntry output) {
        block4: {
            if (output.getPreviousPhysicalKeyOffset() < 0) {
                for (int depth = output.getKeyDepth(); output.getPreviousPhysicalKeyOffset() < 0 && depth > 0; --depth) {
                    if (this.findMe(visionFile, visionFile.getNodeAddresses()[depth - 1], visionFile.getNodeAddresses()[depth], output)) continue;
                    return false;
                }
                if (output.getPreviousPhysicalKeyOffset() < 0) {
                    this.status.setErrno(8);
                    return false;
                }
                FileAddress leftAddress = new FileAddress();
                do {
                    this.getLeftAddress(visionFile, visionFile.getLoadedNode(), output.getPreviousPhysicalKeyOffset(), leftAddress);
                    if (leftAddress.ltZero()) break block4;
                    visionFile.getNodeAddresses()[++depth] = leftAddress.copy();
                } while (this.searchInNode(visionFile, FULL_STOPPER_KEY, 0L, leftAddress, output) != FindKeyResult.ERROR);
                return false;
            }
        }
        output.setPhysicalKeyOffset(output.getPreviousPhysicalKeyOffset());
        this.getFullKey(visionFile, output.getPhysicalKeyOffset(), visionFile.getLoadedNode(), visionFile.getFoundKey());
        return true;
    }

    protected void getLeftAddress(File visionFile, Block nodeBuffer, int physicalOffset, FileAddress output) {
        int version = visionFile.getVersion();
        if (version < 6) {
            output.setOffset(nodeBuffer.get32(physicalOffset + Offset.LEFT_OFF.get(version)));
        } else {
            output.setOffset(nodeBuffer.get48s(physicalOffset + Offset.LEFT_OFF.get(version)));
        }
        if (version == 4 || version == 5) {
            output.setSegment(nodeBuffer.get16(physicalOffset + Offset.LEFT_SEG.get(version)) & 0xFFFF);
        } else {
            output.setSegment(0);
        }
    }

    private void setLeftBranch(File visionFile, Block nodeBuffer, int physicalOffset, FileAddress address) {
        int version = visionFile.getVersion();
        if (version < 6) {
            nodeBuffer.put32(physicalOffset + Offset.LEFT_OFF.get(version), (int)address.getOffset());
            if (version == 4 || version == 5) {
                nodeBuffer.put16(physicalOffset + Offset.LEFT_SEG.get(version), (short)address.getSegment());
            }
        } else {
            nodeBuffer.put48(physicalOffset + Offset.LEFT_OFF.get(version), address.getOffset());
        }
    }

    protected void setKey(File visionFile, int keyNum) {
        int version = visionFile.getVersion();
        visionFile.setFindKeyNum(keyNum);
        if (visionFile.getLogicalAttributes().getKey(keyNum).isDuplicate()) {
            visionFile.setKeyEntryOffset(Offset.KEY.get(version));
            visionFile.setKeyEntryOverhead(Offset.ENTRY_OVERHEAD.get(version));
        } else {
            visionFile.setKeyEntryOffset(Offset.KEY.get(version) - 4);
            visionFile.setKeyEntryOverhead(Offset.ENTRY_OVERHEAD.get(version) - 4);
        }
    }

    private boolean selectedKeyHasDuplicates(File visionFile) {
        return visionFile.getKeyEntryOverhead() == Offset.ENTRY_OVERHEAD.get(visionFile.getVersion());
    }

    protected FindKeyResult searchInNode(File visionFile, Block keyBuffer, long uniqueId, FileAddress address, KeyEntry output) {
        int physicalOffset;
        if (!this.loadNode(visionFile, address)) {
            return FindKeyResult.ERROR;
        }
        Block nodeBlock = visionFile.getLoadedNode();
        int limit = (nodeBlock.get16(1) & 0xFFFF) + 3;
        int previousPhysicalOffset = -1;
        int prefix = 0;
        int previousPrefix = 0;
        int entryOffset = 0;
        int previousEntryOffset = 0;
        int nodeKeySize = 0;
        long nodeUniqueId = 0L;
        int lastDifferentOffset = 0;
        int compareResult = 0;
        for (physicalOffset = 3; physicalOffset < limit; physicalOffset += visionFile.getKeyEntryOverhead() + (nodeBlock.get8(entryOffset) & 0xFF)) {
            entryOffset = physicalOffset + visionFile.getKeyEntryOffset();
            prefix = nodeBlock.get8(entryOffset + 1) & 0xFF;
            if (prefix > previousPrefix) {
                if (previousEntryOffset == 0) {
                    this.status.setErrno(6);
                    this.status.setIntErrno(20);
                    return FindKeyResult.ERROR;
                }
                if (prefix > 251) {
                    this.status.setErrno(6);
                    this.status.setIntErrno(22);
                    return FindKeyResult.ERROR;
                }
                visionFile.getFoundKey().copy(previousPrefix + 1, nodeBlock, previousEntryOffset + 2, prefix - previousPrefix);
            }
            previousPrefix = prefix;
            previousEntryOffset = entryOffset;
            if (compareResult == 0 || lastDifferentOffset >= prefix) {
                nodeKeySize = (nodeBlock.get8(entryOffset) & 0xFF) - 1;
                if (nodeKeySize < 0 || nodeKeySize + prefix > 251) {
                    this.status.setErrno(6);
                    this.status.setIntErrno(21);
                    return FindKeyResult.ERROR;
                }
                int keySizeToCompare = (keyBuffer.get8(0) & 0xFF) - prefix;
                int i1 = prefix;
                int i2 = entryOffset + 1;
                compareResult = 0;
                for (int minSize = Math.min(keySizeToCompare, nodeKeySize); minSize > 0; --minSize) {
                    int b2;
                    int b1;
                    if ((b1 = keyBuffer.get8(++i1) & 0xFF) == (b2 = nodeBlock.get8(++i2) & 0xFF)) continue;
                    compareResult = b1 < b2 ? -1 : 1;
                    break;
                }
                lastDifferentOffset = prefix + (i2 - (entryOffset + 2));
                if (compareResult == 0 && keySizeToCompare != nodeKeySize) {
                    int count;
                    int i;
                    ++lastDifferentOffset;
                    if (keySizeToCompare < nodeKeySize) {
                        i = entryOffset + 2 + keySizeToCompare;
                        count = nodeKeySize - keySizeToCompare;
                    } else {
                        i = prefix + 1 + nodeKeySize;
                        count = keySizeToCompare - nodeKeySize;
                    }
                    while (count-- > 0) {
                        if ((nodeBlock.get8(i) & 0xFF) < 32) {
                            compareResult = keySizeToCompare < nodeKeySize ? 1 : -1;
                            break;
                        }
                        if ((nodeBlock.get8(i) & 0xFF) > 32) {
                            compareResult = keySizeToCompare < nodeKeySize ? -1 : 1;
                            break;
                        }
                        ++i;
                        ++lastDifferentOffset;
                    }
                }
                if (compareResult < 0) break;
                if (compareResult == 0) {
                    visionFile.setFoundExactMatch(true);
                    nodeUniqueId = this.getUniqueId(visionFile, nodeBlock, physicalOffset);
                    if (uniqueId <= nodeUniqueId) break;
                }
            }
            previousPhysicalOffset = physicalOffset;
        }
        output.getNodeAddress().copyFrom(address);
        output.setPhysicalKeyOffset(physicalOffset);
        output.setPreviousPhysicalKeyOffset(previousPhysicalOffset);
        if (physicalOffset >= limit) {
            return FindKeyResult.NO_MATCH;
        }
        visionFile.getFoundKey().copy(prefix + 1, nodeBlock, entryOffset + 2, nodeKeySize);
        visionFile.getFoundKey().put8(0, (byte)(prefix + nodeKeySize));
        return compareResult < 0 ? FindKeyResult.MATCH_NEXT : (uniqueId == nodeUniqueId ? FindKeyResult.FULL_MATCH : FindKeyResult.KEY_MATCH);
    }

    protected long getUniqueId(File visionFile, Block loadedNode, int physicalOffset) {
        if (this.selectedKeyHasDuplicates(visionFile)) {
            return (long)loadedNode.get32(physicalOffset + Offset.UNIQ.get(visionFile.getVersion())) & 0xFFFFFFFFL;
        }
        return 0L;
    }

    protected FileAddress appendRecord(File visionFile, byte[] record, int size) {
        FileAddress nextRec;
        Block h;
        int version = visionFile.getVersion();
        LogicalAttributes logicalAttributes = visionFile.getLogicalAttributes();
        Block recordBuffer = visionFile.getRecord();
        FileAddress freeRec = visionFile.getFreeRec();
        RecordHeader recordHeader = new RecordHeader();
        int newSize = size;
        boolean compressed = logicalAttributes.isCompressed();
        if (compressed) {
            newSize = this.deflate(visionFile, record, size);
            record = visionFile.getCompressedRecord().getBytes();
        }
        FileAddress address = new FileAddress();
        boolean append = freeRec.isZero();
        if (!append) {
            FileAddress recordDataAddress = this.getRecord(visionFile, recordBuffer, visionFile.getRecordOverhead(), freeRec, false);
            if (recordDataAddress.isZero()) {
                address.initialize();
                return address;
            }
            this.unpackRecordHeader(visionFile, recordBuffer, recordHeader);
            if (recordHeader.getStatus() != RecordStatus.DELETED) {
                this.status.setErrno(6);
                this.status.setIntErrno(13);
                address.initialize();
                return address;
            }
            if (version < 5) {
                int minRecSize = version == 3 ? 4 : 6;
                Block tmp = new Block(minRecSize);
                FileAddress nextDeletedAddress = this.getRecord(visionFile, tmp, minRecSize, recordDataAddress, false);
                if (nextDeletedAddress.isZero()) {
                    address.initialize();
                    return address;
                }
                recordHeader.getNextDeleted().setOffset((long)tmp.get32(0) & 0xFFFFFFFFL);
                recordHeader.getNextDeleted().setSegment(version == 3 ? 0 : tmp.get16(4) & 0xFFFF);
            }
            if (newSize > recordHeader.getSize()) {
                append = true;
                if (visionFile.incFreeFailures() > 30) {
                    if (version > 4) {
                        Block abandonedBuffer = new Block(visionFile.getRecordOverhead());
                        RecordHeader abandonedHeader = new RecordHeader();
                        abandonedHeader.setStatus(RecordStatus.ABANDONED);
                        abandonedHeader.setSize(recordHeader.getSize());
                        abandonedHeader.setUsed(recordHeader.getUsed());
                        abandonedHeader.getNextDeleted().copyFrom(visionFile.getAbandonedRec());
                        this.packRecordHeader(visionFile, abandonedBuffer, abandonedHeader);
                        FileDescriptor segment = this.retrieveSegment(visionFile, BlockType.DATA, freeRec.getSegment());
                        FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
                        fileSystemCache.seek(segment, freeRec.getOffset());
                        fileSystemCache.write(segment, abandonedBuffer, CacheDataType.RECORD);
                        visionFile.getAbandonedRec().copyFrom(freeRec);
                        Block h2 = visionFile.getHeaderCache();
                        if (version < 6) {
                            h2.put32(Offset.ABREC_OFF.get(version), (int)freeRec.getOffset());
                            h2.put16(Offset.ABREC_SEG.get(version), (short)freeRec.getSegment());
                        } else {
                            h2.put48(Offset.ABREC_OFF.get(version), freeRec.getOffset());
                        }
                        visionFile.incAbandonedRecords();
                        visionFile.decDeletedRecords();
                    }
                    visionFile.setFreeFailures(0);
                    freeRec.copyFrom(recordHeader.getNextDeleted());
                }
            } else {
                address.copyFrom(freeRec);
                visionFile.setFreeFailures(0);
                freeRec.copyFrom(recordHeader.getNextDeleted());
            }
            h = visionFile.getHeaderCache();
            if (version < 6) {
                h.put32(Offset.FREEREC_OFF.get(version), (int)freeRec.getOffset());
                if (version > 3) {
                    h.put16(Offset.FREEREC_SEG.get(version), (short)freeRec.getSegment());
                }
            } else {
                h.put48(Offset.FREEREC_OFF.get(version), freeRec.getOffset());
            }
        }
        if (append) {
            if (visionFile.getNextRec().isZero()) {
                FileAddress tmp = visionFile.getNextBlock().copy();
                if (version == 3) {
                    tmp.incOffset(1L);
                }
                visionFile.getFirstRec().copyFrom(tmp);
                visionFile.getNextRec().copyFrom(tmp);
                h = visionFile.getHeaderCache();
                if (version < 6) {
                    h.put32(Offset.FIRST_REC_OFF.get(version), (int)tmp.getOffset());
                    if (version > 3) {
                        h.put16(Offset.FIRST_REC_SEG.get(version), (short)tmp.getSegment());
                    }
                } else {
                    h.put48(Offset.FIRST_REC_OFF.get(version), tmp.getOffset());
                }
                if (!this.newBlock(visionFile, BlockType.DATA)) {
                    address.initialize();
                    return address;
                }
            }
            address.copyFrom(visionFile.getNextRec());
            int adjustedSize = size - (size - newSize) * logicalAttributes.getCompressFactor() / 100;
            recordHeader.setSize(this.checkMinRecordSize(version, adjustedSize));
        }
        recordHeader.setStatus(RecordStatus.NO_STATUS);
        recordHeader.setUncompressed(compressed && size == newSize);
        recordHeader.setUsed(newSize);
        recordHeader.setUniqueId(logicalAttributes.getDuplicates() > 0 ? visionFile.getNextUniqueId() : 0L);
        this.packRecordHeader(visionFile, recordBuffer, recordHeader);
        recordBuffer.copy((int)visionFile.getRecordOverhead(), record, 0, newSize);
        if (recordHeader.getUsed() < recordHeader.getSize()) {
            recordBuffer.fill(visionFile.getRecordOverhead() + recordHeader.getUsed(), recordHeader.getSize() - recordHeader.getUsed(), (byte)0);
        }
        if (version > 3) {
            long offsetToCheck = address.getOffset() + (long)visionFile.getRecordOverhead();
            FileAddress fileSize = visionFile.getFileSize();
            FileAddress tmp = address.copy();
            if (tmp.getSegment() == fileSize.getSegment() && offsetToCheck > fileSize.getOffset()) {
                tmp.invalidate();
            } else if (version < 6 && offsetToCheck > visionFile.getMaxSegmentSize()) {
                if (tmp.getSegment() < fileSize.getSegment() && fileSize.getOffset() > 512L) {
                    tmp.incSegment();
                    tmp.setOffset(512L);
                } else {
                    tmp.invalidate();
                }
            }
            if (tmp.isValid()) {
                FileDescriptor segment = this.retrieveSegment(visionFile, BlockType.DATA, tmp.getSegment());
                FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
                fileSystemCache.seek(segment, tmp.getOffset());
                Block tmpBlock = new Block(visionFile.getRecordOverhead());
                if (fileSystemCache.read(segment, tmpBlock, CacheDataType.RECORD) == tmpBlock.size()) {
                    RecordHeader tmpHeader = new RecordHeader();
                    this.unpackRecordHeader(visionFile, tmpBlock, tmpHeader);
                    if (tmpHeader.getStatus() != RecordStatus.DELETED && tmpHeader.getUsed() != 0) {
                        this.status.setErrno(6);
                        this.status.setIntErrno(87);
                        address.initialize();
                        return address;
                    }
                }
            }
        }
        if ((nextRec = this.setRecord(visionFile, recordBuffer, visionFile.getRecordOverhead() + recordHeader.getSize(), address, append)).isZero()) {
            address.initialize();
            return address;
        }
        if (append) {
            visionFile.getNextRec().copyFrom(nextRec);
        }
        visionFile.incTotalRecords();
        if (!append) {
            visionFile.decDeletedRecords();
        }
        return address;
    }

    protected boolean deleteRecord(File visionFile, FileAddress recordAddress) {
        Block recordBuffer;
        FileAddress nextAddress;
        FileAddress address = recordAddress.copy();
        int version = visionFile.getVersion();
        int additionalSpace = 0;
        if (version == 3 || version == 4) {
            additionalSpace = this.checkMinRecordSize(version, 0);
        }
        if ((nextAddress = this.getRecord(visionFile, recordBuffer = new Block(visionFile.getRecordOverhead() + additionalSpace), visionFile.getRecordOverhead(), address, false)).isZero()) {
            return false;
        }
        RecordHeader recordHeader = new RecordHeader();
        this.unpackRecordHeader(visionFile, recordBuffer, recordHeader);
        recordHeader.setStatus(RecordStatus.DELETED);
        if (version < 5) {
            recordHeader.setUsed(0);
        }
        recordHeader.getNextDeleted().copyFrom(visionFile.getFreeRec());
        this.packRecordHeader(visionFile, recordBuffer, recordHeader);
        if (version == 3 || version == 4) {
            recordBuffer.put32(visionFile.getRecordOverhead(), (int)recordHeader.getNextDeleted().getOffset());
            if (version == 4) {
                recordBuffer.put16(visionFile.getRecordOverhead() + 4, (short)recordHeader.getNextDeleted().getSegment());
            }
        }
        if ((nextAddress = this.setRecord(visionFile, recordBuffer, recordBuffer.size(), address, false)).isZero()) {
            return false;
        }
        visionFile.getFreeRec().copyFrom(address);
        Block header = visionFile.getHeaderCache();
        if (version < 6) {
            header.put32(Offset.FREEREC_OFF.get(version), (int)address.getOffset());
            if (version == 4 || version == 5) {
                header.put16(Offset.FREEREC_SEG.get(version), (short)address.getSegment());
            }
        } else {
            header.put48(Offset.FREEREC_OFF.get(version), address.getOffset());
        }
        visionFile.setFreeFailures(0);
        visionFile.decTotalRecords();
        visionFile.incDeletedRecords();
        return true;
    }

    protected void rewriteRecord(File visionFile, byte[] record, int size, RecordHeader recordHeader, FileAddress recordAddress) {
        FileAddress nextAddress;
        boolean useNewRecord;
        LogicalAttributes logicalAttributes = visionFile.getLogicalAttributes();
        FileAddress originalAddress = recordAddress.copy();
        int newSize = size;
        boolean compressed = logicalAttributes.isCompressed();
        if (compressed) {
            newSize = this.deflate(visionFile, record, size);
            record = visionFile.getCompressedRecord().getBytes();
        }
        boolean bl = useNewRecord = newSize > recordHeader.getSize();
        if (useNewRecord) {
            recordAddress.copyFrom(visionFile.getNextRec());
            int adjustedSize = size - (size - newSize) * logicalAttributes.getCompressFactor() / 100;
            recordHeader.setSize(this.checkMinRecordSize(visionFile.getVersion(), adjustedSize));
        }
        recordHeader.setUsed(newSize);
        recordHeader.setStatus(RecordStatus.NO_STATUS);
        recordHeader.setUncompressed(compressed && size == newSize);
        short recordOverhead = visionFile.getRecordOverhead();
        Block buffer = visionFile.getRewrittenRecord();
        this.packRecordHeader(visionFile, buffer, recordHeader);
        buffer.copy((int)recordOverhead, record, 0, newSize);
        if (newSize < recordHeader.getSize()) {
            buffer.fill(recordOverhead + newSize, recordHeader.getSize() - newSize, (byte)0);
        }
        if ((nextAddress = this.setRecord(visionFile, buffer, recordOverhead + recordHeader.getSize(), recordAddress, useNewRecord)).isZero()) {
            recordAddress.initialize();
            return;
        }
        if (useNewRecord) {
            visionFile.getNextRec().copyFrom(nextAddress);
            if (!this.deleteRecord(visionFile, originalAddress)) {
                recordAddress.initialize();
                return;
            }
            visionFile.incTotalRecords();
        }
    }

    protected void unlockRecord(File visionFile) {
        this.unlockRecord(visionFile, null);
    }

    protected void unlockRecord(File visionFile, FileAddress address) {
        if (address == null) {
            if (!this.isMultiLockOnly(visionFile.getOpenMode())) {
                Lock[] locks = visionFile.getLocks();
                int maxLocks = locks.length;
                for (int i = 0; i < maxLocks && locks[i] != null; ++i) {
                    if (!locks[i].isProgramLock()) continue;
                    locks[i].release();
                    locks[i] = null;
                    int nextI = i + 1;
                    if (nextI >= maxLocks || locks[nextI] == null) break;
                    System.arraycopy(locks, nextI, locks, i, maxLocks - nextI);
                    locks[maxLocks - 1] = null;
                    break;
                }
            }
        } else {
            Lock[] locks = visionFile.getLocks();
            int maxLocks = locks.length;
            for (int i = 0; i < maxLocks && locks[i] != null; ++i) {
                if (!locks[i].getAddress().eq(address)) continue;
                locks[i].release();
                locks[i] = null;
                int nextI = i + 1;
                if (nextI >= maxLocks || locks[nextI] == null) break;
                System.arraycopy(locks, nextI, locks, i, maxLocks - nextI);
                locks[maxLocks - 1] = null;
                break;
            }
        }
        visionFile.getCurrentPrimaryKey().put8(0, (byte)0);
        visionFile.getCurrentRecord().invalidate();
    }

    private Lock createLock(File visionFile, FileAddress address, LockType type) {
        FileDescriptor segment = this.retrieveSegment(visionFile, BlockType.DATA, address.getSegment());
        FileLock fileLock = visionFile.getFileSystemCache().testLock(segment, address.getOffset(), 1);
        if (fileLock != null) {
            return new Lock(address.getSegment(), fileLock, type);
        }
        return null;
    }

    protected void moveLock(File visionFile, FileAddress oldAddress, FileAddress newAddress) {
        Lock[] locks = visionFile.getLocks();
        int maxLocks = locks.length;
        for (int i = 0; i < maxLocks && locks[i] != null; ++i) {
            int nextI;
            if (!locks[i].getAddress().eq(oldAddress)) continue;
            locks[i].release();
            locks[i] = this.createLock(visionFile, newAddress, locks[i].getType());
            if (locks[i] != null || (nextI = i + 1) >= maxLocks || locks[nextI] == null) break;
            System.arraycopy(locks, nextI, locks, i, maxLocks - nextI);
            locks[maxLocks - 1] = null;
            break;
        }
    }

    private void extendLock(File visionFile, Lock lockToExtend, FileAddress extendLimit) {
        FileAddress address = lockToExtend.getAddress();
        FileDescriptor segment = this.retrieveSegment(visionFile, BlockType.DATA, address.getSegment());
        long offset = address.getOffset() + 1L;
        FileLock fileLock = visionFile.getFileSystemCache().testLock(segment, offset, (int)(extendLimit.getOffset() - offset));
        if (fileLock != null) {
            lockToExtend.extend(fileLock);
        }
    }

    protected void finishRead(File visionFile, int keyNum, Block fullKey, long uniqueId, FileAddress address, boolean isNext) {
        this.unlockHeader(visionFile, true);
        visionFile.setCurrentKeyNum(keyNum);
        if (visionFile.getCurrentKey() != fullKey) {
            visionFile.getCurrentKey().copy(0, fullKey, 0, (fullKey.get8(0) & 0xFF) + 1);
        }
        visionFile.setCurrentUniqueId(uniqueId);
        visionFile.setCurrentIsNext(isNext);
        visionFile.setPointerState(PointerState.HAS_CUR_REC);
        visionFile.getLastReadBlock().copyFrom(address);
        visionFile.setLastReadTreeVersion(visionFile.getTreeVersion());
    }

    protected boolean beginRead(File visionFile, boolean readOrReadNext) {
        this.status.setErrno(0);
        visionFile.setPointerState(PointerState.NO_CUR_REC);
        visionFile.getLastReadBlock().initialize();
        if (!this.lockHeader(visionFile, false, false, readOrReadNext)) {
            return false;
        }
        this.unlockRecord(visionFile);
        if (this.isOutputOnly(visionFile.getOpenMode()) || this.isExtendOnly(visionFile.getOpenMode())) {
            this.unlockHeader(visionFile, true);
            this.status.setErrno(4);
            return false;
        }
        return true;
    }

    protected void invalidateReadNextAddressesCache(File visionFile) {
        visionFile.getReadNextAddressesCache()[0] = null;
    }

    protected FileAddress getReadNextCachedAddress(File visionFile) {
        return visionFile.getReadNextAddressesCache()[0];
    }

    protected void storeReadNextCachedAddress(File visionFile, int offset, FileAddress recordAddress) {
        visionFile.getReadNextAddressesCache()[offset] = recordAddress;
    }

    protected void popReadNextCachedAddress(File visionFile) {
        FileAddress[] cache = visionFile.getReadNextAddressesCache();
        for (int i = 1; i < 10; ++i) {
            cache[i - 1] = cache[i];
        }
        cache[9] = null;
    }

    protected void purgeReadNextCachedAddress(File visionFile, int start) {
        FileAddress[] cache = visionFile.getReadNextAddressesCache();
        while (start < 10) {
            cache[start] = null;
            ++start;
        }
    }

    protected FileAddress isCurrentLockedRecord(File visionFile, byte[] record) {
        if (visionFile.getCurrentRecord().gtZero()) {
            Block currentPrimaryKey = visionFile.getCurrentPrimaryKey();
            KeyInfo pk = visionFile.getLogicalAttributes().getKey(0);
            int i = 0;
            for (int n = 0; n < pk.getSegments(); ++n) {
                int segmentSize = pk.getSize(n);
                if (currentPrimaryKey.compare(i, record, pk.getOffset(n), segmentSize) != 0) {
                    return null;
                }
                i += segmentSize;
            }
            return visionFile.getCurrentRecord().copy();
        }
        return null;
    }

    private int deflate(File visionFile, byte[] record, int size) {
        int compressedSize = 0;
        int recordIndex = 0;
        int currentByte = record[recordIndex] & 0xFF;
        int count = 0;
        int originalSize = size;
        Block compressedRecord = visionFile.getCompressedRecord();
        while ((size > 0 || count > 0) && compressedSize <= originalSize) {
            if (size > 0 && currentByte == (record[recordIndex] & 0xFF)) {
                ++count;
            } else {
                int amount;
                int compressFlag;
                switch (currentByte) {
                    case 32: {
                        compressFlag = 253;
                        break;
                    }
                    case 48: {
                        compressFlag = 252;
                        break;
                    }
                    case 0: {
                        compressFlag = 251;
                        break;
                    }
                    default: {
                        compressFlag = 0;
                    }
                }
                while (compressFlag != 0 && count > 2) {
                    compressedRecord.put8(compressedSize++, (byte)compressFlag);
                    amount = Math.min(count, 127);
                    compressedRecord.put8(compressedSize++, (byte)amount);
                    count -= amount;
                }
                while (count > 3) {
                    compressedRecord.put8(compressedSize++, (byte)-2);
                    compressedRecord.put8(compressedSize++, (byte)currentByte);
                    amount = Math.min(count, 127);
                    compressedRecord.put8(compressedSize++, (byte)amount);
                    count -= amount;
                }
                while (count > 0) {
                    if (currentByte >= 250 && currentByte <= 254) {
                        compressedRecord.put8(compressedSize++, (byte)-6);
                    }
                    compressedRecord.put8(compressedSize++, (byte)currentByte);
                    --count;
                }
                if (size > 0) {
                    currentByte = record[recordIndex] & 0xFF;
                    count = 1;
                }
            }
            if (size <= 0) continue;
            ++recordIndex;
            --size;
        }
        if (compressedSize >= originalSize) {
            compressedRecord.copy(0, record, 0, originalSize);
            return originalSize;
        }
        return compressedSize;
    }

    private int inflate(File visionFile, Block record, int offset, int size) {
        int uncompressedSize = size;
        int recordIndex = offset;
        int recordEnd = offset + visionFile.getLogicalAttributes().getMaxRecordSize();
        int compressedIndex = offset;
        Block compressedRecord = visionFile.getCompressedRecord();
        while (size > 0) {
            int currentByte = compressedRecord.get8(compressedIndex) & 0xFF;
            if (currentByte >= 251 && currentByte <= 254) {
                byte value;
                if (currentByte == 254) {
                    value = compressedRecord.get8(++compressedIndex);
                    --uncompressedSize;
                    --size;
                } else {
                    value = COMPRESSED_VALUES[254 - currentByte];
                }
                int occurrence = compressedRecord.get8(++compressedIndex) & 0xFF;
                uncompressedSize += occurrence - 2;
                if (recordIndex + occurrence > recordEnd) {
                    return 0;
                }
                while (occurrence-- > 0) {
                    record.put8(recordIndex++, value);
                }
                size -= 2;
                ++compressedIndex;
                continue;
            }
            if (currentByte == 250) {
                --uncompressedSize;
                --size;
                currentByte = compressedRecord.get8(++compressedIndex) & 0xFF;
            }
            if (recordIndex >= recordEnd) {
                return 0;
            }
            record.put8(recordIndex++, (byte)currentByte);
            ++compressedIndex;
            --size;
        }
        return uncompressedSize;
    }
}

