      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       program-id. iofile.

       input-output section.
       file-control.
           select arc assign to "arc"
                      organization indexed
                      access mode dynamic
                      record key k
                      status file-status.

       file section.
       fd  arc.
       01  rec-iofile.
           03 k                pic 9(5).
           03 d                pic x(25).

       working-storage section.
       78  iofile-create-file  value 1.
       78  iofile-open-file    value 2.
       78  iofile-read-file    value 3.
       78  iofile-close-file   value 4.
       77  file-status         pic xx.

       linkage section.
       77  op-code             pic 9.
       01  lk-rec-iofile.
           03 lk-k             pic 9(5).
           03 lk-d             pic x(25).

       procedure division using op-code lk-rec-iofile.
       declaratives.
       ARC-ERR section.
           use after standard error procedure on arc.
           continue.
       end declaratives.
       MAIN.
           evaluate op-code
              when iofile-create-file
                   perform CREATE-FILE
              when iofile-open-file
                   perform OPEN-FILE
              when iofile-read-file
                   perform READ-FILE
              when iofile-close-file
                   perform CLOSE-FILE
           end-evaluate
           if file-status not = "00"
              goback -1
           end-if
           goback
           .

       CREATE-FILE.
           open output arc
           move 1 to k
           move "Record 1" to d
           write rec-iofile
           move 2 to k
           move "Record 2" to d
           write rec-iofile
           move 3 to k
           move "Record 3" to d
           write rec-iofile
           close arc
           .

       OPEN-FILE.
           open i-o arc
           .

       READ-FILE.
           initialize rec-iofile
           move lk-k to k
           read arc
           move rec-iofile to lk-rec-iofile
           .

       CLOSE-FILE.
           close arc
           .