      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       identification division.
       program-id. CREATE-DATA.

       environment division.
       input-output section.
       file-control.
           select datafile assign to "DataFile.txt"
                 organization is line sequential
                 file status is file-status.

       data division.
       file section.
       fd  datafile.
       01  data-rec.
           05 dr-title       pic x(30).
           05 dr-length      pic x(5).
           05 dr-artist      pic x(20).
           05 dr-album       pic x(30).
           05 dr-genre       pic x(15).
           05 dr-label       pic x(30).
           05 dr-year        pic 9(4).

       working-storage section.
       77  file-status          pic x(2).
       01  crerr-status.
           03 crerr-file-status pic xx.
           03 crerr-ext-status  pic x(128).
       77  crerr-mesage         pic x any length.

       77  rerrname             pic x(50).
       77  fileop               pic x(50).

       77  idx                  pic 9(3).

       01  display-data.
           05 ds-artist         pic x(20).
           05 filler            pic x(3) value " | ".
           05 ds-year           pic X(4).
           05 filler            pic x(3) value " | ".
           05 ds-album          pic x(30).
           05 filler            pic x(3) value " | ".
           05 ds-title          pic x(28).
           05 filler            pic x(3) value " | ".
           05 ds-length         pic x(20).

       procedure division.
       declaratives.

       INPUTFILE-ERROR section.
           use after error procedure on datafile.
           call "C$RERR"          using crerr-status
                                        crerr-mesage
           call "C$RERRNAME"      using rerrname
           call "C$GETLASTFILEOP" using fileOp
           display " "  
           display "Error " crerr-file-status " " 
                   function trim(crerr-ext-status)
                   " on " rerrname
           display crerr-mesage
           display "on statement " fileOp.

       end declaratives.

       MAIN.
           perform CREATE-INPUT-FILE.

           perform DISPLAY-INPUT-FILE.

           goback.

       DISPLAY-DATA-HEADER.
           display " "
           move "ARTIST"  to ds-artist
           move "YEAR"    to ds-year
           move "ALBUM"   to ds-album
           move "TITLE"   to ds-title
           move "LENGTH"  to ds-length

           display display-data.

       CREATE-INPUT-FILE.
           open output datafile

           move "Help!"                  to dr-title
           move "2:21"                   to dr-length
           move "Beatles"                to dr-artist
           move "Help!"                  to dr-album
           move "Pop"                    to dr-genre
           move "Parlophone"             to dr-label
           move 1965                     to dr-year
           write data-rec

           move "Satisfaction"           to dr-title
           move "3:45"                   to dr-length
           move "The Rolling Stones"     to dr-artist
           move "Out of Our Heads"       to dr-album
           move "Rock"                   to dr-genre
           move "Decca/ABKCO"            to dr-label
           move 1965                     to dr-year
           write data-rec

           move "Yesterday"              to dr-title
           move "2:07"                   to dr-length
           move "Beatles"                to dr-artist
           move "Help!"                  to dr-album
           move "Pop"                    to dr-genre
           move "Parlophone"             to dr-label
           move 1965                     to dr-year
           write data-rec

           move "Rain Fall Down"         to dr-title
           move "4:55"                   to dr-length
           move "The Rolling Stones"     to dr-artist
           move "A Bigger Bang"          to dr-album
           move "Rock"                   to dr-genre
           move "Polydor Records"        to dr-label
           move 2005                     to dr-year
           write data-rec

           move "Maria Maria"            to dr-title
           move "4:19"                   to dr-length
           move "Santana"                to dr-artist
           move "Supernatural"           to dr-album
           move "Latin Rock"             to dr-genre
           move "BMG Arista/Ariola"      to dr-label
           move 1999                     to dr-year
           write data-rec

           move "Foo Foo"                to dr-title
           move "6:29"                   to dr-length
           move "Santana"                to dr-artist
           move "Shaman"                 to dr-album
           move "Latin Rock"             to dr-genre
           move "Arista"                 to dr-label
           move 2002                     to dr-year
           write data-rec

           move "After Midnight"         to dr-title
           move "2:51"                   to dr-length
           move "Eric Clapton"           to dr-artist
           move "Eric Clapton"           to dr-album
           move "Rock/Pop"               to dr-genre
           move "Atco, Polydor Records"  to dr-label
           move 1970                     to dr-year
           write data-rec

           move "Next Time You See Her"  to dr-title
           move "4:02"                   to dr-length
           move "Eric Clapton"           to dr-artist
           move "Slowhand"               to dr-album
           move "Blues"                  to dr-genre
           move "Polydor"                to dr-label
           move 1977                     to dr-year
           write data-rec

           move "Albachiara"             to dr-title
           move "4:05"                   to dr-length
           move "Vasco Rossi"            to dr-artist
           move "Non siamo mica gli americani"
                                         to dr-album
           move "Rock"                   to dr-genre
           move "Lotus LOP"              to dr-label
           move 1979                     to dr-year
           write data-rec

           move "Bollicine"              to dr-title
           move "5:40"                   to dr-length
           move "Vasco Rossi"            to dr-artist
           move "Bollicine"              to dr-album
           move "Rock"                   to dr-genre
           move "Carosello"              to dr-label
           move 1983                     to dr-year

           write data-rec

           close datafile.

       DISPLAY-INPUT-FILE.
           display " "
           display "List of the data before the sort..."
           open input datafile

           perform DISPLAY-DATA-HEADER

           perform varying idx from 1 by 1 until idx > 20
              read datafile next
                 at end
                    exit perform
              end-read
              perform DISPLAY-INPUT-RECORD
           end-perform.

           close datafile
           .

       DISPLAY-INPUT-RECORD.
           move dr-artist to ds-artist 
           move dr-year   to ds-year   
           move dr-album  to ds-album  
           move dr-title  to ds-title  
           move dr-length to ds-length 

           display display-data.
