/*
 The following source code can be used as a template for the development of
 a preprocessor program. It just prints some information on the system output. 
*/

import com.iscobol.compiler.custpreproc.LinePreProcessor;
import com.iscobol.compiler.custpreproc.ProcessResult;
import com.iscobol.compiler.custpreproc.ProcessException;

public class PreProcBase implements LinePreProcessor {
    
    String currFile = null;
    String mainFile = null;
    
    public void process(String srcLine, int srcFormat, String srcFile, int lineNumber, String[] opts, ProcessResult newLine) throws ProcessException {
    // show the current source file name 
        if (!srcFile.equals(currFile)) {
            System.out.println("");
            System.out.println(">>> " +srcFile + ":");

            if (currFile == null) {
               System.out.println("Main file");
               System.out.print("Compiler Options: " );
               for (int i=0;i<opts.length;i++) {
                  System.out.print(opts[i]);
               }
               System.out.println("");
               mainFile = srcFile;
            } else {
               if (srcFile == mainFile) {
                   System.out.println("Back to main file");
               } else {
                   System.out.println("Copy file");
               }
            }
            
            currFile = srcFile;

            System.out.println("");
            System.out.println("Format   | Line | Original code");
            System.out.println("---------+------+----------------------------------------------------------------------------------------------------");
        }
        if (lineNumber == 0) {
            System.out.println("<<< " +srcFile);
            System.out.println("");
            return;
        }
    // show the source format of the current line
        switch (srcFormat) {
        case ANSI_FIXED:
           System.out.print ("Ansi     |");
           break;
        case TERMINAL_FIXED:
           System.out.print ("Terminal |");
           break;
        case ANSI_FREE:
           System.out.print ("Free     |");
           break;
        case VARIABLE:
           System.out.print ("Variable |");
           break;
        case LONG_LINE:
           System.out.print ("Long     |");
           break;
        case UNKNOWN_FORMAT:
           System.out.print ("Unknow   |");
           break;
        }
    // show the line number and the line content 

        int width = 5;
        char fill = ' ';
        String toPad = String.valueOf(lineNumber);
        String padded = new String(new char[width - toPad.length()]).replace('\0', fill) + toPad;

        System.out.println(padded + " |" + srcLine);
    }
}
