      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. esql-sample.
       WORKING-STORAGE SECTION.  
       EXEC SQL INCLUDE SQLCA END-EXEC.

      *    Declaration of cursor
       77  cmd                  usage handle.
       EXEC SQL DECLARE query-cursor CURSOR FOR :CMD END-EXEC.  

       77  rec-count            pic 9(4).
       77  ind-var-1            pic s9(4) comp.
       77  ind-var-2            pic s9(4) comp.
       77  ind-var-3            pic s9(4) comp.
       77  ind-var-4            pic s9(4) comp.
       77  ind-var-5            pic s9(4) comp.
       77  sql-query            pic x any length.
       77  query-key            pic 9(4).
       77  query-key-2          pic 9(4).
       77  query-album          pic x(30).
       77  query-artist-1       pic x(20).
       77  query-artist-2       pic x(20).
       77  eof-flag             pic 9.
           88 no-more-records   value 1.
           88 record-available  value 0.
 
       77  choice               pic x.
 
       77  connection-url       pic x any length.
       77  dummy-connection-url pic x any length.
       77  connection-type      pic x any length.
           88 ct-db2            value "db2".
           88 ct-apache-derby   value "derby".
           88 ct-informix       value "informix-sqli".
           88 ct-mariadb        value "mariadb".
           88 ct-ms-sqlsrver    value "sqlserver".
           88 ct-mysql          value "mysql".
           88 ct-oracle         value "oracle".
           88 ct-postgres       value "postgresql".

       77  wrk-autocommit       pic x.
       01                       pic 9.
           88 autocommit        value 1.
           88 no-autocommit     value 0.

       77  idx                  pic 9(3).
       77  num-of-record        pic 9(4).

       01  song-rec.
           05 sr-key            pic 9(2).
           05 sr-title          pic x(30).
           05 sr-length         pic x(5).
           05 sr-Artist         pic x(20).
           05 sr-album          pic x(30).
           05 sr-genre          pic x(15).
           05 sr-label          pic x(30).
           05 sr-year           pic 9(4). 
           05 sr-authors        occurs 5.
              10 sr-author      pic x(20).

       01  display-data.
           05 ds-key            pic X(2).
           05 filler            pic x(3) value " | ".
           05 ds-title          pic x(28).
           05 filler            pic x(3) value " | ".
           05 ds-author-1       pic x(20).
           05 filler            pic x(3) value " | ".
           05 ds-author-2       pic x(20).

       01  tab-album.
      ***
           03 filler pic 9(2)  value 1.
           03 filler pic x(30) value "Let It Be".
           03 filler pic x(5)  value "4:03".
           03 filler pic x(20) value "Beatles".
           03 filler pic x(30) value "Let It Be".
           03 filler pic x(15) value "Pop".
           03 filler pic x(30) value "Apple Records".
           03 filler pic 9(4)  value 1970.
           03 filler pic x(20) value "Paul McCartney".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic 9(2)  value 2.
           03 filler pic x(30) value "Yellow Submarine".
           03 filler pic x(5)  value "2:40".
           03 filler pic x(20) value "Beatles".
           03 filler pic x(30) value "Revolver".
           03 filler pic x(15) value "Pop".
           03 filler pic x(30) value "Apple Records".
           03 filler pic 9(4)  value 1966.
           03 filler pic x(20) value "Paul McCartney".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic 9(2)  value 3.
           03 filler pic x(30) value "Help!".
           03 filler pic x(5)  value "2:21".
           03 filler pic x(20) value "Beatles".
           03 filler pic x(30) value "Help!".
           03 filler pic x(15) value "Pop".
           03 filler pic x(30) value "Parlophone".
           03 filler pic 9(4)  value 1965.
           03 filler pic x(20) value "John Lennon".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic 9(2)  value 4.
           03 filler pic x(30) value "Yesterday".
           03 filler pic x(5)  value "2:07".
           03 filler pic x(20) value "Beatles".
           03 filler pic x(30) value "Help!".
           03 filler pic x(15) value "Pop".
           03 filler pic x(30) value "Parlophone".
           03 filler pic 9(4)  value 1965.
           03 filler pic x(20) value "John Lennon".
           03 filler pic x(20) value "Paul McCartney".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic 9(2)  value 5.
           03 filler pic x(30) value "Angie".
           03 filler pic x(5)  value "4:30".
           03 filler pic x(20) value "The Rolling Stones".
           03 filler pic x(30) value "Goats Head Soup".
           03 filler pic x(15) value "Rock".
           03 filler pic x(30) value "R.S.Records".
           03 filler pic 9(4)  value 1973.
           03 filler pic x(20) value "Mick Jagger".
           03 filler pic x(20) value "Keith Richards".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic 9(2)  value 6.
           03 filler pic x(30) value "Start Me Up".
           03 filler pic x(5)  value "3:32".
           03 filler pic x(20) value "The Rolling Stones".
           03 filler pic x(30) value "Tattoo You".
           03 filler pic x(15) value "Rock".
           03 filler pic x(30) value "Rolling Stones records".
           03 filler pic 9(4)  value 1981.
           03 filler pic x(20) value "Mick Jagger".
           03 filler pic x(20) value "Keith Richards".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic 9(2)  value 7.
           03 filler pic x(30) value "Satisfaction".
           03 filler pic x(5)  value "3:45".
           03 filler pic x(20) value "The Rolling Stones".
           03 filler pic x(30) value "Out of Our Heads".
           03 filler pic x(15) value "Rock".
           03 filler pic x(30) value "Decca/ABKCO".
           03 filler pic 9(4)  value 1965.
           03 filler pic x(20) value "Mick Jagger".
           03 filler pic x(20) value "Keith Richards".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic 9(2)  value 8.
           03 filler pic x(30) value "Rain Fall Down".
           03 filler pic x(5)  value "4:55".
           03 filler pic x(20) value "The Rolling Stones".
           03 filler pic x(30) value "A Bigger Bang".
           03 filler pic x(15) value "Rock".
           03 filler pic x(30) value "Polydor Records".
           03 filler pic 9(4)  value 2005.
           03 filler pic x(20) value "Mick Jagger".
           03 filler pic x(20) value "Keith Richards".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic 9(2)  value 9.
           03 filler pic x(30) value "Maria Maria".
           03 filler pic x(5)  value "4:19".
           03 filler pic x(20) value "Santana".
           03 filler pic x(30) value "Supernatural".
           03 filler pic x(15) value "Latin Rock".
           03 filler pic x(30) value "BMG Arista/Ariola".
           03 filler pic 9(4)  value 1999.
           03 filler pic x(20) value "Raul Rekow".
           03 filler pic x(20) value "Jerry Duplessis".
           03 filler pic x(20) value "Wyclef Jean".
           03 filler pic x(20) value "Carlos Santana".
           03 filler pic x(20) value "Karl Perazzo".
      ***
           03 filler pic 9(2)  value 10.
           03 filler pic x(30) value "Oye como va".
           03 filler pic x(5)  value "4:36".
           03 filler pic x(20) value "Santana".
           03 filler pic x(30) value "Abraxas".
           03 filler pic x(15) value "Latin Rock".
           03 filler pic x(30) value "Columbia Records".
           03 filler pic 9(4)  value 1970.
           03 filler pic x(20) value "Tito Puente".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic 9(2)  value 11.
           03 filler pic x(30) value "Lightning in the sky".
           03 filler pic x(5)  value "3:50".
           03 filler pic x(20) value "Santana".
           03 filler pic x(30) value "Marathon".
           03 filler pic x(15) value "Latin Rock".
           03 filler pic x(30) value "Columbia Records".
           03 filler pic 9(4)  value 1979.
           03 filler pic x(20) value "Keith Olsen".
           03 filler pic x(20) value "Santana".
           03 filler pic x(20) value "David De Vore".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic 9(2)  value 12.
           03 filler pic x(30) value "Foo Foo".
           03 filler pic x(5)  value "6:29".
           03 filler pic x(20) value "Santana".
           03 filler pic x(30) value "Shaman".
           03 filler pic x(15) value "Latin Rock".
           03 filler pic x(30) value "Arista".
           03 filler pic 9(4)  value 2002.
           03 filler pic x(20) value "Clive Davis".
           03 filler pic x(20) value "Carlos Santana".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic 9(2)  value 13.
           03 filler pic x(30) value "Money for Nothing".
           03 filler pic x(5)  value "6:19".
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(30) value "After Midnight Live". 
           03 filler pic x(15) value "Rock/Pop".
           03 filler pic x(30) value "Immortal".
           03 filler pic 9(4)  value 2006.
           03 filler pic x(20) value "Mark Knopfler".
           03 filler pic x(20) value "Sting".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic 9(2)  value 14.
           03 filler pic x(30) value "After Midnight".
           03 filler pic x(5)  value "2:51".
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(30) value "Eric Clapton".
           03 filler pic x(15) value "Rock/Pop".
           03 filler pic x(30) value "Atco, Polydor Records".
           03 filler pic 9(4)  value 1970.
           03 filler pic x(20) value "J.J. Cale".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic 9(2)  value 15.
           03 filler pic x(30) value "Bad Love".
           03 filler pic x(5)  value "6:25".
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(30) value "24 Nights".
           03 filler pic x(15) value "Blues rock".
           03 filler pic x(30) value "Duck Records".
           03 filler pic 9(4)  value 1991.
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic 9(2)  value 16.
           03 filler pic x(30) value "Next Time You See Her".
           03 filler pic x(5)  value "4:02".
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(30) value "Slowhand".
           03 filler pic x(15) value "Blues".
           03 filler pic x(30) value "Polydor".
           03 filler pic 9(4)  value 1977.
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic 9(2)  value 17.
           03 filler pic x(30) value "Albachiara".
           03 filler pic x(5)  value "4:05".
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(30) value "Non siamo mica gli americani".
           03 filler pic x(15) value "Rock".
           03 filler pic x(30) value "Lotus LOP".
           03 filler pic 9(4)  value 1979.
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic 9(2)  value 18.
           03 filler pic x(30) value "Tango".
           03 filler pic x(5)  value "3:07".
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(30) value "Liberi Liberi".
           03 filler pic x(15) value "Rock".
           03 filler pic x(30) value "Emi".
           03 filler pic 9(4)  value 1988.
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic 9(2)  value 19.
           03 filler pic x(30) value "C'e' chi dice no". 
           03 filler pic x(5)  value "4:38".
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(30) value "C'e' chi dice no". 
           03 filler pic x(15) value "Rock".
           03 filler pic x(30) value "Carosello".
           03 filler pic 9(4)  value 1987.
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(20) value "Maurizio Solieri".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic 9(2)  value 20.
           03 filler pic x(30) value "Bollicine".
           03 filler pic x(5)  value "5:40".
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(30) value "Bollicine".
           03 filler pic x(15) value "Rock".
           03 filler pic x(30) value "Carosello".
           03 filler pic 9(4)  value 1983.
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".

       01  tab-album-red  redefines tab-album.
           03 ta-item        occurs 20.
              05 ta-key      pic 9(2).
              05 ta-title    pic x(30).
              05 ta-length   pic x(5).
              05 ta-artist   pic x(20).
              05 ta-album    pic x(30).
-              05 ta-genre    pic x(15).
              05 ta-label    pic x(30).
              05 ta-year     pic 9(4).
              05 ta-authors  occurs 5.
                 10 ta-author pic x(20).

       PROCEDURE DIVISION.
       Main.                             
      *First of all we have to configure the jdbc environment.
      *Check the iscobol.properties and modify it for the correct 
      *connection values. Refer to their jdbc documentation and samples

      *I'll check if we are executing the program with autocommit 
      *setting active or not
           accept wrk-autocommit   from environment "jdbc.autocommit"
              on exception
                 set no-autocommit to true
              not on exception
                 if function upper-case (wrk-autocommit) = "T" or
                    wrk-autocommit = 1 
                    set autocommit to true
                 else
                    set no-autocommit to true
                 end-if
           end-accept
      *Next step in sql programs is the connection to the database
           perform CONNECT.

      *Then I make some settings for a specific DB
           perform DB-DEPENDING-SETTING.

      *Then we should create a test table named ISSONGS
           perform CREATE-TABLE.

      *If the table already exist drop the table
           evaluate SQLCODE
           when 0
                continue
           when other
                display "Error:"
                display "SQLCODE is " SQLCODE 
                display "Message is <" SQLERRMC ">"

                if ct-postgres and no-autocommit 
                   perform COMMIT-STATEMENT
                end-if

                perform DROP-TABLE
           end-evaluate
           .

           display " ".
           display "Populating table".
      *Fill the table with a record using constant values
           perform INSERT-WITH-CONSTANT-VALUES.

      *Fill the table with records using variables 
      *and put a NULL value in a record using indicator variables
           perform varying idx from 2 by 1 until idx > 20
              perform INSERT-WITH-VARIABLE-VALUE
           end-perform.

      *Commit all operations if the db is not in autocommit mode
           if no-autocommit
              perform COMMIT-STATEMENT
           end-if
           .

      *Now read the table data using a cursor
      *The declaration of the cursor must appear before the other 
      *statements that use the cursor in the source file
           perform READ-TABLE-WITH-CURSOR

      *Now read the data in a more flexible way, using prepared commands
      *and variable criteria
           perform READ-TABLE-WITH-PREPARED-COMMAND

      *Now read the data using prepared commands and 2 variable criteria
           perform READ-TABLE-WITH-PREPARED-COMMAND-2

      *Now retrieve the number of record for a specif criteria
           perform COUNT-RECORDS.

      *Now we update some records
           perform UPDATE-RECORDS

      *Now we delete some recordd
           perform DELETE-RECORDS
           .


      *Disconnect from the db
           perform DISCONNECT.

      *End of sample, now you have a new table called ISSONGS in your
      *database.
           DISPLAY "End.".
           stop run
           .

       CONNECT.
           display "Connecting".
           EXEC SQL 
              connect
           END-EXEC
           perform TEST-SQL-STATUS.


       DB-DEPENDING-SETTING.
           accept connection-url from environment "jdbc.url"

           unstring connection-url delimited by ":"
                    into dummy-connection-url
                         connection-type

           evaluate true
           when ct-mariadb
           when ct-mysql
                EXEC SQL
                   EXECUTE IMMEDIATE
                        "SET SESSION sql_mode = 'ANSI_QUOTES'"
                END-EXEC
                perform TEST-SQL-STATUS
           when ct-oracle
                set environment "jdbc.kept_spaces" to -1
           end-evaluate.

       CREATE-TABLE.
           DISPLAY "Creating table".

           EXEC SQL 
              CREATE TABLE ISSONGS (SR_KEY        NUMERIC NOT NULL,
                                    SR_TITLE      CHAR(30),
                                    SR_LENGTH     CHAR(5),
                                    SR_ARTIST     CHAR(20),
                                    SR_ALBUM      CHAR(30),
                                    SR_GENRE      CHAR(15),
                                    SR_LABEL      CHAR(30),
                                    SR_YEAR       NUMERIC,
                                    SR_AUTHOR_1   CHAR(20),
                                    SR_AUTHOR_2   CHAR(20),
                                    SR_AUTHOR_3   CHAR(20),
                                    SR_AUTHOR_4   CHAR(20),
                                    SR_AUTHOR_5   CHAR(20)
                                   )
           END-EXEC
           .

       DROP-TABLE.
           display ""

           display "This error can occur when the table already exists."
           perform until 1 = 2
              display "Do you want to proceed with DROP TABLE to have a 
      -            "clean execution (N|Y)?"
              accept choice
              if function upper-case (choice) = "Y" or
                 function upper-case (choice) = "N"
                 exit perform
              end-if 
           end-perform

           if function upper-case (choice) = "Y"
              display ""
              display "Drop the table"

              EXEC SQL 
                 DROP TABLE ISSONGS 
              END-EXEC

              perform TEST-SQL-STATUS
      *Commit all operations if the db is not in autocommit mode
              if no-autocommit
                 perform COMMIT-STATEMENT
              end-if
              perform CREATE-TABLE
              perform TEST-SQL-STATUS
           else
              EXEC SQL 
                  disconnect all 
              END-EXEC
              stop run
           end-if
           .

       INSERT-WITH-CONSTANT-VALUES.
           EXEC SQL 
              INSERT INTO ISSONGS values (01, 'Let It Be',
                                            '4:03', 'Beatles',
                                            'Let It Be', 'Pop',
                                            'Apple Records',
                                            1970, 'Paul McCartney',
                                            '','','',''
                                            )
           END-EXEC.
           perform TEST-SQL-STATUS.

       INSERT-WITH-VARIABLE-VALUE.
           if ta-author(idx, 1) = space
              move -1  to ind-var-1
           else
              move 0   to ind-var-1
           end-if
           if ta-author(idx, 2) = space
              move -1  to ind-var-2
           else
              move 0   to ind-var-2
           end-if
           if ta-author(idx, 3) = space
              move -1  to ind-var-3
           else
              move 0   to ind-var-3
           end-if
           if ta-author(idx, 4) = space
              move -1  to ind-var-4
           else
              move 0   to ind-var-4
           end-if
           if ta-author(idx, 5) = space
              move -1  to ind-var-5
           else
              move 0   to ind-var-5
           end-if

           EXEC SQL 
              INSERT INTO ISSONGS VALUES (:ta-key(idx),
                                          :ta-title(idx),
                                          :ta-length(idx),
                                          :ta-Artist(idx),
                                          :ta-album(idx),
                                          :ta-genre(idx),
                                          :ta-label(idx),
                                          :ta-year(idx),
                                          :ta-author(idx, 1):ind-var-1,
                                          :ta-author(idx, 2):ind-var-2,
                                          :ta-author(idx, 3):ind-var-3,
                                          :ta-author(idx, 4):ind-var-4,
                                          :ta-author(idx, 5):ind-var-5
                                         )
           END-EXEC
           perform TEST-SQL-STATUS.

       COMMIT-STATEMENT.
           display " ".
           display "Committing".
           EXEC SQL 
              commit 
           END-EXEC
           perform TEST-SQL-STATUS.

       READ-TABLE-WITH-CURSOR.
           display " ".
           display "Read the table data using a cursor"
           display "Declaring cursor".

           EXEC SQL 
              DECLARE C1 cursor for select * from ISSONGS 
           END-EXEC

           display "Opening cursor".
           EXEC SQL OPEN C1 INTO :sr-key,
                                 :sr-title,
                                 :sr-length,
                                 :sr-artist,
                                 :sr-album,
                                 :sr-genre,
                                 :sr-label,
                                 :sr-year,
                                 :sr-author(1):IND-VAR-1,
                                 :sr-author(2):IND-VAR-2,
                                 :sr-author(3):IND-VAR-3,
                                 :sr-author(4):IND-VAR-4,
                                 :sr-author(5):IND-VAR-5
           END-EXEC     
           perform TEST-SQL-STATUS

           display "Reading table".

           perform DISPLAY-DATA-HEADER
           set RECORD-AVAILABLE to true.
           perform until NO-MORE-RECORDS
              EXEC SQL 
                 fetch next C1 
              END-EXEC
              perform TEST-SQL-STATUS
              if RECORD-AVAILABLE
                 perform DISPLAY-RECORD
              end-if   
           end-perform

           display "Closing cursor".
           EXEC SQL 
              close C1 
           END-EXEC
           perform TEST-SQL-STATUS.

       READ-TABLE-WITH-PREPARED-COMMAND.
           display " ".
           display "Read the data using a prepared command with variable 
      -            " criteria"
           display "(SR_KEY = 1)"
      
           DISPLAY "Declaring command".
           move 'SELECT * FROM ISSONGS WHERE SR_KEY = ?' 
                                                        to SQL-QUERY
           EXEC SQL 
              prepare :CMD from :SQL-QUERY 
           END-EXEC 
           perform TEST-SQL-STATUS

           DISPLAY "Opening cursor".
           move 1 to QUERY-KEY
           EXEC SQL 
              open query-cursor using :QUERY-KEY 
                                 into :sr-key,
                                      :sr-title,
                                      :sr-length,
                                      :sr-Artist,
                                      :sr-album,
                                      :sr-genre,
                                      :sr-label,
                                      :sr-year,
                                      :sr-author(1):IND-VAR-1,
                                      :sr-author(2):IND-VAR-2,
                                      :sr-author(3):IND-VAR-3,
                                      :sr-author(4):IND-VAR-4,
                                      :sr-author(5):IND-VAR-5
           END-EXEC 
           perform TEST-SQL-STATUS

           DISPLAY "Reading table".
           perform DISPLAY-DATA-HEADER
           set RECORD-AVAILABLE to true.
           perform until NO-MORE-RECORDS
              EXEC SQL 
                 fetch next query-cursor 
              END-EXEC
              perform TEST-SQL-STATUS
              if RECORD-AVAILABLE
                 perform DISPLAY-RECORD
              end-if   
           end-perform   
           DISPLAY "Closing cursor".
           EXEC SQL 
              close query-cursor 
           END-EXEC
           perform TEST-SQL-STATUS
           EXEC SQL 
              free :CMD 
           END-EXEC
           perform TEST-SQL-STATUS.

       READ-TABLE-WITH-PREPARED-COMMAND-2.
           display " ".
           display "Read the data using a prepared command with 2 variab
      -            "le criteria"
           display "(SR_YEAR from 1970 and 1980)"

           DISPLAY "Declaring command".
           initialize SQL-QUERY
           string 'SELECT * FROM ISSONGS '
                  'WHERE SR_YEAR >= ? AND SR_YEAR < ? '
                  into SQL-QUERY
           EXEC SQL 
              prepare :CMD from :SQL-QUERY 
           END-EXEC 
           perform TEST-SQL-STATUS

           DISPLAY "Opening cursor".
           move 1970 to QUERY-KEY
           move 1980 to QUERY-KEY-2
           EXEC SQL 
              open query-cursor using :query-key,
                                      :query-key-2
                                 into :sr-key,
                                      :sr-title,
                                      :sr-length,
                                      :sr-Artist,
                                      :sr-album,
                                      :sr-genre,
                                      :sr-label,
                                      :sr-year,
                                      :sr-author(1):IND-VAR-1,
                                      :sr-author(2):IND-VAR-2,
                                      :sr-author(3):IND-VAR-3,
                                      :sr-author(4):IND-VAR-4,
                                      :sr-author(5):IND-VAR-5
           END-EXEC 
           perform TEST-SQL-STATUS

           DISPLAY "Reading table".
           perform DISPLAY-DATA-HEADER
           set RECORD-AVAILABLE to true.
           perform until NO-MORE-RECORDS
              EXEC SQL 
                 fetch next query-cursor 
              END-EXEC
              perform TEST-SQL-STATUS
              if RECORD-AVAILABLE
                 perform DISPLAY-RECORD
              end-if   
           end-perform
           DISPLAY "Closing cursor".
           EXEC SQL 
              close query-cursor 
           END-EXEC
           perform TEST-SQL-STATUS
           EXEC SQL 
              free :CMD 
           END-EXEC
           perform TEST-SQL-STATUS.
       
       COUNT-RECORDS.
           display " ".
           display "Retrieve the number of records that match with a spe
      -            "cifc criteria"
           display "('SR_ARTIST' = 'Vasco Rossi')"
           display "Expected 4 rows".

           EXEC SQL
              select count(*)
                 into :num-of-record
                    from ISSONGS
                 where SR_ARTIST = 'Vasco Rossi'
           END-EXEC.
           perform TEST-SQL-STATUS.
           display "Number of rows " NUM-OF-RECORD.

       UPDATE-RECORDS.
           display " ".
           display "Update records on the table"
           display "Expected the update of 4 rows".

           EXEC SQL
              update ISSONGS set SR_ARTIST = 'BEATLES' 
                             where SR_ARTIST = 'Beatles'
           END-EXEC.
           perform TEST-SQL-STATUS.
           display "Number of updated records " SQLERRD(3).

           display " ".
           display "Update some records on the table with a prepared sta
      -            "tement".
           display "Expected the update of 0 rows".

           display "Declaring command".
           move 
            'update ISSONGS set SR_ARTIST = ? where SR_ARTIST = ?' 
                                                        to SQL-QUERY
           EXEC SQL 
              prepare :CMD 
              from :SQL-QUERY 
           END-EXEC 
           perform TEST-SQL-STATUS.

           move "from-value" to query-Artist-1
           move "to-value"   to query-Artist-2
           EXEC SQL 
              execute :cmd using :query-Artist-1,
                                 :query-Artist-2
           END-EXEC 
           perform TEST-SQL-STATUS.
           display "Number of updated records " SQLERRD(3).

           EXEC SQL 
              free :CMD 
           END-EXEC
           perform TEST-SQL-STATUS.

      *Commit all operations if the db is not in autocommit mode
           if no-autocommit
              perform COMMIT-STATEMENT
           end-if
           .

       DELETE-RECORDS.
           display " ".
           display "Delete some records from the table with a prepared s
      -            "tatement".
           display "Expected 2 deleted rows".

           DISPLAY "Declaring command".
           move 'delete from ISSONGS where SR_ALBUM = ?' 
                                                     to SQL-QUERY
           EXEC SQL 
              prepare :CMD 
              from :SQL-QUERY 
           END-EXEC 
           perform TEST-SQL-STATUS.

           move "Help!" to query-album
           EXEC SQL 
              execute :cmd using :query-album
           END-EXEC 
           perform TEST-SQL-STATUS.
           display "Number of deleted records " SQLERRD(3).

           EXEC SQL 
              free :CMD 
           END-EXEC
           perform TEST-SQL-STATUS.

      *Commit all operations if the db is not in autocommit mode
           if no-autocommit
              perform COMMIT-STATEMENT
           end-if
           .

       DISCONNECT.
           DISPLAY " ".
           DISPLAY "Disconnecting".
           EXEC SQL DISCONNECT ALL END-EXEC
           perform TEST-SQL-STATUS.

       TEST-SQL-STATUS.
           evaluate SQLCODE
           when 0
                continue
           when 100
                set NO-MORE-RECORDS to true
           when other
                display "Error:"
                display "SQLCODE is " SQLCODE 
                display "Message is <" SQLERRMC ">"
                EXEC SQL 
                   disconnect all 
                END-EXEC
                stop run
           end-evaluate
           .

       DISPLAY-RECORD.
           if IND-VAR-1 = -1
              move "NULL" to sr-author(1)
           end-if
           if IND-VAR-2 = -1
              move "NULL" to sr-author(2)
           end-if
           if IND-VAR-3 = -1
              move "NULL" to sr-author(3)
           end-if
           if IND-VAR-4 = -1
              move "NULL" to sr-author(4)
           end-if
           if IND-VAR-5 = -1
              move "NULL" to sr-author(5)
           end-if

           move sr-key       to ds-key
           move sr-title     to ds-title
           move sr-author(1) to ds-author-1
           move sr-author(2) to ds-author-2

           display display-data.

       DISPLAY-DATA-HEADER.
           display " "
           move "ID"        to ds-key
           move "TITLE"     to ds-title
           move "AUTHOR 1"  to ds-author-1
           move "AUTHOR 2"  to ds-author-2

           display display-data.
       