      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       program-id. calendar.

       configuration section.
       repository.
           class calendar        as "com.toedter.calendar.JCalendar"
           class iscobol-java-bean   
                           as "com.iscobol.gui.server.CobolGUIJavaBean"
           class j-locale        as "java.util.Locale"
           class j-calendar      as "java.util.Calendar"
           class property-change-event
                                 as "java.beans.PropertyChangeEvent"
           class event-object    as "java.util.EventObject"
           class bool            as "java.lang.Boolean"
           .

       working-storage section.
           copy "iscrt.def".
           copy "isgui.def".
           copy "component.def".
      *>-
       77  e-source        is special-names event source   
                           object reference iscobol-java-bean.
       77  e-object        is special-names event object   
                           object reference event-object.  
       77  pc-object       object reference property-change-event.
       77  curr-date       object reference j-calendar.
       77  obj-calendar    object reference iscobol-java-bean.
       77  def-locale      object reference j-locale.
      *>-
       77  key-status      is special-names crt status     pic 9(5).
       77  hWin            handle of window.
       77  close-win       pic 9 value 0. 

       77  small-font      handle of font small-font.
       77  pr-name         pic x(10).    
       77  woy-flag        pic 9 value 1.
       01  date-value.
           03 date-day     pic 99.
           03 filler       pic x value "/".
           03 date-mounth  pic 99.
           03 filler       pic x value "/".
           03 date-year    pic 9999.

       screen section.
       01 mask.
           03 cal 
              java-bean 
              clsid             "com.toedter.calendar.JCalendar"
              event-list        ( "propertychange" )
              line              1.5 
              col               3 
              size              76 
              lines             20
              object            obj-calendar
              event             CAL-EVT
              .
           03 label 
              line              21.4
              col               3
              lines             2.5
              size              76
              background-color  RGB x#D2E4EE
              .
           03 label 
              title             "Date: "
              line              22 
              col               4
              foreground-color  RGB x#005AA4
              transparent
              .
           03 ef1 
              entry-field 
              line              22.3 
              col               10 
              size              20
              background-color  RGB x#D2E4EE
              foreground-color  RGB x#A40000
              read-only
              no-box
              .
           03 pb1 
              push-button
              title             "Set Date"
              line              22 
              col               69
              exception-value   1001
              .
           03 ck1 
              check-box
              notify
              title             "Show week of year"
              line              24.5 
              col               3  
              value             woy-flag 
              .
       procedure division.
       main.
           display standard graphical window                   
                   background-low
                   with   system menu
                   title  "Calendar Bean Demo"
                   control font small-font
                   handle hWin
                   event  WIN-EVT

           display mask.

           set def-locale to j-locale:>getDefault().
           obj-calendar:>setProperty( "locale" def-locale ).

           perform until key-status = 27 or close-win = 1
              accept mask 
                 on exception 
                    continue 
              end-accept
              evaluate woy-flag
              when 1 
                   obj-calendar:>callMethod( "setWeekOfYearVisible", 
                                             bool:>TRUE )
              when 0 
                   obj-calendar:>callMethod( "setWeekOfYearVisible", 
                                             bool:>FALSE)
              end-evaluate
              if key-status = 1001
                 set curr-date to j-calendar:>getInstance()
                 curr-date:>set( 2007 05 02 )
                 obj-calendar:>setProperty( "calendar" curr-date ) 
              end-if
           end-perform.

           destroy Mask           
           destroy hWin
           goback
           .

       CAL-EVT.
           if event-type = msg-jb-event
              if event-data-2 = Component-propertyChange
                 set pc-object to e-object as property-change-event
                 set pr-name to pc-object:>getPropertyName()
                 if pr-name = "calendar"
                    set curr-date to e-source:>getProperty( "calendar" ) 
                                                          as j-calendar 
                    perform FORMAT-DATE
                 end-if
              end-if
           end-if
           .

       FORMAT-DATE.
           set date-day to curr-date:>get( j-calendar:>DAY_OF_MONTH )
           set date-mounth to curr-date:>get( j-calendar:>MONTH )
           add 1 to date-mounth
           set date-year to curr-date:>get( j-calendar:>YEAR )
           modify ef1 value date-value
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .
           