var baseUrl = this.window.location.href;
var scriptAdded=false;

var map = null;
var mapControl = null;
var offices =[];
var markers = [];


var webclientInstance0 = {
    options: {
      autoStart: false,
      args: '',
      recording: getParam('recording'),
      debugPort: getParam('debugPort'),
      connectionUrl: baseUrl,
      syncClipboard : true,

      compositingWindowsListener:{
         windowOpened: function(win) {
            if (win.name === 'f-map'){
               createMap(win)
            }
         },
      },

      customization: function(injector) {
         injector.services.base.handleActionEvent = function(actionName, data, binaryData) {
            if (actionName === 'addOffices'){
               offices = JSON.parse(data); 
               if (map){
                  displayOffices();
               }
            }

            if (actionName === "showOffice") {
               let office = JSON.parse(data);
               selectOffice(office);
               console.log(office);
            }
            if (actionName == 'sumResult'){
               var returnData = JSON.parse(data);
               document.getElementById('result').value = `The sum of ${returnData.num1} and ${returnData.num2} is ${returnData.sum}`;
            }

            if (actionName === "CheckJS") {
               webclientInstance0.performAction({actionName: 'CheckOK'});
            }
            if (actionName === "ComSample") {
               webclientInstance0.performAction({actionName: 'ComSample',data:data.toLowerCase(), binaryData:binaryData});
            }
         }
      } 
    }
  }

  function getParam(name) {
       name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
       var results = new RegExp("[\\?&]" + name + "=([^&#]*)").exec(location.href);
       return results == null ? null : decodeURIComponent(results[1]);
  }

  
  (function (window, document) {
      var loader = function () {
          baseUrl = baseUrl.indexOf("/", baseUrl.length - 1) !== -1 ? baseUrl : (baseUrl + "/");
          var xmlhttp = new XMLHttpRequest();
          xmlhttp.onreadystatechange = function () {
              if (xmlhttp.readyState == XMLHttpRequest.DONE) {
                  var version = xmlhttp.status == 200 ? xmlhttp.responseText : "undefined";
                  var script = document.createElement("script"),
                      tag = document.getElementsByTagName("script")[0];
                  script.src = baseUrl + "javascript/webswing-embed.js?version=" + version;
                  tag.parentNode.insertBefore(script, tag);
              }
          };
          xmlhttp.open("GET", baseUrl + "rest/version", true);
          xmlhttp.send();
      };
      window.addEventListener ? window.addEventListener("load", loader, false) : window.attachEvent("onload", loader);
  })(window, document);
  


   function performSearch(){
    webclientInstance0.performAction({actionName: "search", data: document.getElementById('search').value, binaryData: null});
   }

   function createMap(win) {
      setControlId(win.name);
      mapControl = win;
  
      map = L.map(win.name).setView([51.505, -0.09], 1);
  
      L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: 'Veryant',
        attributionControl: false,
      }).addTo(map);
  

      if (offices){
         displayOffices();
      }
   
     
     win.handleActionEvent = function(actionName, data, binaryData) {
         if (actionName === 'addOffices'){
            markers = [];
            offices = JSON.parse(data); 
            offices.forEach(office => addMarker(office));
            console.log(offices);
         }

         if (actionName === 'selectOffice'){
            let office = JSON.parse(data);
            selectOffice(office);
         }

         if (actionName === 'closeDetails') {
            resetMap();
         }
           
      }
   }
    
   function resetMap() {
      map.setView([51.505, -0.09], 1, {
         animate: true
      });
      markers.forEach(m => {
         if (m.getPopup().isOpen()) {
            m.closePopup();
         }
      })
   }
   
   function setControlId(elementName){
      var panel = webclientInstance0.getWindows().filter(w => w.name === elementName);
      if (panel.length > 0){
        panel[0].element.id = elementName;
        return true;
      } else {
        return false;
      }
    }
  
   function selectOffice(office){
      let selectedOffice = offices.filter(o => o.description === office.description);
      if (selectedOffice.length > 0){
         if (map != null){

            centerMap(selectedOffice[0], 13);
         }
      }         
   }

   function displayOffices(){
      offices.forEach(office => addMarker(office));
   }


   function addMarker(office){
      var marker = L.marker([office.lat, office.lng]).addTo(map);

      var popupContent = office.description;

      marker.bindPopup(popupContent);

      marker.on('click', function() {
         if (this.getPopup().isOpen()) {
            centerMap(office, 13);
            mapControl.performAction({actionName: 'pinClicked', data:  this.getPopup().getContent()});
         }
     });

     marker.getPopup().on('close', function() {
      mapControl.performAction({actionName: 'pinClosed', data:  this.getPopup().getContent()});
     });


     markers.push(marker);

      return marker
   }

   function centerMap(office, zoomLevel) {
      map.setView([office.lat, office.lng], zoomLevel, {
          animate: true,
          duration: 1, // Duration of animation in seconds
          easeLinearity: 0.25, // Animation easing, 0.0 is linear, 1.0 is no easing
      });
    }

   function executeApp(){
      webclientInstance0.configure();
      webclientInstance0.start();
   }