      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. MESSAGE-BOX.
       CONFIGURATION SECTION.
       REPOSITORY.
           .

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.

       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscobol.def".   
       copy "isresize.def".
       copy "iscrt.def".
       copy "isopensave.def".
       copy "isfonts.def".

       77  crt-status                       special-names 
                                            crt status pic 9(5).
       77  hWin                             handle of window.
       77  close-win                        pic 9 value 0.
       77  control-font                     handle of font.
       77  base-sorg-path                   pic x(20). 
       77  command                          pic x(100).

       77  spooler-name                     pic x(128).
       77  winprint-status                  pic s99.

       77  p-title                          pic x any length.
       77  p-text                           pic x any length.
       77  p-type                           pic x any length.
       77  p-icon                           pic x any length.
       77  p-default                        pic x any length.
       77  p-before-time                    pic 9(5).
       77  p-centered                       pic 9.
       77  p-color                          pic 9.
       77  p-foreground-color               pic x(6).
       77  p-background-color               pic x(6).
       77  p-font                           pic 9.
       77  p-font-description               pic x any length.
       77  p-message-type                   pic 9.
           88 p-iscobol-message             value 1. 
           88 p-custom-message              value 2. 
       77  p-result                         pic 9.

       77  e-iscobol-message                pic 9.
       77  e-color                          pic 9.
       77  e-font                           pic 9.
       
       77  wrk-font                         handle of font.

       77  wrk-type                         pic 9.
       77  wrk-default                      pic 9.
       77  wrk-icon                         pic 9.

       77  wrk-foreground-color             pic s9(9).
       77  wrk-background-color             pic s9(9).

       77  wrk-font-name                    pic x(33).
       77  wrk-font-size                    pic 99.

       01  wrk-color-hex.
           03  wrk-hex-r   pic xx.
           03  wrk-hex-g   pic xx.
           03  wrk-hex-b   pic xx.
       77  wrk-color       pic s9(9).
       01  wrk-buffer-rgb.
           03  wrk-r       pic 999.
           03  wrk-g       pic 999.
           03  wrk-b       pic 999.

       78  msg-type-ok                   value "MB-OK".
       78  msg-type-yes-no               value "MB-YES-NO".
       78  msg-type-ok-cancel            value "MB-OK-CANCEL".
       78  msg-type-yes-no-cancel        value "MB-YES-NO-CANCEL".
       78  msg-type-retry-cancel         value "MB-RETRY-CANCEL".
       78  msg-type-abort-retry-ignore   value "MB-ABORT-RETRY-IGNORE".
       78  msg-type-cancel-retry-continue  
                                      value "MB-CANCEL-RETRY-CONTINUE".

       78  msg-default-icon              value "MB-DEFAULT-ICON".
       78  msg-warning-icon              value "MB-WARNING-ICON".
       78  msg-error-icon                value "MB-ERROR-ICON".

       78  msg-default-ok                value "MB-OK".
       78  msg-default-yes               value "MB-YES".
       78  msg-default-no                value "MB-NO".
       78  msg-default-cancel            value "MB-CANCEL".
       78  msg-default-abort             value "MB-ABORT".
       78  msg-default-retry             value "MB-RETRY".
       78  msg-default-ignore            value "MB-IGNORE".
       78  msg-default-continue          value "MB-CONTINUE".

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  3
              size                 10 cells
              title                "Title:"
              transparent
              .
           03 ef-title
              entry-field
              line                 2
              col                  10
              size                 42 cells
              value                p-title
              .
           03 label
              line                 4
              col                  3
              size                 10 cells
              title                "Text:"
              transparent
              .
           03 ef-text
              entry-field
              line                 4
              col                  10
              lines                2
              size                 59 cells
              multiline
              use-return
              value                p-text
              vscroll-bar
              .
           03 label
              line                 7
              col                  3
              size                 10 cells
              title                "Type:"
              transparent
              .
           03 cb-type
              combo-box
              line                 7
              col                  10
              size                 30 cells
              value                p-type
              unsorted
              drop-list
              .
           03 label
              line                 7
              col                  42
              size                 10 cells
              title                "Default:"
              transparent
              .
           03 cb-default
              combo-box
              line                 7
              col                  53
              size                 16 cells
              value                p-default
              unsorted
              drop-list
              .
           03 label
              line                 9
              col                  3
              size                 10 cells
              title                "Icon:"
              transparent
              .
           03 cb-icon
              combo-box
              line                 9
              col                  10
              size                 30 cells
              value                p-icon
              unsorted
              drop-list
              .
           03 label
              line                 9
              col                  42
              size                 10 cells
              title                "Before time:"
              .
           03 ef-before-time
              entry-field
              line                 9
              col                  53
              size                 7 cells
              use-return
              numeric
              right
              picture              z(5)
              value                p-before-time
              .
           03 ck-centered
              check-box
              title                "Centered"
              line                 11.5
              col                  10
              size                 15 cells
              value                p-centered
              exception-value      104
              .
           03 rb-iscobol-message
              radio-button
              group                1
              group-value          1
              line                 11.5
              col                  30
              title                "Message Box"
              value                p-message-type
              exception-value      101
              .
           03 rb-custom-message 
              radio-button
              group                1
              group-value          2
              line                 11.5
              col                  50
              title                "Custom Message Box"
              value                p-message-type
              exception-value      102
              .
           03 frame
              engraved
              title                "Color:"
              line                 13
              col                  2
              lines                3
              size                 68
              .
           03 ck-color
              check-box
              title                "Custom color:"
              line                 14.15
              col                  5
              size                 16 cells
              value                p-color
              left-text
              left-text-alignment  1
              enabled              e-iscobol-message
              exception-value      103
              .
           03 label
              line                 14
              col                  22
              size                 10 cells
              title                "Foreground:"
              .
           03 ef-foreground
              entry-field
              line                 14
              col                  33
              size                 8 cells
              value                p-foreground-color 
              max-text             6
              format-string        "HHHHHH"
              enabled              e-color
              .
           03 label
              line                 14
              col                  42
              size                 10 cells
              title                "Background:"
              .
           03 ef-background
              entry-field
              line                 14
              col                  53
              size                 8 cells
              value                p-background-color
              max-text             6
              format-string        "HHHHHH"
              enabled              e-color
              .
           03 frame
              engraved
              title                "Font:"
              line                 16.3
              col                  2
              lines                3
              size                 68
              .
           03 ck-font
              check-box
              title                "Custom font:"
              line                 17.45
              col                  5
              size                 16 cells
              value                p-font
              left-text
              left-text-alignment  1
              enabled              e-iscobol-message
              exception-value      104
              .
           03 lbl-font
              label
              line                 17.3
              col                  23
              size                 20 cells
              title                p-font-description 
              .
           03 pb-font
              push-button
              line                 17.3
              col                  53
              title                "Change font"
              size                 15 cells
              exception-value      105
              self-act
              enabled              e-color
              .
           03 push-button
              line                 2
              col                  53
              size                 16 cells
              title                "Display message" 
              exception-value      1
              .

           03 label
              line                 20
              col                  5
              title                "Giving:"
              .
           03 lb-result
              label
              line                 20
              col                  12
              title                p-result
              foreground-color     rgb x#0000E3
              .
           03 push-button
              line                 20
              col                  24
              size                 34 cells
              title                "View custom message source code" 
              exception-value      2
              .
           03 Pb-exit
              push-button
              line                 20
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       main. 
           accept base-sorg-path from environment "home_source".
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "Message Box"
                   handle hWin
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   event  WIN-EVT

           perform INTIAL-SETTINGS
           display Mask

           modify cb-type item-to-add (msg-type-ok
                                       msg-type-yes-no  
                                       msg-type-ok-cancel  
                                       msg-type-yes-no-cancel  
                                       msg-type-retry-cancel 
                                       msg-type-abort-retry-ignore 
                                       msg-type-cancel-retry-continue)

           modify cb-icon item-to-add (msg-default-icon
                                       msg-warning-icon
                                       msg-error-icon)

           modify cb-default item-to-add (msg-default-ok
                                          msg-default-yes
                                          msg-default-no
                                          msg-default-cancel
                                          msg-default-abort
                                          msg-default-retry
                                          msg-default-ignore
                                          msg-default-continue)

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue 
              end-accept
              perform EXCEPTION-HANDLING
              move 4 to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           GOBACK
           .

       EXCEPTION-HANDLING.
           evaluate crt-status
           when 1
                perform DISPLAY-MESSAGE
           when 2
                perform VIEW-SORG
           when 101
                call "C$UNSET" using "gui.messagebox.custom_prog"
                perform ENABLED-COLOR-FONT
           when 102
                set environment "gui.messagebox.custom_prog" 
                                               to "MESSAGE-BOX-CUSTOM"
                perform ENABLED-COLOR-FONT
           when 103
                perform ENABLED-COLOR
           when 104
                perform ENABLED-FONT
           when 105
                perform CHANGE-FONT
           end-evaluate
           .

       DISPLAY-MESSAGE.
           inquire ef-title value p-title
           inquire ef-text value p-text

           inquire cb-type VALUE p-type
           evaluate p-type
           when msg-type-ok
                move MB-OK                     to wrk-type
           when msg-type-yes-no
                move MB-YES-NO                 to wrk-type
           when msg-type-ok-cancel
                move MB-OK-CANCEL              to wrk-type
           when msg-type-yes-no-cancel
                move MB-YES-NO-CANCEL          to wrk-type
           when msg-type-retry-cancel
                move MB-RETRY-CANCEL           to wrk-type
           when msg-type-abort-retry-ignore
                move MB-ABORT-RETRY-IGNORE     to wrk-type
           when msg-type-cancel-retry-continue
                move MB-CANCEL-RETRY-CONTINUE  to wrk-type
           end-evaluate

           inquire cb-default value p-default
           evaluate p-default 
           when msg-default-ok
                move MB-OK         to wrk-default
           when msg-default-yes
                move MB-YES        to wrk-default
           when msg-default-no
                move MB-NO         to wrk-default
           when msg-default-cancel
                move MB-CANCEL     to wrk-default
           when msg-default-abort
                move MB-ABORT      to wrk-default
           when msg-default-retry
                move MB-RETRY      to wrk-default
           when msg-default-ignore
                move MB-IGNORE     to wrk-default
           when msg-default-continue
                move MB-CONTINUE   to wrk-default
           end-evaluate

           inquire cb-icon value p-icon 
           evaluate p-icon
           when msg-default-icon
                move MB-DEFAULT-ICON  to wrk-icon
           when msg-warning-icon
                move MB-WARNING-ICON  to wrk-icon
           when msg-error-icon
                move MB-ERROR-ICON    to wrk-icon
           end-evaluate

           if p-color = 1
              perform CALCULATE-COLORS
           end-if
           if p-font = 1
              perform LOAD-FONT
           end-if

           evaluate true also true
           when p-centered = 0 also p-before-time = 0
                perform DISPLAY-MESSAGE-PLAIN
           when p-centered = 1 also p-before-time = 0
                perform DISPLAY-MESSAGE-CENTERED
           when p-centered = 0 also p-before-time not = 0
                perform DISPLAY-MESSAGE-BEFORE-TIME
           when p-centered = 1 also p-before-time not = 0
                perform DISPLAY-MESSAGE-CENTERED-BEFORE-TIME
           end-evaluate
           
           modify lb-result title p-result
           .

       DISPLAY-MESSAGE-PLAIN.
           evaluate true also true
           when p-color = 0 also p-font = 0
                display message box p-text 
                        title p-title 
                        type wrk-type
                        default wrk-default 
                        icon wrk-icon
                        giving p-result 
           when p-color = 1 also p-font = 0
                display message box p-text 
                        title p-title 
                        type wrk-type
                        default wrk-default 
                        icon wrk-icon
                        foreground-color wrk-foreground-color
                        background-color wrk-background-color
                        giving p-result 
           when p-color = 0 also p-font = 1
                display message box p-text 
                        title p-title 
                        type wrk-type
                        default wrk-default 
                        icon wrk-icon
                        font wrk-font 
                        giving p-result 
           when p-color = 1 also p-font = 1
                display message box p-text 
                        title p-title 
                        type wrk-type
                        default wrk-default 
                        icon wrk-icon
                        foreground-color wrk-foreground-color
                        background-color wrk-background-color
                        font wrk-font 
                        giving p-result 
           end-evaluate
           .

       DISPLAY-MESSAGE-CENTERED.
           evaluate true also true
           when p-color = 0 also p-font = 0
                display message box p-text 
                        title p-title 
                        type wrk-type
                        default wrk-default 
                        icon wrk-icon
                        centered
                        giving p-result 
           when p-color = 1 also p-font = 0
                display message box p-text 
                        title p-title 
                        type wrk-type
                        default wrk-default 
                        icon wrk-icon
                        foreground-color wrk-foreground-color
                        background-color wrk-background-color
                        centered
                        giving p-result 
           when p-color = 0 also p-font = 1
                display message box p-text 
                        title p-title 
                        type wrk-type
                        default wrk-default 
                        icon wrk-icon
                        font wrk-font 
                        centered
                        giving p-result 
           when p-color = 1 also p-font = 1
                display message box p-text 
                        title p-title 
                        type wrk-type
                        default wrk-default 
                        icon wrk-icon
                        foreground-color wrk-foreground-color
                        background-color wrk-background-color
                        font wrk-font 
                        centered
                        giving p-result 
           end-evaluate
           .

       DISPLAY-MESSAGE-BEFORE-TIME.
           evaluate true also true
           when p-color = 0 also p-font = 0
                display message box p-text 
                        title p-title 
                        type wrk-type
                        default wrk-default 
                        icon wrk-icon
                        before time p-before-time 
                        giving p-result 
           when p-color = 1 also p-font = 0
                display message box p-text 
                        title p-title 
                        type wrk-type
                        default wrk-default 
                        icon wrk-icon
                        foreground-color wrk-foreground-color
                        background-color wrk-background-color
                        before time p-before-time 
                        giving p-result 
           when p-color = 0 also p-font = 1
                display message box p-text 
                        title p-title 
                        type wrk-type
                        default wrk-default 
                        icon wrk-icon
                        font wrk-font 
                        before time p-before-time 
                        giving p-result 
           when p-color = 1 also p-font = 1
                display message box p-text 
                        title p-title 
                        type wrk-type
                        default wrk-default 
                        icon wrk-icon
                        foreground-color wrk-foreground-color
                        background-color wrk-background-color
                        font wrk-font 
                        before time p-before-time 
                        giving p-result 
           end-evaluate
           .

       DISPLAY-MESSAGE-CENTERED-BEFORE-TIME.
           evaluate true also true
           when p-color = 0 also p-font = 0
                display message box p-text 
                        title p-title 
                        type wrk-type
                        default wrk-default 
                        icon wrk-icon
                        centered
                        before time p-before-time 
                        giving p-result 
           when p-color = 1 also p-font = 0
                display message box p-text 
                        title p-title 
                        type wrk-type
                        default wrk-default 
                        icon wrk-icon
                        foreground-color wrk-foreground-color
                        background-color wrk-background-color
                        centered
                        before time p-before-time 
                        giving p-result 
           when p-color = 0 also p-font = 1
                display message box p-text 
                        title p-title 
                        type wrk-type
                        default wrk-default 
                        icon wrk-icon
                        font wrk-font 
                        centered
                        before time p-before-time 
                        giving p-result 
           when p-color = 1 also p-font = 1
                display message box p-text 
                        title p-title 
                        type wrk-type
                        default wrk-default 
                        icon wrk-icon
                        foreground-color wrk-foreground-color
                        background-color wrk-background-color
                        font wrk-font 
                        centered
                        before time p-before-time 
                        giving p-result 
           end-evaluate
           .

       CALCULATE-COLORS.
           inquire ef-foreground value wrk-color-hex
           perform CALCULATE-COLOR
           move wrk-color  to wrk-foreground-color
       
           inquire ef-background value wrk-color-hex
           perform CALCULATE-COLOR
           move wrk-color  to wrk-background-color
           .

       CALCULATE-COLOR.
           move function hex2dec(wrk-hex-r) to wrk-r.
           move function hex2dec(wrk-hex-g) to wrk-g.
           move function hex2dec(wrk-hex-b) to wrk-b.

           compute wrk-color = (wrk-r  * 65536 + 
                                wrk-g  * 256   + 
                                wrk-b) * -1
           .

       LOAD-FONT.
           if function handle-type (wrk-font) = handle-of-font
              destroy wrk-font
           end-if

           initialize wfont-data
           set wfdevice-console to true
           move wrk-font-name   to wfont-name
           move wrk-font-size   to wfont-size
           CALL "W$FONT" using wfont-get-font
                               wrk-font
                               wfont-data
           .

       CHANGE-FONT.
           initialize wfont-data
           set wfdevice-console to true
           move wrk-font-name   to wfont-name
           move wrk-font-size   to wfont-size
           CALL "W$FONT" using wfont-choose-font
                               wrk-font
                               wfont-data

           if return-code = 1  
              move wfont-name   to wrk-font-name
              move wfont-size   to wrk-font-size
              initialize p-font-description
              string wrk-font-name delimited by trailing space
                     " - "         delimited by size
                     wrk-font-size delimited by size
                     into p-font-description
              modify lbl-font title p-font-description 
           end-if
           .

       INTIAL-SETTINGS.
           move "Custom message Box Title" to p-title
           string "This is the text of the message box."
                  x"0A"
                  "You can use more than 1 line."
                  into p-text 
           move msg-type-ok to p-type

           move msg-default-icon   to p-icon

           move msg-default-ok     to p-default

           move "FFFFFF"           to p-foreground-color
           move "3399FF"           to p-background-color

           move 0   to p-before-time
                       p-centered
                       p-font
                       p-color
                       e-color
                       e-font

           move 1   to e-iscobol-message
                       p-message-type 

           move "Arial" to wrk-font-name
           move 10 to wrk-font-size
           initialize p-font-description
           string wrk-font-name delimited by trailing space
                  " - "         delimited by size
                  wrk-font-size delimited by size
                  into p-font-description 
           .

       ENABLED-COLOR-FONT.
           if p-iscobol-message
              move 1   to e-iscobol-message
              if p-color = 1
                 move 1   to e-color
              else
                 move 0   to e-color
              end-if
              if p-font = 1
                 move 1   to e-font
              else
                 move 0   to e-font
              end-if
           else
              move 0   to e-iscobol-message
                          e-font
                          e-color
           end-if

           modify ck-color      enabled e-iscobol-message
           modify ck-font       enabled e-iscobol-message
           modify ef-foreground enabled e-color
           modify ef-background enabled e-color
           modify pb-font       enabled e-font
           .

       ENABLED-COLOR.
           inquire ck-color value p-color 
           if p-color = 1
              move 1   to e-color
           else
              move 0   to e-color
           end-if
           modify ef-foreground enabled e-color
           modify ef-background enabled e-color
           .

       ENABLED-FONT.
           inquire ck-font value p-font
           if p-font = 1
              move 1   to e-font
           else
              move 0   to e-font
           end-if
           modify pb-font       enabled e-font
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       VIEW-SORG.
           initialize command
           string base-sorg-path            delimited by trailing space
                  "s-gui"                   delimited by space
                  "/MESSAGE-BOX-CUSTOM.cbl" delimited by size
                  into command.

           call run "TEXTVIEWER"  using command.
