      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. drag-and-drop.

       CONFIGURATION SECTION.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.

       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       copy "isopensave.def".

       01  table-articles.
           03 filler.
              05 filler   pic x(50) value "Power Bank 2600 mAh".
              05 filler   pic 9(2) value 2.
           03 filler.
              05 filler   pic x(50) value "Power Bank 5200 mAh".
              05 filler   pic 9(2) value 5.
           03 filler.
              05 filler   pic x(50) 
                          value "Cell Phone Screen Protectors".
              05 filler   pic 9(2) value 7.
           03 filler.
              05 filler   pic x(50) 
                          value "Glass Cell Phone Screen Protectors ".
              05 filler   pic 9(2) value 7.
           03 filler.
              05 filler   pic x(50) value "Pendrive 16Gb".
              05 filler   pic 9(2) value 9.
           03 filler.
              05 filler   pic x(50) value "Pendrive 32Gb".
              05 filler   pic 9(2) value 10.
           03 filler.
              05 filler   pic x(50) value "Cell Phone Screen cleaner".
              05 filler   pic 9(2) value 20.
           03 filler.
              05 filler   pic x(50) value "USB 3.0 cable 5m".
              05 filler   pic 9(2) value 13.
           03 filler.
              05 filler   pic x(50) value "USB 3.0 cable 10m".
              05 filler   pic 9(2) value 45.
           03 filler.
              05 filler   pic x(50) value "Wi-Fi range extender".
              05 filler   pic 9(2) value 21.

       01  record-article       redefines table-articles.
           03 rec-article       occurs 10.
              05 ra-description pic x(50).
              05 ra-qty         pic 9(2).

       01  gd-draged-element.
           05 gd-d-description  pic x(50).
           05 gd-d-qty          pic 9(2).
           05 gd-d-row          pic 9(2).
           
       77  ef-dragged-element   pic x(50).

       77  crt-status              special-names crt status pic 9(5).
       77  hMain                   handle of window.
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9    value 0.

       01  gd-data.
           05 gdr-article          pic x(50).
           05 gdr-qty              pic 9(2).

       77  idx                     pic 9(3).
       
       01  drag-from               pic x value space.
           88 drag-from-nothing    value space.
           88 drag-from-gd-article value "A".
           88 drag-from-gd-order   value "O".
           88 drag-from-ef-article value "E".

       77  max-row                 pic 99.
       77  new-article             pic x(50).
       77  insertion-position      pic 99.

       77  gda-idx                 pic 99.

       77  font-name               pic x any length.
       77  icon-characters         pic n any length.
       
       77  h-font                  handle of font.
       77  icon-color              pic s9(9) value -4804695.
       77  h-font-icon             pic s9(9) comp-4.

       SCREEN SECTION.
       01  Mask.
           03 frame
              line                 1.5
              col                  2
              lines                18.5
              size                 33.5
              title                "Available articles"
              transparent
              engraved
              . 
           03 gd-article
              grid 
              line                 3
              col                  3
              lines                13 cells
              size                 31 cells
              display-columns      (1, 24)
              data-columns         (record-position of gdr-article, 
                                    record-position of gdr-qty)
              alignment            ("L", "R")
              data-types           ("X" "P(2)") 
              end-color            -16774581
              heading-color        257
              border-color         rgb x#ACACAC
              boxed
              column-headings 
              centered-headings
              tiled-headings
              adjustable-Columns
              sortable-columns
              vscroll
              row-background-color-pattern = (-16777215, -14675438)
              drag-mode            3
              Row-Cursor-Background-Color rgb x#395A9D
              Row-Cursor-foreground-Color rgb x#CEE3F6
              event GD-ARTICLE-EVENT
              .
           03 frame
              line                 1.5
              col                  37
              lines                18.5
              size                 33.5
              title                "Ordered items"
              engraved
              transparent
              .
           03 gd-order
              grid 
              line                 3
              col                  38
              lines                13 cells
              size                 31 cells
              display-columns      (1, 24)
              data-columns         (record-position of gdr-article, 
                                    record-position of gdr-qty)
              alignment            ("L", "R")
              data-types           ("X(50)" "9(2)") 
              end-color            -16774581
              heading-color        257
              border-color         rgb x#ACACAC
              boxed
              column-headings 
              centered-headings
              tiled-headings
              adjustable-Columns
              sortable-columns
              vscroll
              row-background-color-pattern = (-16777215, -14675438)
              drag-mode            3
              protection 1
              Row-Cursor-Background-Color rgb x#395A9D
              Row-Cursor-foreground-Color rgb x#CEE3F6
              event GD-ORDER-EVENT
              .
           03 label
              line                 16.5
              col                  3
              title                "New article"
              transparent
              . 
           03 ef-article
              entry-field 
              line                 18 
              col                  3 
              size                 31 cells
              max-text             50
              value                new-article
              drag-mode            1
              event                EF-ARTICLE-EVENT
              .
           03 pb-delete
              push-button
              line                 16.7
              col                  50
              lines                32
              size                 32
              bitmap               h-font-icon
              bitmap-width         32
              bitmap-number        1
              title                "Delete order row"
              exception-value      101
              drag-mode            2
              event                PD-DELETE-EVENT
              .
           03 push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "w$createfont" 
                       using "files/Font Awesome 6 Free-Solid-900.otf" 
                             font-name
           initialize wfont-data
           set wfdevice-console to true
           move font-name       to wfont-name
           move 10              to wfont-size
           CALL "W$FONT" using wfont-get-font
                               h-font
                               wfont-data

           move nx"f2ed"  to icon-characters.
           CALL "W$BITMAP" using wbitmap-load-symbol-font, 
                                      h-font
                                      icon-characters
                                      32
                                      icon-color
                               giving h-font-icon

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call

           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title "Drag and Drop feature"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT
                   control font control-font

           display mask

           modify  gd-order  mass-update 1
           modify  gd-order x 1, y 1, cell-data "Article"
           modify  gd-order x 2, y 1, cell-data "Qty"
           modify  gd-order mass-update 0

           modify  gd-article mass-update 1
           modify  gd-article x 1, y 1, cell-data "Article"
           modify  gd-article x 1, y 1, column-protection 1
           modify  gd-article x 2, y 1, cell-data "Qty"
           move 1   to gda-idx
           perform varying idx from 1 by 1 until idx > 10
              move ra-description(idx)   to gdr-article
              move ra-qty(idx)           to gdr-qty
              add 1 to gda-idx
              perform ADD-RECORD-TO-GD-ARTICLE 
           end-perform
           modify  gd-article mass-update 0

           perform until crt-status = 27 or close-win = 1
              accept Mask
                   on exception 
                      continue
              end-accept
              evaluate crt-status
              when 101
                   perform DELETE-ORDER-ROW
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy mask
           destroy hWin
           destroy control-font
           call "W$BITMAP" using wbitmap-destroy, h-font-icon 
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       GD-ARTICLE-EVENT.
           evaluate event-type
           when MSG-DRAG 
                move event-data-2   to gd-d-row
                inquire gd-article(event-data-2 1) cell-data gdr-article
                inquire gd-article(event-data-2 2) cell-data gdr-qty
                if gdr-qty = 0
                   set event-action to event-action-fail
                else
                   move gdr-article to gd-d-description
                   move gdr-qty     to gd-d-qty
                   set drag-from-gd-article to true
                end-if

           when MSG-DROP
                evaluate true
                when drag-from-gd-order
                     perform DROP-TO-GD-ARTICLE
                when drag-from-ef-article
                     perform DROP-TO-GD-ARTICLE-FROM-EF
                end-evaluate
                set drag-from-nothing to true
           when msg-finish-entry
                inquire gd-article(event-data-2 2) cell-data gdr-qty
                modify gd-article(event-data-2 2) cell-data gdr-qty
           end-evaluate
           .

       GD-ORDER-EVENT.
           evaluate event-type
           when MSG-DRAG 
                inquire gd-order last-row max-row
                if max-row = 1
                   set event-action to event-action-fail
                else
                   move event-data-2   to gd-d-row
                   inquire gd-order(event-data-2 1) 
                                                  cell-data gdr-article
                   inquire gd-order(event-data-2 2) cell-data gdr-qty
                   move gdr-article         to gd-d-description
                   move gdr-qty             to gd-d-qty
                   set drag-from-gd-order   to true
                end-if

           when MSG-DROP
                evaluate true
                when drag-from-gd-article
                     move event-data-1  to insertion-position
                     perform DROP-TO-GD-ORDER
                end-evaluate
                set drag-from-nothing to true
           end-evaluate
           .

       DROP-TO-GD-ORDER.
           inquire gd-order last-row max-row
           if max-row >= 2
              perform varying idx from 2 by 1 until idx > max-row
                 inquire gd-order(idx, 1) cell-data gdr-article 
                 if gdr-article = gd-d-description
                    inquire gd-order(idx 2) cell-data gdr-qty 
                    add 1 to gdr-qty
                    modify gd-order(idx 2) cell-data gdr-qty
                    exit perform
                 end-if
              end-perform
           else
              move 2   to idx
           end-if

           if idx > max-row
              if insertion-position > max-row
                 move 0   to insertion-position
              end-if
              if insertion-position = 0
                 compute idx = max-row + 1   
              else
                 if insertion-position = 1
                    move 2   to insertion-position
                 end-if
                 move insertion-position to idx
              end-if
              modify gd-order insertion-index insertion-position
              move gd-d-description   to gdr-article
              move 1                  to gdr-qty
              modify gd-order record-to-add gd-data
              modify gd-order(idx 2) cell-data gdr-qty
           end-if

           subtract 1 from gd-d-qty
           move gd-d-qty  to gdr-qty 
           modify gd-article(gd-d-row 2) cell-data gdr-qty
           .

       DROP-TO-GD-ARTICLE.
           inquire gd-article last-row max-row
           perform varying idx from 2 by 1 until idx > max-row
              inquire gd-article(idx, 1) cell-data gdr-article 
              if gdr-article = gd-d-description
                 inquire gd-article(idx 2) cell-data gdr-qty 
                 add 1 to gdr-qty
                 modify gd-article(idx 2) cell-data gdr-qty
                 exit perform
              end-if
           end-perform

           subtract 1 from gd-d-qty
           if gd-d-qty = 0
              modify gd-order record-to-delete gd-d-row
           else
              move gd-d-qty  to gdr-qty 
              modify gd-order(gd-d-row 2) cell-data gdr-qty
           end-if
           .

       DROP-TO-GD-ARTICLE-FROM-EF.
           move event-data-1  to insertion-position

           inquire gd-article last-row max-row
           perform varying idx from 2 by 1 until idx > max-row
              inquire gd-article(idx, 1) cell-data gdr-article 
              if gdr-article = ef-dragged-element
                 inquire gd-article(idx 2) cell-data gdr-qty 
                 add 1 to gdr-qty
                 modify gd-article(idx 2) cell-data gdr-qty
                 exit perform
              end-if
           end-perform

           if idx > max-row
              if insertion-position <= max-row
                 if insertion-position = 1
                    move 2   to insertion-position
                 end-if
                 modify gd-article insertion-index insertion-position
                 move insertion-position to idx
              end-if

              move ef-dragged-element to gdr-article
              move 1                  to gdr-qty
              move idx to gda-idx
              perform ADD-RECORD-TO-GD-ARTICLE
           end-if
           .

       ADD-RECORD-TO-GD-ARTICLE.
           modify gd-article record-to-add gd-data
           modify gd-article(gda-idx 2) cell-data gdr-qty
           .

       EF-ARTICLE-EVENT.
           evaluate event-type
           when MSG-DRAG 
                inquire ef-article value ef-dragged-element
                modify ef-article cursor -1
                set drag-from-ef-article to true
           end-evaluate
           .

       PD-DELETE-EVENT.
           evaluate event-type
           when MSG-DROP
                if drag-from-gd-order
                   if event-data-1 > 1
                      perform DROP-TO-PB-DEL
                   end-if
                end-if
                set drag-from-nothing to true
           end-evaluate
           .

       DROP-TO-PB-DEL.
           inquire gd-article last-row max-row 
           perform varying idx from 2 by 1 until idx > max-row
              inquire gd-article(idx, 1) cell-data gdr-article 
              if gdr-article = gd-d-description
                 inquire gd-article(idx 2) cell-data gdr-qty 
                 add gd-d-qty   to gdr-qty
                 modify gd-article(idx 2) cell-data gdr-qty
                 exit perform
              end-if
           end-perform
           modify gd-order record-to-delete gd-d-row
           .

       DELETE-ORDER-ROW.
           inquire gd-order  cursor-y gd-d-row 
           if gd-d-row > 1
              inquire gd-order(gd-d-row 1) cell-data gd-d-description 
              inquire gd-order(gd-d-row 2) cell-data gd-d-qty 
              perform DROP-TO-PB-DEL
           end-if
           .

