      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. BLOB.

       WORKING-STORAGE SECTION.
           copy "isgui.def".
           copy "isfonts.def".
           copy "iscrt.def".
           copy "iscobol.def".   
           copy "isresize.def".
           copy "isopensave.def".
           copy "SQLCA".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
                                               
       77  w-desc                  pic x(32) value "Blob data".
       77  w-blob                  handle.
       77  w-driver                pic x any length.
       77  w-url                   pic x any length.
           
       SCREEN SECTION.
       01  Mask.
           03 Lb1
              label
              line                 3
              col                  3
              title                "Connected!"
              visible              0
              .
           03 push-button
              line                 6
              col                  2
              size                 25 cells
              title                "&Create Table 'BLOBTEST'"
              exception-value      101
              .                
           03 push-button
              line                 9
              col                  2
              size                 25 cells
              title                "&Store Blob in DB"
              exception-value      102
              .
           03 push-button
              line                 12
              col                  2
              size                 25 cells
              title                "&Read Blob from DB"
              exception-value      103
              .                 
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.                            
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "ESQL$BLOB Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           accept w-driver from environment "jdbc.driver"
           accept w-url    from environment "jdbc.url"
           
           if w-driver = space or
              w-url    = space
              display message "To run this sample, you must set "
                              "iscobol.jdbc.url and iscobol.jdbc.driver"
                              " to a database that supports BLOB data "
                              "types in samples/iscobol.properties, "
                              "and put the jdbc driver in the CLASSPATH"
                              " or $ISCOBOL/jars folder."
              destroy hWin
              goback
           end-if

           try
              EXEC SQL
                 connect
              END-EXEC
           catch exception
              display message exception-object x"0D0A"
                              "To run this sample, you must set "
                              "iscobol.jdbc.url and iscobol.jdbc.driver"
                              " to a database that supports BLOB data "
                              "types in samples/iscobol.properties, "
                              "and put the jdbc driver in the CLASSPATH"
                              " or $ISCOBOL/jars folder"
              destroy hWin
              goback
           end-try.

           if sqlcode not = 0
              display message "Connection Error!"  x"0a0a"
                              sqlerrmc             x"0a0a"
                              "Driver = " w-driver x"0a"
                              "Url = "    w-url 
                      title   "Connect"
                      icon    mb-warning-icon
              perform QUIT
           end-if

           display Mask

           modify Lb1 visible 1

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    evaluate crt-status
                    when 101
                         perform CREATE-TABLE   
                    when 102
                         perform WRITE-BLOB
                    when 103
                         perform READ-BLOB
                    end-evaluate
              end-accept
              move 4   to accept-control
           end-perform
           .
                     
       QUIT.
           EXEC SQL 
                disconnect
           END-EXEC
           destroy hWin
           destroy control-font
           goback
           .
             
     
       CREATE-TABLE.
           EXEC SQL
                create table BLOBTEST (k numeric, d char(32), b blob)
           END-EXEC
           if sqlcode not = 0
              display message sqlerrmc
                      title   "Create Table"
                      icon    mb-warning-icon
              perform QUIT
           end-if
           display message "Table created successfully"
                   title   "Create Table"        
           .

       WRITE-BLOB.
           initialize opensave-data
           call "C$OPENSAVEBOX" using opensave-open-box
                                      opensave-data
           if return-code < 1
              display message "Operation cancelled by the user"
                      title   "Insert Data"
              exit paragraph
           end-if
           .

           call "ESQL$BLOB" using get-blob-from-file
                                  w-blob
                                  opnsav-filename.
           EXEC SQL
                insert into BLOBTEST (k, d, b) values (1, 
                                                          :w-desc, 
                                                          :w-blob)
           END-EXEC
           if sqlcode not = 0
              EXEC SQL
                   update BLOBTEST set b = :w-blob where k = 1
              END-EXEC
              if sqlcode not = 0
                 display message sqlerrmc
                         title   "Insert Data"
                         icon    mb-warning-icon
                 perform QUIT
              end-if
           end-if
           call "ESQL$BLOB" using free-blob-handle, w-blob
           display message "data stored successfully"
                   title   "Insert Data"
           .


       READ-BLOB.
           EXEC SQL
                select b  into :w-blob from BLOBTEST  where k = 1
           END-EXEC
           evaluate sqlcode
                    when 0
                         perform SAVE-BLOB-TO-DISK
                    when 100         
                         display message "not found"
                                 title   "Select"
                                 icon    mb-warning-icon
                         perform QUIT
                    when other
                         display message sqlerrmc 
                                 title   "Select"
                                 icon    mb-warning-icon
                         perform QUIT
           end-evaluate  
           .

       SAVE-BLOB-TO-DISK.
           initialize opensave-data
           call "C$OPENSAVEBOX" using opensave-save-box
                                      opensave-data
           if return-code > 0
              call "ESQL$BLOB" using put-blob-into-file
                                     w-blob
                                     opnsav-filename
              display message "File saved correctly"
                      title   "Select"
           else               
              display message "Operation cancelled by the user"
                      title   "Select"
           end-if
           .
           
           
       WIN-EVT.  
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .