      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. cblcopy.

       WORKING-STORAGE SECTION.
       copy "isopensave.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              is special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  opensave-status         pic s9.
       77  file-name               pic x(256).
       77  dest-file               pic x(256).
       77  wstatus                 pic s9(5).
       77  risp                    pic 9.

       77  rb-value                pic 9.
       01  execution-type          pic X.
           88 standalone-execution value "A".
           88 client-execution     value "C".
           88 server-execution     value "S".
       77  e-remote                pic 9.
       77  e-standalone            pic 9.
       77  e-client                pic 9.
       77  rb-type                 pic 9 value 1.
       77  file-type               pic x.

       SCREEN SECTION.
       01  Mask.
           03 radio-button 
              line                 2 
              col                  2
              title                "Stand alone"
              group                1
              group-value          1 
              value                rb-value
              exception-value      103
              enabled              e-standalone
              .
           03 radio-button 
              line                 2 
              col                  17
              title                "Run on Client"
              group                1
              group-value          2
              value                rb-value
              exception-value      103
              enabled              e-remote
              .
           03 radio-button 
              line                 2 
              col                  34
              title                "Run on Server"  
              group                1
              group-value          3
              value                rb-value
              exception-value      103
              enabled              e-remote
              .
           03 label               
              line                 4 
              col                  2
              size                 20 cells
              title                "Select a file:"
              .
           03 file-copy
              entry-field
              line                 6 
              col                  2
              value                file-name
              size                 64 cells
              max-text             256
              .
           03 pb-choose
              push-button
              line                 6
              col                  + 2
              title                "..."
              size                 4 cells
              exception-value      101
              enabled              e-client
              self-act
              .
           03 push-button
              line                 8 
              col                  2
              title                "Create &Backup"
              size                 15 cells
              exception-value      102
              self-act
              .
           03 Pb-exit
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN. 
           accept terminal-abilities from terminal-info.
           if is-remote
              move 1                     to e-remote
              move zero                  to e-standalone
              move 2                     to rb-value
              set client-execution       to true
           else
              move zero                  to e-remote
              move 1                     to e-standalone
              move 1                     to rb-value
              set standalone-execution   to true
           end-if
           move 1                        to e-client

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "CBL_COPY_FILE Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception 
                    perform EXCEPTION-HANDLING
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status
           when 101
                perform CHOOSE-FILE
           when 102
                perform COPY-FILE
           when 103
                if rb-value = 2
                   set client-execution   to true
                   move 1                 to e-client
                else
                   set server-execution   to true
                   move zero              to e-client
                end-if
                modify pb-choose enabled e-client
           end-evaluate
           .

       CHOOSE-FILE.
           initialize opensave-data
           call client "C$GETENV" USING "user.home"
                                        opnsav-default-dir
           move 1 to opnsav-default-filter
           move "All Files (*.*)" to opnsav-filters
           call "C$OPENSAVEBOX" using opensave-open-box
                                      opensave-data
                               giving opensave-status
           if opensave-status > 0
              move opnsav-filename to file-name
              modify file-copy value file-name
           end-if.

       COPY-FILE.
           initialize dest-file
           string file-name delimited by spaces
                  " -Bk"    delimited by size
                  into dest-file
           end-string
           inquire file-copy value in file-name

           evaluate true
           when client-execution
                call client "CBL_COPY_FILE" using file-name 
                                                  dest-file
                                           giving wstatus
           when standalone-execution
           when server-execution
                call "CBL_COPY_FILE" using file-name 
                                           dest-file
                                    giving wstatus
           end-evaluate.

           evaluate wstatus
           when 0
                display message "Copy successful"
           when 14613
                display message "You have selected a Directory",
                        icon    mb-default-icon
           when 14605
                display message "File not found",
                        icon    mb-default-icon
           when 14628
                display message "Exists",
                        icon    mb-default-icon
           when 14629
                display message "No permission",
                        icon    mb-default-icon
           end-evaluate.

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .