      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.    CBLPROC.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  tabe                    pic x occurs 2.
       77  idx                     pic 9.
       77  base-sorg-path          pic x(20). 
       77  command                 pic x(100).

       SCREEN SECTION.
       01  Mask.
           03 frame
              engraved
              title                "CBL_ERROR_PROC"
              line                 2
              col                  2
              lines                4
              size                 55
              .
           03 push-button
              line                 4 
              col                  3
              size                 20 cells
              title                "Install" 
              exception-value      101
              .
           03 push-button
              line                 4 
              col                  25
              size                 20 cells
              title                "Remove" 
              exception-value      201
              .
           03 frame
              engraved
              title                "CBL_EXIT_PROC"
              line                 7
              col                  2
              lines                4
              size                 55
              .
           03  push-button
               line                9 
               col                 3
               size                20 cells
               title               "Install" 
               exception-value     102
               self-act
               .
           03  push-button
               line                9 
               col                 25
               size                20 cells
               title               "Remove" 
               exception-value     202
               self-act
               .
           03  push-button
               line                13 
               col                 3
               size                20 cells
               title               "Make error" 
               exception-value     103
               self-act
               .
           03  push-button
               line                 20 
               col                  2 
               size                 30 cells
               title                "CBL_ERROR_PROC source code" 
               exception-value      301
               self-act
               .
           03  push-button
               line                 20 
               col                  32 
               size                 30 cells
               title                "CBL_EXIT_PROC source code" 
               exception-value      302
               self-act
               .
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "CBL_ERROR_PROC and CBL_EXIT_PROC routines"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue 
              end-accept
              perform EXCEPTION-HANDLING
              move 4    to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status
           when 101 
                perform CBLERRORPROC
           when 102 
                perform CBLEXITPROC
           when 103 
                perform MAKE-ERROR
           when 201 
                perform REMOVE-CBLERRORPROC
           when 202 
                perform REMOVE-CBLEXITPROC
           when 301
                perform VIEW-CBLERRORPROC
           when 302
                perform VIEW-CBLEXITPROC
           end-evaluate.

       WIN-EVT.
           if event-type = cmd-close   
              move 1 to close-win
           end-if
           .

       CBLERRORPROC.
           call "CBL_ERROR_PROC" using 0, "ERRORPROC"

           display message "The program 'ERRORPROC' has been loaded to h
      -                    "andle errors"
                   icon    mb-default-icon
           .
                                          
       REMOVE-CBLERRORPROC.
           call "CBL_ERROR_PROC" using 1, "ERRORPROC"

           display message "The program 'ERRORPROC' has been removed"
                   icon    mb-default-icon
           .

       CBLEXITPROC.
           call "CBL_EXIT_PROC" using 0, "EXITPROC"

           display message "The program 'EXITPROC' has been loaded to ha
      -                    "ndle program termination"
                   icon    mb-default-icon
           .

       REMOVE-CBLEXITPROC.
           call "CBL_EXIT_PROC" using 1, "EXITPROC"

           display message "The program 'EXITPROC' has been removed"
                   icon    mb-default-icon
           .

       MAKE-ERROR.
           move 5   to idx
           move "a" to tabe(idx).

       VIEW-CBLERRORPROC.
           initialize command
           string base-sorg-path delimited by trailing space
                  "s-routines"   delimited by space
                  "/ERRORPROC.cbl" delimited by size
                                 into command.

           call run "TEXTVIEWER" using command.

       VIEW-CBLEXITPROC.
           initialize command
           string base-sorg-path   delimited by trailing space
                  "s-routines"     delimited by space
                  "/EXITPROC.cbl"  delimited by size
                                   into command.

           call run "TEXTVIEWER"  using command.
