      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CEASYOPEN.

       WORKING-STORAGE SECTION.
       copy "iscobol.def".   
       copy "isresize.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "isopensave.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  opensave-status         pic s9.
       77  wstatus                 pic s9.
       77  file-name               pic x(256).
       77  v-remote                pic 9.
       77  e-client                pic 9.
       77  e-server                pic 9.
       77  rb-orig                 pic 9 value 1.
       77  rb-dest                 pic 9 value 1.

       01  source-type             pic X.
           88 client-source        value "C".
           88 server-source        value "S".

       01  destination-type        pic X.
           88 client-dest          value "C".
           88 server-dest          value "S".

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  2
              size                 10 cells
              title                "Open:"
              .
           03 file-open
              entry-field
              line                 4
              col                  2
              size                 63 cells
              value                file-name
              max-text             256
              . 
           03 pb-choose
              push-button
              line                 4
              col                  + 2
              size                 4 cells
              title                "..."
              exception-value      101
              enabled              e-client
              self-act
              .
           03 label
              title                "Source"
              line                 6
              col                  2
              visible              v-remote
              .
           03 radio-button 
              line                 8 
              col                  2
              title                "Client"
              group                2
              group-value          1 
              value                rb-orig
              exception-value      103
              visible              v-remote
              . 
           03 radio-button 
              line                 8 
              col                  17
              title                "Server"
              group                2
              group-value          2 
              value                rb-orig
              exception-value      103
              visible              v-remote
              .
           03 label
              title                "Destination"
              line                 10
              col                  2
              visible              v-remote
              .
           03 rb-dest-client
              radio-button 
              line                 12 
              col                  2
              title                "Client"
              group                3
              group-value          1 
              value                rb-dest
              exception-value      104
              visible              v-remote
              enabled              e-server
              . 
           03 rb-dest-server
              radio-button 
              line                 12 
              col                  17
              title                "Server"
              group                3
              group-value          2 
              value                rb-dest
              exception-value      104
              visible              v-remote
              enabled              e-server
              . 
           03 push-button
              default-button
              line                 20
              col                  2
              size                 8 cells
              title                "&Open"
              exception-value      100
              self-act
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.    
           accept terminal-abilities from terminal-info.
           if is-remote
              move 1   to v-remote
           else
              move 0   to v-remote
           end-if
           move 1      to e-client
           move zero   to e-server

           set client-source to true
           set client-dest   to true

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$EASYOPEN Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status
                    when 100  
                         perform OPEN-FILE 
                    when 101
                         perform CHOOSE-FILE
                    when 103
                         if rb-orig = 1
                            set client-source  to true
                            move 1             to e-client
                            move zero          to e-server
                            set client-dest    to true
                            move 1             to rb-dest
                         else
                            set server-source   to true
                            move zero           to e-client
                            move 1              to e-server
                         end-if
                         modify pb-choose enabled e-client
                         modify rb-dest-client enabled e-server
                                               value rb-dest 
                         modify rb-dest-server enabled e-server
                    when 104
                         if rb-dest = 1
                            set client-dest   to true
                         else
                            set server-dest   to true
                         end-if
                         modify pb-choose enabled e-client
           end-evaluate.

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .

       CHOOSE-FILE.
           initialize opensave-data
           call client "C$GETENV" USING "user.home"
                                        opnsav-default-dir
           call "C$OPENSAVEBOX" using opensave-open-box
                                      opensave-data
                               giving opensave-status
           if opensave-status > 0
              move opnsav-filename to file-name
              modify file-open value opnsav-filename
           end-if.

       OPEN-FILE. 
           if file-name not = spaces
              if is-remote
                 evaluate true also true 
                 when client-source also client-dest
                      call client "C$EASYOPEN" using file-name
                                               giving wstatus

                 when server-source also client-dest
                      call "C$EASYOPEN" using file-name
                                              1
                                       giving wstatus
                 when server-source also server-dest
                      call "C$EASYOPEN" using file-name
                                              0
                                       giving wstatus
                 end-evaluate
              else
                   call "C$EASYOPEN" using file-name
                                     giving wstatus
              end-if
              evaluate wstatus 
              when = 1
                     display message "Can't find "
                                     file-name
                                icon mb-warning-icon
              when = 2
                     display message "Error during the copy of "
                                     file-name
                                     x"0D0A"
                                     "from the server"
                             icon mb-warning-icon
              when = 3
                     display message "I'm not able to open "
                                     file-name
                             icon mb-warning-icon
              end-evaluate
           end-if.