      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CRERR.   

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           select test-file
           assign to disc
           line sequential.

       file section.
       fd  test-file.
       01  f-line               pic x(150).

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       01  crerr-status.
           03 file-status          pic xx.
           03 ext-status           pic x(128).
       77  crerr-mesage            pic x any length.

       77  rerrname                pic x(50).

       SCREEN SECTION.
       01  Mask.
           03 pb-open
              push-button
              line                 2
              col                  2 
              size                 32 cells
              title                "Open a file that doesn't exist"
              exception-value      101
              .      
           03 pb-close 
              push-button
              line                 5
              col                  2 
              size                 32 cells
              title                "Read a file never opened"
              exception-value      102
              .          
           03 pb-close 
              push-button
              line                 8
              col                  2 
              size                 32 cells
              title                "Close a file never opened"
              exception-value      103
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .
      
       PROCEDURE DIVISION.
       DECLARATIVES.
       PRINT-FILE-ERROR section.
           use after error procedure on test-file.

           call "C$RERR"     using crerr-status
                                   crerr-mesage
           call "C$RERRNAME" using rerrname

           display message "Error " file-status " " ext-status
                           x"0D0A" " on " rerrname
                           x"0D0A" crerr-mesage

       END DECLARATIVES.

       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "File Error handling"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    continue
              end-accept 
              evaluate crt-status 
              when 101
                   open input test-file   
              when 102
                   read test-file
              when 103
                   close test-file
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
