      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.    HEXASCII.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(4).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       01  hex-value               pic x any length.
       01  ascii-value             pic x any length.
       77  ascii-data-len          pic 9(4).

       SCREEN SECTION.
       01  Mask. 
           03 label
              line                 2
              col                  2
              lines                5
              size                 70 cells
              title                "Input a value in the field and click
      -                            " the button to convert it to ASCII"
              .
           03 label
              line                 4
              col                  2
              size                 30 cells
              title                "Input Hexadecimal string:"
              .
           03 Ef-Hex
              entry-field
              line                 6 
              col                  2
              size                 68 cells
              value                hex-value
              .
           03 push-button
              default-button
              line                 8
              col                  2
              title                "Convert"
              exception-value      101
              .
           03 label
              line                 10
              col                  2
              size                 30 cells
              title                "ASCII output string:"
              .
           03 Ef-Ascii
              entry-field
              line                 12
              col                  2
              size                 68 cells
              read-only
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.       
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "HEX2ASCII Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask 
                 on exception
                    continue
              end-accept
              if crt-status = 101   
                 call "HEX2ASCII" using ascii-value, hex-value
                 compute ascii-data-len = (length of hex-value / 2)
                 modify  Ef-Ascii value ascii-value(1:ascii-data-len)
              end-if
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
